#
# TABLE STRUCTURE FOR: article_has_attachments
#

DROP TABLE IF EXISTS article_has_attachments;

CREATE TABLE `article_has_attachments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `article_id` bigint(20) DEFAULT NULL,
  `filename` varchar(250) DEFAULT NULL,
  `savename` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: clients
#

DROP TABLE IF EXISTS clients;

CREATE TABLE `clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(140) DEFAULT NULL,
  `firstname` varchar(100) DEFAULT NULL,
  `lastname` varchar(100) DEFAULT NULL,
  `email` varchar(180) DEFAULT NULL,
  `phone` varchar(25) DEFAULT NULL,
  `mobile` varchar(25) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `zipcode` varchar(30) DEFAULT NULL,
  `userpic` varchar(150) DEFAULT 'no-pic.png',
  `city` varchar(45) DEFAULT NULL,
  `hashed_password` varchar(255) DEFAULT NULL,
  `inactive` tinyint(4) DEFAULT '0',
  `access` varchar(150) DEFAULT '0',
  `last_active` varchar(50) DEFAULT NULL,
  `last_login` varchar(50) DEFAULT NULL,
  `twitter` varchar(255) DEFAULT NULL,
  `skype` varchar(255) DEFAULT NULL,
  `linkedin` varchar(255) DEFAULT NULL,
  `facebook` varchar(255) DEFAULT NULL,
  `instagram` varchar(255) DEFAULT NULL,
  `googleplus` varchar(255) DEFAULT NULL,
  `youtube` varchar(255) DEFAULT NULL,
  `pinterest` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `language` varchar(255) DEFAULT NULL,
  `signature` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO clients (`id`, `company_id`, `firstname`, `lastname`, `email`, `phone`, `mobile`, `address`, `zipcode`, `userpic`, `city`, `hashed_password`, `inactive`, `access`, `last_active`, `last_login`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `token`, `language`, `signature`) VALUES ('1', '1', 'Anton', 'Geier', 'info@anton-geier.de', '+37120069001', '', '', '', 'no-pic.png', '', '573537467c5b5c232e306d777b6144283f622f305e2a29535974633d215f235f4eff1478d04ef797dafaa60f258fb8eb0a1337bc40f331a1c88746f221617e53', '0', '103,101,102,107,106', '1547818012', '1547817048', '', '', '', '', '', '', '', '', NULL, NULL, NULL);
INSERT INTO clients (`id`, `company_id`, `firstname`, `lastname`, `email`, `phone`, `mobile`, `address`, `zipcode`, `userpic`, `city`, `hashed_password`, `inactive`, `access`, `last_active`, `last_login`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `token`, `language`, `signature`) VALUES ('2', '9', 'Mihail', 'Nesterovich', 'info@qualitybeautystore.com', '', '', '', '', 'no-pic.png', '', '312b2d763d76462854324c3a4848702d68527c7c5271295822567b505c6a616ccbf06830e6b0db04d7c71dbe5ba0ee5de2f9bb3b2c4bb1ac66e82af181bf6a75', '0', '102,106', NULL, NULL, '', '', '', '', '', '', '', '', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: companies
#

DROP TABLE IF EXISTS companies;

CREATE TABLE `companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` int(11) NOT NULL,
  `name` varchar(140) DEFAULT NULL,
  `client_id` varchar(140) DEFAULT NULL,
  `phone` varchar(25) DEFAULT NULL,
  `mobile` varchar(25) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `zipcode` varchar(30) NOT NULL,
  `city` varchar(45) DEFAULT NULL,
  `inactive` tinyint(4) DEFAULT '0',
  `website` varchar(250) DEFAULT NULL,
  `country` varchar(250) DEFAULT NULL,
  `vat` varchar(250) DEFAULT NULL,
  `note` longtext,
  `province` varchar(255) DEFAULT NULL,
  `twitter` varchar(255) DEFAULT NULL,
  `skype` varchar(255) DEFAULT NULL,
  `linkedin` varchar(255) DEFAULT NULL,
  `facebook` varchar(255) DEFAULT NULL,
  `instagram` varchar(255) DEFAULT NULL,
  `googleplus` varchar(255) DEFAULT NULL,
  `youtube` varchar(255) DEFAULT NULL,
  `pinterest` varchar(255) DEFAULT NULL,
  `terms` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('1', '41001', 'BCS Travel B.V.', '1', '+31 20 241 69 95', '', 'Radarweg 29', '1043 NX', 'Amsterdam', '0', 'bcs-bus.com', 'Netherlands', 'NL856563523B01', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('2', '41002', 'BlackLimousines GmbH', '0', '', '', 'Sinziger Strasse 11', '50968', 'Cologne', '0', 'Limousine-service.com', 'Germany', 'DE288336350', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('3', '41003', 'UNTERNEHMENSBERATUNG JAHNES GMBH', '0', '+49 160 951 33 430', '', 'EM TRENGEL 14', '52385 ', 'NIDEGGEN ', '0', 'jahnes.art', 'Germany', 'DE122291121', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('4', '41004', 'SIA Mobilizing', NULL, '', '', '', '', '', '0', 'Mobilizing.eu', '', '', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('5', '41005', 'SIA Nemestok', NULL, '', '', '', '', '', '0', 'Nemestok.lv', '', '', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('6', '41006', 'SIA Kel (Public)', '0', '', '', '', '', '', '0', 'publicmakesimage.com', '', '', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('7', '41007', 'SIA Alinej', NULL, '', '', '', '', '', '0', 'toysale.lv', '', '', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('8', '41008', 'SIA “Wings 4 Sky Group”', '0', '', '', ' Lestenes iela 5', 'LV-1002', 'Rīga', '0', 'skycatering.lv', 'Latvija', 'LV50003224381', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('9', '41009', 'QUALITY BEAUTY STORE LTD', '2', '+44 7070 808 708', '', '311 Roundhay Road', 'LS8 4HT', 'LEEDS', '0', 'qualitybeautystore.com', 'United Kingdom', 'GB249092390', NULL, '', '', '', '', '', '', '', '', '', '');
INSERT INTO companies (`id`, `reference`, `name`, `client_id`, `phone`, `mobile`, `address`, `zipcode`, `city`, `inactive`, `website`, `country`, `vat`, `note`, `province`, `twitter`, `skype`, `linkedin`, `facebook`, `instagram`, `googleplus`, `youtube`, `pinterest`, `terms`) VALUES ('10', '41010', 'Embassy of Travel GmbH', NULL, '+49 (0) 30 68811124', '', 'Kurfürstendamm 69', '10707', 'Berlin', '0', 'exclusivegermany.com', 'Germany', 'DE301782222', NULL, '', '', '', '', '', '', '', '', '', '');


#
# TABLE STRUCTURE FOR: company_has_admins
#

DROP TABLE IF EXISTS company_has_admins;

CREATE TABLE `company_has_admins` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `company_id` int(10) DEFAULT NULL,
  `user_id` int(10) DEFAULT NULL,
  `access` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('1', '1', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('2', '2', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('3', '3', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('4', '4', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('5', '5', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('6', '6', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('7', '7', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('8', '8', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('9', '9', '1', NULL);
INSERT INTO company_has_admins (`id`, `company_id`, `user_id`, `access`) VALUES ('10', '10', '1', NULL);


#
# TABLE STRUCTURE FOR: core
#

DROP TABLE IF EXISTS core;

CREATE TABLE `core` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` char(10) NOT NULL DEFAULT '0',
  `domain` varchar(65) DEFAULT NULL,
  `email` varchar(80) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `tax` varchar(5) DEFAULT NULL,
  `second_tax` varchar(5) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `autobackup` int(11) DEFAULT NULL,
  `cronjob` int(11) DEFAULT NULL,
  `last_cronjob` int(11) DEFAULT NULL,
  `last_autobackup` int(11) DEFAULT NULL,
  `invoice_terms` mediumtext,
  `company_reference` int(6) DEFAULT NULL,
  `project_reference` int(6) DEFAULT NULL,
  `invoice_reference` int(6) DEFAULT NULL,
  `subscription_reference` int(6) DEFAULT NULL,
  `ticket_reference` int(10) DEFAULT NULL,
  `date_format` varchar(20) DEFAULT NULL,
  `date_time_format` varchar(20) DEFAULT NULL,
  `invoice_mail_subject` varchar(150) DEFAULT NULL,
  `pw_reset_mail_subject` varchar(150) DEFAULT NULL,
  `pw_reset_link_mail_subject` varchar(150) DEFAULT NULL,
  `credentials_mail_subject` varchar(150) DEFAULT NULL,
  `notification_mail_subject` varchar(150) DEFAULT NULL,
  `language` varchar(150) DEFAULT NULL,
  `invoice_address` varchar(200) DEFAULT NULL,
  `invoice_city` varchar(200) DEFAULT NULL,
  `invoice_contact` varchar(200) DEFAULT NULL,
  `invoice_tel` varchar(50) DEFAULT NULL,
  `subscription_mail_subject` varchar(250) DEFAULT NULL,
  `logo` varchar(150) DEFAULT NULL,
  `template` varchar(200) DEFAULT 'default',
  `paypal` varchar(5) DEFAULT '1',
  `paypal_currency` varchar(200) DEFAULT 'EUR',
  `paypal_account` varchar(200) DEFAULT 'luxsys@luxsys-apps.com',
  `invoice_logo` varchar(150) DEFAULT 'assets/blackline/img/invoice_logo.png',
  `pc` varchar(150) DEFAULT NULL,
  `vat` varchar(150) DEFAULT NULL,
  `ticket_email` varchar(250) DEFAULT NULL,
  `ticket_default_owner` int(10) DEFAULT '1',
  `ticket_default_queue` int(10) DEFAULT '1',
  `ticket_default_type` int(10) DEFAULT '1',
  `ticket_default_status` varchar(200) DEFAULT 'new',
  `ticket_config_host` varchar(250) DEFAULT NULL,
  `ticket_config_login` varchar(250) DEFAULT NULL,
  `ticket_config_pass` varchar(250) DEFAULT NULL,
  `ticket_config_port` varchar(250) DEFAULT NULL,
  `ticket_config_ssl` varchar(250) DEFAULT NULL,
  `ticket_config_email` varchar(250) DEFAULT NULL,
  `ticket_config_flags` varchar(250) DEFAULT '/notls',
  `ticket_config_search` varchar(250) DEFAULT 'UNSEEN',
  `ticket_config_timestamp` int(11) DEFAULT NULL,
  `ticket_config_mailbox` varchar(250) DEFAULT NULL,
  `ticket_config_delete` int(11) DEFAULT NULL,
  `ticket_config_active` int(11) DEFAULT NULL,
  `ticket_config_imap` int(11) DEFAULT '1',
  `stripe` int(11) DEFAULT '0',
  `stripe_key` varchar(250) DEFAULT NULL,
  `stripe_p_key` varchar(255) DEFAULT NULL,
  `bank_transfer` int(11) DEFAULT NULL,
  `bank_transfer_text` longtext,
  `stripe_currency` varchar(255) NOT NULL DEFAULT 'USD',
  `estimate_terms` longtext,
  `estimate_prefix` varchar(255) NOT NULL DEFAULT 'EST',
  `estimate_pdf_template` varchar(255) NOT NULL DEFAULT 'templates/estimate/default',
  `invoice_pdf_template` varchar(255) NOT NULL DEFAULT 'invoices/preview',
  `estimate_mail_subject` varchar(255) NOT NULL DEFAULT 'New Estimate #{estimate_id}',
  `money_currency_position` int(5) NOT NULL DEFAULT '1',
  `money_format` int(5) NOT NULL DEFAULT '1',
  `pdf_font` varchar(255) NOT NULL DEFAULT 'NotoSans',
  `pdf_path` int(10) NOT NULL DEFAULT '1',
  `registration` int(10) NOT NULL DEFAULT '0',
  `authorize_api_login_id` varchar(255) DEFAULT NULL,
  `authorize_api_transaction_key` varchar(255) DEFAULT NULL,
  `authorize_net` int(20) DEFAULT '0',
  `authorize_currency` varchar(30) DEFAULT NULL,
  `invoice_prefix` varchar(255) DEFAULT NULL,
  `company_prefix` varchar(255) DEFAULT NULL,
  `quotation_prefix` varchar(255) DEFAULT NULL,
  `project_prefix` varchar(255) DEFAULT NULL,
  `subscription_prefix` varchar(255) DEFAULT NULL,
  `calendar_google_api_key` varchar(255) DEFAULT NULL,
  `calendar_google_event_address` varchar(255) DEFAULT NULL,
  `default_client_modules` varchar(255) DEFAULT NULL,
  `estimate_reference` int(10) DEFAULT '0',
  `login_background` varchar(255) DEFAULT 'blur.jpg',
  `custom_colors` int(1) DEFAULT '1',
  `top_bar_background` varchar(60) DEFAULT '#FFFFFF',
  `top_bar_color` varchar(60) DEFAULT '#333333',
  `body_background` varchar(60) DEFAULT '#e3e6ed',
  `menu_background` varchar(60) DEFAULT '#173240',
  `menu_color` varchar(60) DEFAULT '#FFFFFF',
  `primary_color` varchar(60) DEFAULT '#356cc9',
  `twocheckout_seller_id` varchar(250) DEFAULT NULL,
  `twocheckout_publishable_key` varchar(250) DEFAULT NULL,
  `twocheckout_private_key` varchar(250) DEFAULT NULL,
  `twocheckout` int(11) DEFAULT '0',
  `twocheckout_currency` varchar(250) DEFAULT NULL,
  `login_logo` varchar(255) DEFAULT NULL,
  `login_style` varchar(255) DEFAULT 'left',
  `reference_lenght` int(20) DEFAULT NULL,
  `stripe_ideal` int(1) DEFAULT NULL,
  `zip_position` varchar(60) DEFAULT 'left',
  `timezone` varchar(255) DEFAULT NULL,
  `notifications` int(1) unsigned DEFAULT '0',
  `last_notification` varchar(100) DEFAULT NULL,
  `receipt_mail_subject` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO core (`id`, `version`, `domain`, `email`, `company`, `tax`, `second_tax`, `currency`, `autobackup`, `cronjob`, `last_cronjob`, `last_autobackup`, `invoice_terms`, `company_reference`, `project_reference`, `invoice_reference`, `subscription_reference`, `ticket_reference`, `date_format`, `date_time_format`, `invoice_mail_subject`, `pw_reset_mail_subject`, `pw_reset_link_mail_subject`, `credentials_mail_subject`, `notification_mail_subject`, `language`, `invoice_address`, `invoice_city`, `invoice_contact`, `invoice_tel`, `subscription_mail_subject`, `logo`, `template`, `paypal`, `paypal_currency`, `paypal_account`, `invoice_logo`, `pc`, `vat`, `ticket_email`, `ticket_default_owner`, `ticket_default_queue`, `ticket_default_type`, `ticket_default_status`, `ticket_config_host`, `ticket_config_login`, `ticket_config_pass`, `ticket_config_port`, `ticket_config_ssl`, `ticket_config_email`, `ticket_config_flags`, `ticket_config_search`, `ticket_config_timestamp`, `ticket_config_mailbox`, `ticket_config_delete`, `ticket_config_active`, `ticket_config_imap`, `stripe`, `stripe_key`, `stripe_p_key`, `bank_transfer`, `bank_transfer_text`, `stripe_currency`, `estimate_terms`, `estimate_prefix`, `estimate_pdf_template`, `invoice_pdf_template`, `estimate_mail_subject`, `money_currency_position`, `money_format`, `pdf_font`, `pdf_path`, `registration`, `authorize_api_login_id`, `authorize_api_transaction_key`, `authorize_net`, `authorize_currency`, `invoice_prefix`, `company_prefix`, `quotation_prefix`, `project_prefix`, `subscription_prefix`, `calendar_google_api_key`, `calendar_google_event_address`, `default_client_modules`, `estimate_reference`, `login_background`, `custom_colors`, `top_bar_background`, `top_bar_color`, `body_background`, `menu_background`, `menu_color`, `primary_color`, `twocheckout_seller_id`, `twocheckout_publishable_key`, `twocheckout_private_key`, `twocheckout`, `twocheckout_currency`, `login_logo`, `login_style`, `reference_lenght`, `stripe_ideal`, `zip_position`, `timezone`, `notifications`, `last_notification`, `receipt_mail_subject`) VALUES ('1', '3.2.9', 'https://my.apusseo.com/', 'info@apusseo.com', 'SIA Apus', '21', '0', 'EUR', '1', '1', '0', '0', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '41011', '51009', '20', '61002', '10033', 'd/m/Y', 'H:i', 'New Invoice', 'Password Reset', 'Password Reset', 'Login Details', 'Notification', 'english', 'Brīvības iela 224 k.2', 'Rīga, LV-1039', 'Sergej', '+371 28316172', 'New Subscription', 'files/media/apus-logo-white.svg', 'blueline', '0', 'EUR', '', 'files/media/apus-logo.svg', 'nulled', 'LV40103951003', NULL, '1', '1', '1', 'new', 'cp.euwebhoster.com', 'info@apusseo.com', 'taba4okyoy', '993', '1', 'info@apusseo.com', '/notls', 'UNSEEN', '1566487501', 'inbox', '0', '1', '1', '0', NULL, NULL, '1', '', 'USD', '', 'EST', 'templates/estimate/default', 'templates/invoice/default', 'New Estimate #{estimate_id}', '1', '1', 'NotoSans', '1', '0', NULL, NULL, '0', NULL, '2019-', '', '', '', '', NULL, NULL, NULL, '20001', 'At-Organik-SEO-Office.jpg', '1', '#ffffff', '#333333', '#e3e6ed', '#173240', '#ffffff', '#356cc9', NULL, NULL, NULL, '0', NULL, NULL, 'left', NULL, NULL, 'left', 'Europe/Riga', '0', NULL, 'Your payment received');


#
# TABLE STRUCTURE FOR: custom_quotation_requests
#

DROP TABLE IF EXISTS custom_quotation_requests;

CREATE TABLE `custom_quotation_requests` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `form` longtext,
  `custom_quotation_id` int(11) DEFAULT NULL,
  `date` varchar(50) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `user_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: custom_quotations
#

DROP TABLE IF EXISTS custom_quotations;

CREATE TABLE `custom_quotations` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `formcontent` longtext,
  `inactive` int(250) DEFAULT '0',
  `user_id` int(11) DEFAULT NULL,
  `created` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO custom_quotations (`id`, `name`, `formcontent`, `inactive`, `user_id`, `created`) VALUES ('1', 'SEO service quotation', '{\"fields\":[{\"label\":\"What kind of the service are you looking for?\",\"field_type\":\"radio\",\"required\":true,\"field_options\":{\"options\":[{\"label\":\"Independent seo audit\",\"checked\":false},{\"label\":\"Full Seo pack for new website\",\"checked\":false},{\"label\":\"seo for old project with previous seo footprints\",\"checked\":false},{\"label\":\"linkbuilding, pbn, guest posts\",\"checked\":false},{\"label\":\"technical optimisation\",\"checked\":false}]},\"cid\":\"c2\"},{\"label\":\"Your project domain url\",\"field_type\":\"text\",\"required\":true,\"field_options\":{\"size\":\"small\"},\"cid\":\"c18\"},{\"label\":\"Give us some information about your what you are doing and what you expect... *\",\"field_type\":\"paragraph\",\"required\":true,\"field_options\":{\"size\":\"small\"},\"cid\":\"c31\"},{\"label\":\"What is your approximate SEO budget? (EUR/month)\",\"field_type\":\"checkboxes\",\"required\":true,\"field_options\":{\"options\":[{\"label\":\"less than 250\",\"checked\":false},{\"label\":\"250 to 550\",\"checked\":false},{\"label\":\"550 to 1300\",\"checked\":false},{\"label\":\"more than 1300\",\"checked\":false}]},\"cid\":\"c26\"},{\"label\":\"Business name\",\"field_type\":\"text\",\"required\":false,\"field_options\":{\"size\":\"small\"},\"cid\":\"c30\"},{\"label\":\"Full name\",\"field_type\":\"text\",\"required\":true,\"field_options\":{\"size\":\"small\"},\"cid\":\"c34\"},{\"label\":\"Email\",\"field_type\":\"email\",\"required\":true,\"field_options\":[],\"cid\":\"c38\"},{\"label\":\"Phone\",\"field_type\":\"text\",\"required\":true,\"field_options\":{\"size\":\"small\"},\"cid\":\"c42\"},{\"label\":\"country\",\"field_type\":\"text\",\"required\":true,\"field_options\":{\"size\":\"small\"},\"cid\":\"c27\"}]}', '0', '1', NULL);


#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS events;

CREATE TABLE `events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `allday` varchar(30) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `classname` varchar(255) DEFAULT NULL,
  `start` varchar(255) DEFAULT NULL,
  `end` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT '0',
  `access` varchar(255) DEFAULT NULL,
  `reminder` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS expenses;

CREATE TABLE `expenses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `currency` varchar(255) DEFAULT NULL,
  `value` float(20,2) DEFAULT '0.00',
  `vat` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `project_id` bigint(20) DEFAULT '0',
  `rebill` int(20) DEFAULT '0',
  `invoice_id` bigint(20) DEFAULT '0',
  `attachment` varchar(255) DEFAULT NULL,
  `attachment_description` varchar(255) DEFAULT NULL,
  `recurring` varchar(255) DEFAULT NULL,
  `recurring_until` varchar(255) DEFAULT NULL,
  `user_id` int(20) DEFAULT '0',
  `expense_id` int(20) DEFAULT '0',
  `next_payment` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('1', 'Brivibas 224', 'recurring_payment', 'Office Costs', '2019-01-01', 'EUR', '250.00', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '2019-12-31', '1', '0', '2019-02-01', 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('2', 'vw passat', 'payment', 'Auto Expenses', '2019-01-01', 'EUR', '216.99', '', '', '0', '1', '0', NULL, NULL, '+1 month', '2019-12-31', '1', '0', '2019-02-01', 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('3', 'Jelena', 'recurring_payment', 'Accountancy Fees', '2019-01-01', 'EUR', '50.00', '', '', '0', '0', '0', NULL, NULL, '+1 month', '2019-12-31', '1', '0', '2019-02-01', 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('4', 'tele2 internet', 'recurring_payment', 'Web Hosting', '2019-01-01', 'EUR', '14.00', '', '', '0', '0', '0', NULL, NULL, '+1 month', '2019-12-31', '1', '0', '2019-02-01', 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('5', 'printer hp', 'payment', 'Computer Hardware', '2019-01-30', 'EUR', '150.70', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('6', 'CAR COMPANY TAX', 'payment', 'Auto Expenses', '2019-01-30', 'EUR', '175.00', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('7', 'Office sofa', 'payment', 'Office Costs', '2019-01-30', 'EUR', '80.00', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('8', 'neste fuel for january', 'payment', 'Auto Expenses', '2019-02-05', 'EUR', '72.50', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('9', 'january salary', 'payment', 'salary', '2019-02-05', 'EUR', '546.00', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('10', 'water', 'payment', 'Accommodation', '2019-02-06', 'EUR', '45.00', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('11', 'headphones', 'payment', 'Computer Hardware', '2019-03-08', 'EUR', '180.00', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Paid');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('12', 'water', 'payment', 'Office Costs', '2019-03-12', 'EUR', '9.99', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Paid');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('13', 'vw passat', 'payment', 'Auto Expenses', '2019-02-01', 'EUR', '216.99', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Paid');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('14', 'vw passat', 'payment', 'Auto Expenses', '2019-03-12', 'EUR', '216.99', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Paid');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('15', 'brivibas 224', 'payment', 'Office Costs', '2019-03-12', 'EUR', '274.56', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Paid');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('16', 'neste fuel for february', 'payment', 'Auto Expenses', '2019-03-12', 'EUR', '138.00', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Paid');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('17', 'tele2', 'payment', 'Office Costs', '2019-03-12', 'EUR', '15.45', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Paid');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('18', 'february salary', 'payment', 'salary', '2019-03-12', 'EUR', '546.00', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Paid');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('19', 'skapis', 'payment', 'Office Costs', '2019-03-26', 'EUR', '75.00', '', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('20', 'PC adapter', 'payment', '15', '2019-03-26', 'EUR', '15.00', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('21', 'wifi device', 'payment', 'Computer Hardware', '2019-03-26', 'EUR', '195.00', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');
INSERT INTO expenses (`id`, `description`, `type`, `category`, `date`, `currency`, `value`, `vat`, `reference`, `project_id`, `rebill`, `invoice_id`, `attachment`, `attachment_description`, `recurring`, `recurring_until`, `user_id`, `expense_id`, `next_payment`, `status`) VALUES ('22', 'neste fuel for january', 'payment', 'Travel', '2019-04-04', 'EUR', '73.23', '21', '', '0', '0', '0', NULL, NULL, '+1 month', '', '1', '0', NULL, 'Open');


#
# TABLE STRUCTURE FOR: invoice_has_items
#

DROP TABLE IF EXISTS invoice_has_items;

CREATE TABLE `invoice_has_items` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) DEFAULT '0',
  `item_id` int(11) DEFAULT '0',
  `amount` char(11) DEFAULT NULL,
  `description` mediumtext,
  `value` float DEFAULT '0',
  `name` varchar(250) DEFAULT NULL,
  `type` varchar(250) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('3', '2', '0', '1', 'Google ads campaign setup', '500', 'Google reklāmu kampaņas iestatīšana', 'ads', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('2', '1', '0', '1', 'Apkalposanas periods (1.01.2019 - 31.01.2019)', '500', 'SEO apkalpošana / SEO service', 'seo', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('4', '4', '0', '1', 'Apkalposanas periods (1.01.2019 - 31.01.2019)', '800', 'google Ads apkalpošana / service', 'google', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('5', '4', '0', '1', '', '309', 'veb lapās apkalpošana / website service', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('6', '5', '1', '1', 'Apkalposanas periods (29.01.2019 - 28.02.2019)', '200', 'google Ads apkalpošana / service', 'google', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('7', '6', '1', '1', 'Apkalposanas periods (1.02.2019 - 28.02.2019)', '888', 'SEO apkalpošana / SEO service', 'seo', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('8', '6', '3', '1', 'Apkalposanas periods (1.02.2019 - 28.02.2019)', '500', 'google Ads apkalpošana / service', 'ads', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('9', '6', '2', '1', '', '434', 'veb lapās apkalpošana / website service', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('10', '7', '2', '1', '', '700', 'Mājas lapu izstrāde', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('11', '8', '0', '1', '', '1315', 'Organic Leads Feb-Mar', 'leads', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('12', '8', '0', '1', '', '2461', 'Google ads Leads Feb-Mar', 'google', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('13', '9', '1', '1', 'Apkalposanas periods (1.03.2019 - 31.03.2019)', '888', 'SEO apkalpošana / SEO service', 'seo', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('14', '9', '3', '1', 'Apkalposanas periods (1.03.2019 - 31.03.2019)', '500', 'google Ads apkalpošana / service', 'ads', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('15', '9', '0', '1', '', '3055', 'Mājas lapu izstrāde / website development', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('16', '10', '2', '1', '', '3570', 'veb lapās apkalpošana / website service', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('17', '11', '1', '1', 'Apkalposanas periods (1.04.2019 - 30.04.2019)', '888', 'SEO apkalpošana / SEO service', 'seo', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('18', '11', '4', '1', '', '3398', 'Mājas lapu izstrāde / website development', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('19', '12', '0', '1', '', '625', 'Organic Leads Apr', 'leads', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('20', '12', '0', '1', '', '825', 'Google ads Leads Apr', 'leads', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('21', '13', '2', '1', 'Apkalposanas periods (1.04.2019 - 30.04.2019)', '3050', 'veb lapās apkalpošana / website service', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('22', '14', '1', '1', 'Apkalposanas periods (1.05.2019 - 31.05.2019)', '888', 'SEO apkalpošana / SEO service', 'seo', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('23', '14', '4', '1', '', '2300', 'Mājas lapu izstrāde / website development', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('24', '15', '2', '1', 'Apkalposanas periods (1.05.2019 - 31.05.2019)', '2845.5', 'veb lapās apkalpošana / website service', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('25', '16', '1', '1', 'Apkalposanas periods (1.06.2019 - 30.06.2019)', '2730.5', 'SEO apkalpošana / SEO service', 'seo', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('26', '17', '2', '1', '	Apkalposanas periods (1.06.2019 - 30.06.2019)', '1437.5', 'veb lapās apkalpošana / website service', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('27', '18', '2', '1', 'Apkalposanas periods (1.07.2019 - 31.07.2019)', '1510', 'veb lapās apkalpošana / website service', 'web', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('28', '19', '1', '1', 'Apkalposanas periods (1.07.2019 - 31.07.2019)', '4688.5', 'SEO apkalpošana / SEO service', 'seo', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('29', '20', '5', '1', '', '1000', 'Mājas lapu optimizācija / Tech. optimisation', 'SEO', NULL);
INSERT INTO invoice_has_items (`id`, `invoice_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`, `task_id`) VALUES ('30', '20', '6', '1', '', '1200', 'Tekstu optimizācija / Content optimisation', 'SEO', NULL);


#
# TABLE STRUCTURE FOR: invoice_has_payments
#

DROP TABLE IF EXISTS invoice_has_payments;

CREATE TABLE `invoice_has_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) DEFAULT '0',
  `reference` varchar(255) DEFAULT NULL,
  `amount` float DEFAULT '0',
  `date` varchar(20) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `notes` text,
  `user_id` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('1', '1', '1001', '500', '2019-01-25', 'bank_transfer', '9025J2120­‌644988S0A­‌I', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('2', '2', '2001', '500', '2019-02-01', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('3', '4', '3001', '1109', '2019-02-05', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('4', '6', '5001', '1822', '2019-03-07', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('5', '5', '4001', '200', '2019-03-26', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('6', '9', '8001', '4443', '2019-04-04', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('7', '10', '9001', '3570', '2019-04-04', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('8', '8', '7001', '3776', '2019-05-07', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('9', '11', '10001', '4286', '2019-05-13', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('10', '13', '12001', '3050', '2019-05-16', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('11', '12', '11001', '1450', '2019-06-07', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('12', '14', '13001', '3188', '2019-06-12', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('13', '15', '14001', '2845.5', '2019-07-08', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('14', '17', '16001', '1437.5', '2019-07-09', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('15', '16', '15001', '2730.5', '2019-07-09', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('16', '19', '18001', '4688.5', '2019-08-14', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('17', '18', '17001', '1510', '2019-08-14', 'bank_transfer', '', '1');
INSERT INTO invoice_has_payments (`id`, `invoice_id`, `reference`, `amount`, `date`, `type`, `notes`, `user_id`) VALUES ('18', '7', '6001', '847', '2019-08-22', 'bank_transfer', '', '1');


#
# TABLE STRUCTURE FOR: invoices
#

DROP TABLE IF EXISTS invoices;

CREATE TABLE `invoices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sum` float NOT NULL DEFAULT '0',
  `estimate_sent` varchar(255) NOT NULL DEFAULT '0',
  `estimate_status` varchar(255) NOT NULL DEFAULT '0',
  `project_id` int(11) DEFAULT '0',
  `reference` int(11) DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  `status` varchar(50) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `issue_date` varchar(20) DEFAULT NULL,
  `due_date` varchar(20) DEFAULT NULL,
  `sent_date` varchar(20) DEFAULT NULL,
  `paid_date` varchar(20) DEFAULT NULL,
  `terms` mediumtext,
  `discount` varchar(50) DEFAULT NULL,
  `subscription_id` varchar(50) DEFAULT NULL,
  `tax` varchar(255) DEFAULT NULL,
  `second_tax` varchar(5) DEFAULT NULL,
  `estimate` int(11) DEFAULT '0',
  `estimate_accepted_date` varchar(255) DEFAULT NULL,
  `paid` float DEFAULT '0',
  `outstanding` float DEFAULT NULL,
  `estimate_reference` int(10) DEFAULT '0',
  `po_number` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('1', '500', '0', '0', '0', '1', '1', 'Paid', 'EUR', '2019-01-03', '2019-02-04', NULL, '2019-01-25', '<p>Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.</p><p>The invoice has been prepared electronically and is valid without signature.<br></p>', '', '1', '0', '', '0', NULL, '500', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('2', '500', '0', '0', '5', '2', '3', 'Paid', 'EUR', '2019-01-24', '2019-01-31', NULL, '2019-02-01', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '500', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('3', '0', '0', 'Open', '2', '0', '1', 'Open', 'EUR', '2019-01-30', '2019-02-04', NULL, NULL, '<p>test</p>', '', NULL, '0', '', '1', NULL, '0', NULL, '20000', NULL);
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('4', '1109', '0', '0', '0', '3', '1', 'Paid', 'EUR', '2019-01-31', '2019-02-07', NULL, '2019-02-05', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '1109', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('5', '200', '0', '0', '5', '4', '3', 'Paid', 'EUR', '2019-02-28', '2019-03-14', NULL, '2019-03-26', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '200', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('6', '1822', '0', '0', '0', '5', '1', 'Paid', 'EUR', '2019-03-01', '2019-03-07', NULL, '2019-03-07', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '1822', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('7', '847', '0', '0', '0', '6', '8', 'Paid', 'EUR', '2019-04-01', '2019-04-08', NULL, '2019-08-22', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '21', '', '0', NULL, '847', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('8', '3776', '0', '0', '0', '7', '2', 'Paid', 'EUR', '2019-04-01', '2019-04-18', NULL, '2019-05-07', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '3776', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('9', '4443', '0', '0', '0', '8', '1', 'Paid', 'EUR', '2019-04-01', '2019-04-11', NULL, '2019-04-04', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '4443', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('10', '3570', '0', '0', '0', '9', '9', 'Paid', 'EUR', '2019-04-01', '2019-04-04', NULL, '2019-04-04', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '3570', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('11', '4286', '0', '0', '0', '10', '1', 'Paid', 'EUR', '2019-05-03', '2019-05-17', NULL, '2019-05-13', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '4286', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('12', '1450', '0', '0', '0', '11', '2', 'Paid', 'EUR', '2019-05-03', '2017-05-19', NULL, '2019-06-07', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '1450', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('13', '3050', '0', '0', '0', '12', '9', 'Paid', 'EUR', '2019-05-03', '2019-05-17', NULL, '2019-05-16', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '3050', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('14', '3188', '0', '0', '0', '13', '1', 'Paid', 'EUR', '2019-06-10', '2019-06-20', NULL, '2019-06-12', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '3188', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('15', '2845.5', '0', '0', '0', '14', '9', 'Paid', 'EUR', '2019-06-10', '2019-06-20', NULL, '2019-07-08', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '2845.5', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('16', '2730.5', '0', '0', '0', '15', '1', 'Paid', 'EUR', '2019-07-05', '2019-07-12', NULL, '2019-07-09', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '2730.5', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('17', '1437.5', '0', '0', '0', '16', '9', 'Paid', 'EUR', '2019-07-05', '2019-07-12', NULL, '2019-07-09', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '1437.5', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('18', '1510', '0', '0', '0', '17', '9', 'Paid', 'EUR', '2019-08-08', '2019-08-15', NULL, '2019-08-14', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '1510', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('19', '4688.5', '0', '0', '0', '18', '1', 'Paid', 'EUR', '2019-08-08', '2019-08-15', NULL, '2019-08-14', 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '4688.5', '0', '0', '');
INSERT INTO invoices (`id`, `sum`, `estimate_sent`, `estimate_status`, `project_id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `due_date`, `sent_date`, `paid_date`, `terms`, `discount`, `subscription_id`, `tax`, `second_tax`, `estimate`, `estimate_accepted_date`, `paid`, `outstanding`, `estimate_reference`, `po_number`) VALUES ('20', '2200', '0', '0', '0', '19', '10', 'Open', 'EUR', '2019-08-16', '2019-08-23', NULL, NULL, 'Rēķins ir sagatavots elektroniski un ir derīgs bez paraksa.<div>The invoice has been prepared electronically and is valid without signature.<br></div>', '', NULL, '0', '', '0', NULL, '0', '2200', '0', '');


#
# TABLE STRUCTURE FOR: items
#

DROP TABLE IF EXISTS items;

CREATE TABLE `items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `value` float DEFAULT '0',
  `type` varchar(45) DEFAULT NULL,
  `inactive` tinyint(4) DEFAULT '0',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO items (`id`, `name`, `value`, `type`, `inactive`, `description`) VALUES ('1', 'SEO apkalpošana / SEO service', '500', 'seo', '0', '');
INSERT INTO items (`id`, `name`, `value`, `type`, `inactive`, `description`) VALUES ('2', 'veb lapās apkalpošana / website service', '500', 'web', '0', '');
INSERT INTO items (`id`, `name`, `value`, `type`, `inactive`, `description`) VALUES ('3', 'google Ads apkalpošana / service', '500', 'ads', '0', 'Apkalposanas periods (x.2019 - x.2019)');
INSERT INTO items (`id`, `name`, `value`, `type`, `inactive`, `description`) VALUES ('4', 'Mājas lapu izstrāde / website development', '3500', 'web', '0', '');
INSERT INTO items (`id`, `name`, `value`, `type`, `inactive`, `description`) VALUES ('5', 'Mājas lapu optimizācija / Tech. optimisation', '1000', 'SEO', '0', '');
INSERT INTO items (`id`, `name`, `value`, `type`, `inactive`, `description`) VALUES ('6', 'Tekstu optimizācija / Content optimisation', '1200', 'SEO', '0', '');


#
# TABLE STRUCTURE FOR: lead_has_comments
#

DROP TABLE IF EXISTS lead_has_comments;

CREATE TABLE `lead_has_comments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attachment` varchar(250) DEFAULT NULL,
  `attachment_link` varchar(250) DEFAULT NULL,
  `datetime` varchar(250) DEFAULT NULL,
  `message` text,
  `user_id` bigint(20) DEFAULT '0',
  `lead_id` bigint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: lead_status
#

DROP TABLE IF EXISTS lead_status;

CREATE TABLE `lead_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `order` float DEFAULT '0',
  `offset` bigint(200) DEFAULT '0',
  `limit` bigint(200) DEFAULT '50',
  `color` varchar(100) DEFAULT '#5071ab',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO lead_status (`id`, `name`, `description`, `order`, `offset`, `limit`, `color`) VALUES ('1', 'email', '', '1', '0', '50', '#1261cb');
INSERT INTO lead_status (`id`, `name`, `description`, `order`, `offset`, `limit`, `color`) VALUES ('2', 'lead', '', '2', '0', '50', '#1261cb');


#
# TABLE STRUCTURE FOR: leads
#

DROP TABLE IF EXISTS leads;

CREATE TABLE `leads` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status_id` bigint(20) DEFAULT '0',
  `source` varchar(250) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `position` varchar(250) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `city` varchar(250) DEFAULT NULL,
  `state` varchar(250) DEFAULT NULL,
  `country` varchar(250) DEFAULT NULL,
  `zipcode` varchar(250) DEFAULT NULL,
  `language` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `website` varchar(250) DEFAULT NULL,
  `phone` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `company` varchar(250) DEFAULT NULL,
  `tags` varchar(250) DEFAULT NULL,
  `description` text,
  `first_contact` varchar(250) DEFAULT NULL,
  `last_contact` varchar(250) DEFAULT NULL,
  `valid_until` varchar(250) DEFAULT NULL,
  `created` varchar(20) DEFAULT NULL,
  `modified` varchar(20) DEFAULT NULL,
  `private` varchar(20) DEFAULT '0',
  `custom` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT '0',
  `icon` varchar(255) DEFAULT NULL,
  `order` float DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS messages;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT '0',
  `media_id` int(11) DEFAULT '0',
  `from` varchar(120) DEFAULT NULL,
  `text` text,
  `datetime` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS migrations;

CREATE TABLE `migrations` (
  `version` int(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO migrations (`version`) VALUES ('41');


#
# TABLE STRUCTURE FOR: modules
#

DROP TABLE IF EXISTS modules;

CREATE TABLE `modules` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `link` varchar(250) DEFAULT NULL,
  `type` varchar(250) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=109 DEFAULT CHARSET=utf8;

INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('1', 'Dashboard', 'dashboard', 'main', 'icon dripicons-meter', '1');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('2', 'Messages', 'messages', 'main', 'icon dripicons-message', '2');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('3', 'Projects', 'projects', 'main', 'icon dripicons-rocket', '3');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('4', 'Clients', 'clients', 'main', 'icon dripicons-user', '4');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('5', 'Invoices', 'invoices', 'main', 'icon dripicons-document', '5');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('6', 'Items', 'items', 'main', 'icon dripicons-shopping-bag', '7');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('7', 'Quotations', 'quotations', 'main', 'icon dripicons-blog', '8');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('8', 'Subscriptions', 'subscriptions', 'main', 'icon dripicons-retweet', '6');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('9', 'Settings', 'settings', 'main', 'icon dripicons-toggles', '20');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('10', 'QuickAccess', 'quickaccess', 'widget', '', '50');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('11', 'User Online', 'useronline', 'widget', '', '51');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('12', 'Estimates', 'estimates', 'main', 'icon dripicons-document-edit', '5');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('13', 'Expenses', 'expenses', 'main', 'icon dripicons-cart', '5');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('20', 'Calendar', 'calendar', 'main', 'icon dripicons-calendar', '8');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('33', 'Reports', 'reports', 'main', 'icon dripicons-graph-pie', '8');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('101', 'Projects', 'cprojects', 'client', 'icon dripicons-rocket', '2');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('102', 'Invoices', 'cinvoices', 'client', 'icon dripicons-document', '3');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('103', 'Messages', 'cmessages', 'client', 'icon dripicons-message', '1');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('104', 'Subscriptions', 'csubscriptions', 'client', 'icon dripicons-retweet', '4');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('105', 'Tickets', 'tickets', 'main', 'icon dripicons-ticket', '8');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('106', 'Tickets', 'ctickets', 'client', 'icon dripicons-ticket', '4');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('107', 'Estimates', 'cestimates', 'client', 'icon dripicons-document-edit', '3');
INSERT INTO modules (`id`, `name`, `link`, `type`, `icon`, `sort`) VALUES ('108', 'Leads', 'leads', 'main', 'icon dripicons-phone', '4');


#
# TABLE STRUCTURE FOR: privatemessages
#

DROP TABLE IF EXISTS privatemessages;

CREATE TABLE `privatemessages` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(150) DEFAULT NULL,
  `sender` varchar(250) DEFAULT NULL,
  `recipient` varchar(250) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text,
  `time` varchar(100) DEFAULT NULL,
  `conversation` varchar(32) DEFAULT NULL,
  `deleted` int(11) DEFAULT '0',
  `attachment` varchar(255) DEFAULT NULL,
  `attachment_link` varchar(255) DEFAULT NULL,
  `receiver_delete` int(11) DEFAULT '0',
  `marked` int(1) DEFAULT '0',
  `read` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: project_has_activities
#

DROP TABLE IF EXISTS project_has_activities;

CREATE TABLE `project_has_activities` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) DEFAULT '0',
  `user_id` bigint(20) DEFAULT '0',
  `client_id` bigint(20) DEFAULT '0',
  `datetime` varchar(250) DEFAULT NULL,
  `subject` varchar(250) DEFAULT NULL,
  `message` text,
  `type` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO project_has_activities (`id`, `project_id`, `user_id`, `client_id`, `datetime`, `subject`, `message`, `type`) VALUES ('1', '2', '0', '1', '1547817901', 'Media file has been added', '<b>Anton Geier</b> uploaded Anton Geier', 'media');


#
# TABLE STRUCTURE FOR: project_has_files
#

DROP TABLE IF EXISTS project_has_files;

CREATE TABLE `project_has_files` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `project_id` int(10) DEFAULT '0',
  `user_id` int(10) DEFAULT '0',
  `client_id` int(10) DEFAULT '0',
  `type` varchar(80) DEFAULT NULL,
  `name` varchar(120) DEFAULT NULL,
  `filename` varchar(150) DEFAULT NULL,
  `description` text,
  `savename` varchar(200) DEFAULT NULL,
  `phase` varchar(100) DEFAULT NULL,
  `date` varchar(50) DEFAULT NULL,
  `download_counter` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO project_has_files (`id`, `project_id`, `user_id`, `client_id`, `type`, `name`, `filename`, `description`, `savename`, `phase`, `date`, `download_counter`) VALUES ('1', '2', '0', '1', 'image/jpeg', 'Anton Geier', 'thnak_you_page.jpg', 'thank you page', 'eddc2df20b140f93f55540053bd53cfa.jpg', 'Planning', '2019-01-18 15:24', '1');


#
# TABLE STRUCTURE FOR: project_has_invoices
#

DROP TABLE IF EXISTS project_has_invoices;

CREATE TABLE `project_has_invoices` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL,
  `invoice_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: project_has_milestones
#

DROP TABLE IF EXISTS project_has_milestones;

CREATE TABLE `project_has_milestones` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `description` longtext,
  `due_date` varchar(255) DEFAULT NULL,
  `orderindex` int(11) DEFAULT '0',
  `start_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: project_has_tasks
#

DROP TABLE IF EXISTS project_has_tasks;

CREATE TABLE `project_has_tasks` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `project_id` int(10) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `user_id` int(10) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `public` int(10) DEFAULT NULL,
  `datetime` int(11) DEFAULT NULL,
  `due_date` varchar(250) DEFAULT NULL,
  `description` text,
  `start_date` varchar(250) DEFAULT NULL,
  `value` float DEFAULT '0',
  `priority` smallint(6) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `client_id` int(30) DEFAULT '0',
  `created_by_client` int(30) DEFAULT '0',
  `tracking` int(11) DEFAULT '0',
  `time_spent` int(11) DEFAULT '0',
  `milestone_id` int(11) DEFAULT '0',
  `invoice_id` int(60) DEFAULT '0',
  `milestone_order` int(11) DEFAULT '0',
  `task_order` int(11) DEFAULT '0',
  `progress` int(11) DEFAULT '0',
  `created_at` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO project_has_tasks (`id`, `project_id`, `name`, `user_id`, `status`, `public`, `datetime`, `due_date`, `description`, `start_date`, `value`, `priority`, `time`, `client_id`, `created_by_client`, `tracking`, `time_spent`, `milestone_id`, `invoice_id`, `milestone_order`, `task_order`, `progress`, `created_at`) VALUES ('1', '3', 'test1', NULL, 'open', '1', NULL, '', '', NULL, '0', '2', NULL, '1', '1', '0', '0', '0', '0', '0', '0', '0', '2019-01-18 15:11:49');
INSERT INTO project_has_tasks (`id`, `project_id`, `name`, `user_id`, `status`, `public`, `datetime`, `due_date`, `description`, `start_date`, `value`, `priority`, `time`, `client_id`, `created_by_client`, `tracking`, `time_spent`, `milestone_id`, `invoice_id`, `milestone_order`, `task_order`, `progress`, `created_at`) VALUES ('2', '2', 'forma zaprosa na pervoj stranize', NULL, 'open', '1', NULL, '', '', NULL, '0', '2', NULL, '1', '1', '0', '0', '0', '0', '0', '0', '0', '2019-01-18 15:24:14');
INSERT INTO project_has_tasks (`id`, `project_id`, `name`, `user_id`, `status`, `public`, `datetime`, `due_date`, `description`, `start_date`, `value`, `priority`, `time`, `client_id`, `created_by_client`, `tracking`, `time_spent`, `milestone_id`, `invoice_id`, `milestone_order`, `task_order`, `progress`, `created_at`) VALUES ('3', '8', 'FB messangericon', '1', 'done', '0', NULL, '', '', '2019-05-02', '2', '1', NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '2019-05-02 11:28:36');


#
# TABLE STRUCTURE FOR: project_has_timesheets
#

DROP TABLE IF EXISTS project_has_timesheets;

CREATE TABLE `project_has_timesheets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT '0',
  `user_id` int(11) DEFAULT '0',
  `time` varchar(250) DEFAULT '0',
  `task_id` int(11) DEFAULT '0',
  `client_id` int(11) DEFAULT '0',
  `start` varchar(250) DEFAULT '0',
  `end` varchar(250) DEFAULT '0',
  `invoice_id` int(11) DEFAULT '0',
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: project_has_workers
#

DROP TABLE IF EXISTS project_has_workers;

CREATE TABLE `project_has_workers` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `project_id` int(10) DEFAULT NULL,
  `user_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO project_has_workers (`id`, `project_id`, `user_id`) VALUES ('1', '1', '1');
INSERT INTO project_has_workers (`id`, `project_id`, `user_id`) VALUES ('2', '2', '1');
INSERT INTO project_has_workers (`id`, `project_id`, `user_id`) VALUES ('3', '3', '1');
INSERT INTO project_has_workers (`id`, `project_id`, `user_id`) VALUES ('4', '4', '1');
INSERT INTO project_has_workers (`id`, `project_id`, `user_id`) VALUES ('5', '5', '1');
INSERT INTO project_has_workers (`id`, `project_id`, `user_id`) VALUES ('6', '6', '1');
INSERT INTO project_has_workers (`id`, `project_id`, `user_id`) VALUES ('7', '7', '1');
INSERT INTO project_has_workers (`id`, `project_id`, `user_id`) VALUES ('8', '8', '1');


#
# TABLE STRUCTURE FOR: projects
#

DROP TABLE IF EXISTS projects;

CREATE TABLE `projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` int(11) DEFAULT '0',
  `name` varchar(65) DEFAULT NULL,
  `description` text,
  `start` varchar(20) DEFAULT NULL,
  `end` varchar(20) DEFAULT NULL,
  `progress` decimal(3,0) DEFAULT NULL,
  `phases` varchar(150) DEFAULT NULL,
  `tracking` int(11) DEFAULT '0',
  `time_spent` int(11) DEFAULT '0',
  `datetime` int(11) DEFAULT '0',
  `sticky` enum('1','0') DEFAULT '0',
  `category` varchar(150) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  `note` longtext,
  `progress_calc` tinyint(4) DEFAULT '0',
  `hide_tasks` int(1) DEFAULT '0',
  `enable_client_tasks` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO projects (`id`, `reference`, `name`, `description`, `start`, `end`, `progress`, `phases`, `tracking`, `time_spent`, `datetime`, `sticky`, `category`, `company_id`, `note`, `progress_calc`, `hide_tasks`, `enable_client_tasks`) VALUES ('1', '51001', 'bcs-bus.com SEO', '', '2019-01-01', '2019-06-30', '0', 'Planning, Developing, Testing', '0', '7', '1547224996', '0', 'SEO', '1', NULL, '0', '0', '1');
INSERT INTO projects (`id`, `reference`, `name`, `description`, `start`, `end`, `progress`, `phases`, `tracking`, `time_spent`, `datetime`, `sticky`, `category`, `company_id`, `note`, `progress_calc`, `hide_tasks`, `enable_client_tasks`) VALUES ('2', '51002', 'bcs-bus limo ads', '', '2019-01-01', '2019-06-30', '0', 'Planning, Developing, Testing', '0', '0', '1547237808', '0', 'Ads', '1', NULL, '0', '0', '1');
INSERT INTO projects (`id`, `reference`, `name`, `description`, `start`, `end`, `progress`, `phases`, `tracking`, `time_spent`, `datetime`, `sticky`, `category`, `company_id`, `note`, `progress_calc`, `hide_tasks`, `enable_client_tasks`) VALUES ('3', '51003', 'bus-service new design', '', '2019-01-14', '2019-01-31', '0', 'Planning, Developing, Testing', '0', '0', '1547237858', '0', 'design', '1', NULL, '0', '0', '1');
INSERT INTO projects (`id`, `reference`, `name`, `description`, `start`, `end`, `progress`, `phases`, `tracking`, `time_spent`, `datetime`, `sticky`, `category`, `company_id`, `note`, `progress_calc`, `hide_tasks`, `enable_client_tasks`) VALUES ('4', '51004', 'bus-service SEO', '', '2019-01-01', '2019-06-30', '0', 'Planning, Developing, Testing', '0', '0', '1547237907', '0', 'SEO', '0', NULL, '0', '0', '1');
INSERT INTO projects (`id`, `reference`, `name`, `description`, `start`, `end`, `progress`, `phases`, `tracking`, `time_spent`, `datetime`, `sticky`, `category`, `company_id`, `note`, `progress_calc`, `hide_tasks`, `enable_client_tasks`) VALUES ('5', '51005', 'Jahnes google ads', '', '2019-01-10', '2019-01-18', '0', 'Planning, Developing, Testing', '0', '0', '1547237969', '0', 'Ads', '3', NULL, '0', '0', '1');
INSERT INTO projects (`id`, `reference`, `name`, `description`, `start`, `end`, `progress`, `phases`, `tracking`, `time_spent`, `datetime`, `sticky`, `category`, `company_id`, `note`, `progress_calc`, `hide_tasks`, `enable_client_tasks`) VALUES ('6', '51006', 'BCS chat bot', '', '2019-01-01', '2019-01-31', '0', 'Planning, Developing, Testing', '0', '0', '1547238181', '0', 'Administration', '0', NULL, '0', '0', '1');
INSERT INTO projects (`id`, `reference`, `name`, `description`, `start`, `end`, `progress`, `phases`, `tracking`, `time_spent`, `datetime`, `sticky`, `category`, `company_id`, `note`, `progress_calc`, `hide_tasks`, `enable_client_tasks`) VALUES ('7', '51007', 'BlackLimousines ads', '', '2019-01-01', '2019-06-30', '0', 'Planning, Developing, Testing', '0', '2', '1547238334', '0', 'Ads', '0', NULL, '0', '0', '1');
INSERT INTO projects (`id`, `reference`, `name`, `description`, `start`, `end`, `progress`, `phases`, `tracking`, `time_spent`, `datetime`, `sticky`, `category`, `company_id`, `note`, `progress_calc`, `hide_tasks`, `enable_client_tasks`) VALUES ('8', '51008', 'QBS website', '', '2019-05-01', '2018-05-31', '100', 'Planning, Developing, Testing', '0', '7200', '1556785676', '0', 'design', '9', NULL, '1', '0', '1');


#
# TABLE STRUCTURE FOR: pw_reset
#

DROP TABLE IF EXISTS pw_reset;

CREATE TABLE `pw_reset` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `email` varchar(250) DEFAULT NULL,
  `timestamp` varchar(250) DEFAULT NULL,
  `token` varchar(250) DEFAULT NULL,
  `user` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: queues
#

DROP TABLE IF EXISTS queues;

CREATE TABLE `queues` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `inactive` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO queues (`id`, `name`, `description`, `inactive`) VALUES ('1', 'Service', 'First service queue', '0');
INSERT INTO queues (`id`, `name`, `description`, `inactive`) VALUES ('2', 'Second Level', 'Second Level Queue', '0');


#
# TABLE STRUCTURE FOR: quotations
#

DROP TABLE IF EXISTS quotations;

CREATE TABLE `quotations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `q1` varchar(50) DEFAULT NULL,
  `q2` varchar(50) DEFAULT NULL,
  `q3` varchar(50) DEFAULT NULL,
  `q4` varchar(150) DEFAULT NULL,
  `q5` text,
  `q6` varchar(50) DEFAULT NULL,
  `company` varchar(150) DEFAULT '-',
  `fullname` varchar(150) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `phone` varchar(150) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `city` varchar(150) DEFAULT NULL,
  `zip` varchar(150) DEFAULT NULL,
  `country` varchar(150) DEFAULT NULL,
  `comment` text,
  `date` varchar(50) DEFAULT NULL,
  `status` varchar(150) DEFAULT NULL,
  `user_id` int(50) DEFAULT '0',
  `replied` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: reminders
#

DROP TABLE IF EXISTS reminders;

CREATE TABLE `reminders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(250) DEFAULT NULL,
  `source_id` bigint(20) DEFAULT '0',
  `title` varchar(250) DEFAULT NULL,
  `body` text,
  `email_notification` int(1) DEFAULT '0',
  `done` int(1) DEFAULT '0',
  `datetime` varchar(50) DEFAULT NULL,
  `sent_at` varchar(50) DEFAULT NULL,
  `user_id` int(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: subscription_has_items
#

DROP TABLE IF EXISTS subscription_has_items;

CREATE TABLE `subscription_has_items` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `subscription_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `amount` char(11) DEFAULT '0',
  `description` mediumtext,
  `value` float DEFAULT '0',
  `name` varchar(250) DEFAULT NULL,
  `type` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO subscription_has_items (`id`, `subscription_id`, `item_id`, `amount`, `description`, `value`, `name`, `type`) VALUES ('1', '1', '0', '1', '', '500', 'SEO', 'Seo');


#
# TABLE STRUCTURE FOR: subscriptions
#

DROP TABLE IF EXISTS subscriptions;

CREATE TABLE `subscriptions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `reference` varchar(50) DEFAULT NULL,
  `company_id` int(10) DEFAULT '0',
  `status` varchar(50) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `issue_date` varchar(20) DEFAULT NULL,
  `end_date` varchar(20) DEFAULT NULL,
  `frequency` varchar(20) DEFAULT NULL,
  `next_payment` varchar(20) DEFAULT NULL,
  `terms` mediumtext,
  `discount` varchar(50) DEFAULT NULL,
  `tax` varchar(250) DEFAULT NULL,
  `second_tax` varchar(255) DEFAULT NULL,
  `subscribed` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO subscriptions (`id`, `reference`, `company_id`, `status`, `currency`, `issue_date`, `end_date`, `frequency`, `next_payment`, `terms`, `discount`, `tax`, `second_tax`, `subscribed`) VALUES ('1', '61001', '1', 'Active', 'EUR', '2019-01-01', '2019-06-30', '+1 month', '2019-02-01', 'Thank you for your business. We do expect payment within {due_date}, so please process this invoice within that time.', '', '0', '0', NULL);


#
# TABLE STRUCTURE FOR: task_has_comments
#

DROP TABLE IF EXISTS task_has_comments;

CREATE TABLE `task_has_comments` (
  `id` bigint(255) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `message` text,
  `datetime` varchar(20) DEFAULT NULL,
  `attachment` varchar(255) DEFAULT NULL,
  `task_id` bigint(20) DEFAULT NULL,
  `attachment_link` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: templates
#

DROP TABLE IF EXISTS templates;

CREATE TABLE `templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) NOT NULL,
  `name` varchar(250) NOT NULL,
  `text` text,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ticket_has_articles
#

DROP TABLE IF EXISTS ticket_has_articles;

CREATE TABLE `ticket_has_articles` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) DEFAULT '0',
  `from` varchar(250) NOT NULL,
  `reply_to` varchar(250) DEFAULT NULL,
  `to` varchar(250) DEFAULT NULL,
  `cc` varchar(250) DEFAULT NULL,
  `subject` varchar(250) DEFAULT NULL,
  `message` text,
  `datetime` varchar(250) DEFAULT NULL,
  `internal` int(10) DEFAULT '1',
  `user_id` bigint(20) DEFAULT '0',
  `note` int(1) DEFAULT '0',
  `raw` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO ticket_has_articles (`id`, `ticket_id`, `from`, `reply_to`, `to`, `cc`, `subject`, `message`, `datetime`, `internal`, `user_id`, `note`, `raw`) VALUES ('1', '1', 'Sergey Baranov - sergey@unicom.lv', 'sergey@unicom.lv', '1', NULL, 'Ticket assigned', '', '1547554949', '1', '0', '0', NULL);
INSERT INTO ticket_has_articles (`id`, `ticket_id`, `from`, `reply_to`, `to`, `cc`, `subject`, `message`, `datetime`, `internal`, `user_id`, `note`, `raw`) VALUES ('2', '1', 'Sergey Baranov - sergey@unicom.lv', 'sergey@unicom.lv', 'juliesavicka@gmail.com', NULL, '', '<p>I love you too</p>', '1547560247', '0', '1', '0', NULL);
INSERT INTO ticket_has_articles (`id`, `ticket_id`, `from`, `reply_to`, `to`, `cc`, `subject`, `message`, `datetime`, `internal`, `user_id`, `note`, `raw`) VALUES ('3', '2', 'Sergey Baranov - sergey@unicom.lv', 'sergey@unicom.lv', 'info@anton-geier.de', NULL, 'test', '<p>test prinjat!</p><p><br></p>', '1547817333', '0', '1', '0', NULL);
INSERT INTO ticket_has_articles (`id`, `ticket_id`, `from`, `reply_to`, `to`, `cc`, `subject`, `message`, `datetime`, `internal`, `user_id`, `note`, `raw`) VALUES ('4', '3', 'Sergey Baranov - sergey@unicom.lv', 'sergey@unicom.lv', 'info@anton-geier.de', NULL, 'Close', '<p>solved</p>', '1548143208', '0', '0', '0', NULL);


#
# TABLE STRUCTURE FOR: ticket_has_attachments
#

DROP TABLE IF EXISTS ticket_has_attachments;

CREATE TABLE `ticket_has_attachments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint(20) DEFAULT NULL,
  `filename` varchar(250) DEFAULT NULL,
  `savename` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tickets
#

DROP TABLE IF EXISTS tickets;

CREATE TABLE `tickets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `from` varchar(250) DEFAULT NULL,
  `reference` varchar(250) DEFAULT NULL,
  `type_id` smallint(6) DEFAULT '1',
  `lock` smallint(6) DEFAULT NULL,
  `subject` varchar(250) DEFAULT NULL,
  `text` text,
  `status` varchar(50) DEFAULT NULL,
  `client_id` int(11) DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  `user_id` int(11) DEFAULT '0',
  `escalation_time` int(11) DEFAULT '0',
  `priority` varchar(50) DEFAULT NULL,
  `created` int(11) DEFAULT '0',
  `queue_id` int(11) DEFAULT '0',
  `updated` tinyint(4) DEFAULT '0',
  `project_id` bigint(20) DEFAULT '0',
  `raw` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('1', 'Jūlija Savicka <juliesavicka@gmail.com> - juliesavicka@gmail.com', '10000', '1', NULL, '', '<div>Ljublju</div>\n', 'closed', '0', '0', '1', '0', NULL, '1547497129', '1', '0', '0', 'Return-Path: <juliesavicka@gmail.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP id GNezJX7uPFzKSgwAMoQ/pw\r\n	for <info@apusseo.com>; Mon, 14 Jan 2019 22:18:06 +0200\r\nReturn-path: <juliesavicka@gmail.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Mon, 14 Jan 2019 22:18:06 +0200\r\nReceived: from mail-ot1-f52.google.com ([209.85.210.52]:33726)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <juliesavicka@gmail.com>)\r\n	id 1gj8gQ-003NxU-Ei\r\n	for info@apusseo.com; Mon, 14 Jan 2019 22:18:06 +0200\r\nReceived: by mail-ot1-f52.google.com with SMTP id i20so368523otl.0\r\n        for <info@apusseo.com>; Mon, 14 Jan 2019 12:18:07 -0800 (PST)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=20161025;\r\n        h=mime-version:from:date:message-id:subject:to;\r\n        bh=EmAlaW9YM4MSLIg/yZH2Qu/Cdl1lGjMCnOeHtsT9ioY=;\r\n        b=OrGgiU4+qArmop9mPlhw4EOExiLeH9G+FELH4CcT0mIJfPfzj1jOYHsEAKL3Pjl9gl\r\n         mvUyuuj0WzhqPTzEgcg/PfgEes6Vr8iDg3vrOemeH8W3u/Ve6FKStAjqSttBm/8lYqkw\r\n         36G0JPRYWkXLLubG6H/SjdJiXb8wXeyYijpvz5aQV7GlkbdPrZP1I4m8mbw7P1LtvWHB\r\n         aFukMCtDYVmvlJDTaXgWeGYzkZbtBDIMz/ztibBEBh0KXMEK21qz/fFG9WppAm84LQCF\r\n         kUu0VZPcZKNE1sgawvS4bLZR1uJFAtvU430dfo8vN21ezs8C/jraahyjndhlLteOhN2a\r\n         gF8w==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:mime-version:from:date:message-id:subject:to;\r\n        bh=EmAlaW9YM4MSLIg/yZH2Qu/Cdl1lGjMCnOeHtsT9ioY=;\r\n        b=mmFDN66ll8TOHd3BqLrMhL/DlFeDjB9FqXWydf+CLfuMSF8ppkyBrOGKEWAD5OnXhO\r\n         mAcS2fTbnGUt0HkVsV34AXPqHBmCHdY6RVCzkB6eI7fdkcD1HGNWPOu6/yukjvZDP71g\r\n         R/Um4v8GCMGrp3p9ynh6C3gOPzw2+qWL5D0OX3iY75JkI73RG8Vf+M0H0j6HLUGyqKBc\r\n         tflOuNw48VqGcAdbrczysGumg3E9KV9InxUYp+JaQOhA0xbmwUZZjhGR66LuJ/n4D5ds\r\n         x0WcjP5yBcl8/wx9Doii8SWiNkdbDp4dGAOkLOf6Acbv55Ld3/k1CohlX5YhGPludHcH\r\n         2E/w==\r\nX-Gm-Message-State: AJcUukd0Pz2wOOZE7Qm74TB9KxBKQR/C2l7pj6tCGuSU4atbz0uigx1O\r\n	ir2nXE0MKkr2VcQnVqLNbZnbWZYSuU4JCb/ABxOzSA==\r\nX-Google-Smtp-Source: ALg8bN5htxUOGADtEPS4MU98+issGny14HABedbVn2D3rNkoce/jZzlFu3eTh3PIi2OnAzrvDBFiRV3ojT/AULnH48k=\r\nX-Received: by 2002:a9d:6c3:: with SMTP id 61mr164367otx.314.1547497085165;\r\n Mon, 14 Jan 2019 12:18:05 -0800 (PST)\r\nMIME-Version: 1.0\r\nFrom: =?UTF-8?Q?J=C5=ABlija_Savicka?= <juliesavicka@gmail.com>\r\nDate: Mon, 14 Jan 2019 22:17:54 +0200\r\nMessage-ID: <CAKZ9eo68kE0DUc=uGsE8ir1X1wcoRv8VLxFdh1901H_GRakRZw@mail.gmail.com>\r\nSubject: \r\nTo: \"info@apusseo.com\" <info@apusseo.com>\r\nContent-Type: multipart/alternative; boundary=\"0000000000000d6357057f70bef4\"\r\n\r\n --0000000000000d6357057f70bef4\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\n\r\nLjublju\r\n\r\n--0000000000000d6357057f70bef4\r\nContent-Type: text/html; charset=\"UTF-8\"\r\n\r\n<div dir=\"auto\">Ljublju</div>\r\n\r\n--0000000000000d6357057f70bef4--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('2', 'Anton Geier - info@anton-geier.de', '10001', '1', NULL, 'test', '<p>test</p>', 'closed', '1', '1', '1', '0', NULL, '1547817203', '1', '0', '0', NULL);
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('3', 'info@anton-geier.de - info@anton-geier.de', '10002', '1', NULL, 'RE: Password Reset', '<div class=\"WordSection1\"><p class=\"MsoNormal\"><span lang=\"en-gb\" xml:lang=\"en-gb\">Hi Sergej,</span></p><p></p><p class=\"MsoNormal\"><span lang=\"en-gb\" xml:lang=\"en-gb\">Ne mogu zaloginitsa</span></p><p></p><p class=\"MsoNormal\"><span lang=\"en-gb\" xml:lang=\"en-gb\">Anton</span></p><p></p><p class=\"MsoNormal\"><span lang=\"en-nl\" xml:lang=\"en-nl\"></span></p><p> </p><div><div style=\"border:none;border-top:solid #E1E1E1 1pt;padding:3pt 0cm 0cm 0cm;\"><p class=\"MsoNormal\"><b><span lang=\"en-us\" xml:lang=\"en-us\">From:</span></b><span lang=\"en-us\" xml:lang=\"en-us\"> Apus SIA &lt;info@apusseo.com&gt; <br /><b>Sent:</b> Friday, 18 January 2019 11:24<br /><b>To:</b> info@anton-geier.de<br /><b>Subject:</b> Password Reset</span></p><p></p></div></div><p class=\"MsoNormal\"></p><p> </p><div><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"600\" style=\"width:450pt;border-collapse:collapse;\"><tr><td style=\"padding:0cm 0cm 0cm 0cm;\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td style=\"padding:0cm 0cm 0cm 0cm;\"><div><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td valign=\"top\" style=\"padding:15pt 0cm 15pt 0cm;\"><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse:collapse;\"><tr><td width=\"600\" valign=\"top\" style=\"width:450pt;padding:0cm 0cm 0cm 0cm;\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td style=\"padding:7.5pt 18.75pt 7.5pt 18.75pt;\"><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse:collapse;\"><tr><td style=\"padding:0cm 0cm 0cm 0cm;\"><p class=\"MsoNormal\" align=\"center\" style=\"text-align:center;\"><img src=\"http://my.apusseo.com/files/media/apus-logo1.png\" alt=\"Apus SIA\" /></p><p></p></td></tr></table></div></td></tr></table></td></tr></table></div></td></tr></table></div></div></td></tr></table></td></tr></table></div><p class=\"MsoNormal\" style=\"background:#F4F7FA;\"></p><p> </p><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"600\" style=\"width:450pt;border-collapse:collapse;\"><tr><td style=\"padding:0cm 0cm 0cm 0cm;\"><div><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;background:#FFFFFF;border-collapse:collapse;\"><tr><td valign=\"top\" style=\"padding:15pt 15pt 15pt 15pt;\"><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse:collapse;\"><tr><td width=\"600\" valign=\"top\" style=\"width:450pt;padding:0cm 0cm 0cm 0cm;\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td style=\"padding:7.5pt 18.75pt 7.5pt 18.75pt;\"><p class=\"MsoNormal\" align=\"center\" style=\"text-align:center;line-height:16.5pt;\"><span style=\"font-size:12pt;font-family:BlinkMacSystemFont, serif;color:#4E5C6E;\">Password Reset</span></p><p></p></td></tr></table></td><td width=\"600\" valign=\"top\" style=\"width:450pt;padding:0cm 0cm 0cm 0cm;\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td style=\"padding:7.5pt 18.75pt 7.5pt 18.75pt;\"><div align=\"center\"><table class=\"MsoNormalTable\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;border:none;\"><tr><td style=\"border:none;border-top:solid #F4F7FA 1pt;padding:0cm 0cm 0cm 0cm;\"><p class=\"MsoNormal\" style=\"line-height:0%;\"><span style=\"font-size:1pt;\"> </span></p><p></p></td></tr></table></div></td></tr></table></td><td width=\"600\" valign=\"top\" style=\"width:450pt;padding:0cm 0cm 0cm 0cm;\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td style=\"padding:3.75pt 18.75pt 7.5pt 18.75pt;\"><p class=\"MsoNormal\" style=\"line-height:16.5pt;\"><span style=\"font-size:10pt;font-family:BlinkMacSystemFont, serif;color:#444444;\">Hi Anton, <br /><br />We\'ve received a request to reset your password. If you didn\'t make the request, just ignore this email. Otherwise, you can reset your password using the link below.</span></p><p></p></td></tr><tr><td style=\"padding:3.75pt 18.75pt 7.5pt 18.75pt;\"><p class=\"MsoNormal\" style=\"line-height:16.5pt;\"><span style=\"font-size:10pt;font-family:BlinkMacSystemFont, serif;color:#444444;\">Kind Regards, <br />Apus SIA </span></p><p></p></td></tr></table></td><td width=\"600\" valign=\"top\" style=\"width:450pt;padding:0cm 0cm 0cm 0cm;\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td style=\"padding:7.5pt 18.75pt 7.5pt 18.75pt;\"><div align=\"center\"><table class=\"MsoNormalTable\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;border:none;\"><tr><td style=\"border:none;border-top:solid #F4F7FA 1pt;padding:0cm 0cm 0cm 0cm;\"><p class=\"MsoNormal\" style=\"line-height:0%;\"><span style=\"font-size:1pt;\"> </span></p><p></p></td></tr></table></div></td></tr><tr><td style=\"padding:7.5pt 18.75pt 7.5pt 18.75pt;\"><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse:collapse;\"><tr><td style=\"background:#356CC9;padding:7.5pt 18.75pt 7.5pt 18.75pt;\"><p class=\"MsoNormal\" align=\"center\" style=\"text-align:center;\"><span style=\"color:#FFFFFF;\"><a href=\"http://my.apusseo.com/forgotpass/token/b9001f3c56c86d5a2094db145d0a30509032c46ab9c8a5a6d019ffc1c596c616\"><span style=\"font-size:10pt;font-family:BlinkMacSystemFont, serif;color:#FFFFFF;background:#356CC9;text-decoration:none;\">Click here to reset your password</span></a> </span></p><p></p></td></tr></table></div></td></tr></table></td></tr></table></div></td></tr></table></div></div></td></tr></table></div><p class=\"MsoNormal\" style=\"background:#F4F7FA;\"></p><p> </p><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"600\" style=\"width:450pt;border-collapse:collapse;\"><tr><td style=\"padding:0cm 0cm 0cm 0cm;\"><div><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td valign=\"top\" style=\"padding:15pt 0cm 15pt 0cm;\"><div align=\"center\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse:collapse;\"><tr><td width=\"600\" valign=\"top\" style=\"width:450pt;padding:0cm 0cm 0cm 0cm;\"><table class=\"MsoNormalTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"width:100%;border-collapse:collapse;\"><tr><td style=\"padding:7.5pt 18.75pt 7.5pt 18.75pt;\"><p class=\"MsoNormal\" align=\"center\" style=\"text-align:center;line-height:16.5pt;\"><span style=\"font-size:10pt;font-family:BlinkMacSystemFont, serif;color:#BBBBBB;\">© Apus SIA</span></p><p></p></td></tr></table></td></tr></table></div></td></tr></table></div></div></td></tr></table></div><p class=\"MsoNormal\"></p><p> </p></div></div><div><br />\n<table style=\"border-top:1px solid #D3D4DE;\">\n	<tr>\n        <td style=\"width:55px;padding-top:13px;\"><a href=\"https://www.avast.com/sig-email?utm_medium=email&amp;utm_source=link&amp;utm_campaign=sig-email&amp;utm_content=emailclient\"><img src=\"https://ipmcdn.avast.com/images/icons/icon-envelope-tick-round-orange-animated-no-repeat-v1.gif\" alt=\"\" width=\"46\" height=\"29\" style=\"width:46px;height:29px;\" /></a></td>\n		<td style=\"width:470px;padding-top:12px;color:#41424e;font-size:13px;font-family:Arial, Helvetica, sans-serif;line-height:18px;\">Virus-free. <a href=\"https://www.avast.com/sig-email?utm_medium=email&amp;utm_source=link&amp;utm_campaign=sig-email&amp;utm_content=emailclient\" style=\"color:#4453ea;\">www.avast.com</a>\n		</td>\n	</tr>\n</table><a href=\"#DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\"> </a></div>', 'closed', '1', '1', '1', '0', NULL, '1548142503', '1', '1', '0', 'Return-Path: <info@anton-geier.de>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP id qHErKZmeQVzW9AgAMoQ/pw\r\n	for <info@apusseo.com>; Fri, 18 Jan 2019 11:38:33 +0200\r\nReturn-path: <info@anton-geier.de>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Fri, 18 Jan 2019 11:38:33 +0200\r\nReceived: from mout.kundenserver.de ([212.227.126.130]:33597)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <info@anton-geier.de>)\r\n	id 1gkQbh-002TAx-Ix\r\n	for info@apusseo.com; Fri, 18 Jan 2019 11:38:33 +0200\r\nReceived: from DESKTOPJEMA1OT ([90.139.210.127]) by mrelayeu.kundenserver.de\r\n (mreue012 [212.227.15.167]) with ESMTPSA (Nemesis) id\r\n 1MPaQU-1gXpFE32l0-00MaNz for <info@apusseo.com>; Fri, 18 Jan 2019 10:25:58\r\n +0100\r\nFrom: <info@anton-geier.de>\r\nTo: \"\'Apus SIA\'\" <info@apusseo.com>\r\nReferences: <820b5ecf8602b0fad6c96fdec9a68a4e@my.apusseo.com>\r\nIn-Reply-To: <820b5ecf8602b0fad6c96fdec9a68a4e@my.apusseo.com>\r\nSubject: RE: Password Reset\r\nDate: Fri, 18 Jan 2019 11:25:58 +0200\r\nMessage-ID: <007401d4af0f$d2edd840$78c988c0$@anton-geier.de>\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative;\r\n	boundary=\"----=_NextPart_000_0075_01D4AF20.967807D0\"\r\nX-Mailer: Microsoft Outlook 16.0\r\nThread-Index: AQGvk2Ca0QcEy6ezTBNKq/ZP0giCQqX++M/w\r\nContent-Language: en-nl\r\nX-Antivirus: Avast (VPS 190118-0, 18/01/2019), Outbound message\r\nX-Antivirus-Status: Clean\r\nX-Provags-ID: V03:K1:VCCvmwuRZNxTY3uffXMB0aq5kUeeGFJHHvFI75DKj5jNSHASvLI\r\n sNrMOlqjY3yWa1GffURwga70nx0CmcFKhDgr49xP0mid9+4DnOCbOCFhWSXDNwXT8nfVDhR\r\n 8zJGW0jAOsfkIJ3UVz5yN4A38Jqdd2evDkg96LQFmbzTpze106ZSCJp4HdqaKTU4C0xnHKJ\r\n PMwC6wQ4LymWNWfkm5yPw==\r\nX-UI-Out-Filterresults: notjunk:1;V03:K0:Yh/vIa+tnrQ=:iElgJJngtchUq3H7s3rQLk\r\n vBZnosFDEbOdtEc+ZfYnSZnDF0AWme4F7ZbUsxjQcfVVuFBgYdw9Kcerl/F+aj3jbFVdC01Hy\r\n vomV0O94Bdu4Wb/6gdmb/TRNXQnnCd6CuWCPSbtD+OoK63M8w+AAK7Cz+/b58QnIwFBMYyRB9\r\n ELk5PgV6p0RA5rIYxmDu4pz/8oEim5vQUkm6SXLzA4NiF3sqdTrrfYVpeQArmTytvsTpP9x4B\r\n mqtjrr/d4XvG+O3qAl7/+vCRImgYFS0ILFcpfuIblznB9XeB92IRHD0bqlz15vQ1aARX2HLks\r\n S8/WUV6MMXqj/jHx4XBclC89jsmN2ZaPhT47X6Y3UnEx4H//g/VOQkI9J2Xx/mfXQyvu2kQAj\r\n aFW+Uu6KgL7qIeMtLsfstAgzdMOewy4Td7uxyqAESCo0pUr7x8a5gzeqIDTagWhcWMIXT1Ggy\r\n VqVa2+itUWQOjHjmfRNLk9+uALpoLRtmpuvSIt+Ksczsn0C2a+3Ce3f+iZkQuW0aYKenfs5tU\r\n sgMRGHYwkYUCOrhkb0+tM9ExmbohGwTh0ulKol0JJdVDCyL/wIr5hlNgatfDtxW6xLPMSwVWN\r\n lgBx8J0yJkfWfcL5mSVaZScj5QSvR8bTqfFANayHG5IVrhn29ldh7uevB1fTfFmnXdBlNRgLf\r\n IaAeeopicGIM4z9cVLnL06vNjXshJkGrGE+Um7QuF90I81GrCp+n8vv0RACbp6OU303PLLlLh\r\n uWvuZBKrKKgEtKEf0P3Vu2W1jLunIZoNOPlbEvCwUwR1ewu49hXxNbNzHws=\r\n\r\n This is a multipart message in MIME format.\r\n\r\n------=_NextPart_000_0075_01D4AF20.967807D0\r\nContent-Type: text/plain;\r\n	charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHi Sergej,\r\n\r\nNe mogu zaloginitsa\r\n\r\nAnton\r\n\r\n \r\n\r\nFrom: Apus SIA <info@apusseo.com> \r\nSent: Friday, 18 January 2019 11:24\r\nTo: info@anton-geier.de\r\nSubject: Password Reset\r\n\r\n \r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n  <http://my.apusseo.com/files/media/apus-logo1.png> \r\n\r\n \r\n\r\n\r\n\r\n\r\n\r\nPassword Reset\r\n\r\n\r\n\r\n \r\n\r\n\r\nHi Anton, \r\n\r\nWe\'ve received a request to reset your password. If you didn\'t make the req=\r\nuest, just ignore this email. Otherwise, you can reset your password using =\r\nthe link below.\r\n\r\n\r\nKind Regards, \r\nApus SIA \r\n\r\n\r\n\r\n \r\n\r\n\r\n\r\n <http://my.apusseo.com/forgotpass/token/b9001f3c56c86d5a2094db145d0a305090=\r\n32c46ab9c8a5a6d019ffc1c596c616> Click here to reset your password \r\n\r\n \r\n\r\n\r\n\r\n\r\n\r\n=C2=A9 Apus SIA\r\n\r\n \r\n\r\n\r\n\r\n---\r\nThis email has been checked for viruses by Avast antivirus software.\r\nhttps://www.avast.com/antivirus\r\n\r\n------=_NextPart_000_0075_01D4AF20.967807D0\r\nContent-Type: text/html;\r\n	charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<html xmlns:v=3D\"urn:schemas-microsoft-com:vml\" xmlns:o=3D\"urn:schemas-micr=\r\nosoft-com:office:office\" xmlns:w=3D\"urn:schemas-microsoft-com:office:word\" =\r\nxmlns:m=3D\"http://schemas.microsoft.com/office/2004/12/omml\" xmlns=3D\"http:=\r\n//www.w3.org/TR/REC-html40\"><head><meta http-equiv=3DContent-Type content=\r\n=3D\"text/html; charset=3Dutf-8\"><meta name=3DGenerator content=3D\"Microsoft=\r\n Word 15 (filtered medium)\"><!--[if !mso]><style>v\\:* {behavior:url(#defaul=\r\nt#VML);}\r\no\\:* {behavior:url(#default#VML);}\r\nw\\:* {behavior:url(#default#VML);}\r\n=2Eshape {behavior:url(#default#VML);}\r\n</style><![endif]--><style><!--\r\n/* Font Definitions */\r\n@font-face\r\n	{font-family:\"Cambria Math\";\r\n	panose-1:2 4 5 3 5 4 6 3 2 4;}\r\n@font-face\r\n	{font-family:Calibri;\r\n	panose-1:2 15 5 2 2 2 4 3 2 4;}\r\n@font-face\r\n	{font-family:BlinkMacSystemFont;\r\n	panose-1:0 0 0 0 0 0 0 0 0 0;}\r\n/* Style Definitions */\r\np.MsoNormal, li.MsoNormal, div.MsoNormal\r\n	{margin:0cm;\r\n	margin-bottom:.0001pt;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\na:link, span.MsoHyperlink\r\n	{mso-style-priority:99;\r\n	color:blue;\r\n	text-decoration:underline;}\r\na:visited, span.MsoHyperlinkFollowed\r\n	{mso-style-priority:99;\r\n	color:purple;\r\n	text-decoration:underline;}\r\np.msonormal0, li.msonormal0, div.msonormal0\r\n	{mso-style-name:msonormal;\r\n	margin-top:9.75pt;\r\n	margin-right:0cm;\r\n	margin-bottom:9.75pt;\r\n	margin-left:0cm;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\np.readmsgbody, li.readmsgbody, div.readmsgbody\r\n	{mso-style-name:readmsgbody;\r\n	mso-margin-top-alt:auto;\r\n	margin-right:0cm;\r\n	mso-margin-bottom-alt:auto;\r\n	margin-left:0cm;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\np.externalclass, li.externalclass, div.externalclass\r\n	{mso-style-name:externalclass;\r\n	mso-margin-top-alt:auto;\r\n	margin-right:0cm;\r\n	mso-margin-bottom-alt:auto;\r\n	margin-left:0cm;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\nspan.EmailStyle21\r\n	{mso-style-type:personal-reply;\r\n	font-family:\"Calibri\",sans-serif;}\r\n=2EMsoChpDefault\r\n	{mso-style-type:export-only;\r\n	font-size:10.0pt;}\r\n@page WordSection1\r\n	{size:612.0pt 792.0pt;\r\n	margin:72.0pt 72.0pt 72.0pt 72.0pt;}\r\ndiv.WordSection1\r\n	{page:WordSection1;}\r\n--></style><!--[if gte mso 9]><xml>\r\n<o:shapedefaults v:ext=3D\"edit\" spidmax=3D\"1026\" />\r\n</xml><![endif]--><!--[if gte mso 9]><xml>\r\n<o:shapelayout v:ext=3D\"edit\">\r\n<o:idmap v:ext=3D\"edit\" data=3D\"1\" />\r\n</o:shapelayout></xml><![endif]--></head><body bgcolor=3D\"#F4F7FA\" lang=3De=\r\nn-NL link=3Dblue vlink=3Dpurple><div class=3DWordSection1><p class=3DMsoNor=\r\nmal><span lang=3DEN-GB style=3D\'mso-fareast-language:EN-US\'>Hi Sergej,<o:p>=\r\n</o:p></span></p><p class=3DMsoNormal><span lang=3DEN-GB style=3D\'mso-farea=\r\nst-language:EN-US\'>Ne mogu zaloginitsa<o:p></o:p></span></p><p class=3DMsoN=\r\normal><span lang=3DEN-GB style=3D\'mso-fareast-language:EN-US\'>Anton<o:p></o=\r\n:p></span></p><p class=3DMsoNormal><span lang=3Den-NL style=3D\'mso-fareast-=\r\nlanguage:EN-US\'><o:p>&nbsp;</o:p></span></p><div><div style=3D\'border:none;=\r\nborder-top:solid #E1E1E1 1.0pt;padding:3.0pt 0cm 0cm 0cm\'><p class=3DMsoNor=\r\nmal><b><span lang=3DEN-US>From:</span></b><span lang=3DEN-US> Apus SIA &lt;=\r\ninfo@apusseo.com&gt; <br><b>Sent:</b> Friday, 18 January 2019 11:24<br><b>T=\r\no:</b> info@anton-geier.de<br><b>Subject:</b> Password Reset<o:p></o:p></sp=\r\nan></p></div></div><p class=3DMsoNormal><o:p>&nbsp;</o:p></p><div><div alig=\r\nn=3Dcenter><table class=3DMsoNormalTable border=3D0 cellspacing=3D0 cellpad=\r\nding=3D0 width=3D600 style=3D\'width:450.0pt;border-collapse:collapse\'><tr><=\r\ntd style=3D\'padding:0cm 0cm 0cm 0cm\'><table class=3DMsoNormalTable border=\r\n=3D0 cellspacing=3D0 cellpadding=3D0 width=3D\"100%\" style=3D\'width:100.0%;b=\r\norder-collapse:collapse\'><tr><td style=3D\'padding:0cm 0cm 0cm 0cm\'><div><di=\r\nv align=3Dcenter><table class=3DMsoNormalTable border=3D0 cellspacing=3D0 c=\r\nellpadding=3D0 width=3D\"100%\" style=3D\'width:100.0%;border-collapse:collaps=\r\ne\'><tr><td valign=3Dtop style=3D\'padding:15.0pt 0cm 15.0pt 0cm\'><div align=\r\n=3Dcenter><table class=3DMsoNormalTable border=3D0 cellspacing=3D0 cellpadd=\r\ning=3D0 style=3D\'border-collapse:collapse\'><tr><td width=3D600 valign=3Dtop=\r\n style=3D\'width:450.0pt;padding:0cm 0cm 0cm 0cm\'><table class=3DMsoNormalTa=\r\nble border=3D0 cellspacing=3D0 cellpadding=3D0 width=3D\"100%\" style=3D\'widt=\r\nh:100.0%;border-collapse:collapse\'><tr><td style=3D\'padding:7.5pt 18.75pt 7=\r\n=2E5pt 18.75pt\'><div align=3Dcenter><table class=3DMsoNormalTable border=3D=\r\n0 cellspacing=3D0 cellpadding=3D0 style=3D\'border-collapse:collapse\'><tr><t=\r\nd style=3D\'padding:0cm 0cm 0cm 0cm\'><p class=3DMsoNormal align=3Dcenter sty=\r\nle=3D\'text-align:center\'><img id=3D\"_x0000_i1025\" src=3D\"http://my.apusseo.=\r\ncom/files/media/apus-logo1.png\" alt=3D\"Apus SIA\"><o:p></o:p></p></td></tr><=\r\n/table></div></td></tr></table></td></tr></table></div></td></tr></table></=\r\ndiv></div></td></tr></table></td></tr></table></div><p class=3DMsoNormal st=\r\nyle=3D\'background:#F4F7FA\'><o:p>&nbsp;</o:p></p><div align=3Dcenter><table =\r\nclass=3DMsoNormalTable border=3D0 cellspacing=3D0 cellpadding=3D0 width=3D6=\r\n00 style=3D\'width:450.0pt;border-collapse:collapse\'><tr><td style=3D\'paddin=\r\ng:0cm 0cm 0cm 0cm;word-wrap:break-word\'><div><div align=3Dcenter><table cla=\r\nss=3DMsoNormalTable border=3D0 cellspacing=3D0 cellpadding=3D0 width=3D\"100=\r\n%\" style=3D\'width:100.0%;background:white;border-collapse:collapse\'><tr><td=\r\n valign=3Dtop style=3D\'padding:15.0pt 15.0pt 15.0pt 15.0pt\'><div align=3Dce=\r\nnter><table class=3DMsoNormalTable border=3D0 cellspacing=3D0 cellpadding=\r\n=3D0 style=3D\'border-collapse:collapse\'><tr><td width=3D600 valign=3Dtop st=\r\nyle=3D\'width:450.0pt;padding:0cm 0cm 0cm 0cm\'><table class=3DMsoNormalTable=\r\n border=3D0 cellspacing=3D0 cellpadding=3D0 width=3D\"100%\" style=3D\'width:1=\r\n00.0%;border-collapse:collapse\'><tr><td style=3D\'padding:7.5pt 18.75pt 7.5p=\r\nt 18.75pt\'><p class=3DMsoNormal align=3Dcenter style=3D\'text-align:center;l=\r\nine-height:16.5pt;mso-line-height-rule:exactly\'><span style=3D\'font-size:12=\r\n=2E0pt;font-family:\"BlinkMacSystemFont\",serif;color:#4E5C6E\'>Password Reset=\r\n<o:p></o:p></span></p></td></tr></table></td><td width=3D600 valign=3Dtop s=\r\ntyle=3D\'width:450.0pt;padding:0cm 0cm 0cm 0cm;word-wrap:break-word\'><table =\r\nclass=3DMsoNormalTable border=3D0 cellspacing=3D0 cellpadding=3D0 width=3D\"=\r\n100%\" style=3D\'width:100.0%;border-collapse:collapse\'><tr><td style=3D\'padd=\r\ning:7.5pt 18.75pt 7.5pt 18.75pt\'><div align=3Dcenter><table class=3DMsoNorm=\r\nalTable border=3D1 cellspacing=3D0 cellpadding=3D0 width=3D\"100%\" style=3D\'=\r\nwidth:100.0%;border-collapse:collapse;border:none;word-wrap:break-word\'><tr=\r\n><td style=3D\'border:none;border-top:solid #F4F7FA 1.0pt;padding:0cm 0cm 0c=\r\nm 0cm\'><p class=3DMsoNormal style=3D\'line-height:0%\'><span style=3D\'font-si=\r\nze:1.0pt\'>&nbsp;<o:p></o:p></span></p></td></tr></table></div></td></tr></t=\r\nable></td><td width=3D600 valign=3Dtop style=3D\'width:450.0pt;padding:0cm 0=\r\ncm 0cm 0cm;word-wrap:break-word\'><table class=3DMsoNormalTable border=3D0 c=\r\nellspacing=3D0 cellpadding=3D0 width=3D\"100%\" style=3D\'width:100.0%;border-=\r\ncollapse:collapse\'><tr><td style=3D\'padding:3.75pt 18.75pt 7.5pt 18.75pt\'><=\r\np class=3DMsoNormal style=3D\'line-height:16.5pt;mso-line-height-rule:exactl=\r\ny\'><span style=3D\'font-size:10.0pt;font-family:\"BlinkMacSystemFont\",serif;c=\r\nolor:#444444\'>Hi Anton, <br><br>We\'ve received a request to reset your pass=\r\nword. If you didn\'t make the request, just ignore this email. Otherwise, yo=\r\nu can reset your password using the link below.<o:p></o:p></span></p></td><=\r\n/tr><tr><td style=3D\'padding:3.75pt 18.75pt 7.5pt 18.75pt;word-wrap:break-w=\r\nord\'><p class=3DMsoNormal style=3D\'line-height:16.5pt;mso-line-height-rule:=\r\nexactly\'><span style=3D\'font-size:10.0pt;font-family:\"BlinkMacSystemFont\",s=\r\nerif;color:#444444\'>Kind Regards, <br>Apus SIA <o:p></o:p></span></p></td><=\r\n/tr></table></td><td width=3D600 valign=3Dtop style=3D\'width:450.0pt;paddin=\r\ng:0cm 0cm 0cm 0cm;word-wrap:break-word\'><table class=3DMsoNormalTable borde=\r\nr=3D0 cellspacing=3D0 cellpadding=3D0 width=3D\"100%\" style=3D\'width:100.0%;=\r\nborder-collapse:collapse\'><tr><td style=3D\'padding:7.5pt 18.75pt 7.5pt 18.7=\r\n5pt\'><div align=3Dcenter><table class=3DMsoNormalTable border=3D1 cellspaci=\r\nng=3D0 cellpadding=3D0 width=3D\"100%\" style=3D\'width:100.0%;border-collapse=\r\n:collapse;border:none;word-wrap:break-word\'><tr><td style=3D\'border:none;bo=\r\nrder-top:solid #F4F7FA 1.0pt;padding:0cm 0cm 0cm 0cm\'><p class=3DMsoNormal =\r\nstyle=3D\'line-height:0%\'><span style=3D\'font-size:1.0pt\'>&nbsp;<o:p></o:p><=\r\n/span></p></td></tr></table></div></td></tr><tr><td style=3D\'padding:7.5pt =\r\n18.75pt 7.5pt 18.75pt;word-wrap:break-word\'><div align=3Dcenter><table clas=\r\ns=3DMsoNormalTable border=3D0 cellspacing=3D0 cellpadding=3D0 style=3D\'bord=\r\ner-collapse:collapse\'><tr><td style=3D\'background:#356CC9;padding:7.5pt 18.=\r\n75pt 7.5pt 18.75pt\'><p class=3DMsoNormal align=3Dcenter style=3D\'text-align=\r\n:center\'><span style=3D\'color:white\'><a href=3D\"http://my.apusseo.com/forgo=\r\ntpass/token/b9001f3c56c86d5a2094db145d0a30509032c46ab9c8a5a6d019ffc1c596c61=\r\n6\" target=3D\"_blank\"><span style=3D\'font-size:10.0pt;font-family:\"BlinkMacS=\r\nystemFont\",serif;color:white;background:#356CC9;text-decoration:none\'>Click=\r\n here to reset your password</span></a> <o:p></o:p></span></p></td></tr></t=\r\nable></div></td></tr></table></td></tr></table></div></td></tr></table></di=\r\nv></div></td></tr></table></div><p class=3DMsoNormal style=3D\'background:#F=\r\n4F7FA\'><o:p>&nbsp;</o:p></p><div align=3Dcenter><table class=3DMsoNormalTab=\r\nle border=3D0 cellspacing=3D0 cellpadding=3D0 width=3D600 style=3D\'width:45=\r\n0.0pt;border-collapse:collapse\'><tr><td style=3D\'padding:0cm 0cm 0cm 0cm;wo=\r\nrd-wrap:break-word\'><div><div align=3Dcenter><table class=3DMsoNormalTable =\r\nborder=3D0 cellspacing=3D0 cellpadding=3D0 width=3D\"100%\" style=3D\'width:10=\r\n0.0%;border-collapse:collapse\'><tr><td valign=3Dtop style=3D\'padding:15.0pt=\r\n 0cm 15.0pt 0cm\'><div align=3Dcenter><table class=3DMsoNormalTable border=\r\n=3D0 cellspacing=3D0 cellpadding=3D0 style=3D\'border-collapse:collapse\'><tr=\r\n><td width=3D600 valign=3Dtop style=3D\'width:450.0pt;padding:0cm 0cm 0cm 0c=\r\nm\'><table class=3DMsoNormalTable border=3D0 cellspacing=3D0 cellpadding=3D0=\r\n width=3D\"100%\" style=3D\'width:100.0%;border-collapse:collapse\'><tr><td sty=\r\nle=3D\'padding:7.5pt 18.75pt 7.5pt 18.75pt\'><p class=3DMsoNormal align=3Dcen=\r\nter style=3D\'text-align:center;line-height:16.5pt;mso-line-height-rule:exac=\r\ntly\'><span style=3D\'font-size:10.0pt;font-family:\"BlinkMacSystemFont\",serif=\r\n;color:#BBBBBB\'>=C2=A9 Apus SIA<o:p></o:p></span></p></td></tr></table></td=\r\n></tr></table></div></td></tr></table></div></div></td></tr></table></div><=\r\np class=3DMsoNormal><o:p>&nbsp;</o:p></p></div></div><div id=3D\"DAB4FAD8-2D=\r\nD7-40BB-A1B8-4E2AA1F9FDF2\"><br />\r\n<table style=3D\"border-top: 1px solid #D3D4DE;\">\r\n	<tr>\r\n        <td style=3D\"width: 55px; padding-top: 13px;\"><a href=3D\"https://ww=\r\nw.avast.com/sig-email?utm_medium=3Demail&utm_source=3Dlink&utm_campaign=3Ds=\r\nig-email&utm_content=3Demailclient\" target=3D\"_blank\"><img src=3D\"https://i=\r\npmcdn.avast.com/images/icons/icon-envelope-tick-round-orange-animated-no-re=\r\npeat-v1.gif\" alt=3D\"\" width=3D\"46\" height=3D\"29\" style=3D\"width: 46px; heig=\r\nht: 29px;\" /></a></td>\r\n		<td style=3D\"width: 470px; padding-top: 12px; color: #41424e; font-size: =\r\n13px; font-family: Arial, Helvetica, sans-serif; line-height: 18px;\">Virus-=\r\nfree. <a href=3D\"https://www.avast.com/sig-email?utm_medium=3Demail&utm_sou=\r\nrce=3Dlink&utm_campaign=3Dsig-email&utm_content=3Demailclient\" target=3D\"_b=\r\nlank\" style=3D\"color: #4453ea;\">www.avast.com</a>\r\n		</td>\r\n	</tr>\r\n</table><a href=3D\"#DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\" width=3D\"1\" heigh=\r\nt=3D\"1\"> </a></div></body></html>\r\n------=_NextPart_000_0075_01D4AF20.967807D0--\r\n\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('4', 'Amit Kumar <info@getnewwebsite.net> - info@getnewwebsite.net', '10003', '1', NULL, 'Website Design/ PHP, Magento, Drupal, E-Commerce .etc apusseo.com', '<p><font color=\"#0000a0\" face=\"Calibri\">Hi Company Director,</font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\">I apologize for my cold outreach and I hope You\'re doing well.</font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\">I work for a leading Website Design / Apps Development Company based out in India at a Minimum price by experts, where you won\'t compromise the quality too.</font></p><br />\n<p><font color=\"#004040\" face=\"Calibri\"><strong>Our Creative Services Cover the Following Areas:-</strong></font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\"><strong><font color=\"#004040\"></font> Website Development <font color=\"#004040\">(Custom Website Development, PHP Development, Ajax Programming) etc.</font><br /><font color=\"#004040\"></font> Website Designing <font color=\"#004040\">(HTML Designing, Corporate Website Design, PSD to XHTML/HTML) etc.</font><br /><font color=\"#004040\"></font> Open Source Customization/ CMS <font color=\"#004040\">(Joomla, Shopify, Drupal, Wordpress) etc.</font><br /><font color=\"#004040\"></font> Ecommerce Website Development <font color=\"#004040\">(Magento, OS Commerce, Zen Cart integration) etc.<br /></font> Web Programming Services <font color=\"#004040\">(PHP MySQL Development, PHP Frameworks, JavaScript Frameworks) etc.</font><br /><font color=\"#004040\"></font> Mobile Application Development <font color=\"#004040\">(iPhone, Android, Blackberry, Windows) etc.</font></strong></font></p><br />\n<p><br />\n</p><p><font color=\"#0000a0\" face=\"Calibri\"><strong></strong></font></p><font color=\"#0000a0\" face=\"Calibri\">I can send you more details on the packages/action/Portfolio/past work details.</font> <br />\n<p></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\">Please share your requirement and contact details for talk with you,</font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\">I am waiting for your reply.</font></p><br />\n<p><font color=\"#004040\" face=\"Calibri\"><strong>Kindest Regards,</strong></font></p><br />\n<p><font color=\"#004040\" face=\"Calibri\"><strong>Amit Kumar</strong></font></p><br />\n<p><font color=\"#0000a0\"><font face=\"Calibri\"><strong><font color=\"#004040\"><em>Recipients ID:</em></font> <font size=\"2\"><font color=\"#004040\">E-Mail</font></font></strong><font size=\"2\"> info@apusseo.com <strong><font color=\"#004040\">Website</font></strong> apusseo.com</font><br /><strong><font color=\"#004040\">---------------------------------------------------------------------------------</font></strong><br /><strong><em>Disclaimer:</em></strong><font color=\"#0000a0\"> <font size=\"2\">If you are not the intended recipient, please contact the sender by reply e-mail and delete all copies of the original message. If you are not interested in receiving our e-mails then please reply with a <strong><font color=\"#800000\">\"REMOVE\"</font></strong> in the subject line, the e-mail addresses to be removed with any e-mail addresses, which might be diverting the e-mails to you. We are sorry for the inconvenience.</font></font></font></font></p>', 'closed', '0', '0', '1', '0', NULL, '1550938504', '1', '1', '0', 'Return-Path: <info@getnewwebsite.net>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP id iOvsJnxxcVyRPRUAMoQ/pw\r\n	for <info@apusseo.com>; Sat, 23 Feb 2019 18:14:52 +0200\r\nReturn-path: <info@getnewwebsite.net>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Sat, 23 Feb 2019 18:14:52 +0200\r\nReceived: from [157.119.122.6] (port=51301 helo=localhost.localdomain.com)\r\n	by cp.euwebhoster.com with esmtp (Exim 4.91)\r\n	(envelope-from <info@getnewwebsite.net>)\r\n	id 1gxZwx-005r5t-Gz\r\n	for info@apusseo.com; Sat, 23 Feb 2019 18:14:52 +0200\r\nX-Sender: \"Amit Kumar\"\r\n <info@getnewwebsite.net>\r\nX-Receiver: info@apusseo.com\r\nMIME-Version: 1.0\r\nFrom: \"Amit Kumar\"\r\n <info@getnewwebsite.net>\r\nTo: info@apusseo.com\r\nReply-To: \"Amit Kumar\"\r\n <digital1o1web@gmail.com>\r\nDate: 23 Feb 2019 07:56:01 -0800\r\nSubject: Website Design/ PHP, Magento, Drupal, E-Commerce .etc apusseo.com\r\nContent-Type: text/html; charset=Windows-1252\r\nContent-Transfer-Encoding: quoted-printable\r\nPriority: urgent\r\nImportance: normal\r\n\r\n <BODY scroll=3Dauto><P><FONT color=3D#0000a0 face=3DCalibri>Hi Co=\r\nmpany Director,</FONT></P>=0D=0A<P><FONT color=3D#0000a0 face=3DC=\r\nalibri>I apologize for my cold outreach and I hope You\'re doing w=\r\nell.</FONT></P>=0D=0A<P><FONT color=3D#0000a0 face=3DCalibri>I wo=\r\nrk for a leading Website Design / Apps Development Company based =\r\nout in&nbsp;India at a Minimum price by experts, where you won\'t =\r\ncompromise the quality too.</FONT></P>=0D=0A<P><FONT color=3D#004=\r\n040 face=3DCalibri><STRONG>Our Creative Services Cover the Follow=\r\ning Areas:-</STRONG></FONT></P>=0D=0A<P><FONT color=3D#0000a0 fac=\r\ne=3DCalibri><STRONG><FONT color=3D#004040>=95</FONT> Website Deve=\r\nlopment <FONT color=3D#004040>(Custom Website Development, PHP De=\r\nvelopment, Ajax Programming) etc.</FONT><BR><FONT color=3D#004040=\r\n>=95</FONT> Website Designing <FONT color=3D#004040>(HTML Designi=\r\nng, Corporate Website Design, PSD to XHTML/HTML) etc.</FONT><BR><=\r\nFONT color=3D#004040>=95</FONT> Open Source Customization/ CMS <F=\r\nONT color=3D#004040>(Joomla, Shopify, Drupal, Wordpress) etc.</FO=\r\nNT><BR><FONT color=3D#004040>=95</FONT> Ecommerce Website Develop=\r\nment <FONT color=3D#004040>(Magento, OS Commerce, Zen Cart integr=\r\nation) etc.<BR>=95</FONT> Web Programming Services <FONT color=3D=\r\n#004040>(PHP MySQL Development, PHP Frameworks, JavaScript Framew=\r\norks) etc.</FONT><BR><FONT color=3D#004040>=95</FONT> Mobile Appl=\r\nication Development <FONT color=3D#004040>(iPhone, Android, Black=\r\nberry, Windows) etc.</FONT></STRONG></FONT></P>=0D=0A<P>=0D=0A<P>=\r\n<FONT color=3D#0000a0 face=3DCalibri><STRONG></STRONG></FONT></P>=\r\n<FONT color=3D#0000a0 face=3DCalibri>I can send you more details =\r\non the packages/action/Portfolio/past work details.</FONT> =0D=0A=\r\n<P></P>=0D=0A<P><FONT color=3D#0000a0 face=3DCalibri>Please share=\r\n your requirement and contact details for talk with you,</FONT></=\r\nP>=0D=0A<P><FONT color=3D#0000a0 face=3DCalibri>I am waiting for =\r\nyour reply.</FONT></P>=0D=0A<P><FONT color=3D#004040 face=3DCalib=\r\nri><STRONG>Kindest Regards,</STRONG></FONT></P>=0D=0A<P><FONT col=\r\nor=3D#004040 face=3DCalibri><STRONG>Amit Kumar</STRONG></FONT></P=\r\n>=0D=0A<P><FONT color=3D#0000a0><FONT face=3DCalibri><STRONG><FON=\r\nT color=3D#004040><EM>Recipients ID:</EM></FONT> <FONT size=3D2><=\r\nFONT color=3D#004040>E-Mail</FONT></FONT></STRONG><FONT size=3D2>=\r\n info@apusseo.com <STRONG><FONT color=3D#004040>Website</FONT></S=\r\nTRONG> apusseo.com</FONT><BR><STRONG><FONT color=3D#004040>------=\r\n-----------------------------------------------------------------=\r\n----------</FONT></STRONG><BR><STRONG><EM>Disclaimer:</EM></STRON=\r\nG><FONT color=3D#0000a0> <FONT size=3D2>If you are not the intend=\r\ned recipient, please contact the sender by reply e-mail and delet=\r\ne all copies of the original message. If you are not interested i=\r\nn receiving our e-mails then please reply with a <STRONG><FONT co=\r\nlor=3Dmaroon>\"REMOVE\"</FONT></STRONG> in the subject line, the e-=\r\nmail addresses to be removed with any e-mail addresses, which mig=\r\nht be diverting the e-mails to you. We are sorry for the inconven=\r\nience.</FONT></FONT></FONT></FONT></P></BODY>=0D=0A\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('5', 'Allen Jackson <allenjacksonagency@gmail.com> - allenjacksonagency@gmail.com', '10004', '1', NULL, 'SEO Outsourcing at Low Cost!', '<img src=\"http://localhost:8080/g.html?uid=1.6c.3nh2z.0.yp32pgmsfh\" alt=\"\" border=\"0\" height=\"1\" width=\"1\" /><div>\n	<span style=\"font-family:verdana;\">Hi,</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">Have you thought about hiring an offshore help and then decided not to go that path because of horror stories?</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">In last 3 months we have started working with 10 SEO agencies just like yours and they love our work. Which is why I have decided to approach more because I believe that what my team can help you scale your business just like we are helping others agencies like yours.</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">Quick Note: we are 125+ team, running 300+ projects.</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">Here is what I am offering:</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">1. 15 day free trial on 3 seo projects.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">2. We use Basecamp to manage our projects. You will see project management like never before.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">3. We have paid access to tools like moz, Raventools, Semrush, Ahrefs, Majestic, Serpbook, Hootsuite and more.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">4. We use tier link building approach in SEO. 1st tier links to money site, 2nd tier links to 1st tier links and so on. You know how it is.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">5. Every project gets 2 hours worth of work every single day. No compromise here. We build at least 2-3 backlinks per project every single day.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">6. We build links from sites with PA, DA &gt; 15. No low quality junk spam.</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">If you are interested and want to give it a shot, I would be happy to share our Methodologies, past work details and client Testimonials and Prices. </span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">let’s hop on a quick Skype call. I am sure you will love us (100% sure).Please reply to this email with you Skype or Phone number. </span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">Regards,</span></div>\n<div>\n	<span style=\"font-family:verdana;\">Allen Jackson</span></div>\n<div>\n	<span style=\"font-family:verdana;\">Business Development Executive</span></div>', 'closed', '0', '0', '1', '0', NULL, '1551716103', '1', '1', '0', 'Return-Path: <allenjacksonagency@gmail.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id GO06AaVOfVzC1g0AMoQ/pw\r\n	(envelope-from <allenjacksonagency@gmail.com>)\r\n	for <info@apusseo.com>; Mon, 04 Mar 2019 18:13:25 +0200\r\nReturn-path: <allenjacksonagency@gmail.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Mon, 04 Mar 2019 18:13:25 +0200\r\nReceived: from mail.clutchitsolutions.com ([72.9.100.134]:57160)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-GCM-SHA384:256)\r\n	(Exim 4.91)\r\n	(envelope-from <allenjacksonagency@gmail.com>)\r\n	id 1h0qDU-003oQN-Nq\r\n	for info@apusseo.com; Mon, 04 Mar 2019 18:13:24 +0200\r\nReceived: by mail.clutchitsolutions.com (Postfix, from userid 500)\r\n	id B8146156509B; Tue,  5 Mar 2019 00:35:00 +0530 (IST)\r\nDKIM-Filter: OpenDKIM Filter v2.11.0 mail.clutchitsolutions.com B8146156509B\r\nReceived: by mail.clutchitsolutions.com for <info@apusseo.com>; Mon,  4 Mar 2019 19:03:41 GMT\r\nMessage-ID: <20190304233321-1.1.6c.3nh2z.0.45z8kvf9kf@openemm.net>\r\nDate: Mon,  4 Mar 2019 19:03:41 GMT\r\nFrom: \"Allen Jackson\" <allenjacksonagency@gmail.com>\r\nTo: <info@apusseo.com>\r\nSubject: SEO Outsourcing at Low Cost!\r\nX-Mailer: OpenEMM V2015_R3\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative;\r\n	boundary=\"-==AGNITASOUTER164240059B290000E4==\"\r\n\r\n This is a multi-part message in MIME format.\r\n\r\n---==AGNITASOUTER164240059B290000E4==\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHi,\r\n\r\nHave you thought about hiring an offshore help and then decided not to\r\ngo that path because of horror stories?\r\n\r\nIn last 3 months we have started working with 10 SEO agencies just like\r\nyours and they love our work. Which is why I have decided to approach\r\nmore because I believe that what my team can help you scale your\r\nbusiness just like we are helping others agencies like yours.\r\n\r\nQuick Note: we are 125+ team, running 300+ projects.\r\n\r\nHere is what I am offering:\r\n\r\n1. 15 day free trial on 3 seo projects.\r\n2. We use Basecamp to manage our projects. You will see project\r\nmanagement like never before.\r\n3. We have paid access to tools like moz, Raventools, Semrush, Ahrefs,\r\nMajestic, Serpbook, Hootsuite and more.\r\n4. We use tier link building approach in SEO. 1st tier links to money\r\nsite, 2nd tier links to 1st tier links and so on. You know how it is.\r\n5. Every project gets 2 hours worth of work every single day. No\r\ncompromise here. We build at least 2-3 backlinks per project every\r\nsingle day.\r\n6. We build links from sites with PA, DA > 15. No low quality junk\r\nspam.\r\n\r\nIf you are interested and want to give it a shot, I would be happy to\r\nshare our Methodologies, past work details and client Testimonials and\r\nPrices.\r\n\r\nlet=E2=80=99s hop on a quick Skype call. I am sure you will love us (100%\r\nsure).Please reply to this email with you Skype or Phone number.\r\n\r\nRegards,\r\nAllen Jackson\r\nBusiness Development Executive\r\n---==AGNITASOUTER164240059B290000E4==\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<img src=3D\"http://localhost:8080/g.html?uid=3D1.6c.3nh2z.0.yp32pgmsfh\" a=\r\nlt=3D\"\" border=3D\"0\" height=3D\"1\" width=3D\"1\"/><div>\r\n	<span style=3D\"font-family:verdana;\">Hi,</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Have you thought about hiring an of=\r\nfshore help and then decided not to go that path because of horror storie=\r\ns?</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">In last 3 months we have started wo=\r\nrking with 10 SEO agencies just like yours and they love our work. Which =\r\nis why I have decided to approach more because I believe that what my tea=\r\nm can help you scale your business just like we are helping others agenci=\r\nes like yours.</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Quick Note: we are 125+ team, runni=\r\nng 300+ projects.</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Here is what I am offering:</span><=\r\n/div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">1. 15 day free trial on 3 seo proje=\r\ncts.</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">2. We use Basecamp to manage our pr=\r\nojects. You will see project management like never before.</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">3. We have paid access to tools lik=\r\ne moz, Raventools, Semrush, Ahrefs, Majestic, Serpbook, Hootsuite and mor=\r\ne.</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">4. We use tier link building approa=\r\nch in SEO. 1st tier links to money site, 2nd tier links to 1st tier links=\r\n and so on. You know how it is.</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">5. Every project gets 2 hours worth=\r\n of work every single day. No compromise here. We build at least 2-3 back=\r\nlinks per project every single day.</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">6. We build links from sites with P=\r\nA, DA &gt; 15. No low quality junk spam.</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">If you are interested and want to g=\r\nive it a shot, I would be happy to share our Methodologies, past work det=\r\nails and client Testimonials and Prices.&nbsp;</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">let&rsquo;s hop on a quick Skype ca=\r\nll. I am sure you will love us (100% sure).Please reply to this email wit=\r\nh you Skype or Phone number.&nbsp;</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Regards,</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Allen Jackson</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Business Development Executive</spa=\r\nn></div>\r\n---==AGNITASOUTER164240059B290000E4==--\r\n\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('6', 'Ritu Sharma <wordpresswebsiteservices@yahoo.com> - wordpresswebsiteservices@yahoo.com', '10005', '1', NULL, 'Top Ranking SEO and Digital Marketing Services', '<div class=\"ydp553c1fdeyahoo-style-wrap\" style=\"font-family:\'Helvetica Neue\', Helvetica, Arial, sans-serif;font-size:16px;\"><span>\n\n</span><p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\">Hi<br />\n<br />\nI\'m Ritu,</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nInternet Marketing Manager .</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nDo you want to see your website <b>in Top\n10 position</b> in Google or other major search engine?</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nDo you want more targeted visitors on your website?</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nIf yes, please let me know your website URL and keywords name that you want to\noptimize so that our team could analyze the keywords, level of competition and\ncould supply you with </span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"> </span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\">our best price to optimize the\nwebsite .</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nAlso, Please let me know the <b>competitors\nURL</b> for better understanding of the level of competition.</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nMost firms overseas have achieved a significant amount of savings by\noutsourcing either complete or part of their Work to us in India. All our\nwork remains in the background and the</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"> </span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\">end client never knows that the work\nhas been outsourced resulting in both savings and brand value for you and your\ncompany.</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nPlease let me know your skype,phone number and email id for more discussion.<br />\n<br />\n</span></p>\n\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\">I look forward to your positive\nresponse.<br />\n<br />\n</span></p>\n\n<span style=\"font-size:12pt;line-height:115%;font-family:Helvetica, sans-serif;\">Thanks &amp; Regards<br />\n<br />\n <br />Ritu</span></div>', 'closed', '0', '0', '1', '0', NULL, '1552655103', '1', '1', '0', 'Return-Path: <wordpresswebsiteservices@yahoo.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id cIpUFXSii1xN4T0AMoQ/pw\r\n	(envelope-from <wordpresswebsiteservices@yahoo.com>)\r\n	for <info@apusseo.com>; Fri, 15 Mar 2019 15:02:44 +0200\r\nReturn-path: <wordpresswebsiteservices@yahoo.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Fri, 15 Mar 2019 15:02:44 +0200\r\nReceived: from sonic312-19.consmr.mail.sg3.yahoo.com ([106.10.244.209]:46181)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <wordpresswebsiteservices@yahoo.com>)\r\n	id 1h4mTz-00H1Of-L0\r\n	for info@apusseo.com; Fri, 15 Mar 2019 15:02:44 +0200\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=yahoo.com; s=s2048; t=1552654959; bh=ab7qRAX+cpxJoN+SN7J28M3Ksr3JUaBRCnOmTIWrlu8=; h=Date:From:Subject:References:From:Subject; b=WCIWRfx4xQ+0rT/qcsS4jvWkOQ7S99qIKj7Q/RZEVf2oQBJOzSGjbz79MhqwRezK1RtaGX6HshsUKQ4YE4edI8me2J+04Yku0T7wiOW6B0tSqcdskHJO6Ep5mkRYUJplcX4cIkna3Pd51TsojWmjK7uCnOnm7+uCBuyvobYpKjiCal/Z7xWHiDXtGgJxST5qQ2rW4n+Ayg8GlDBZ/UZLMnIYX2MV45wYJvoAzFy/8GUUOoi8ZQZapt+vmhdnjo2vE0AmMqNU9qSd+LLYJye8bAV/LilP+C4DAYnJbtlYMSOZQRUss+g4q4700Hn73/QQCSVPNRQOk5yHJDWWDNjBQQ==\r\nX-YMail-OSG: tvgsCAMVM1m85oLGvqRT3khc0kxqZ8NrJo8m6hV3yydWBNuzxgt.6YLlmppb0.7\r\n hTbWWpBe1GmFmew8BbU1A052nADHjh5bDBCtX1XDOD0a7oHhMqNOiv_5VDWwwEzg496gNqD.xIgC\r\n ukMXmANrH0FU7OnTGcQnIMdsFFJpTv90810L54z5C0u6Ok45l2vatNx5L.02nnVo3B6uh4Q2qy6z\r\n tv_eYl6apA68D_O1Xcjj7.2vPUocJ2H2bDCS75HhjUF9J2BWTETtISi171giXrOJ5zYQ_UB5S9y6\r\n qYitc7HDyEr6_5xTorSk5Mqg1QjJXtzu79PBQ3vbO594wjgA8QXSnlM7fD1vDIOgVy30PGZ158Oj\r\n 613QcVLrlIax4Eh1q0_Xsn0QVmqlzOo1KfmrjvEm08Ega74c9c2uGXAstYDcgscKNrHonfbeJ0Vl\r\n oim5CpqvryyOIlL_n955Azaj046seNI3OiFV8d2POK2ez1ZhKMUhg91qlSVcT5xAWU10esxqP4FH\r\n Jye3ykeVYXqeU8Mo4mjayQZCkJzXS9txyKMaiafnMX5XArwg6X5hRhqIdhp0XMkfXHLSAN48ab3t\r\n 6_Tt1qe9WDK5aA2BXt3h22JJ5mAyQAmoPwjTF9BE_bQEqe90gBM7EWPDNb.Oh35kRU3RjrG1apyv\r\n UftwoShsADwXy3JZ6bR_aoLNcFyFj9Y.1BxOLX7Ibzv6kr.CblSJZDP8.GX0eSaz.NRwGJzta1Vd\r\n PvLvcAp_hzpMt4XGd.W4saDqKMj6XIbln8kRphtRMExirg9CiLpZ0SNTNcz.LZel59tRmpBYx2v2\r\n hVMmbLkU8kh3qzDYv2FtYT9UohfI5u4_ucKHLS2DxBwSpcNcdQKKNnXJqFS8DSYuoXLHI_u0vn5o\r\n uRBO2lGtmNU1fKJQKwNe7.wBIWx1TGl2ILiA.qHPKGzWxHUT5.I4Xr7sj596Co3BWnC8QhXDFsDv\r\n LjVeceb416boErB7UviZ6jXo_HJqnEfBx2MPhLwm_KZI_w89EXhkyPyzHlOku7mav679lpFUWg6k\r\n YJrNT5WozNRO8RA5K_Y24TEXRtiHA8Je3nepczEOMDErrcNezrDzOcHnVpyABIg--\r\nReceived: from sonic.gate.mail.ne1.yahoo.com by sonic312.consmr.mail.sg3.yahoo.com with HTTP; Fri, 15 Mar 2019 13:02:39 +0000\r\nDate: Fri, 15 Mar 2019 13:02:39 +0000 (UTC)\r\nFrom: Ritu Sharma <wordpresswebsiteservices@yahoo.com>\r\nMessage-ID: <1384395697.5208929.1552654959474@mail.yahoo.com>\r\nSubject: Top Ranking SEO and Digital Marketing Services\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_5208928_1168292767.1552654959472\"\r\nReferences: <1384395697.5208929.1552654959474.ref@mail.yahoo.com>\r\nX-Mailer: WebService/1.1.13212 YMailNorrin Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0\r\nContent-Length: 23634\r\n\r\n ------=_Part_5208928_1168292767.1552654959472\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n\r\nHi\r\n\r\nI\'m Ritu,\r\n\r\n\r\nInternet Marketing Manager .\r\n\r\n\r\nDo you want to see your website in Top10 position in Google or other major =\r\nsearch engine?\r\n\r\n\r\nDo you want more targeted visitors on your website?\r\n\r\n\r\nIf yes, please let me know your website URL and keywords name that you want=\r\n tooptimize so that our team could analyze the keywords, level of competiti=\r\non andcould supply you with=20\r\n\r\n=C2=A0\r\n\r\nour best price to optimize thewebsite .\r\n\r\n\r\nAlso, Please let me know the competitorsURL for better understanding of the=\r\n level of competition.\r\n\r\n\r\nMost firms overseas have achieved a significant amount of savings byoutsour=\r\ncing either complete or part of their=C2=A0Work to us in India. All ourwork=\r\n remains in the background and the\r\n\r\n=C2=A0\r\n\r\nend client never knows that the workhas been outsourced resulting in both s=\r\navings and brand value for you and yourcompany.\r\n\r\n\r\nPlease let me know your skype,phone number and email id for more discussion=\r\n.\r\n\r\n\r\n\r\nI look forward to your positiveresponse.\r\n\r\n\r\nThanks & Regards\r\n\r\n=C2=A0\r\nRitu\r\n------=_Part_5208928_1168292767.1552654959472\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\n<html><head></head><body><div class=\"ydp553c1fdeyahoo-style-wrap\" style=\"font-family:Helvetica Neue, Helvetica, Arial, sans-serif;font-size:16px;\"><span><!--[if gte mso 9]><xml>\r\n <w:WordDocument>\r\n  <w:View>Normal</w:View>\r\n  <w:Zoom>0</w:Zoom>\r\n  <w:TrackMoves/>\r\n  <w:TrackFormatting/>\r\n  <w:PunctuationKerning/>\r\n  <w:ValidateAgainstSchemas/>\r\n  <w:SaveIfXMLInvalid>false</w:SaveIfXMLInvalid>\r\n  <w:IgnoreMixedContent>false</w:IgnoreMixedContent>\r\n  <w:AlwaysShowPlaceholderText>false</w:AlwaysShowPlaceholderText>\r\n  <w:DoNotPromoteQF/>\r\n  <w:LidThemeOther>EN-US</w:LidThemeOther>\r\n  <w:LidThemeAsian>X-NONE</w:LidThemeAsian>\r\n  <w:LidThemeComplexScript>X-NONE</w:LidThemeComplexScript>\r\n  <w:Compatibility>\r\n   <w:BreakWrappedTables/>\r\n   <w:SnapToGridInCell/>\r\n   <w:WrapTextWithPunct/>\r\n   <w:UseAsianBreakRules/>\r\n   <w:DontGrowAutofit/>\r\n   <w:SplitPgBreakAndParaMark/>\r\n   <w:DontVertAlignCellWithSp/>\r\n   <w:DontBreakConstrainedForcedTables/>\r\n   <w:DontVertAlignInTxbx/>\r\n   <w:Word11KerningPairs/>\r\n   <w:CachedColBalance/>\r\n  </w:Compatibility>\r\n  <w:BrowserLevel>MicrosoftInternetExplorer4</w:BrowserLevel>\r\n  <m:mathPr>\r\n   <m:mathFont m:val=\"Cambria Math\"/>\r\n   <m:brkBin m:val=\"before\"/>\r\n   <m:brkBinSub m:val=\"--\"/>\r\n   <m:smallFrac m:val=\"off\"/>\r\n   <m:dispDef/>\r\n   <m:lMargin m:val=\"0\"/>\r\n   <m:rMargin m:val=\"0\"/>\r\n   <m:defJc m:val=\"centerGroup\"/>\r\n   <m:wrapIndent m:val=\"1440\"/>\r\n   <m:intLim m:val=\"subSup\"/>\r\n   <m:naryLim m:val=\"undOvr\"/>\r\n  </m:mathPr></w:WordDocument>\r\n</xml><![endif]--><!--[if gte mso 9]><xml>\r\n <w:LatentStyles DefLockedState=\"false\" DefUnhideWhenUsed=\"true\"\r\n  DefSemiHidden=\"true\" DefQFormat=\"false\" DefPriority=\"99\"\r\n  LatentStyleCount=\"267\">\r\n  <w:LsdException Locked=\"false\" Priority=\"0\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Normal\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"heading 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 7\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 8\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 9\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 7\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 8\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" Name=\"toc 9\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"35\" QFormat=\"true\" Name=\"caption\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"10\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Title\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"1\" Name=\"Default Paragraph Font\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"11\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Subtitle\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"22\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Strong\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"20\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Emphasis\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"59\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Table Grid\"/>\r\n  <w:LsdException Locked=\"false\" UnhideWhenUsed=\"false\" Name=\"Placeholder Text\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"1\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"No Spacing\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Shading\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light List\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Grid\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Dark List\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Shading\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful List\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Grid\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light List Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" UnhideWhenUsed=\"false\" Name=\"Revision\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"34\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"List Paragraph\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"29\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Quote\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"30\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Intense Quote\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 1\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light List Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 2\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light List Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 3\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light List Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 4\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light List Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 5\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"60\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Shading Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"61\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light List Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"62\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Light Grid Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"63\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 1 Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"64\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Shading 2 Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"65\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 1 Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"66\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium List 2 Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"67\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 1 Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"68\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 2 Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"69\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Medium Grid 3 Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"70\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Dark List Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"71\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Shading Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"72\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful List Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"73\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" Name=\"Colorful Grid Accent 6\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"19\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Subtle Emphasis\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"21\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Intense Emphasis\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"31\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Subtle Reference\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"32\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Intense Reference\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"33\" SemiHidden=\"false\"\r\n   UnhideWhenUsed=\"false\" QFormat=\"true\" Name=\"Book Title\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"37\" Name=\"Bibliography\"/>\r\n  <w:LsdException Locked=\"false\" Priority=\"39\" QFormat=\"true\" Name=\"TOC Heading\"/>\r\n </w:LatentStyles>\r\n</xml><![endif]--><!--[if gte mso 10]>\r\n<style>\r\n /* Style Definitions */\r\n table.MsoNormalTable\r\n	{mso-style-name:\"Table Normal\";\r\n	mso-tstyle-rowband-size:0;\r\n	mso-tstyle-colband-size:0;\r\n	mso-style-noshow:yes;\r\n	mso-style-priority:99;\r\n	mso-style-qformat:yes;\r\n	mso-style-parent:\"\";\r\n	mso-padding-alt:0in 5.4pt 0in 5.4pt;\r\n	mso-para-margin-top:0in;\r\n	mso-para-margin-right:0in;\r\n	mso-para-margin-bottom:10.0pt;\r\n	mso-para-margin-left:0in;\r\n	line-height:115%;\r\n	mso-pagination:widow-orphan;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",\"sans-serif\";\r\n	mso-ascii-font-family:Calibri;\r\n	mso-ascii-theme-font:minor-latin;\r\n	mso-fareast-font-family:\"Times New Roman\";\r\n	mso-fareast-theme-font:minor-fareast;\r\n	mso-hansi-font-family:Calibri;\r\n	mso-hansi-theme-font:minor-latin;\r\n	mso-bidi-font-family:\"Times New Roman\";\r\n	mso-bidi-theme-font:minor-bidi;}\r\n</style>\r\n<![endif]-->\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\">Hi<br>\r\n<br>\r\nI\'m Ritu,</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\"><br>\r\nInternet Marketing Manager .</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\"><br>\r\nDo you want to see your website <b>in Top\r\n10 position</b> in Google or other major search engine?</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\"><br>\r\nDo you want more targeted visitors on your website?</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\"><br>\r\nIf yes, please let me know your website URL and keywords name that you want to\r\noptimize so that our team could analyze the keywords, level of competition and\r\ncould supply you with </span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\">&nbsp;</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\">our best price to optimize the\r\nwebsite .</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\"><br>\r\nAlso, Please let me know the <b>competitors\r\nURL</b> for better understanding of the level of competition.</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\"><br>\r\nMost firms overseas have achieved a significant amount of savings by\r\noutsourcing either complete or part of their&nbsp;Work to us in India. All our\r\nwork remains in the background and the</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\">&nbsp;</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\">end client never knows that the work\r\nhas been outsourced resulting in both savings and brand value for you and your\r\ncompany.</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\"><br>\r\nPlease let me know your skype,phone number and email id for more discussion.<br>\r\n<br>\r\n</span></p>\r\n\r\n<p class=\"ydp554f9d60MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal\"><span style=\"font-size:12.0pt;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman\">I look forward to your positive\r\nresponse.<br>\r\n<br>\r\n</span></p>\r\n\r\n<span style=\"font-size:12.0pt;line-height:115%;font-family:Helvetica,sans-serif;mso-fareast-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:EN-US;mso-bidi-language:AR-SA\">Thanks &amp; Regards<br>\r\n<br>\r\n&nbsp;<br>Ritu</span></span></div></body></html>\r\n------=_Part_5208928_1168292767.1552654959472--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('7', 'Ritu Sharma <wordpresswebsiteservices@yahoo.com> - wordpresswebsiteservices@yahoo.com', '10006', '1', NULL, 'Re: Top Ranking SEO and Digital Marketing Services', '<div class=\"ydpc4b90430yahoo-style-wrap\" style=\"font-family:\'Helvetica Neue\', Helvetica, Arial, sans-serif;font-size:16px;\"><div></div>\n        <div><span>Hello,<br /><br />Hope you are doing fine.<br /><br />This is just a follow up mail to touch base with you.<br /><br />Haven’t heard back from you, just wondering if you are interested for outsourcing digital marketing for your business.<br /><br />Please let us know your response.<br /><br />Warm Regards,<br />Ritu</span><br /></div><div><br /></div>\n        \n        </div><div class=\"yahoo_quoted\">\n            <div style=\"font-family:\'Helvetica Neue\', Helvetica, Arial, sans-serif;font-size:13px;color:#26282a;\">\n                \n                <div>\n                    On Friday, 15 March, 2019, 6:32:39 pm IST, Ritu Sharma &lt;wordpresswebsiteservices@yahoo.com&gt; wrote:\n                </div>\n                <div><br /></div>\n                <div><br /></div>\n                <div><div><div><div class=\"yiv8277140913ydp553c1fdeyahoo-style-wrap\" style=\"font-family:\'Helvetica Neue\', Helvetica, Arial, sans-serif;font-size:16px;\"><span>\n\n</span><p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\">Hi<br />\n<br />\nI\'m Ritu,</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nInternet Marketing Manager .</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nDo you want to see your website <b>in Top\n10 position</b> in Google or other major search engine?</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nDo you want more targeted visitors on your website?</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nIf yes, please let me know your website URL and keywords name that you want to\noptimize so that our team could analyze the keywords, level of competition and\ncould supply you with </span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"> </span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\">our best price to optimize the\nwebsite .</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nAlso, Please let me know the <b>competitors\nURL</b> for better understanding of the level of competition.</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nMost firms overseas have achieved a significant amount of savings by\noutsourcing either complete or part of their Work to us in India. All our\nwork remains in the background and the</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"> </span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\">end client never knows that the work\nhas been outsourced resulting in both savings and brand value for you and your\ncompany.</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\"><br />\nPlease let me know your skype,phone number and email id for more discussion.<br />\n<br />\n</span></p>\n\n<p class=\"yiv8277140913ydp554f9d60MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span style=\"font-size:12pt;font-family:Helvetica, sans-serif;\">I look forward to your positive\nresponse.<br />\n<br />\n</span></p>\n\n<span style=\"font-size:12pt;line-height:115%;font-family:Helvetica, sans-serif;\">Thanks &amp; Regards<br />\n<br />\n <br />Ritu</span></div></div></div></div>\n            </div>\n        </div>', 'closed', '0', '0', '1', '0', NULL, '1552893604', '1', '1', '0', 'Return-Path: <wordpresswebsiteservices@yahoo.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id YEkLFFtFj1wLgxoAMoQ/pw\r\n	(envelope-from <wordpresswebsiteservices@yahoo.com>)\r\n	for <info@apusseo.com>; Mon, 18 Mar 2019 09:14:35 +0200\r\nReturn-path: <wordpresswebsiteservices@yahoo.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Mon, 18 Mar 2019 09:14:35 +0200\r\nReceived: from sonic306-19.consmr.mail.sg3.yahoo.com ([106.10.241.139]:39258)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <wordpresswebsiteservices@yahoo.com>)\r\n	id 1h5mTi-007J6E-Ub\r\n	for info@apusseo.com; Mon, 18 Mar 2019 09:14:35 +0200\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=yahoo.com; s=s2048; t=1552893271; bh=n7H+oTYeekpqPOWbe7CtgJsMUpe516F2AO4AaxI0JZk=; h=Date:From:In-Reply-To:References:Subject:From:Subject; b=Zs2u++Egg4tsYQzJjaXGIQ1QkgLgkOhwvvPgaXDJTXRdzu6fppYXtItSSOIor7m2Ps2tJjm9cMk95QyHciBhU0+aoKY2beMp1kk++43P7A7HAxd7N8fyfqquHBaittRw0ZYnPpdUc04/qdE2VshUBKvtJWxp3oV8mqGx7n/q6km4tuIPtxbmS8G1MADTdjiYcY1nliPqPIOgfiKxgVrJgk/U/DYAg/XCovyL2QpfKPaBy72UWt4TODuS9wqMlw5pPFH2spqIUZHhjLxeYN7YB3tAkkC00qkLEIedAF7l07LPTBWreiBhqNh5K9Y8gw5GYPCejpKtB9KBYdAhzLulbQ==\r\nX-YMail-OSG: _7fDTD0VM1mskHzXDJI3N7zupzfPbEsFtNjbMKsxRaoKPwMPfTSZcD26AOYMIB9\r\n GKIJIHs9X33PURydZhOiOF5Ii7Rs0vRSaQmokJ3ji8QXAc4rkYd9bKNQVZaGe6DCZhHkALN..E15\r\n rksfVnXMjAc44N1xX45NEzALT3bcTEP8i4J2TtyWmSLwEhOVFC2.HjxyL_EmU0eM3ZjLdMjE9y7Q\r\n PX.1EURuI795LnFwYqRrlfGzuY.WraaGZWZfhIfiovE9RJSOiKKvVcewl1AtsMA.a9o2Y.D4sUID\r\n vKchRWx1KbySYLtD7dyybuaK8JJP7A4QCiNI2jLt99yFj9WtE5jBwB4t834n08CcIgpq6s6lI38X\r\n HZ_fFrVW2rB3.GSdazqPoTHK_k3F5N0TIQH7eXvuQP29TGXxownk2Q1ksPFG2C10dhWCIPqO1nka\r\n 7zg4U67xVXKqpsBWONw.jYHAcJTAWLXJyPHhtCKsNkPQ32iq7HPAi1scBb8Rl_8itJk5BCmM5lkA\r\n .8fyavp3X1vF4Xy_pM8WcHgJrvHz1pJNoxYJSV0dkYgtG1BvGvUN5KakiPPGTciYm2z0Nlji_W6a\r\n jwbBQt2HU2QHYMRvrP6jmaCQHPrOYWzwjP2zfwFNCC_SbNIxSvRyOcxrSgum91st1ce12C0tTzeS\r\n W7XsxErW8l4bZ3pPAMNCBvvJY5DKyHLv0NBvbRK4_1dRrFkKBlTqxT3YujlwYZgunAo7azlPx5vY\r\n QmQIWTN81c2oybUCouIUZQThvuiXDZkr1oEvS1.jmTxYJ8ZCUZdTcGvEdPe2.h1o3RVFyKNzwcJh\r\n kREr11S_jEXunSwS8Krvt1lAqFq3c8JQzL3LoAQ_tYUR1PKecBzId5h5OsVNaKe3iCbXSyBkswrF\r\n 2rgR8ZG6N6Nx1mFXaQKotaoVFWYIcgSrQDeVpmT6iILLZGInAFPM1pz0_92kif_WZ5N3VQvv2vzd\r\n FMCzyzgrMp2dSD6Qlnf.NI0nYgUKuW5HC2zNNr9KCsw3gW_.ZzVc4oQeHqKZhmW9aZnIvyyZ8s9B\r\n 0SfVIO9CYqBu2k.lnoc2A0kRr9aV68v_dicxxXgv9wxulgOtudTg0kQ9ZMZL4Qw--\r\nReceived: from sonic.gate.mail.ne1.yahoo.com by sonic306.consmr.mail.sg3.yahoo.com with HTTP; Mon, 18 Mar 2019 07:14:31 +0000\r\nDate: Mon, 18 Mar 2019 07:14:26 +0000 (UTC)\r\nFrom: Ritu Sharma <wordpresswebsiteservices@yahoo.com>\r\nMessage-ID: <2009455143.6238368.1552893266346@mail.yahoo.com>\r\nIn-Reply-To: <1384395697.5208929.1552654959474@mail.yahoo.com>\r\nReferences: <1384395697.5208929.1552654959474.ref@mail.yahoo.com> <1384395697.5208929.1552654959474@mail.yahoo.com>\r\nSubject: Re: Top Ranking SEO and Digital Marketing Services\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_6238367_181886761.1552893266344\"\r\nX-Mailer: WebService/1.1.13212 YMailNorrin Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0\r\nContent-Length: 6777\r\n\r\n ------=_Part_6238367_181886761.1552893266344\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n Hello,\r\n\r\nHope you are doing fine.\r\n\r\nThis is just a follow up mail to touch base with you.\r\n\r\nHaven=E2=80=99t heard back from you, just wondering if you are interested f=\r\nor outsourcing digital marketing for your business.\r\n\r\nPlease let us know your response.\r\n\r\nWarm Regards,\r\nRitu\r\n\r\n    On Friday, 15 March, 2019, 6:32:39 pm IST, Ritu Sharma <wordpresswebsit=\r\neservices@yahoo.com> wrote: =20\r\n=20\r\n=20\r\nHi\r\n\r\nI\'m Ritu,\r\n\r\n\r\nInternet Marketing Manager .\r\n\r\n\r\nDo you want to see your website in Top10 position in Google or other major =\r\nsearch engine?\r\n\r\n\r\nDo you want more targeted visitors on your website?\r\n\r\n\r\nIf yes, please let me know your website URL and keywords name that you want=\r\n tooptimize so that our team could analyze the keywords, level of competiti=\r\non andcould supply you with=20\r\n\r\n=C2=A0\r\n\r\nour best price to optimize thewebsite .\r\n\r\n\r\nAlso, Please let me know the competitorsURL for better understanding of the=\r\n level of competition.\r\n\r\n\r\nMost firms overseas have achieved a significant amount of savings byoutsour=\r\ncing either complete or part of their=C2=A0Work to us in India. All ourwork=\r\n remains in the background and the\r\n\r\n=C2=A0\r\n\r\nend client never knows that the workhas been outsourced resulting in both s=\r\navings and brand value for you and yourcompany.\r\n\r\n\r\nPlease let me know your skype,phone number and email id for more discussion=\r\n.\r\n\r\n\r\n\r\nI look forward to your positiveresponse.\r\n\r\n\r\nThanks & Regards\r\n\r\n=C2=A0\r\nRitu =20\r\n------=_Part_6238367_181886761.1552893266344\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<html><head></head><body><div class=3D\"ydpc4b90430yahoo-style-wrap\" style=\r\n=3D\"font-family:Helvetica Neue, Helvetica, Arial, sans-serif;font-size:16px=\r\n;\"><div></div>\r\n        <div><span>Hello,<br><br>Hope you are doing fine.<br><br>This is ju=\r\nst a follow up mail to touch base with you.<br><br>Haven=E2=80=99t heard ba=\r\nck from you, just wondering if you are interested for outsourcing digital m=\r\narketing for your business.<br><br>Please let us know your response.<br><br=\r\n>Warm Regards,<br>Ritu</span><br></div><div><br></div>\r\n       =20\r\n        </div><div id=3D\"yahoo_quoted_3286397927\" class=3D\"yahoo_quoted\">\r\n            <div style=3D\"font-family:\'Helvetica Neue\', Helvetica, Arial, s=\r\nans-serif;font-size:13px;color:#26282a;\">\r\n               =20\r\n                <div>\r\n                    On Friday, 15 March, 2019, 6:32:39 pm IST, Ritu Sharma =\r\n&lt;wordpresswebsiteservices@yahoo.com&gt; wrote:\r\n                </div>\r\n                <div><br></div>\r\n                <div><br></div>\r\n                <div><div id=3D\"yiv8277140913\"><div><div class=3D\"yiv827714=\r\n0913ydp553c1fdeyahoo-style-wrap\" style=3D\"font-family:Helvetica Neue, Helve=\r\ntica, Arial, sans-serif;font-size:16px;\"><span>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\">Hi<br>\r\n<br>\r\nI\'m Ritu,</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\"><br>\r\nInternet Marketing Manager .</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\"><br>\r\nDo you want to see your website <b>in Top\r\n10 position</b> in Google or other major search engine?</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\"><br>\r\nDo you want more targeted visitors on your website?</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\"><br>\r\nIf yes, please let me know your website URL and keywords name that you want=\r\n to\r\noptimize so that our team could analyze the keywords, level of competition =\r\nand\r\ncould supply you with </span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\">&nbsp;</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\">our best price to optimize the\r\nwebsite .</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\"><br>\r\nAlso, Please let me know the <b>competitors\r\nURL</b> for better understanding of the level of competition.</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\"><br>\r\nMost firms overseas have achieved a significant amount of savings by\r\noutsourcing either complete or part of their&nbsp;Work to us in India. All =\r\nour\r\nwork remains in the background and the</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\">&nbsp;</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\">end client never knows that the work\r\nhas been outsourced resulting in both savings and brand value for you and y=\r\nour\r\ncompany.</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\"><br>\r\nPlease let me know your skype,phone number and email id for more discussion=\r\n.<br>\r\n<br>\r\n</span></p>\r\n\r\n<p class=3D\"yiv8277140913ydp554f9d60MsoNormal\" style=3D\"margin-bottom:0in;m=\r\nargin-bottom:.0001pt;line-height:normal;\"><span style=3D\"font-size:12.0pt;f=\r\nont-family:Helvetica, sans-serif;\">I look forward to your positive\r\nresponse.<br>\r\n<br>\r\n</span></p>\r\n\r\n<span style=3D\"font-size:12.0pt;line-height:115%;font-family:Helvetica, san=\r\ns-serif;\">Thanks &amp; Regards<br>\r\n<br>\r\n&nbsp;<br>Ritu</span></span></div></div></div></div>\r\n            </div>\r\n        </div></body></html>\r\n------=_Part_6238367_181886761.1552893266344--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('8', 'Billy Anderson <billyandersonmob@gmail.com> - billyandersonmob@gmail.com', '10007', '1', NULL, 'Let\'s Work Together?', '<img src=\"http://localhost:8080/g.html?uid=1.35.1uzqv.0.g8n4pkbgfi\" alt=\"\" border=\"0\" height=\"1\" width=\"1\" /><div>\n	<span style=\"font-family:verdana;\">Hi,</span></div>\n<div>\n	 </div>\n<div>\n	<strong><span style=\"font-family:verdana;\">Have you thought about hiring an offshore help and then decided not to go that path because of horror stories?</span></strong></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">In last 3 months we have started working with 25 SEO agencies just like yours and they love our work. Which is why I have decided to approach more because I believe that what my team can help you scale your business just like we are helping others agencies like yours.</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">Quick Note: we are 150+ team, running 300+ projects.</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">Here is what I am offering:</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">1.  <strong> 15 day free trial on 3 seo  projects.</strong></span></div>\n<div>\n	<span style=\"font-family:verdana;\">2.    We use Basecamp to manage our projects. You will see project management like never before.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">3.    We have paid access to tools like moz, Raventools, Semrush, Ahrefs, Majestic, Serpbook, Hootsuite and more.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">4.    We use tier link building approach in SEO. 1st tier links to money site, 2nd tier links to 1st tier links and so on. You know how it is.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">5.    Every project gets 2 hours worth of work every single day. No compromise here. We build at least 2-3 backlinks  per project every single day.</span></div>\n<div>\n	<span style=\"font-family:verdana;\">6.    We build links from sites with PA, DA &gt; 15. No low quality junk spam.</span></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">If you are interested and want to give it a shot, I would be happy to share our Methodologies, past work details and client Testimonials and Prices. </span></div>\n<div>\n	 </div>\n<div>\n	<strong><span style=\"font-family:verdana;\">let’s hop on a quick Skype call. I am sure you will love us (100% sure).Please reply to this email with you Skype or Phone number. </span></strong></div>\n<div>\n	 </div>\n<div>\n	<span style=\"font-family:verdana;\">Regards,</span></div>\n<div>\n	<span style=\"font-family:verdana;\">Billy</span></div>\n<div>\n	<span style=\"font-family:verdana;\">Business Development Executive</span></div>', 'closed', '0', '0', '1', '0', NULL, '1553299204', '1', '1', '0', 'Return-Path: <billyandersonmob@gmail.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id ts2KAa92lVySqQcAMoQ/pw\r\n	(envelope-from <billyandersonmob@gmail.com>)\r\n	for <info@apusseo.com>; Sat, 23 Mar 2019 01:58:39 +0200\r\nReturn-path: <billyandersonmob@gmail.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Sat, 23 Mar 2019 01:58:39 +0200\r\nReceived: from mail.broitmedia.com ([72.9.100.186]:54480)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-GCM-SHA384:256)\r\n	(Exim 4.91)\r\n	(envelope-from <billyandersonmob@gmail.com>)\r\n	id 1h7U3a-0026dG-Lg\r\n	for info@apusseo.com; Sat, 23 Mar 2019 01:58:38 +0200\r\nReceived: by mail.broitmedia.com (Postfix, from userid 500)\r\n	id 83136120EE57; Fri, 22 Mar 2019 20:43:18 +0530 (IST)\r\nDKIM-Filter: OpenDKIM Filter v2.11.0 mail.broitmedia.com 83136120EE57\r\nReceived: by mail.broitmedia.com for <info@apusseo.com>; Fri, 22 Mar 2019 15:13:16 GMT\r\nMessage-ID: <20190322182408-1.1.35.1uzqv.0.chd3bkg745@openemm.net>\r\nDate: Fri, 22 Mar 2019 15:13:16 GMT\r\nFrom: \"Billy Anderson\" <billyandersonmob@gmail.com>\r\nTo: <info@apusseo.com>\r\nSubject: Let\'s Work Together?\r\nX-Mailer: OpenEMM V2015_R3\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative;\r\n	boundary=\"-==AGNITASOUTER164240059B29000071==\"\r\n\r\n This is a multi-part message in MIME format.\r\n\r\n---==AGNITASOUTER164240059B29000071==\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHi,\r\n\r\nHave you thought about hiring an offshore help and then decided not to\r\ngo that path because of horror stories?\r\n\r\nIn last 3 months we have started working with 25 SEO agencies just like\r\nyours and they love our work. Which is why I have decided to approach\r\nmore because I believe that what my team can help you scale your\r\nbusiness just like we are helping others agencies like yours.\r\n\r\nQuick Note: we are 150+ team, running 300+ projects.\r\n\r\nHere is what I am offering:\r\n\r\n1.   15 day free trial on 3 seo  projects.\r\n2.    We use Basecamp to manage our projects. You will see project\r\nmanagement like never before.\r\n3.    We have paid access to tools like moz, Raventools, Semrush,\r\nAhrefs, Majestic, Serpbook, Hootsuite and more.\r\n4.    We use tier link building approach in SEO. 1st tier links to\r\nmoney site, 2nd tier links to 1st tier links and so on. You know how it\r\nis.\r\n5.    Every project gets 2 hours worth of work every single day. No\r\ncompromise here. We build at least 2-3 backlinks  per project every\r\nsingle day.\r\n6.    We build links from sites with PA, DA > 15. No low quality junk\r\nspam.\r\n\r\nIf you are interested and want to give it a shot, I would be happy to\r\nshare our Methodologies, past work details and client Testimonials and\r\nPrices.\r\n\r\nlet=E2=80=99s hop on a quick Skype call. I am sure you will love us (100%\r\nsure).Please reply to this email with you Skype or Phone number.\r\n\r\nRegards,\r\nBilly\r\nBusiness Development Executive\r\n\r\n\r\n---==AGNITASOUTER164240059B29000071==\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<img src=3D\"http://localhost:8080/g.html?uid=3D1.35.1uzqv.0.g8n4pkbgfi\" a=\r\nlt=3D\"\" border=3D\"0\" height=3D\"1\" width=3D\"1\"/><div>\r\n	<span style=3D\"font-family:verdana;\">Hi,</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<strong><span style=3D\"font-family:verdana;\">Have you thought about hiri=\r\nng an offshore help and then decided not to go that path because of horro=\r\nr stories?</span></strong></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">In last 3 months we have started wo=\r\nrking with 25 SEO agencies just like yours and they love our work. Which =\r\nis why I have decided to approach more because I believe that what my tea=\r\nm can help you scale your business just like we are helping others agenci=\r\nes like yours.</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Quick Note: we are 150+ team, runni=\r\nng 300+ projects.</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Here is what I am offering:</span><=\r\n/div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">1.&nbsp; <strong>&nbsp;15 day free =\r\ntrial on 3 seo&nbsp; projects.</strong></span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">2.&nbsp; &nbsp; We use Basecamp to =\r\nmanage our projects. You will see project management like never before.</=\r\nspan></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">3.&nbsp; &nbsp; We have paid access=\r\n to tools like moz, Raventools, Semrush, Ahrefs, Majestic, Serpbook, Hoot=\r\nsuite and more.</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">4.&nbsp; &nbsp; We use tier link bu=\r\nilding approach in SEO. 1st tier links to money site, 2nd tier links to 1=\r\nst tier links and so on. You know how it is.</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">5.&nbsp; &nbsp; Every project gets =\r\n2 hours worth of work every single day. No compromise here. We build at l=\r\neast 2-3 backlinks&nbsp; per project every single day.</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">6.&nbsp; &nbsp; We build links from=\r\n sites with PA, DA &gt; 15. No low quality junk spam.</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">If you are interested and want to g=\r\nive it a shot, I would be happy to share our Methodologies, past work det=\r\nails and client Testimonials and Prices.&nbsp;</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<strong><span style=3D\"font-family:verdana;\">let&rsquo;s hop on a quick =\r\nSkype call. I am sure you will love us (100% sure).Please reply to this e=\r\nmail with you Skype or Phone number.&nbsp;</span></strong></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Regards,</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Billy</span></div>\r\n<div>\r\n	<span style=3D\"font-family:verdana;\">Business Development Executive</spa=\r\nn></div>\r\n---==AGNITASOUTER164240059B29000071==--\r\n\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('9', 'manoj kumar <manojkumar123546@aol.com> - manojkumar123546@aol.com', '10008', '1', NULL, 'Develop website: wordpress, Joomla, corePHP, PHP, E-commerce, Magento', '<font size=\"2\" face=\"Helvetica Neue\">\n</font><div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:11pt;font-family:Calibri, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Hi there,</span><span lang=\"en-in\" style=\"font-size:11.5pt;font-family:Calibri, \'sans-serif\';color:#444444;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:11pt;font-family:Calibri, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">We are an India based web development agency\nwith primary focus on<span class=\"ecxapple-converted-space\"> </span><b>Web\nDevelopment, Mobile Application Development, Online Marketing Services (SEO,\nPPC, SMO, Reputation Management)<span class=\"ecxapple-converted-space\"> </span>and\nEcommerce solutions at an affordable cost.</b></span><span lang=\"en-in\" style=\"font-size:11.5pt;font-family:Calibri, \'sans-serif\';color:#444444;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:11pt;font-family:Calibri, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">We have expertise in Wordpress, Joomla,\nMagento, Virtuemart, Woocommerce, HTML 5, PHP, node js, Angular js, Drupal,\nZend, Prestashop, Shopify and smart phone apps.<span class=\"ecxapple-converted-space\"> </span></span><span lang=\"en-in\" style=\"font-size:11.5pt;font-family:Calibri, \'sans-serif\';color:#444444;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:11pt;font-family:Calibri, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Do let me know if you are willing to discuss a\npossible redesigning \\ redevelopment of your website or designing new website,\nmobile app or online marketing services, I can send you more details on the<span class=\"ecxapple-converted-space\"> </span><b>packages, action and past work\nreferences</b>.</span><span lang=\"en-in\" style=\"font-size:11.5pt;font-family:Calibri, \'sans-serif\';color:#444444;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:11pt;font-family:Calibri, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">I look forward to hearing from you soon.<span class=\"ecxapple-converted-space\"> </span></span><span lang=\"en-in\" style=\"font-size:11.5pt;font-family:Calibri, \'sans-serif\';color:#444444;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:11pt;font-family:Calibri, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Kind Regards</span><span lang=\"en-in\" style=\"font-size:11.5pt;font-family:Calibri, \'sans-serif\';color:#444444;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10.5pt;font-family:\'Segoe UI\', \'sans-serif\';color:#444444;background:#F3F3F3;\" xml:lang=\"en-in\">Manoj</span><span lang=\"en-in\" style=\"font-size:11.5pt;font-family:Calibri, \'sans-serif\';color:#444444;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:11pt;font-family:Calibri, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Business Development Manager</span><span lang=\"en-in\" style=\"font-size:11.5pt;font-family:Calibri, \'sans-serif\';color:#444444;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"MsoNormal\"><span lang=\"en-in\" xml:lang=\"en-in\"> </span></div>\n\n\n\n<div class=\"MsoNormal\"><span lang=\"en-in\" xml:lang=\"en-in\"> </span></div>\n', 'closed', '0', '0', '1', '0', NULL, '1554309602', '1', '1', '0', 'Return-Path: <manojkumar123546@aol.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id UJBLKdDgpFx+XTwAMoQ/pw\r\n	(envelope-from <manojkumar123546@aol.com>)\r\n	for <info@apusseo.com>; Wed, 03 Apr 2019 19:35:28 +0300\r\nReturn-path: <manojkumar123546@aol.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Wed, 03 Apr 2019 19:35:28 +0300\r\nReceived: from sonic312-48.consmr.mail.bf2.yahoo.com ([74.6.128.110]:35169)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <manojkumar123546@aol.com>)\r\n	id 1hBirI-00GbKk-Db\r\n	for info@apusseo.com; Wed, 03 Apr 2019 19:35:28 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=aol.com; s=a2048; t=1554309326; bh=j7QQPK3XlycfUVTEI31d8mlKX6Cc4iYla6F40v6fGCM=; h=Date:From:Subject:References:From:Subject; b=CpZvfhPHF/RXRUlmufZBcmGYUdxCjIlDe30L6zYOZOGAhyi9XC/3iAG1PBBXpaAPY5PHPhV/pRa1TWvyVSv0ek+2JB+zSl3mQMbg+gtFspyIDcOp/kDULeejhZ30BY1uI6pCuEMWW4WLDMNpl61eS3jlO3HSQZ3m+N7lc8gseONv6k33ccpIVHk7wlIZ9xV50YChpHRp03feXfraQNhTdpLi26GyBvtGgFqjBBQSOMvqvnP7f3r6NOUKTGo9pcza8HpCnkIh34Qg818RcrR5ndGFiM6+yvOpPJ/ql3tldE0NFWUGLryGEaXDXDC7icQwMosAEtO6ilH9apqdkKb5xw==\r\nX-YMail-OSG: bfxKY0AVM1n_rdNDL6vJo5xHuYEHbanPCiJcLeqCUjyLFFRXaB9br0OU13BuJiy\r\n QfSaRzDMv5eMqynXJsDcIY8PXGX0_Oe7bxV9Ik.VMiTNi7oE8GZJrfUbsKBLoDusOmeS94WSwtep\r\n gw2T4bQUaEyal5AJ1K0sgOPzVAcapr55TaDFpkD7qTQfl2oQkMY739zKRml_U5JACvyHoZqLd3iP\r\n tHMZQaqcwDPoghcxc2qHH70Z89vs3A4qDm5IHXMSkgG3IESBjnv_swjLRpSy6dVY75FywIykls3j\r\n u1gS_muRuDCjhUVi8cdtPyTl7hUpJCd9NtB05RdHcCZNvnlAEhP.pu3.Ds3PYnMglWfOYL39dSah\r\n 2tYzFL2yUrpWb4iFEiC2DzzG2iJFiNhUhLnHzY756CdUZ.RoAmNe5y.7gjdZYzKANT_wS2874_Mb\r\n XadmD8KCd1KCM1rdz0SUPSH2BkEg5puPusVmFNWwCXCKsEBrCX1_K9yLmiFXOgGKAxdBbKwH90d_\r\n hrQ_7QFdZidhqmqCUydV_Q0yqI.TiWQcnqNC6ZwXV_7PeTI4WHMq2hXFhewF6hVJQmOQtarf2Ljb\r\n U_bbxlfjS7R7gjXzxCdtlDwsX.IQK9e_XVm8ihowdw1pZLeFAW2Am0MAXZBk47ZXbTTQGWGyYEyU\r\n xtlKe44Wgy1Xflrc0tp7Gg6vCQ52DTIaj3DviJt1Dhk9qbjgZs8HG9EVsXrGvGE6fhy2N5itnFZf\r\n Cn23DDuafeEOSKFxiBoM0aS4a0QZR1Rextz.0Zsp47S6dwEb3kVO8HDzD0hnLbDJuonh.kxYFqsG\r\n _5a_ZgaNxLt2PNa1ZSycBjgQodjN1Tvo1Mz9PpKkOjmyzdfHib.dHktC3ibotwP0nPo4UON2IpKE\r\n eRRbjNe57UvHdBdGHrPbOQnfbAiegLaNmN26Xm3GYx9mkdgHowuph3Zbojw9HQ_ru46zndTKQvjQ\r\n UpRvIe5ql2oJUMG.UO90vqrB3MucpZ75jcijB2y7wJ1_01_HG0BIwAB7ax3cw7y4aae6guyjHl6X\r\n EwxJoPWrTpA99HHGezJOm6p.LZayalc8KKjj6UAqTzR0zWlgkT0__7DCgIyWAjKORXV70y.DSBGU\r\n 7sIvqru4YhWyuMCDSom3faP8P0rkqm_ncCv_E2WWC11VdYtA-\r\nReceived: from sonic.gate.mail.ne1.yahoo.com by sonic312.consmr.mail.bf2.yahoo.com with HTTP; Wed, 3 Apr 2019 16:35:26 +0000\r\nDate: Wed, 3 Apr 2019 16:33:25 +0000 (UTC)\r\nFrom: manoj kumar <manojkumar123546@aol.com>\r\nMessage-ID: <1180526128.15966299.1554309205397@mail.yahoo.com>\r\nSubject: Develop website: wordpress, Joomla, corePHP, PHP, E-commerce,\r\n Magento\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_15966298_313124272.1554309205395\"\r\nReferences: <1180526128.15966299.1554309205397.ref@mail.yahoo.com>\r\nX-Mailer: WebService/1.1.13212 aolwebmail Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36\r\nContent-Length: 6224\r\n\r\n ------=_Part_15966298_313124272.1554309205395\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHi there,\r\n\r\nWe are an India based web development agencywith primary focus on=C2=A0WebD=\r\nevelopment, Mobile Application Development, Online Marketing Services (SEO,=\r\nPPC, SMO, Reputation Management)=C2=A0andEcommerce solutions at an affordab=\r\nle cost.\r\n\r\nWe have expertise in Wordpress, Joomla,Magento, Virtuemart, Woocommerce, HT=\r\nML 5, PHP, node js, Angular js, Drupal,Zend, Prestashop, Shopify and smart =\r\nphone apps.=C2=A0\r\n\r\nDo let me know if you are willing to discuss apossible redesigning \\ redeve=\r\nlopment of your website or designing new website,mobile app or online marke=\r\nting services, I can send you more details on the=C2=A0packages, action and=\r\n past workreferences.\r\n\r\nI look forward to hearing from you soon.=C2=A0\r\n\r\nKind Regards\r\n\r\nManoj\r\n\r\nBusiness Development Manager\r\n\r\n=C2=A0=C2=A0\r\n------=_Part_15966298_313124272.1554309205395\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\n<font color=\'\' size=\'2\' face=\'Helvetica Neue\'>\r\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16.0pt;background:white\"><span lang=\"EN-IN\" style=\"font-size:11.0pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D\">Hi there,</span><span lang=\"EN-IN\" style=\"font-size:11.5pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#444444\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16.0pt;background:white\"><span lang=\"EN-IN\" style=\"font-size:11.0pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D\">We are an India based web development agency\r\nwith primary focus on<span class=\"ecxapple-converted-space\">&nbsp;</span><b>Web\r\nDevelopment, Mobile Application Development, Online Marketing Services (SEO,\r\nPPC, SMO, Reputation Management)<span class=\"ecxapple-converted-space\">&nbsp;</span>and\r\nEcommerce solutions at an affordable cost.</b></span><span lang=\"EN-IN\" style=\"font-size:11.5pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#444444\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16.0pt;background:white\"><span lang=\"EN-IN\" style=\"font-size:11.0pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D\">We have expertise in Wordpress, Joomla,\r\nMagento, Virtuemart, Woocommerce, HTML 5, PHP, node js, Angular js, Drupal,\r\nZend, Prestashop, Shopify and smart phone apps.<span class=\"ecxapple-converted-space\">&nbsp;</span></span><span lang=\"EN-IN\" style=\"font-size:11.5pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#444444\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16.0pt;background:white\"><span lang=\"EN-IN\" style=\"font-size:11.0pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D\">Do let me know if you are willing to discuss a\r\npossible redesigning \\ redevelopment of your website or designing new website,\r\nmobile app or online marketing services, I can send you more details on the<span class=\"ecxapple-converted-space\">&nbsp;</span><b>packages, action and past work\r\nreferences</b>.</span><span lang=\"EN-IN\" style=\"font-size:11.5pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#444444\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16.0pt;background:white\"><span lang=\"EN-IN\" style=\"font-size:11.0pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D\">I look forward to hearing from you soon.<span class=\"ecxapple-converted-space\">&nbsp;</span></span><span lang=\"EN-IN\" style=\"font-size:11.5pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#444444\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16.0pt;background:white\"><span lang=\"EN-IN\" style=\"font-size:11.0pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D\">Kind Regards</span><span lang=\"EN-IN\" style=\"font-size:11.5pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#444444\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16.0pt;background:white\"><span lang=\"EN-IN\" style=\"font-size:10.5pt;font-family:&quot;Segoe UI&quot;,&quot;sans-serif&quot;;color:#444444;background:#F3F3F3\">Manoj</span><span lang=\"EN-IN\" style=\"font-size:11.5pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#444444\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=\"ecxmsonormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:16.2pt;margin-left:0in;line-height:16.0pt;background:white\"><span lang=\"EN-IN\" style=\"font-size:11.0pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D\">Business Development Manager</span><span lang=\"EN-IN\" style=\"font-size:11.5pt;font-family:&quot;Calibri&quot;,&quot;sans-serif&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#444444\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=\"MsoNormal\"><span lang=\"EN-IN\">&nbsp;</span></div>\r\n\r\n\r\n\r\n<div class=\"MsoNormal\"><span lang=\"EN-IN\">&nbsp;</span></div>\r\n</font>\r\n------=_Part_15966298_313124272.1554309205395--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('10', 'Saniya Roy <saniyaroy.seoconsultent@gmail.com> - saniyaroy.seoconsultent@gmail.com', '10009', '1', NULL, 'Link Building Opportunity.', '<div dir=\"ltr\"><div dir=\"ltr\"><div>Hi,</div><div><br /></div><div>I\'m a Blogger outreach supplier.I have in my collection 5000+ good quality sites.</div><div><br /></div><div>For example:</div><div><br /></div><div><a href=\"http://www.educationviews.org/\">http://www.educationviews.org/</a> DA 54</div><div><a href=\"https://www.startupguys.net/\">https://www.startupguys.net/</a> DA 42</div><div><a href=\"https://wideinfo.org\">https://wideinfo.org</a><span style=\"white-space:pre;\">	</span> DA 42</div><div><a href=\"https://www.zero2turbo.com/\">https://www.zero2turbo.com/</a> DA 49</div><div><a href=\"https://www.bgfashion.net/\">https://www.bgfashion.net/</a> DA 49</div><div><a href=\"http://www.storeboard.com\">http://www.storeboard.com</a><span style=\"white-space:pre;\">	</span>DA 50</div><div><br /></div><div>Above sites are just few examples. I have many more sites with high page authority and domain authority.</div><div>Waiting for your response.</div><div><br /></div>-- <br /><div dir=\"ltr\" class=\"gmail_signature\"><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><b>Thanks!</b><div><font size=\"4\"><b>Saniya Roy</b></font></div><div><b style=\"color:rgb(38,50,56);font-family:Roboto, sans-serif;font-size:13px;\">Professional Blogger and Outreach supplier</b><font size=\"4\"><b><br /></b></font></div><div><b>Web : <a href=\"https://qualitylinkbuilders.com\">https://qualitylinkbuilders.com</a></b></div></div></div></div></div></div></div></div></div></div></div>\n', 'closed', '0', '0', '1', '0', NULL, '1554359404', '1', '1', '0', 'Return-Path: <saniyaroy.seoconsultent@gmail.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id /f/mGBakpVxE1QUAMoQ/pw\r\n	(envelope-from <saniyaroy.seoconsultent@gmail.com>)\r\n	for <info@apusseo.com>; Thu, 04 Apr 2019 09:28:38 +0300\r\nReturn-path: <saniyaroy.seoconsultent@gmail.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Thu, 04 Apr 2019 09:28:38 +0300\r\nReceived: from mail-lj1-f193.google.com ([209.85.208.193]:42738)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <saniyaroy.seoconsultent@gmail.com>)\r\n	id 1hBvra-001bRT-8g\r\n	for info@apusseo.com; Thu, 04 Apr 2019 09:28:38 +0300\r\nReceived: by mail-lj1-f193.google.com with SMTP id v22so990861lje.9\r\n        for <info@apusseo.com>; Wed, 03 Apr 2019 23:28:38 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=20161025;\r\n        h=mime-version:from:date:message-id:subject:to;\r\n        bh=Yc70mjc2DLBVU9tj+FZ/YVAy5shsV2M7YqD0WyN4p/M=;\r\n        b=SqMuSodjhbCePtsdgvCkq6wOO+eDiAhjj0Ry8YwISaf5rtS6iShkCCeCgAuTYnAtYx\r\n         3uNJcIkYzkDG5mPDrD8pVBY0sHKyB16HYZ2RglEAGBHOZzKksKKHiCvCOfIZfqRWSqqO\r\n         E/VdFQnNOA/8JyE5zclZNPp6/M1cJNQf1j8+ABKxJQKWiOHMvgh0SStth2Ki2KRJbsN+\r\n         jLk1JJk5uXCHYfr8H5KMSOfzxyViOQh5cdDhmC8sstS9XZxrzqMljmPxj6rpWte2U709\r\n         pZXA7T0o7HwBnOBP55YJBDuCbodysGtEiWV/mdq9Q6j9hb31uRQHL6jXujeTmrbKzi3S\r\n         Lvww==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:mime-version:from:date:message-id:subject:to;\r\n        bh=Yc70mjc2DLBVU9tj+FZ/YVAy5shsV2M7YqD0WyN4p/M=;\r\n        b=AjD97dRarX+fx+13aO/q5s5Whz5HnTTwXT/kUp7vPXXTAAaHsNUfoI8nMlAlmN9ioa\r\n         MqJ9OacFbJ6zbyLYQzXxkBr4lVZGW+R/kZb6gpRbKd/K+xfD/UXcyPJ1TTor3FiUsE5P\r\n         WJbTG+RIWnfsKrb8sbMCoZczMsaav9Nt+C1L8RJaKEuqXXzjvn+ZvWxdN/nAMj8m2eE9\r\n         W9gX+52pHUeV7Jxv9jRq2bsiEzxrKwVP4qjCjAadk3pzgAuALLqE7+c8xd8calnLgoM4\r\n         8M3nF79NpVqSFW2+qV7nPJGOGB6SlM+Hs2vIZ/rU6WqC9jF5lqY65axM1vRcvPD8weRN\r\n         SZ2Q==\r\nX-Gm-Message-State: APjAAAVYMtlTUp2qXPuSRlWTYR1ewAIOrx5rjpbGAnzLQmyoSBpEwT6q\r\n	7CpmDA3KNWOyZ+8azp1PTsztitcAqcjITwfqmKt0IxDD\r\nX-Google-Smtp-Source: APXvYqw1SOzEBA+V3qoYeGbhMMxaC4RUNEcC1TUNcOi31NfjjmSMQNwqlGKOJ2/4KyfHdQjN4CCEvUThYkB/2uLrhwU=\r\nX-Received: by 2002:a2e:978c:: with SMTP id y12mr2235629lji.70.1554359317897;\r\n Wed, 03 Apr 2019 23:28:37 -0700 (PDT)\r\nMIME-Version: 1.0\r\nFrom: Saniya Roy <saniyaroy.seoconsultent@gmail.com>\r\nDate: Thu, 4 Apr 2019 11:58:23 +0530\r\nMessage-ID: <CAH-i_=RptmPEJh=f8ov2MYCU-nQNFXJ6MhWTu3HpiEYoOkUv5A@mail.gmail.com>\r\nSubject: Link Building Opportunity.\r\nTo: info@apusseo.com\r\nContent-Type: multipart/alternative; boundary=\"000000000000ff27cb0585ae7a65\"\r\n\r\n --000000000000ff27cb0585ae7a65\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\n\r\nHi,\r\n\r\nI\'m a Blogger outreach supplier.I have in my collection 5000+ good quality\r\nsites.\r\n\r\nFor example:\r\n\r\nhttp://www.educationviews.org/ DA 54\r\nhttps://www.startupguys.net/ DA 42\r\nhttps://wideinfo.org DA 42\r\nhttps://www.zero2turbo.com/ DA 49\r\nhttps://www.bgfashion.net/ DA 49\r\nhttp://www.storeboard.com DA 50\r\n\r\nAbove sites are just few examples. I have many more sites with high page\r\nauthority and domain authority.\r\nWaiting for your response.\r\n\r\n-- \r\n*Thanks!*\r\n*Saniya Roy*\r\n*Professional Blogger and Outreach supplier*\r\n*Web : https://qualitylinkbuilders.com <https://qualitylinkbuilders.com>*\r\n\r\n--000000000000ff27cb0585ae7a65\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<div dir=3D\"ltr\"><div dir=3D\"ltr\"><div>Hi,</div><div><br></div><div>I&#39;m=\r\n a Blogger outreach supplier.I have in my collection 5000+ good quality sit=\r\nes.</div><div><br></div><div>For example:</div><div><br></div><div><a href=\r\n=3D\"http://www.educationviews.org/\">http://www.educationviews.org/</a> DA 5=\r\n4</div><div><a href=3D\"https://www.startupguys.net/\">https://www.startupguy=\r\ns.net/</a> DA 42</div><div><a href=3D\"https://wideinfo.org\">https://wideinf=\r\no.org</a><span style=3D\"white-space:pre\">	</span> DA 42</div><div><a href=\r\n=3D\"https://www.zero2turbo.com/\">https://www.zero2turbo.com/</a> DA 49</div=\r\n><div><a href=3D\"https://www.bgfashion.net/\">https://www.bgfashion.net/</a>=\r\n DA 49</div><div><a href=3D\"http://www.storeboard.com\">http://www.storeboar=\r\nd.com</a><span style=3D\"white-space:pre\">	</span>DA 50</div><div><br></div>=\r\n<div>Above sites are just few examples. I have many more sites with high pa=\r\nge authority and domain authority.</div><div>Waiting for your response.</di=\r\nv><div><br></div>-- <br><div dir=3D\"ltr\" class=3D\"gmail_signature\"><div dir=\r\n=3D\"ltr\"><div><div dir=3D\"ltr\"><div><div dir=3D\"ltr\"><div><div dir=3D\"ltr\">=\r\n<b>Thanks!</b><div><font size=3D\"4\"><b>Saniya Roy</b></font></div><div><b s=\r\ntyle=3D\"outline:none;color:rgb(38,50,56);font-family:Roboto,sans-serif;font=\r\n-size:13px\">Professional Blogger and Outreach supplier</b><font size=3D\"4\">=\r\n<b><br></b></font></div><div><b>Web :=C2=A0<a href=3D\"https://qualitylinkbu=\r\nilders.com\" target=3D\"_blank\">https://qualitylinkbuilders.com</a></b></div>=\r\n</div></div></div></div></div></div></div></div></div></div>\r\n\r\n--000000000000ff27cb0585ae7a65--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('11', 'Ravi Sharma <ravi.web0034@aol.com> - ravi.web0034@aol.com', '10010', '1', NULL, 'Seo Packages', '<font size=\"2\" face=\"Helvetica Neue\">\n</font><div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><b><span style=\"font-size:12pt;color:#222222;\">Hi</span></b><p><b></b></p><b></b></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><sub><span style=\"font-size:18pt;\">It was not ranking\non any of the search engines (Google Yahoo and Bing) for most of the keywords\nrelating to your business.</span></sub><b><span style=\"font-size:12pt;color:#222222;\"></span></b><p><b></b></p><b></b></div>\n\n\n\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18pt;\">I am affiliated with\nan SEO company helped over 200 businesses rank on the 1st Page of GOOGLE for\neven the most competitive Industries.</span></sub><p></p></div>\n\n\n\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18pt;\">Let me know if you\nare interested and I will send you our company details or create a proposal so\nyou can see exactly where you rank compared to your competitors.</span></sub><p></p></div>\n\n\n\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18pt;\">I look forward to\nyour mail.</span></sub><p></p></div>\n\n\n\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18pt;\">Kind Regards</span></sub><p></p></div>\n\n\n\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18pt;\">Business Development\nExecutive Hello &amp; Good</span></sub><p></p></div>\n\n\n\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18pt;\">Ravi Sharma</span></sub><p></p></div>\n\n\n\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18pt;\">Business Development\nManager</span></sub><p></p></div>\n', 'closed', '0', '0', '1', '0', NULL, '1555075503', '1', '1', '0', 'Return-Path: <ravi.web0034@aol.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id YFC/HISRsFzC3gAAMoQ/pw\r\n	(envelope-from <ravi.web0034@aol.com>)\r\n	for <info@apusseo.com>; Fri, 12 Apr 2019 16:24:20 +0300\r\nReturn-path: <ravi.web0034@aol.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Fri, 12 Apr 2019 16:24:20 +0300\r\nReceived: from sonic311-13.consmr.mail.bf2.yahoo.com ([74.6.131.123]:45710)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <ravi.web0034@aol.com>)\r\n	id 1hEwAG-000EqM-85\r\n	for info@apusseo.com; Fri, 12 Apr 2019 16:24:20 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=aol.com; s=a2048; t=1555075458; bh=MhllWMV9fe7eJMz+iwPZlTvA3jI+9dyCsJc4XBIDCgM=; h=Date:From:Subject:References:From:Subject; b=YKYjLe4kK1QzSaHxQNd0tMI78DT2sPkfekk806caMfZK5/OOd/wYedcXPG6ulwSKpj0Qt+mI9zrw0GuJ2jH5RhrDNn41fG3mQZNBV5dr45tGuV3U/nZQ/1woGHcq7EBagVcLdeg7YU842FktRo2ua7zqpQ44NBvZ6XWLiO+2pl7Sg2LtvkXzrgo+pIkQIWP1d5qWudSiSCjrOT2zOtbbTWRRED1K8e+rDgkL2vFylIizsSZO7xkXzMFBLYmnqJGKNEE10g6sn33Jl3dpQ1a3GxgQjq1ZvNRxaREZS4m8OF9svH307+41UwSlcwrZLsbPgGbs6VsuFd2IWHSg8grufQ==\r\nX-YMail-OSG: NdymLxIVM1mnmbp8equR..d9_tQp3zgwfmSYAoSbsrgcjW3q90lRUYkeBrKT96C\r\n n2U2SUvW3ZM.f5SQki3lR__0MQ22N2zvwn8Fi7MHIEndmvvqy5ArDs0jrxBdlp3iHHjiKbs19ybL\r\n MFtgxQh0mm8bxo5U5_990omv1_CWDlBWRDCmbB9_ju2bNEW0Z9YWuk5NZHjywXpDbmrKX6ZUqrzp\r\n Bn70StbsCqjn_MypHccim8ouHKwn2THNEQI73CknS.Wyf2lxW_LnxX1_4Tav02JBTJ2Y57dWEaoz\r\n 02bli9QsEtm8ocQXIqRP.xevhvtfxR_x7d1JTJmV4xWlBfTQRULA8ZPJEl7t75Ok29k6AobejTaJ\r\n NfsbXw.CLUqGIOOHLDr2yXqWOfFX0mc1mfIK0gB6veOecH6Yb32pcG5h3rKsgDU2k3_M0w5Ayde1\r\n 7o36ueEhAGhJNz6W_o0mUKk.n4ApDA0t0Lxqj7XgtZEw2V9Ydalgu6hT0MRDz96y0kL5xtkwsA9w\r\n 1pM1bsE8ZRc74mJud_.lvls5lVW649V5WQF8X9u8p2a1VyQcUlCrz5nJXxh_323QHpCBW3FgSTCp\r\n L7V10tJpBXvnyHQXitUHb9OVIuq_LfvRmAyJbow3pEH_C8qs_KpYoLRXkGwgUbzT5Zxlxsjp.b2Z\r\n pp_wa8FejMi0BxKMkSXJaRxo4rwtl9FCDamBwZEhmvuytwHkvJDdrcSVF4Ko5CvaUQPiRhIxJvvh\r\n CQULeN5JSlcocJ6XDBxBDj7AqlyyalqQN9TLNx7JGTP7eJIblhVdDS.M5EH9UF4ucBqrUwmgzQya\r\n u5WH4FNXof3hi5AzqYJa247RMO1r8WjKQ6vhal5qId8PQzvjbpRP5CwCHg6KmfuwP_rbrsv48C4G\r\n 5DtobA9DNTFp0T.ntqesn29IIhk5f_QsIsWphnBhdRj6QAR220Ydll7WDeKhVDR6G2Suobei4rb6\r\n J1n8esnlpJoKgVIHIgHBSXqMBaXbxOdIonlQsfyv0r6cgO5G89pRG0TZx63dRfmgQuiVsnXHTzu6\r\n QkPaofsOnctjyjVKI8RODwPcvpJAscmIaRdvh9asGjA.SaKcvLDo-\r\nReceived: from sonic.gate.mail.ne1.yahoo.com by sonic311.consmr.mail.bf2.yahoo.com with HTTP; Fri, 12 Apr 2019 13:24:18 +0000\r\nDate: Fri, 12 Apr 2019 13:24:17 +0000 (UTC)\r\nFrom: Ravi Sharma <ravi.web0034@aol.com>\r\nMessage-ID: <1037515829.2559328.1555075457731@mail.yahoo.com>\r\nSubject:  Seo Packages\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_2559327_1157694862.1555075457729\"\r\nReferences: <1037515829.2559328.1555075457731.ref@mail.yahoo.com>\r\nX-Mailer: WebService/1.1.13212 aolwebmail Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36\r\nContent-Length: 2760\r\n\r\n ------=_Part_2559327_1157694862.1555075457729\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\nHi\r\n\r\nIt was not rankingon any of the search engines (Google Yahoo and Bing) for most of the keywordsrelating to your business.\r\n\r\nI am affiliated withan SEO company helped over 200 businesses rank on the 1st Page of GOOGLE foreven the most competitive Industries.\r\n\r\nLet me know if youare interested and I will send you our company details or create a proposal soyou can see exactly where you rank compared to your competitors.\r\n\r\nI look forward toyour mail.\r\n\r\nKind Regards\r\n\r\nBusiness DevelopmentExecutive Hello & Good\r\n\r\nRavi Sharma\r\n\r\nBusiness DevelopmentManager\r\n\r\n\r\n------=_Part_2559327_1157694862.1555075457729\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\n<font color=\'\' size=\'2\' face=\'Helvetica Neue\'>\r\n<div class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal;background:white\"><b><span style=\"font-size:12.0pt;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;color:#222222\">Hi<o:p></o:p></span></b></div>\r\n\r\n\r\n\r\n<div class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;line-height:normal;background:white\"><sub><span style=\"font-size:18.0pt\">It was not ranking\r\non any of the search engines (Google Yahoo and Bing) for most of the keywords\r\nrelating to your business.</span></sub><b><span style=\"font-size:12.0pt;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Calibri;mso-bidi-theme-font:minor-latin;color:#222222\"><o:p></o:p></span></b></div>\r\n\r\n\r\n\r\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18.0pt\">I am affiliated with\r\nan SEO company helped over 200 businesses rank on the 1st Page of GOOGLE for\r\neven the most competitive Industries.<o:p></o:p></span></sub></div>\r\n\r\n\r\n\r\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18.0pt\">Let me know if you\r\nare interested and I will send you our company details or create a proposal so\r\nyou can see exactly where you rank compared to your competitors.<o:p></o:p></span></sub></div>\r\n\r\n\r\n\r\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18.0pt\">I look forward to\r\nyour mail.<o:p></o:p></span></sub></div>\r\n\r\n\r\n\r\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18.0pt\">Kind Regards<o:p></o:p></span></sub></div>\r\n\r\n\r\n\r\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18.0pt\">Business Development\r\nExecutive Hello &amp; Good<o:p></o:p></span></sub></div>\r\n\r\n\r\n\r\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18.0pt\">Ravi Sharma<o:p></o:p></span></sub></div>\r\n\r\n\r\n\r\n<div class=\"MsoNoSpacing\"><sub><span style=\"font-size:18.0pt\">Business Development\r\nManager<o:p></o:p></span></sub></div>\r\n</font>\r\n------=_Part_2559327_1157694862.1555075457729--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('12', 'Kristina Parker <kristina@dapperitmedia.com> - kristina@dapperitmedia.com', '10011', '1', NULL, 'SEO | SMO | SMM | PPC Outsourcing !!', '<img src=\"http://localhost:8080/g.html?uid=1.26.fla5.0.fjbmkyfrs1\" alt=\"\" border=\"0\" height=\"1\" width=\"1\" /><span style=\"font-family:verdana;\">Greetings,<br />\n <br />\n<strong>Have you thought about hiring an offshore help and then decided not to go that path because of horror stories?</strong><br />\n <br />\nIn last 3 months we have started working with 30 Digital Marketing agencies and they love our work. Which is why I have decided to approach more because I believe that what my team can help you scale your business just like we are helping others? We handle SEO, SMO, PPC, Facebook advertising, Twitter and LinkedIn marketing, content marketing, brand reputation management.<br />\n <br />\nOur All Services: SEO | PPC | SMO | SMM | Website and Mobile App Design &amp; Development.<br />\n <br />\n<strong>Quick Note: we are 150+ team, running 300+ projects. Here is what I am offering:</strong><br />\n <br />\n1.    <strong>15 day free trial on 3 SEO projects</strong>.<br />\n2.    We use Basecamp to manage our projects. You will see project management like never before.<br />\n3.    We have paid access to tools like moz, Raventools, Semrush, Ahrefs, Majestic, Serpbook, Hootsuite and more.<br />\n4.    We use tier link building approach in SEO. 1st tier links to money site, 2nd tier links to 1st tier links and so on. You know how it is.<br />\n5.    Every project gets 2 hours’ worth of work every single day. No compromise here. We build at least 2-3 backlinks per project every single day.<br />\n6.    We build links from sites with PA, DA &gt; 15. No low quality junk spam.<br />\n7.    Free Audit Report: We analyze and send you a free audit report of websites; these reports point out all the weak areas to be focused on.<br />\n <br />\n<strong>Let’s hop on a quick Skype call. I am sure you will love us (100% sure).Please reply to this email with you Skype or Phone number. </strong><br />\n <br />\n<strong>If you are interested, then I can send you our past work details, company information, affordable quotation with best offer. You can get more information.</strong><br />\n <br />\n<strong>Best Regards,</strong><br />\nKristina Parker<br />\nBusiness Development Executive<br />\n </span><br />', 'closed', '0', '0', '1', '0', NULL, '1555155302', '1', '1', '0', 'Return-Path: <kristina@dapperitmedia.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id KLeMKlDIsVxV9ggAMoQ/pw\r\n	(envelope-from <kristina@dapperitmedia.com>)\r\n	for <info@apusseo.com>; Sat, 13 Apr 2019 14:30:24 +0300\r\nReturn-path: <kristina@dapperitmedia.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Sat, 13 Apr 2019 14:30:24 +0300\r\nReceived: from mail.dapperitmedia.com ([151.106.28.75]:36118)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-GCM-SHA384:256)\r\n	(Exim 4.91)\r\n	(envelope-from <kristina@dapperitmedia.com>)\r\n	id 1hFGrY-002SxB-H6\r\n	for info@apusseo.com; Sat, 13 Apr 2019 14:30:24 +0300\r\nReceived: by mail.dapperitmedia.com (Postfix, from userid 500)\r\n	id 74138A7F0; Sat, 13 Apr 2019 16:52:06 +0530 (IST)\r\nDKIM-Filter: OpenDKIM Filter v2.11.0 mail.dapperitmedia.com 74138A7F0\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=dapperitmedia.com;\r\n	s=default; t=1555154877;\r\n	bh=yyi3Ri72I2OG4r93ne/09J1p/CXahjR02Jwj85Gq8JM=;\r\n	h=Date:From:To:Subject:From;\r\n	b=i5WC3HCge/rl0lHelgrmFwfbPLyfKGu39Ver5qXp7mKsgs6a3Jq3EMqm/QCwgSV/2\r\n	 736SUxCVcKG/ICh7onzanDIPn0F2v/PT0CcwmOV1zy4BSSd3pNXqt7hq3FFKyXPkN4\r\n	 jZp50rC7GYDM4MLTESKZfFCZ54WjO0qw31fYKCvI=\r\nReceived: by mail.dapperitmedia.com for <info@apusseo.com>; Sat, 13 Apr 2019 11:21:36 GMT\r\nMessage-ID: <20190413164055-1.1.26.fla5.0.aqycj8qmon@openemm.net>\r\nDate: Sat, 13 Apr 2019 11:21:36 GMT\r\nFrom: \"Kristina Parker\" <kristina@dapperitmedia.com>\r\nTo: <info@apusseo.com>\r\nSubject: SEO | SMO | SMM | PPC  Outsourcing !!\r\nX-Mailer: OpenEMM V2015_R3\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative;\r\n	boundary=\"-==AGNITASOUTER164240059B2900004E==\"\r\n\r\n This is a multi-part message in MIME format.\r\n\r\n---==AGNITASOUTER164240059B2900004E==\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nGreetings,\r\n\r\nHave you thought about hiring an offshore help and then decided not to\r\ngo that path because of horror stories?\r\n\r\nIn last 3 months we have started working with 30 Digital Marketing\r\nagencies and they love our work. Which is why I have decided to\r\napproach more because I believe that what my team can help you scale\r\nyour business just like we are helping others? We handle SEO, SMO, PPC,\r\nFacebook advertising, Twitter and LinkedIn marketing, content\r\nmarketing, brand reputation management.\r\n\r\nOur All Services: SEO | PPC | SMO | SMM | Website and Mobile App Design\r\n& Development.\r\n\r\nQuick Note: we are 150+ team, running 300+ projects. Here is what I am\r\noffering:\r\n\r\n1.    15 day free trial on 3 SEO projects.\r\n2.    We use Basecamp to manage our projects. You will see project\r\nmanagement like never before.\r\n3.    We have paid access to tools like moz, Raventools, Semrush,\r\nAhrefs, Majestic, Serpbook, Hootsuite and more.\r\n4.    We use tier link building approach in SEO. 1st tier links to\r\nmoney site, 2nd tier links to 1st tier links and so on. You know how it\r\nis.\r\n5.    Every project gets 2 hours=E2=80=99 worth of work every single day.=\r\n No\r\ncompromise here. We build at least 2-3 backlinks per project every\r\nsingle day.\r\n6.    We build links from sites with PA, DA > 15. No low quality junk\r\nspam.\r\n7.    Free Audit Report: We analyze and send you a free audit report of\r\nwebsites; these reports point out all the weak areas to be focused on.\r\n\r\nLet=E2=80=99s hop on a quick Skype call. I am sure you will love us (100%\r\nsure).Please reply to this email with you Skype or Phone number.\r\n\r\nIf you are interested, then I can send you our past work details,\r\ncompany information, affordable quotation with best offer. You can get\r\nmore information.\r\n\r\nBest Regards,\r\nKristina Parker\r\nBusiness Development Executive\r\n\r\n---==AGNITASOUTER164240059B2900004E==\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<img src=3D\"http://localhost:8080/g.html?uid=3D1.26.fla5.0.fjbmkyfrs1\" al=\r\nt=3D\"\" border=3D\"0\" height=3D\"1\" width=3D\"1\"/><span style=3D\"font-family:=\r\nverdana;\">Greetings,<br />\r\n&nbsp;<br />\r\n<strong>Have you thought about hiring an offshore help and then decided n=\r\not to go that path because of horror stories?</strong><br />\r\n&nbsp;<br />\r\nIn last 3 months we have started working with 30 Digital Marketing agenci=\r\nes and they love our work. Which is why I have decided to approach more b=\r\necause I believe that what my team can help you scale your business just =\r\nlike we are helping others? We handle SEO, SMO, PPC, Facebook advertising=\r\n, Twitter and LinkedIn marketing, content marketing, brand reputation man=\r\nagement.<br />\r\n&nbsp;<br />\r\nOur All Services: SEO | PPC | SMO | SMM | Website and Mobile App Design &=\r\namp; Development.<br />\r\n&nbsp;<br />\r\n<strong>Quick Note: we are 150+ team, running 300+ projects. Here is what=\r\n I am offering:</strong><br />\r\n&nbsp;<br />\r\n1.&nbsp;&nbsp;&nbsp; <strong>15 day free trial on 3 SEO projects</strong>=\r\n=2E<br />\r\n2.&nbsp;&nbsp;&nbsp;&nbsp;We use Basecamp to manage our projects. You wil=\r\nl see project management like never before.<br />\r\n3.&nbsp;&nbsp;&nbsp;&nbsp;We have paid access to tools like moz, Raventoo=\r\nls, Semrush, Ahrefs, Majestic, Serpbook, Hootsuite and more.<br />\r\n4.&nbsp;&nbsp;&nbsp;&nbsp;We use tier link building approach in SEO. 1st =\r\ntier links to money site, 2nd tier links to 1st tier links and so on. You=\r\n know how it is.<br />\r\n5.&nbsp;&nbsp;&nbsp;&nbsp;Every project gets 2 hours&rsquo; worth of work=\r\n every single day. No compromise here. We build at least 2-3 backlinks&nb=\r\nsp;per project every single day.<br />\r\n6.&nbsp;&nbsp;&nbsp;&nbsp;We build links from sites with PA, DA &gt; 15. =\r\nNo low quality junk spam.<br />\r\n7.&nbsp;&nbsp;&nbsp; Free Audit Report: We analyze and send you a free au=\r\ndit report of websites; these reports point out all the weak areas to be =\r\nfocused on.<br />\r\n&nbsp;<br />\r\n<strong>Let&rsquo;s hop on a quick Skype call. I am sure you will love us=\r\n (100% sure).Please reply to this email with you Skype or Phone number.&n=\r\nbsp;</strong><br />\r\n&nbsp;<br />\r\n<strong>If you are interested, then I can send you our past work details,=\r\n company information, affordable quotation with best offer. You can get m=\r\nore information.</strong><br />\r\n&nbsp;<br />\r\n<strong>Best Regards,</strong><br />\r\nKristina Parker<br />\r\nBusiness Development Executive<br />\r\n&nbsp;</span><br />\r\n---==AGNITASOUTER164240059B2900004E==--\r\n\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('13', 'Manoj Kumar <websitedesign546954@yahoo.com> - websitedesign546954@yahoo.com', '10012', '1', NULL, 'Customized CMS Websites Designed and Developed', '<div class=\"yahoo-style-wrap\" style=\"font-family:\'Helvetica Neue\', Helvetica, Arial, sans-serif;font-size:16px;\"><div><div><p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span lang=\"en-in\" style=\"font-size:11.5pt;color:#0070C0;\" xml:lang=\"en-in\">Hi,</span></b></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span lang=\"en-in\" style=\"font-size:11.5pt;color:#0070C0;\" xml:lang=\"en-in\">Very Good Morning!</span></b></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">Would you be interested in a possible redesigning of\nthe site or addition feature that might benefit the overall usability and user\nexperience which usually leads to better sales.</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">We are an Indian Web Design and Development firm with\nover 8 years of experience. In these tough times, where it is hard to maintain\nthe top line, we can help share the bottom-line for you.</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">We will be happy to help execute Web Design and\nDevelopment projects at a much lower cost than what you have in house - No\ncompromise on quality!</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span lang=\"en-in\" style=\"font-size:11.5pt;color:#0070C0;\" xml:lang=\"en-in\">We are at present partnering with over 45 firms from\nUK, US, Australia, Canada.</span></b></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span lang=\"en-in\" style=\"font-size:11.5pt;color:#0070C0;\" xml:lang=\"en-in\">Our primary focus is: - </span></b></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">1. Website Designing</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">2. PHP Development in CMS (WordPress, Joomla, Magneto,\nDrupal)</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">3. Database programming</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">4. Flash Design</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">5. Graphic Designs</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">6. Ecommerce Solutions</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">Do let me know if you are interested and I would be\nhappy to share our Methodologies, past work details and client testimonials</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">I look forward to your mail.</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#444444;\" xml:lang=\"en-in\">Kind Regards</span></p>\n\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:.0001pt;\"><span lang=\"en-in\" style=\"font-size:10.5pt;color:#444444;background:#F3F3F3;\" xml:lang=\"en-in\">Manoj</span></p>\n\n<p class=\"ydp6165a082MsoNormal\"> </p></div><br /></div></div>', 'closed', '0', '0', '1', '0', NULL, '1557234604', '1', '1', '0', 'Return-Path: <websitedesign546954@yahoo.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id cCR2J36D0VzGbgEAMoQ/pw\r\n	(envelope-from <websitedesign546954@yahoo.com>)\r\n	for <info@apusseo.com>; Tue, 07 May 2019 16:09:18 +0300\r\nReturn-path: <websitedesign546954@yahoo.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Tue, 07 May 2019 16:09:18 +0300\r\nReceived: from sonic306-47.consmr.mail.sg3.yahoo.com ([106.10.241.167]:35961)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <websitedesign546954@yahoo.com>)\r\n	id 1hNzqQ-000OVC-As\r\n	for info@apusseo.com; Tue, 07 May 2019 16:09:18 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=yahoo.com; s=s2048; t=1557234555; bh=S+aXKtnUX8mbGVkJZdBURDLdwyjrO1EK3H9A6RaWJRU=; h=Date:From:Subject:References:From:Subject; b=nku9PHt9ZiaIWviVbg/8/GxH7D2XJO0MwcLXYMl64UXN47PwDsAGF4YmnhAxYbtwVZFWJJc3mpLOMcIVvE+wwMdkWi6UMLQrEgYjkBifNHztS4W5SaiCm7xR62uhtnz19Q2fGCcAmK7kzwKVcb8QsoOx4NdAjqYBWSad3djIUUSGFbJPgWsTc7GSiQ+bIovNa71BM1hIViZPmYLduXx5IOGDajvixpUVGXX/lqYyPr491o2WWvrOFNG4SsWY9pd/plj2AUUffXt/Bg4+he8RC2f5eijv2za0I/Ulpgj+2eWFaliGryd4bg0JbhxlrEfKsTXlxyEWOCb8kKbaLBRd9g==\r\nX-YMail-OSG: t9c_v6gVM1mnN6ElqD9Wn_2qbX2J2HlegAWIfBQC_IF8IvxTQhzq9ntJNz0JrOY\r\n RWiDDE_LPHRPkDBaw78U7lny2wmQyNZOXR91ZdH.utoS5Bl56EBoZpnBfvROjNd4npN2PkNAByNf\r\n UowHq_XIwQGYNnR7RIPQqEazBiUiC1gVQ.lRfZ3uLYt07H5jxapxkPr124Hr7scB.FFlkqtwfAfU\r\n tN8ABnbhhspeo53.0D3apo4Tf7ZwDN7q2cYMh5JYwFkmvKgZovmf65rbJLWmrXHdrnm9tQ11ntdd\r\n xGr1LuI.oIgJBNG4aIj9sF.F2O1Me96nTKo5JTIiFeJI22_ZzALytLNgQWMtCma7OUy7362OplQy\r\n n2K3UeR1CiFKF7nYWqQKLRYJ3o8JdYks8oS9d5uP4pTcEmNGtcTAfOqseaTjY3gwbXiprtAhDApS\r\n aPQMDBrRKE56OoO7_tu.TAW2No0BVWbiUelJ2wmFpDVJufLfp7_6MbWNWGcvkgHHNKHGm_WNr8Nj\r\n H8ODeZ7KD5sTwQcrSBcz2RJ4bILndMiQ_C1b.ROl0YkH.sia9yzZBjj2YtLikFz_qcja_cNxXAXS\r\n MGHNTgndQ1Lb.V3TUcHNRHCFRPJGjf_ELkJ_r_u31CHeXlRxan9AVr1QxvZz1E5Zr_S0e4DApX9y\r\n wy_kbD4wRsjAtcF.ipbbI7_HjlwFvhheL5mC9cpUKiWXlHBDwsoO67MgSYA0FphtcRnw5WpccvLA\r\n 7ztu.UFzi1pjUsE3HNPZPxbEKEVCg8A5OG9qYxjiZ.kWs1WApV6XAbPNNRhAKBeMg6ulVhkFG0zn\r\n wdaGdIWNc3lPNBr1TWDfZs8MhqG16E4mLcHWY3Zpbgedmfn81NwH0CagMrHTkbxKZynGd3aV.BZ3\r\n 0Ytl43Qr6yiiZcgRprvX_peYMXslOSmp0tsNzzz5wSVLqD_mcX_aqiBJaewKuAJ7bHQaW3E4Q1h8\r\n ZlMh5Zg_4FlegBlPMcIseMwi2U_Cda6O.zTdTD0uFCHi3KrbD3yhIMzLihQY3OYNaTGw7asqXLwV\r\n 3.PiHxxkgsNoDPcWOsqi7WorkuKcq2ss2XlZgOAy39Cn.g8kW5cw5ee_9y5WcqB1Btx6kr.cj36_\r\n nM5XljUVXOJV3s2_f0oUVVRGrvcuLaH2mhVwSU64fXLwXaaBnn5TocqVa1bTu3s9EZTmKFIks3KG\r\n XN8qI9U_Scx4sQSipl4E4SoyJSxWTc2um4f2I3GDXcU0mCCtfjuk2nvmx2tmbooa8X11eBwE2OMh\r\n og53bxHEMGC7uhO0X\r\nReceived: from sonic.gate.mail.ne1.yahoo.com by sonic306.consmr.mail.sg3.yahoo.com with HTTP; Tue, 7 May 2019 13:09:15 +0000\r\nDate: Tue, 7 May 2019 13:07:13 +0000 (UTC)\r\nFrom: Manoj Kumar <websitedesign546954@yahoo.com>\r\nMessage-ID: <1426881909.1435831.1557234433576@mail.yahoo.com>\r\nSubject: Customized CMS Websites Designed and Developed\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_1435830_531996126.1557234433574\"\r\nReferences: <1426881909.1435831.1557234433576.ref@mail.yahoo.com>\r\nX-Mailer: WebService/1.1.13583 YMailNorrin Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36\r\nContent-Length: 5962\r\n\r\n ------=_Part_1435830_531996126.1557234433574\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n\r\nHi,\r\n\r\nVery Good Morning!\r\n\r\nWould you be interested in a possible redesigning ofthe site or addition fe=\r\nature that might benefit the overall usability and userexperience which usu=\r\nally leads to better sales.\r\n\r\nWe are an Indian Web Design and Development firm withover 8 years of experi=\r\nence. In these tough times, where it is hard to maintainthe top line, we ca=\r\nn help share the bottom-line for you.\r\n\r\nWe will be happy to help execute Web Design andDevelopment projects at a mu=\r\nch lower cost than what you have in house - Nocompromise on quality!\r\n\r\nWe are at present partnering with over 45 firms fromUK, US, Australia, Cana=\r\nda.\r\n\r\nOur primary focus is: -=C2=A0\r\n\r\n1. Website Designing\r\n\r\n2. PHP Development in CMS (WordPress, Joomla, Magneto,Drupal)\r\n\r\n3. Database programming\r\n\r\n4. Flash Design\r\n\r\n5. Graphic Designs\r\n\r\n6. Ecommerce Solutions\r\n\r\nDo let me know if you are interested and I would behappy to share our Metho=\r\ndologies, past work details and client testimonials\r\n\r\nI look forward to your mail.\r\n\r\nKind Regards\r\n\r\nManoj\r\n\r\n=C2=A0\r\n\r\n\r\n------=_Part_1435830_531996126.1557234433574\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\n<html><head></head><body><div class=\"yahoo-style-wrap\" style=\"font-family:Helvetica Neue, Helvetica, Arial, sans-serif;font-size:16px;\"><div><div><p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><b><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#0070C0;mso-ansi-language:EN-IN\">Hi,</span></b></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><b><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#0070C0;mso-ansi-language:EN-IN\">Very Good Morning!</span></b></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">Would you be interested in a possible redesigning of\r\nthe site or addition feature that might benefit the overall usability and user\r\nexperience which usually leads to better sales.</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">We are an Indian Web Design and Development firm with\r\nover 8 years of experience. In these tough times, where it is hard to maintain\r\nthe top line, we can help share the bottom-line for you.</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">We will be happy to help execute Web Design and\r\nDevelopment projects at a much lower cost than what you have in house - No\r\ncompromise on quality!</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><b><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#0070C0;mso-ansi-language:EN-IN\">We are at present partnering with over 45 firms from\r\nUK, US, Australia, Canada.</span></b></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><b><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#0070C0;mso-ansi-language:EN-IN\">Our primary focus is: -&nbsp;</span></b></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">1. Website Designing</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">2. PHP Development in CMS (WordPress, Joomla, Magneto,\r\nDrupal)</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">3. Database programming</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">4. Flash Design</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">5. Graphic Designs</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">6. Ecommerce Solutions</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">Do let me know if you are interested and I would be\r\nhappy to share our Methodologies, past work details and client testimonials</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">I look forward to your mail.</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt\"><span lang=\"EN-IN\" style=\"font-size:11.5pt;color:#444444;mso-ansi-language:EN-IN\">Kind Regards</span></p>\r\n\r\n<p class=\"ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt\"><span lang=\"EN-IN\" style=\"font-size:10.5pt;color:#444444;background:#F3F3F3;mso-ansi-language:EN-IN\">Manoj</span></p>\r\n\r\n<p class=\"ydp6165a082MsoNormal\">&nbsp;</p></div><br></div></div></body></html>\r\n------=_Part_1435830_531996126.1557234433574--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('14', 'Manoj Kumar <websitedesign546954@yahoo.com> - websitedesign546954@yahoo.com', '10013', '1', NULL, 'Re: Customized CMS Websites Designed and Developed', '<div>Hello,<br /><br />Hope you are doing fine.<br /><br />This is just a follow up mail to touch base with you.<br /><br />Haven’t heard back from you, just wondering if you are interested for outsource some of your projects to us.<br /><br />By Outsourcing, you can save money by hiring professionals from countries with a lower cost of living that typically provide their service at lower cost.<br /><br />Please let us know your response.<br /><br />Warm Regards,<br /><br />Manoj<br /><br /></div><div class=\"ydpa9d86e7fyahoo-style-wrap\" style=\"font-family:\'Helvetica Neue\', Helvetica, Arial, sans-serif;font-size:16px;\"><div></div>\n        <div><br /></div><div><br /></div>\n        \n        </div><div class=\"yahoo_quoted\">\n            <div style=\"font-family:\'Helvetica Neue\', Helvetica, Arial, sans-serif;font-size:13px;color:#26282a;\">\n                \n                <div>\n                    On Tuesday, 7 May, 2019, 6:37:13 pm IST, Manoj Kumar &lt;websitedesign546954@yahoo.com&gt; wrote:\n                </div>\n                <div><br /></div>\n                <div><br /></div>\n                <div><div><div><div class=\"yiv0967073707yahoo-style-wrap\" style=\"font-family:\'Helvetica Neue\', Helvetica, Arial, sans-serif;font-size:16px;\"><div><div><p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span style=\"font-size:11.5pt;color:#0070C0;\" lang=\"en-in\" xml:lang=\"en-in\">Hi,</span></b></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span style=\"font-size:11.5pt;color:#0070C0;\" lang=\"en-in\" xml:lang=\"en-in\">Very Good Morning!</span></b></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">Would you be interested in a possible redesigning of\nthe site or addition feature that might benefit the overall usability and user\nexperience which usually leads to better sales.</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">We are an Indian Web Design and Development firm with\nover 8 years of experience. In these tough times, where it is hard to maintain\nthe top line, we can help share the bottom-line for you.</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">We will be happy to help execute Web Design and\nDevelopment projects at a much lower cost than what you have in house - No\ncompromise on quality!</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span style=\"font-size:11.5pt;color:#0070C0;\" lang=\"en-in\" xml:lang=\"en-in\">We are at present partnering with over 45 firms from\nUK, US, Australia, Canada.</span></b></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span style=\"font-size:11.5pt;color:#0070C0;\" lang=\"en-in\" xml:lang=\"en-in\">Our primary focus is: - </span></b></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">1. Website Designing</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">2. PHP Development in CMS (WordPress, Joomla, Magneto,\nDrupal)</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">3. Database programming</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">4. Flash Design</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">5. Graphic Designs</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">6. Ecommerce Solutions</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">Do let me know if you are interested and I would be\nhappy to share our Methodologies, past work details and client testimonials</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">I look forward to your mail.</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=\"font-size:11.5pt;color:#444444;\" lang=\"en-in\" xml:lang=\"en-in\">Kind Regards</span></p>\n\n<p class=\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" style=\"margin-bottom:.0001pt;\"><span style=\"font-size:10.5pt;color:#444444;background:#F3F3F3;\" lang=\"en-in\" xml:lang=\"en-in\">Manoj</span></p>\n\n<p class=\"yiv0967073707ydp6165a082MsoNormal\"> </p></div><br /></div></div></div></div></div>\n            </div>\n        </div>', 'closed', '0', '0', '1', '0', NULL, '1557310502', '1', '1', '0', 'Return-Path: <websitedesign546954@yahoo.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id AF8DKmir0lxeqgoAMoQ/pw\r\n	(envelope-from <websitedesign546954@yahoo.com>)\r\n	for <info@apusseo.com>; Wed, 08 May 2019 13:11:52 +0300\r\nReturn-path: <websitedesign546954@yahoo.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Wed, 08 May 2019 13:11:52 +0300\r\nReceived: from sonic302-20.consmr.mail.sg3.yahoo.com ([106.10.242.140]:34495)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <websitedesign546954@yahoo.com>)\r\n	id 1hOJYG-002vtE-C4\r\n	for info@apusseo.com; Wed, 08 May 2019 13:11:52 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=yahoo.com; s=s2048; t=1557310309; bh=I94mv9+xMUdu0TZzMGM87rrrNo0Azg/zwVfAiZtOj5Q=; h=Date:From:In-Reply-To:References:Subject:From:Subject; b=hub318sQjvZSvJ60kLkcI34yopzR9p/5dCxmkNLlXxYlegAmCIKDGmlsLs3OZeo2NQxVV6t61YB0Bv/x+/v2SgFv4DxtDhAB18C2MG+rqiG1KoGaONdOaAG3a4EH+kiQeflVzE97j86lhYa8yomE43LAZCHG5ssmf9DOeZCyJnlWTqaoHNRphE88AJhHcLRApll7pItse3T4a/hKv/nLd4h6SQhT4IFCAzl095f+7pau3V78PTrygzwEqe0ZAzvvkZB5vhr8a+wz3GOjRFEWAXA5s27GBTSnf9QnMeaqvUAh1+i9dczGVZbBNwLLNQGDW6SuYgow0yhFIl99AhuVig==\r\nX-YMail-OSG: iFGeRi8VM1kRG5pJWNT2mtO3J5JjmhgWY3XezkV4yylASwVwHRJpzTMGBubx08M\r\n gV6bvdqP_AAOlVvmUGGzjmodxpfmS40oI.NIPd52jmMUcP1DBtEMJIpHqf7KpqENNBAY_sfq2cws\r\n xf1mxzGIpQmOk5vvl5QzR3dTJhy21Q7YjWgMSftiNuEdUvfZMTpPMd74qsrnDuCMlE.aOyiJdFGv\r\n wIaUm1lEsdp2DQcCFBOd3UXKx1kA1OnZrfl3cASAum.OLByAWCRjGQoaKwxskLhFiWeYXlZRSYkr\r\n _W3T0rY.Ra6vlDfszmXBda_4LkMuidi27Kj7GYkcs6AQyRIdnWB10Y.kHPsoQ_CPPbYsuTCSSeSo\r\n ND9MgONU1EffUVl5b8BHWG1pMhWOzmTH0xr345ppDO6XW8H_ox2.BTqtn3Iwtokvyr56ZvxHQUVx\r\n .L2hW3es6J4oVdNeRrKmtZmTcBz2SRK1D8mlZzyHaOpKVZ20F3xQFUu0gL4uxWh.3QPRRw71JEsM\r\n _nt52HKqHp7aqHOZMWUDfDFDY3QW602EVJN1q1j3pO_r7QMtSKtkvTP0TxJu8wT7p2HK7U93EAhr\r\n c_LMBQB8ssGDOz01ynIHCwtZHzGrq88ewhdt0nKvKdREI1UPAE6ZnMSJzhZtSIcwRFsq9eygzj8u\r\n cTjL1q_7B32bA3cIxrx5c6A0VV61MA4vgL6PxhuWodvS1pViAkFMeDglpRynTmrFKi0HigezdzuJ\r\n w0OcnoY34q4D.2qyl70uXyAIl6tZE85FVqg3j.yBYw5C5lWRR012RjWxE0iPfTg0rU2M1.9ntwaY\r\n DS3wh89L5Go9_x4gR2TSK.k5Vy3IvikJ3kSqGFnMw689JMo1xLLmqpKMRVdhweFhXPeqdUvzOqde\r\n 3DMs6vcPPmzY9knheW47D7ggkmnVqCYEbbYDuMX1E93N_oCtc56jNHWsG9xwzN2MrhFCAPWXk1Tc\r\n znONjRFe0tI1eBbL08xF1QBmko5j9KnWJbCPFw3VmUjNyFvUsZkd097FDBftPxvYe5fjnKWD2HnQ\r\n rli1xcHaCTemsTpacnY86QmRzuk3gKCMsy4tnbMkUlZ6inEDFYu6KP4vkXxHdU4DfKsRUspvr02H\r\n X0LaMU4DHteN8dTj41OQT7nHmmW323V3XvUTixFf.c6SGdkcBNjgVtmqO0.r0JrbiQoJr\r\nReceived: from sonic.gate.mail.ne1.yahoo.com by sonic302.consmr.mail.sg3.yahoo.com with HTTP; Wed, 8 May 2019 10:11:49 +0000\r\nDate: Wed, 8 May 2019 10:11:46 +0000 (UTC)\r\nFrom: Manoj Kumar <websitedesign546954@yahoo.com>\r\nMessage-ID: <1780588748.1890814.1557310306381@mail.yahoo.com>\r\nIn-Reply-To: <1426881909.1435831.1557234433576@mail.yahoo.com>\r\nReferences: <1426881909.1435831.1557234433576.ref@mail.yahoo.com> <1426881909.1435831.1557234433576@mail.yahoo.com>\r\nSubject: Re: Customized CMS Websites Designed and Developed\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_1890813_1113093135.1557310306379\"\r\nX-Mailer: WebService/1.1.13583 YMailNorrin Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0\r\nContent-Length: 7858\r\n\r\n ------=_Part_1890813_1113093135.1557310306379\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHello,\r\n\r\nHope you are doing fine.\r\n\r\nThis is just a follow up mail to touch base with you.\r\n\r\nHaven=E2=80=99t heard back from you, just wondering if you are interested f=\r\nor outsource some of your projects to us.\r\n\r\nBy Outsourcing, you can save money by hiring professionals from countries w=\r\nith a lower cost of living that typically provide their service at lower co=\r\nst.\r\n\r\nPlease let us know your response.\r\n\r\nWarm Regards,\r\n\r\nManoj\r\n\r\n=20\r\n\r\n    On Tuesday, 7 May, 2019, 6:37:13 pm IST, Manoj Kumar <websitedesign5469=\r\n54@yahoo.com> wrote: =20\r\n=20\r\n=20\r\nHi,\r\n\r\nVery Good Morning!\r\n\r\nWould you be interested in a possible redesigning ofthe site or addition fe=\r\nature that might benefit the overall usability and userexperience which usu=\r\nally leads to better sales.\r\n\r\nWe are an Indian Web Design and Development firm withover 8 years of experi=\r\nence. In these tough times, where it is hard to maintainthe top line, we ca=\r\nn help share the bottom-line for you.\r\n\r\nWe will be happy to help execute Web Design andDevelopment projects at a mu=\r\nch lower cost than what you have in house - Nocompromise on quality!\r\n\r\nWe are at present partnering with over 45 firms fromUK, US, Australia, Cana=\r\nda.\r\n\r\nOur primary focus is: -=C2=A0\r\n\r\n1. Website Designing\r\n\r\n2. PHP Development in CMS (WordPress, Joomla, Magneto,Drupal)\r\n\r\n3. Database programming\r\n\r\n4. Flash Design\r\n\r\n5. Graphic Designs\r\n\r\n6. Ecommerce Solutions\r\n\r\nDo let me know if you are interested and I would behappy to share our Metho=\r\ndologies, past work details and client testimonials\r\n\r\nI look forward to your mail.\r\n\r\nKind Regards\r\n\r\nManoj\r\n\r\n=C2=A0\r\n\r\n =20\r\n------=_Part_1890813_1113093135.1557310306379\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<html><head></head><body><div>Hello,<br><br>Hope you are doing fine.<br><br=\r\n>This is just a follow up mail to touch base with you.<br><br>Haven=E2=80=\r\n=99t heard back from you, just wondering if you are interested for outsourc=\r\ne some of your projects to us.<br><br>By Outsourcing, you can save money by=\r\n hiring professionals from countries with a lower cost of living that typic=\r\nally provide their service at lower cost.<br><br>Please let us know your re=\r\nsponse.<br><br>Warm Regards,<br><br>Manoj<br><br></div><div class=3D\"ydpa9d=\r\n86e7fyahoo-style-wrap\" style=3D\"font-family:Helvetica Neue, Helvetica, Aria=\r\nl, sans-serif;font-size:16px;\"><div></div>\r\n        <div><br></div><div><br></div>\r\n       =20\r\n        </div><div id=3D\"yahoo_quoted_7662335103\" class=3D\"yahoo_quoted\">\r\n            <div style=3D\"font-family:\'Helvetica Neue\', Helvetica, Arial, s=\r\nans-serif;font-size:13px;color:#26282a;\">\r\n               =20\r\n                <div>\r\n                    On Tuesday, 7 May, 2019, 6:37:13 pm IST, Manoj Kumar &l=\r\nt;websitedesign546954@yahoo.com&gt; wrote:\r\n                </div>\r\n                <div><br></div>\r\n                <div><br></div>\r\n                <div><div id=3D\"yiv0967073707\"><div><div class=3D\"yiv096707=\r\n3707yahoo-style-wrap\" style=3D\"font-family:Helvetica Neue, Helvetica, Arial=\r\n, sans-serif;font-size:16px;\"><div><div><p class=3D\"yiv0967073707ydp6165a08=\r\n2yiv9949602595ydpddbf7f5fmsonormal\" style=3D\"margin-bottom:16.2pt;line-heig=\r\nht:15.95pt;\"><b><span style=3D\"font-size:11.5pt;color:#0070C0;\" lang=3D\"EN-=\r\nIN\">Hi,</span></b></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span style=3D\"font-size=\r\n:11.5pt;color:#0070C0;\" lang=3D\"EN-IN\">Very Good Morning!</span></b></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">Would you be interested in a possible r=\r\nedesigning of\r\nthe site or addition feature that might benefit the overall usability and u=\r\nser\r\nexperience which usually leads to better sales.</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">We are an Indian Web Design and Develop=\r\nment firm with\r\nover 8 years of experience. In these tough times, where it is hard to maint=\r\nain\r\nthe top line, we can help share the bottom-line for you.</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">We will be happy to help execute Web De=\r\nsign and\r\nDevelopment projects at a much lower cost than what you have in house - No\r\ncompromise on quality!</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span style=3D\"font-size=\r\n:11.5pt;color:#0070C0;\" lang=3D\"EN-IN\">We are at present partnering with ov=\r\ner 45 firms from\r\nUK, US, Australia, Canada.</span></b></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><b><span style=3D\"font-size=\r\n:11.5pt;color:#0070C0;\" lang=3D\"EN-IN\">Our primary focus is: -&nbsp;</span>=\r\n</b></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">1. Website Designing</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">2. PHP Development in CMS (WordPress, J=\r\noomla, Magneto,\r\nDrupal)</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">3. Database programming</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">4. Flash Design</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">5. Graphic Designs</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">6. Ecommerce Solutions</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">Do let me know if you are interested an=\r\nd I would be\r\nhappy to share our Methodologies, past work details and client testimonials=\r\n</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">I look forward to your mail.</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:16.2pt;line-height:15.95pt;\"><span style=3D\"font-size:11=\r\n.5pt;color:#444444;\" lang=3D\"EN-IN\">Kind Regards</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082yiv9949602595ydpddbf7f5fmsonormal\" styl=\r\ne=3D\"margin-bottom:0in;margin-bottom:.0001pt;\"><span style=3D\"font-size:10.=\r\n5pt;color:#444444;background:#F3F3F3;\" lang=3D\"EN-IN\">Manoj</span></p>\r\n\r\n<p class=3D\"yiv0967073707ydp6165a082MsoNormal\">&nbsp;</p></div><br></div></=\r\ndiv></div></div></div>\r\n            </div>\r\n        </div></body></html>\r\n------=_Part_1890813_1113093135.1557310306379--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('15', 'kuldeep sharma <kuldeepsharma4524@aol.com> - kuldeepsharma4524@aol.com', '10014', '1', NULL, 'Mobile Application,website design and webdevelopment', '\n<div style=\"font:10pt \'Helvetica Neue\';\">\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">Hello,</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">I hope you are having a\ngreat day!!</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:12pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">We are a 10 Year old\nISO certified company that specializes in Web design, Development and Mobile\nApplication Development Company. Having successfully delivered 1000+ projects,\nwe offer a wide </span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:12pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">range of Internet-\nRelated outsourcing services to our clients all around the globe at competitive\nprices.</span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">Here take a look what\nwe can help you with</span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:12pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\"> </span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:12pt;line-height:normal;background:#FFFFFF;\"><b><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\">UI Engineering (Conversion from PSD to\nWord Press, Joomla, Drupal, Concrete 5, Modx, Typo3)</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:2.25pt;line-height:16pt;background:#FFFFFF;\"><b><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\">Responsive Design (HTML5 &amp; CSS3)</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:2.25pt;margin-left:12pt;line-height:16pt;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Symbol;color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"> </span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:2.25pt;line-height:16pt;background:#FFFFFF;\"><b><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\">E commerce Development- (Magento,\nWoo-commerce, CS cart, OS commerce, Shopify, Zen cart, Prestashop)</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:2.25pt;line-height:16pt;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Symbol;color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"> </span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:2.25pt;line-height:16pt;background:#FFFFFF;\"><span style=\"font-size:7pt;font-family:\'Times New Roman\', serif;color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"> </span><b><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\">Framework [Cake PHP, code igniter, Zend\nFramework]</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:2.25pt;margin-left:12pt;line-height:16pt;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Symbol;color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"> </span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:2.25pt;line-height:16pt;background:#FFFFFF;\"><span style=\"font-size:7pt;font-family:\'Times New Roman\', serif;color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"> </span><b><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\">Search Engine Optimization (SEO)/Social\nMedia Optimization (SMO)/Pay per click (PPC)</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:2.25pt;line-height:16pt;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Symbol;color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"> </span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:2.25pt;line-height:16pt;background:#FFFFFF;\"><span style=\"font-size:7pt;font-family:\'Times New Roman\', serif;color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\">  </span><b><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\">Logo Design/Graphic Design</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\"> </span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n<br />\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">What’s more, you\ncan hire our web veterans who are well-trained and have in-depth expertise\nacross varied areas including HTML 5, CSS, PHP, My SQL, CMS, Adobe Photoshop,\nPayment Gateway Integration and other key business areas.</span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\"> </span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">We would like to help\nyou with your business needs and give you a website that works on the web. If\nyou’re interested, would it be okay if we send you a few ideas along with our\nportfolio and client testimonials for your perusal?</span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\"> </span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">We look forward to\nhearing from you!</span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\"> </span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">Thanks &amp; Regards</span><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><span>                 </span></span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n<br />\n</span><span style=\"font-size:10pt;font-family:\'Segoe UI\', \'sans-serif\';color:#244061;background:#F3F3F3;\" lang=\"en-in\" xml:lang=\"en-in\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:\'Segoe UI\', \'sans-serif\';color:#244061;background:#F3F3F3;\" lang=\"en-in\" xml:lang=\"en-in\">Kul<font size=\"2\"><font face=\"Arial, Helvetica, sans-serif\">deep</font></font></span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:10pt;font-family:Arial, \'sans-serif\';color:#244061;\" lang=\"en-in\" xml:lang=\"en-in\"><br />\n\n</span><span style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#244061;background:#FFFFFF;\" lang=\"en-in\" xml:lang=\"en-in\">Online Marketing\nConsultant</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\" lang=\"en-in\" xml:lang=\"en-in\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></div>\n\n\n\n<div class=\"MsoNormal\"> </div>\n\n\n</div>\n', 'closed', '0', '0', '1', '0', NULL, '1557833703', '1', '1', '0', 'Return-Path: <kuldeepsharma4524@aol.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id aJ3zEMam2lz4QAEAMoQ/pw\r\n	(envelope-from <kuldeepsharma4524@aol.com>)\r\n	for <info@apusseo.com>; Tue, 14 May 2019 14:30:14 +0300\r\nReturn-path: <kuldeepsharma4524@aol.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Tue, 14 May 2019 14:30:14 +0300\r\nReceived: from sonic312-47.consmr.mail.bf2.yahoo.com ([74.6.128.109]:33537)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <kuldeepsharma4524@aol.com>)\r\n	id 1hQVdN-000Lkq-S1\r\n	for info@apusseo.com; Tue, 14 May 2019 14:30:14 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=aol.com; s=a2048; t=1557833411; bh=CkWVCCH5B8o0MS9TnrUujeonElMJI/tEJv70HiZir6o=; h=Date:From:Subject:References:From:Subject; b=EEH2UtQIcaogOuINgCtZ3Pxm6zFHIknPeh3uQP8J6/yZJhPebjzDSc1/toMuT5UQtVNp5Tkh1OMvqid/+pZqx8F3tqb4w9NiOL8Qc5iOmb7yOVijPlP63DMeAKGdW+tIFHlJfsGdjwhSLDlOJchn2K15zEhr5766gfCxdLJfrhhTJjYJnTYbI/3PysUM8Jr3o2cd8yOE62TDPXidrX62P/I6sieapqc+TqKI/oYK3yuWcSc8Pb4xpVN2Ys90IRGBuMikIDl7Uz3FzULTpvcWK9Rq4yuGkgVs3i2fyum6WRVJEGvZGay2l+/y2/8cjOz6N5ia9BC3f7efrsxAQUGupg==\r\nX-YMail-OSG: 6mJJ6iIVM1kW92NMlXc.xBbwnXWDGluEHJenA.75.BkNulrToDsnItXIWXx9I..\r\n h_Oblm00.sQQgio8xWmVY_Nn0rkx6iWeFNH.oqx8KV1GYeq8IE8ipx4q2zEeH3mpd5M_prUDLFOd\r\n 0BPTK90pHinFCvvlWxVbZFYUFR2OZE5mQ4l5JtN.NfuaUCnlC9FFa7wA7Px1EswOL0xj9VDv4DUP\r\n 6La4q.2eCUSMEYJCe10Y5yB6ErS032jwv4pPvTGM61IK.kY90578gTb3BIiS01fzcM._4drofEV_\r\n fA9loNuBN89Mndm7iDqnd3cmqAenfi0ERln.cmRZP6ag0xDedHOfk_jyxqmajMy_iY0PFC846kuA\r\n 3ptzV7Ng5qciLur5NeShlgPv.0ghrFT4CyKcS8hboMQqwDmSzyksvfngyi.2j3fdbE0ogYyrgv4N\r\n BC9BL98TPnW0FFcbwA0CvHqwLS9rHzgIo010uLuNo84pC6dFbGAJfsrauiLG0FKtJhe_rERvC7Uu\r\n zMVURnCjgX8leInQPpXIi5uGCg8k8zMLu2O6S8Ejy0CUePEKZyIasRT20hoF3UW9hMU_3Amh9bfS\r\n Bgy5vYw4LaFXkgPM8qc4qDDVkT6MBBaGtzUTCpxDaB4XZ1MnVJLIRrn_9y1mqNsUN2aOd2t8K20Z\r\n PRaN3Q1rJowLcMIHOGTdBmbmQITVp8tXzl6S0wpjCqoAPu79LB9O5gqluSA.Ja_PESaGyTfzKtRs\r\n egRxBf2zvVk49xEGTxlFxjwdTuM8g.GKy4dKpXawqOihu01UuRKE7aOnjIruInNNcOsHN4Dusd5i\r\n AaXeaxTtj_eVo9STRFxv03pk9q9bw0ZWHvV_NkC_jbKmi0RAyM2JmwxUDzuMLCdiAJ3ASfVYWKk9\r\n 22rLwGliNyhxkFPhK1HyZrN_.CidxqA8Rz8D8IpGYYZRNK0Djf.kxfCIqk1nFqx.qCQOnA35OotH\r\n CeaIAgC2IDGHhJbjZuT7OsC4TFzaz2lgXAqalVp0md2hJ22wVTVLST0q1o9LMQmQ2PbkS7W64wgA\r\n KbuhemnUFqFkZvWEXhlmGvH6.xkIEnEsnT16G8WmsowEClkSIG.IrUg0.rDCEkSULJclK5IiF.ap\r\n gIP4ZgKEEPf.eke_goRk_MJHNdvVukvDAXWu0ZfAC2HmU2I1Iowl2aeFKHcFo7oTIYS.lIb5rF.2\r\n A1UYtdtIKgEsYY8b8Yg2AubHfKI.wwb4kkeE-\r\nReceived: from sonic.gate.mail.ne1.yahoo.com by sonic312.consmr.mail.bf2.yahoo.com with HTTP; Tue, 14 May 2019 11:30:11 +0000\r\nDate: Tue, 14 May 2019 11:28:10 +0000 (UTC)\r\nFrom: kuldeep sharma <kuldeepsharma4524@aol.com>\r\nMessage-ID: <2001554000.279360.1557833290402@mail.yahoo.com>\r\nSubject:  Mobile Application,website design and webdevelopment\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_279359_1034045758.1557833290399\"\r\nReferences: <2001554000.279360.1557833290402.ref@mail.yahoo.com>\r\nX-Mailer: WebService/1.1.13634 aolwebmail Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0\r\nContent-Length: 37519\r\n\r\n ------=_Part_279359_1034045758.1557833290399\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHello,\r\nI hope you are having agreat day!!\r\nWe are a 10 Year oldISO certified company that specializes in Web design, D=\r\nevelopment and MobileApplication Development Company. Having successfully d=\r\nelivered 1000+ projects,we offer a wide range of Internet-Related outsourci=\r\nng services to our clients all around the globe at competitiveprices.\r\nHere take a look whatwe can help you with=C2=A0UI Engineering (Conversion f=\r\nrom PSD toWord Press, Joomla, Drupal, Concrete 5, Modx, Typo3)Responsive De=\r\nsign (HTML5 & CSS3)=C2=A0E commerce Development- (Magento,Woo-commerce, CS =\r\ncart, OS commerce, Shopify, Zen cart, Prestashop)=C2=A0=C2=A0Framework [Cak=\r\ne PHP, code igniter, ZendFramework]=C2=A0=C2=A0Search Engine Optimization (=\r\nSEO)/SocialMedia Optimization (SMO)/Pay per click (PPC)=C2=A0=C2=A0=C2=A0Lo=\r\ngo Design/Graphic Design=C2=A0\r\n\r\nWhat=E2=80=99s more, youcan hire our web veterans who are well-trained and =\r\nhave in-depth expertiseacross varied areas including HTML 5, CSS, PHP, My S=\r\nQL, CMS, Adobe Photoshop,Payment Gateway Integration and other key business=\r\n areas.\r\n=C2=A0\r\nWe would like to helpyou with your business needs and give you a website th=\r\nat works on the web. Ifyou=E2=80=99re interested, would it be okay if we se=\r\nnd you a few ideas along with ourportfolio and client testimonials for your=\r\n perusal?\r\n=C2=A0\r\nWe look forward tohearing from you!\r\n=C2=A0\r\nThanks & Regards=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=\r\n=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=20\r\n\r\nKuldeep\r\nOnline MarketingConsultant=C2=A0=C2=A0\r\n------=_Part_279359_1034045758.1557833290399\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n\r\n<div style=3D\"color:;font: 10pt Helvetica Neue;\"><!--[if gte mso 9]><xml>\r\n <w:WordDocument>\r\n  <w:View>Normal</w:View>\r\n  <w:Zoom>0</w:Zoom>\r\n  <w:TrackMoves/>\r\n  <w:TrackFormatting/>\r\n  <w:PunctuationKerning/>\r\n  <w:ValidateAgainstSchemas/>\r\n  <w:SaveIfXMLInvalid>false</w:SaveIfXMLInvalid>\r\n  <w:IgnoreMixedContent>false</w:IgnoreMixedContent>\r\n  <w:AlwaysShowPlaceholderText>false</w:AlwaysShowPlaceholderText>\r\n  <w:DoNotPromoteQF/>\r\n  <w:LidThemeOther>EN-US</w:LidThemeOther>\r\n  <w:LidThemeAsian>X-NONE</w:LidThemeAsian>\r\n  <w:LidThemeComplexScript>X-NONE</w:LidThemeComplexScript>\r\n  <w:Compatibility>\r\n   <w:BreakWrappedTables/>\r\n   <w:SnapToGridInCell/>\r\n   <w:WrapTextWithPunct/>\r\n   <w:UseAsianBreakRules/>\r\n   <w:DontGrowAutofit/>\r\n   <w:SplitPgBreakAndParaMark/>\r\n   <w:DontVertAlignCellWithSp/>\r\n   <w:DontBreakConstrainedForcedTables/>\r\n   <w:DontVertAlignInTxbx/>\r\n   <w:Word11KerningPairs/>\r\n   <w:CachedColBalance/>\r\n  </w:Compatibility>\r\n  <m:mathPr>\r\n   <m:mathFont m:val=3D\"Cambria Math\"/>\r\n   <m:brkBin m:val=3D\"before\"/>\r\n   <m:brkBinSub m:val=3D\"--\"/>\r\n   <m:smallFrac m:val=3D\"off\"/>\r\n   <m:dispDef/>\r\n   <m:lMargin m:val=3D\"0\"/>\r\n   <m:rMargin m:val=3D\"0\"/>\r\n   <m:defJc m:val=3D\"centerGroup\"/>\r\n   <m:wrapIndent m:val=3D\"1440\"/>\r\n   <m:intLim m:val=3D\"subSup\"/>\r\n   <m:naryLim m:val=3D\"undOvr\"/>\r\n  </m:mathPr></w:WordDocument>\r\n</xml><![endif]--><!--[if gte mso 9]><xml>\r\n <w:LatentStyles DefLockedState=3D\"false\" DefUnhideWhenUsed=3D\"true\"\r\n  DefSemiHidden=3D\"true\" DefQFormat=3D\"false\" DefPriority=3D\"99\"\r\n  LatentStyleCount=3D\"267\">\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"0\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Normal\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"heading 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" QFormat=3D\"true\" Name=3D\"=\r\nheading 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" QFormat=3D\"true\" Name=3D\"=\r\nheading 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" QFormat=3D\"true\" Name=3D\"=\r\nheading 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" QFormat=3D\"true\" Name=3D\"=\r\nheading 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" QFormat=3D\"true\" Name=3D\"=\r\nheading 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" QFormat=3D\"true\" Name=3D\"=\r\nheading 7\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" QFormat=3D\"true\" Name=3D\"=\r\nheading 8\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"9\" QFormat=3D\"true\" Name=3D\"=\r\nheading 9\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 7\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 8\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" Name=3D\"toc 9\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"35\" QFormat=3D\"true\" Name=3D=\r\n\"caption\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"10\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Title\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"1\" Name=3D\"Default Paragraph=\r\n Font\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"11\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Subtitle\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"22\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Strong\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"20\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Emphasis\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"59\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Table Grid\"/>\r\n  <w:LsdException Locked=3D\"false\" UnhideWhenUsed=3D\"false\" Name=3D\"Placeho=\r\nlder Text\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"1\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"No Spacing\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"60\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Shading\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"61\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light List\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"62\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Grid\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"63\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"64\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"65\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"66\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"67\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"68\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"69\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"70\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Dark List\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"71\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Shading\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"72\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful List\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"73\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Grid\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"60\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Shading Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"61\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light List Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"62\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Grid Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"63\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 1 Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"64\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 2 Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"65\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 1 Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" UnhideWhenUsed=3D\"false\" Name=3D\"Revisio=\r\nn\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"34\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"List Paragraph\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"29\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Quote\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"30\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Intense Quote\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"66\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 2 Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"67\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 1 Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"68\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 2 Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"69\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 3 Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"70\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Dark List Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"71\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Shading Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"72\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful List Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"73\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Grid Accent 1\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"60\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Shading Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"61\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light List Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"62\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Grid Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"63\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 1 Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"64\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 2 Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"65\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 1 Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"66\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 2 Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"67\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 1 Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"68\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 2 Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"69\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 3 Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"70\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Dark List Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"71\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Shading Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"72\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful List Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"73\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Grid Accent 2\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"60\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Shading Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"61\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light List Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"62\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Grid Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"63\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 1 Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"64\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 2 Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"65\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 1 Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"66\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 2 Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"67\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 1 Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"68\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 2 Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"69\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 3 Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"70\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Dark List Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"71\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Shading Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"72\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful List Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"73\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Grid Accent 3\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"60\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Shading Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"61\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light List Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"62\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Grid Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"63\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 1 Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"64\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 2 Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"65\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 1 Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"66\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 2 Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"67\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 1 Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"68\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 2 Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"69\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 3 Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"70\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Dark List Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"71\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Shading Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"72\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful List Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"73\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Grid Accent 4\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"60\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Shading Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"61\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light List Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"62\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Grid Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"63\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 1 Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"64\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 2 Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"65\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 1 Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"66\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 2 Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"67\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 1 Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"68\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 2 Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"69\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 3 Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"70\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Dark List Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"71\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Shading Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"72\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful List Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"73\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Grid Accent 5\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"60\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Shading Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"61\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light List Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"62\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Light Grid Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"63\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 1 Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"64\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Shading 2 Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"65\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 1 Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"66\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium List 2 Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"67\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 1 Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"68\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 2 Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"69\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Medium Grid 3 Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"70\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Dark List Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"71\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Shading Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"72\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful List Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"73\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" Name=3D\"Colorful Grid Accent 6\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"19\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Subtle Emphasis\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"21\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Intense Emphasis\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"31\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Subtle Reference\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"32\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Intense Reference\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"33\" SemiHidden=3D\"false\"\r\n   UnhideWhenUsed=3D\"false\" QFormat=3D\"true\" Name=3D\"Book Title\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"37\" Name=3D\"Bibliography\"/>\r\n  <w:LsdException Locked=3D\"false\" Priority=3D\"39\" QFormat=3D\"true\" Name=3D=\r\n\"TOC Heading\"/>\r\n </w:LatentStyles>\r\n</xml><![endif]--><!--[if gte mso 10]>\r\n<style>\r\n /* Style Definitions */\r\n table.MsoNormalTable\r\n=09{mso-style-name:\"Table Normal\";\r\n=09mso-tstyle-rowband-size:0;\r\n=09mso-tstyle-colband-size:0;\r\n=09mso-style-noshow:yes;\r\n=09mso-style-priority:99;\r\n=09mso-style-qformat:yes;\r\n=09mso-style-parent:\"\";\r\n=09mso-padding-alt:0in 5.4pt 0in 5.4pt;\r\n=09mso-para-margin-top:0in;\r\n=09mso-para-margin-right:0in;\r\n=09mso-para-margin-bottom:10.0pt;\r\n=09mso-para-margin-left:0in;\r\n=09line-height:115%;\r\n=09mso-pagination:widow-orphan;\r\n=09font-size:11.0pt;\r\n=09font-family:\"Calibri\",\"sans-serif\";\r\n=09mso-ascii-font-family:Calibri;\r\n=09mso-ascii-theme-font:minor-latin;\r\n=09mso-fareast-font-family:\"Times New Roman\";\r\n=09mso-fareast-theme-font:minor-fareast;\r\n=09mso-hansi-font-family:Calibri;\r\n=09mso-hansi-theme-font:minor-latin;}\r\n</style>\r\n<![endif]-->\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal;background:white\"><span style=3D\"font-size:10.0pt;font-fa=\r\nmily:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&qu=\r\not;Times New Roman&quot;;mso-bidi-font-family:Arial;color:#244061;backgroun=\r\nd:white;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">Hello,</span><span style=3D=\r\n\"font-size:12.0pt;font-family:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-=\r\nfareast-font-family:&quot;Times New Roman&quot;;color:#222222\"></span></div=\r\n>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal;background:white\"><span style=3D\"font-size:10.0pt;font-fa=\r\nmily:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot=\r\n;Times New Roman&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN=\r\n\"><br>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">I hope you are having a\r\ngreat day!!</span><span style=3D\"font-size:12.0pt;font-family:&quot;Arial&q=\r\nuot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&q=\r\nuot;;color:#222222\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:12.0pt;line-height:normal;b=\r\nackground:white\"><span style=3D\"font-size:10.0pt;font-family:&quot;Arial&qu=\r\not;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&qu=\r\not;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\"><br>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">We are a 10 Year old\r\nISO certified company that specializes in Web design, Development and Mobil=\r\ne\r\nApplication Development Company. Having successfully delivered 1000+ projec=\r\nts,\r\nwe offer a wide </span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:12.0pt;line-height:normal;b=\r\nackground:white\"><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&=\r\nquot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&=\r\nquot;;mso-bidi-font-family:Arial;color:#244061;background:white;mso-ansi-la=\r\nnguage:EN-IN\" lang=3D\"EN-IN\">range of Internet-\r\nRelated outsourcing services to our clients all around the globe at competi=\r\ntive\r\nprices.</span><span style=3D\"font-size:10.0pt;font-family:&quot;Arial&quot;=\r\n,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;=\r\n;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\"><br>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">Here take a look what\r\nwe can help you with</span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:12.0pt;line-height:normal;b=\r\nackground:white\"><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&=\r\nquot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&=\r\nquot;;mso-bidi-font-family:Arial;color:#244061;background:white;mso-ansi-la=\r\nnguage:EN-IN\" lang=3D\"EN-IN\">&nbsp;</span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:12.0pt;line-height:normal;b=\r\nackground:white\"><b><span style=3D\"font-size:10.0pt;font-family:&quot;Verda=\r\nna&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Rom=\r\nan&quot;;mso-bidi-font-family:Arial;color:#244061;mso-ansi-language:EN-IN\" =\r\nlang=3D\"EN-IN\">UI Engineering (Conversion from PSD to\r\nWord Press, Joomla, Drupal, Concrete 5, Modx, Typo3)</span></b><span style=\r\n=3D\"font-size:12.0pt;font-family:&quot;Arial&quot;,&quot;sans-serif&quot;;m=\r\nso-fareast-font-family:&quot;Times New Roman&quot;;color:#222222\"></span></=\r\ndiv>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:2.25pt;line-height:16.0pt;b=\r\nackground:white\"><b><span style=3D\"font-size:10.0pt;font-family:&quot;Verda=\r\nna&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Rom=\r\nan&quot;;mso-bidi-font-family:Arial;color:#244061;mso-ansi-language:EN-IN\" =\r\nlang=3D\"EN-IN\">Responsive Design (HTML5 &amp; CSS3)</span></b><span style=\r\n=3D\"font-size:12.0pt;font-family:&quot;Arial&quot;,&quot;sans-serif&quot;;m=\r\nso-fareast-font-family:&quot;Times New Roman&quot;;color:#222222\"></span></=\r\ndiv>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-top:0in;margin-right:0in;margin-bo=\r\nttom:2.25pt;margin-left:12.0pt;line-height:16.0pt;background:white\"><span s=\r\ntyle=3D\"font-size:10.0pt;font-family:Symbol;mso-fareast-font-family:&quot;T=\r\nimes New Roman&quot;;mso-bidi-font-family:Arial;color:#244061;mso-ansi-lang=\r\nuage:EN-IN\" lang=3D\"EN-IN\">&nbsp;</span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:2.25pt;line-height:16.0pt;b=\r\nackground:white\"><b><span style=3D\"font-size:10.0pt;font-family:&quot;Verda=\r\nna&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Rom=\r\nan&quot;;mso-bidi-font-family:Arial;color:#244061;mso-ansi-language:EN-IN\" =\r\nlang=3D\"EN-IN\">E commerce Development- (Magento,\r\nWoo-commerce, CS cart, OS commerce, Shopify, Zen cart, Prestashop)</span></=\r\nb><span style=3D\"font-size:12.0pt;font-family:&quot;Arial&quot;,&quot;sans-=\r\nserif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;color:#2222=\r\n22\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:2.25pt;line-height:16.0pt;b=\r\nackground:white\"><span style=3D\"font-size:10.0pt;font-family:Symbol;mso-far=\r\neast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Arial;col=\r\nor:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">&nbsp;</span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:2.25pt;line-height:16.0pt;b=\r\nackground:white\"><span style=3D\"font-size:7.0pt;font-family:&quot;Times New=\r\n Roman&quot;,&quot;serif&quot;;mso-fareast-font-family:&quot;Times New Roma=\r\nn&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">&nbsp;</span>=\r\n<b><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quot;sa=\r\nns-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi=\r\n-font-family:Arial;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">Fr=\r\namework [Cake PHP, code igniter, Zend\r\nFramework]</span></b><span style=3D\"font-size:12.0pt;font-family:&quot;Aria=\r\nl&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roma=\r\nn&quot;;color:#222222\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-top:0in;margin-right:0in;margin-bo=\r\nttom:2.25pt;margin-left:12.0pt;line-height:16.0pt;background:white\"><span s=\r\ntyle=3D\"font-size:10.0pt;font-family:Symbol;mso-fareast-font-family:&quot;T=\r\nimes New Roman&quot;;mso-bidi-font-family:Arial;color:#244061;mso-ansi-lang=\r\nuage:EN-IN\" lang=3D\"EN-IN\">&nbsp;</span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:2.25pt;line-height:16.0pt;b=\r\nackground:white\"><span style=3D\"font-size:7.0pt;font-family:&quot;Times New=\r\n Roman&quot;,&quot;serif&quot;;mso-fareast-font-family:&quot;Times New Roma=\r\nn&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">&nbsp;</span>=\r\n<b><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quot;sa=\r\nns-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-bidi=\r\n-font-family:Arial;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">Se=\r\narch Engine Optimization (SEO)/Social\r\nMedia Optimization (SMO)/Pay per click (PPC)</span></b><span style=3D\"font-=\r\nsize:12.0pt;font-family:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareas=\r\nt-font-family:&quot;Times New Roman&quot;;color:#222222\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:2.25pt;line-height:16.0pt;b=\r\nackground:white\"><span style=3D\"font-size:10.0pt;font-family:Symbol;mso-far=\r\neast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:Arial;col=\r\nor:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">&nbsp;</span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:2.25pt;line-height:16.0pt;b=\r\nackground:white\"><span style=3D\"font-size:7.0pt;font-family:&quot;Times New=\r\n Roman&quot;,&quot;serif&quot;;mso-fareast-font-family:&quot;Times New Roma=\r\nn&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">&nbsp;&nbsp;<=\r\n/span><b><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&q=\r\nuot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;ms=\r\no-bidi-font-family:Arial;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-=\r\nIN\">Logo Design/Graphic Design</span></b><span style=3D\"font-size:12.0pt;fo=\r\nnt-family:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;color:#222222\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal;background:white\"><span style=3D\"font-size:10.0pt;font-fa=\r\nmily:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&qu=\r\not;Times New Roman&quot;;mso-bidi-font-family:Arial;color:#244061;backgroun=\r\nd:white;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">&nbsp;</span><span style=3D=\r\n\"font-size:10.0pt;font-family:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-=\r\nfareast-font-family:&quot;Times New Roman&quot;;color:#244061;mso-ansi-lang=\r\nuage:EN-IN\" lang=3D\"EN-IN\"><br style=3D\"mso-special-character:line-break\">\r\n<br style=3D\"mso-special-character:line-break\">\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal;background:white\"><span style=3D\"font-size:10.0pt;font-fa=\r\nmily:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&qu=\r\not;Times New Roman&quot;;mso-bidi-font-family:Arial;color:#244061;backgroun=\r\nd:white;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\">What=E2=80=99s more, you\r\ncan hire our web veterans who are well-trained and have in-depth expertise\r\nacross varied areas including HTML 5, CSS, PHP, My SQL, CMS, Adobe Photosho=\r\np,\r\nPayment Gateway Integration and other key business areas.</span><span style=\r\n=3D\"font-size:10.0pt;font-family:&quot;Arial&quot;,&quot;sans-serif&quot;;m=\r\nso-fareast-font-family:&quot;Times New Roman&quot;;color:#244061;mso-ansi-l=\r\nanguage:EN-IN\" lang=3D\"EN-IN\"><br>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">&nbsp;</span><span style=3D\"font-size:10.0pt;font-family=\r\n:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Tim=\r\nes New Roman&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\"><b=\r\nr>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">We would like to help\r\nyou with your business needs and give you a website that works on the web. =\r\nIf\r\nyou=E2=80=99re interested, would it be okay if we send you a few ideas alon=\r\ng with our\r\nportfolio and client testimonials for your perusal?</span><span style=3D\"fo=\r\nnt-size:10.0pt;font-family:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-far=\r\neast-font-family:&quot;Times New Roman&quot;;color:#244061;mso-ansi-languag=\r\ne:EN-IN\" lang=3D\"EN-IN\"><br>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">&nbsp;</span><span style=3D\"font-size:10.0pt;font-family=\r\n:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Tim=\r\nes New Roman&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\"><b=\r\nr>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">We look forward to\r\nhearing from you!</span><span style=3D\"font-size:10.0pt;font-family:&quot;A=\r\nrial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New R=\r\noman&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\"><br>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">&nbsp;</span><span style=3D\"font-size:10.0pt;font-family=\r\n:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Tim=\r\nes New Roman&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\"><b=\r\nr>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">Thanks &amp; Regards</span><span style=3D\"font-size:10.0=\r\npt;font-family:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-fa=\r\nmily:&quot;Times New Roman&quot;;color:#244061;mso-ansi-language:EN-IN\" lan=\r\ng=3D\"EN-IN\"><span style=3D\"mso-spacerun:yes\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span><=\r\n/span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quot=\r\n;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-b=\r\nidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-I=\r\nN\" lang=3D\"EN-IN\"><br style=3D\"mso-special-character:line-break\">\r\n<br style=3D\"mso-special-character:line-break\">\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Segoe UI&quot;,&qu=\r\not;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;col=\r\nor:#244061;background:#F3F3F3;mso-ansi-language:EN-IN\" lang=3D\"EN-IN\"></spa=\r\nn></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal;background:white\"><span style=3D\"font-size:10.0pt;font-fa=\r\nmily:&quot;Segoe UI&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&q=\r\nuot;Times New Roman&quot;;color:#244061;background:#F3F3F3;mso-ansi-languag=\r\ne:EN-IN\" lang=3D\"EN-IN\">Kul<font size=3D\"2\"><font face=3D\"Arial, Helvetica,=\r\n sans-serif\">deep</font></font></span><span style=3D\"font-size:12.0pt;font-=\r\nfamily:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&qu=\r\not;Times New Roman&quot;;color:#222222\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal;background:white\"><span style=3D\"font-size:10.0pt;font-fa=\r\nmily:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot=\r\n;Times New Roman&quot;;color:#244061;mso-ansi-language:EN-IN\" lang=3D\"EN-IN=\r\n\"><br>\r\n\r\n</span><span style=3D\"font-size:10.0pt;font-family:&quot;Verdana&quot;,&quo=\r\nt;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-=\r\nbidi-font-family:Arial;color:#244061;background:white;mso-ansi-language:EN-=\r\nIN\" lang=3D\"EN-IN\">Online Marketing\r\nConsultant</span><span style=3D\"font-size:12.0pt;font-family:&quot;Arial&qu=\r\not;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&qu=\r\not;;color:#222222\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal;background:white\"><span style=3D\"font-size:12.0pt;font-fa=\r\nmily:&quot;Arial&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot=\r\n;Times New Roman&quot;;color:#222222;mso-ansi-language:EN-IN\" lang=3D\"EN-IN=\r\n\">&nbsp;</span><span style=3D\"font-size:12.0pt;font-family:&quot;Arial&quot=\r\n;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New Roman&quot=\r\n;;color:#222222\"></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\">&nbsp;</div>\r\n\r\n\r\n</div>\r\n\r\n------=_Part_279359_1034045758.1557833290399--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('16', 'web design <design.web52@aol.com> - design.web52@aol.com', '10015', '1', NULL, 'Open Source Development - (WordPress, Joomla, Drupal, Cake PHP Development)', '\n<div style=\"font:10pt \'Helvetica Neue\';\">\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">Hello,</span><p></p></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;\"><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">I hope you are having a great day!!</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">We are a 10 Year old ISO certified company that\nspecializes in Web design, Development and Mobile Application Development\nCompany. Having successfully delivered 1000+ projects, we offer a wide range of\nInternet- Related outsourcing services to our clients all around the globe at\ncompetitive prices.</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">Here take a look what we can help you with:</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n<br />\n\n</span><span lang=\"en-in\" style=\"font-size:12pt;font-family:\'Times New Roman\', serif;color:#17365D;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:2.25pt;margin-left:12pt;text-indent:-.25in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Symbol;color:#17365D;\" xml:lang=\"en-in\">·<span style=\"font-size:7pt;line-height:normal;font-family:\'Times New Roman\';\">        \n</span></span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">UI Engineering (Conversion from\nPSD to Word Press, Joomla, Drupal, Concrete 5, Modx, Typo3)</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:2.25pt;margin-left:12pt;text-indent:-.25in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Symbol;color:#17365D;\" xml:lang=\"en-in\">·<span style=\"font-size:7pt;line-height:normal;font-family:\'Times New Roman\';\">        \n</span></span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Responsive Design (HTML5 &amp;\nCSS3)</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:2.25pt;margin-left:12pt;text-indent:-.25in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Symbol;color:#17365D;\" xml:lang=\"en-in\">·<span style=\"font-size:7pt;line-height:normal;font-family:\'Times New Roman\';\">        \n</span></span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Ecommerce Development- (Magento,\nWoo-commerce, CS cart, OS commerce, Shopify, Zen cart, Prestashop)</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:2.25pt;margin-left:12pt;text-indent:-.25in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Symbol;color:#17365D;\" xml:lang=\"en-in\">·<span style=\"font-size:7pt;line-height:normal;font-family:\'Times New Roman\';\">        \n</span></span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Framework [Cake PHP, code\nigniter, Zend Framework]</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:2.25pt;margin-left:12pt;text-indent:-.25in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Symbol;color:#17365D;\" xml:lang=\"en-in\">·<span style=\"font-size:7pt;line-height:normal;font-family:\'Times New Roman\';\">        \n</span></span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Search Engine Optimization\n(SEO)/Social Media Optimization (SMO)/Pay per click (PPC)</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"MsoNormal\" style=\"margin-top:0in;margin-right:0in;margin-bottom:2.25pt;margin-left:12pt;text-indent:-.25in;line-height:16pt;background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Symbol;color:#17365D;\" xml:lang=\"en-in\">·<span style=\"font-size:7pt;line-height:normal;font-family:\'Times New Roman\';\">        \n</span></span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#17365D;\" xml:lang=\"en-in\">Logo Design/Graphic Design</span><span lang=\"en-in\" style=\"font-size:11.5pt;color:#17365D;\" xml:lang=\"en-in\"></span><p></p></div>\n\n\n\n<div class=\"MsoNormal\"><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\"> </span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">What’s more, you can hire our web\nveterans who are well-trained and have in-depth expertise across varied areas\nincluding HTML 5, CSS, PHP, My SQL, CMS, Adobe Photoshop, Payment Gateway\nIntegration and other key business areas.</span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\"> </span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">We would like to help you with\nyour business needs and give you a website that works on the web. If you’re\ninterested, would it be okay if we send you a few ideas along with our\nportfolio and client testimonials for your perusal?</span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\"> </span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">We look forward to hearing from\nyou!</span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\"> </span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">Thanks &amp; Regards</span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\"> </span><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10.5pt;line-height:115%;font-family:\'Segoe UI\', \'sans-serif\';color:#17365D;background:#F3F3F3;\" xml:lang=\"en-in\">Rohit</span><p></p></div>\n\n\n\n<div class=\"MsoNormal\"><span lang=\"en-in\" style=\"font-size:11.5pt;line-height:115%;color:#17365D;\" xml:lang=\"en-in\"><br />\n\n</span><span lang=\"en-in\" style=\"font-size:10pt;line-height:115%;font-family:Verdana, \'sans-serif\';color:#17365D;background:#FFFFFF;\" xml:lang=\"en-in\">Online Marketing Consultant</span><span lang=\"en-in\" style=\"color:#17365D;\" xml:lang=\"en-in\"></span><p></p></div>\n</div>\n', 'closed', '0', '0', '1', '0', NULL, '1557917102', '1', '1', '0', 'Return-Path: <design.web52@aol.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id SAxCHjXt21w/TQoAMoQ/pw\r\n	(envelope-from <design.web52@aol.com>)\r\n	for <info@apusseo.com>; Wed, 15 May 2019 13:43:01 +0300\r\nReturn-path: <design.web52@aol.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Wed, 15 May 2019 13:43:01 +0300\r\nReceived: from sonic304-56.consmr.mail.bf2.yahoo.com ([74.6.128.31]:40501)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.91)\r\n	(envelope-from <design.web52@aol.com>)\r\n	id 1hQrNF-002pfP-6p\r\n	for info@apusseo.com; Wed, 15 May 2019 13:43:01 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=aol.com; s=a2048; t=1557916979; bh=W3yhrgdU8naTRkIHW+eoMSoajJw1JSR4ZH2KJJOMoVs=; h=Date:From:Subject:References:From:Subject; b=rmEb+iBL1zbxWj9UkHEsFYLilolWGNoweFVVd1VGvtL/zz8h8bnWlWVY3cIION6TjnKriGhp5sj6NZ+gsbVAEGTRW7pGjBpSGloDaqGRQiQoqwd57/3YowpjEx4YkAr81AyHtt4g/2oNgnQoYjAJGThgFjaPCHOX64upALmLhx7aP5/kNzlq7SscxTMtx5yNeKTK96Yl78d31RKtqXo5WwqwN1Vg+Oln4dE1r8BkRCsTY7Rsh6569/HV0hoGt5prrWAu09MFT4oD6jwCwUyw9Ah5jzr4a140/u3XxKYixYOvCnRimTu4EaKzE67D6lilFk7XgwPoWLM2RtqA2xxE9A==\r\nX-YMail-OSG: 9fcwGQ0VM1lm2vO33E7PQ9fBahtNoZnU1ctACMDF_xPmLYZiRZm2qL7KzMHUn7q\r\n 4dg13cUgqHUjV75HyIZ1zxTXV7HnkDeNEKfHywNaQozlkY0K0si_htaBicGPWN0QxgVrIIUnTrt2\r\n hlk0nfar5QRk7NaSvLOQWTB882MNM8sjroktAIGTu0MtrXEJ92_nGLi9FUw69rA_MFhWjPgbknRj\r\n mkOWoQYGGTThmca6EV0d.E5hSlY.uQFYV4y.50C97Vc6NXM1U17Kuw9lFb3eAFsTnODJXG6MYwPK\r\n S0jdb5_caFkG.U.D2f75j2iZ.4hrcp4BHvK_K1iS94UbN3ey3B0FJEQ57g1UHA62tSwTaQVyAH.u\r\n HLhZA37.HF8x67xeV5VU9pe4mK6wRaBz_k91PvRevZDmuhKIUApErEIpdDrWG24bFxFz2PpfkWw7\r\n GrT764ZPq81kiIcBLsRI6nV6cFZHTHMCkcNpS5kiw0q0kq3.VLZcAqbnCxpvnx1.pCaUfruw28Gc\r\n uZqmMgkKM380fc5zpQ28aqN_xchQfHXu7hWCIRklJoT4uObTWaTlhR0BVtgS6GtIZnzn4T.EIDd_\r\n Uk3FYmkPFW8LzKMLZ0hkQAXgnW9m7SP8EbI.mvCZpHax_aOWH.SyY8JS0O1cDnQSbYDjV7Q8pbXd\r\n xWSYCIllBxj2QV8r2y3M8cfinB0t26n_quw5KE5Lcz4qyPiJ6orPKylb1YwSpe.Rb2P9QRe2gUyj\r\n CBkrxGAxFIv5aP7Lsx7nff5FyXbsjMygpTZC.QjeOV0C6zMLJ0.VHb3QbfbzNtUDYM4tEaDrl.kY\r\n 5.XtTCycLZKflBuyc9UwEEh9GlIywS42VHe_qA9VT1QONzw0AI6GDXecMtB8YsQds1JCScj4SW49\r\n LjoumDB55Zoufm3b1nSq2WXpgiEs.FEAbP._j4vTNcC3tMmLc5WWs6KLKqf3SAIBAbt8BGS1Vk8X\r\n uj0pL7eATrzfFlhnqYvUQjTeOZMGzJ0jm55D0q5HfaaLp.bYcE2xz7JPnIblcp87kF4zaeOCgD9y\r\n A.kPoxJ8J06_FlqfIhjm5e9938AEJDGODaeAC18.4FILTDj9IE7d.po4NEjb7dTtOY_oj5LyXUu0\r\n H5h1rzKLEjHLZESNpvOZ0XaPrOUDxQEON1L91wV2soXO30a62pW3NlYCDv.N_\r\nReceived: from sonic.gate.mail.ne1.yahoo.com by sonic304.consmr.mail.bf2.yahoo.com with HTTP; Wed, 15 May 2019 10:42:59 +0000\r\nDate: Wed, 15 May 2019 10:42:54 +0000 (UTC)\r\nFrom: web design <design.web52@aol.com>\r\nMessage-ID: <607143921.756955.1557916974982@mail.yahoo.com>\r\nSubject: Open Source Development - (WordPress, Joomla, Drupal, Cake PHP\r\n Development)\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_756954_466960068.1557916974980\"\r\nReferences: <607143921.756955.1557916974982.ref@mail.yahoo.com>\r\nX-Mailer: WebService/1.1.13634 aolwebmail Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36\r\nContent-Length: 22176\r\n\r\n ------=_Part_756954_466960068.1557916974980\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHello,\r\n\r\n\r\nI hope you are having a great day!!\r\nWe are a 10 Year old ISO certified company thatspecializes in Web design, D=\r\nevelopment and Mobile Application DevelopmentCompany. Having successfully d=\r\nelivered 1000+ projects, we offer a wide range ofInternet- Related outsourc=\r\ning services to our clients all around the globe atcompetitive prices.\r\nHere take a look what we can help you with:\r\n\r\n\r\n\r\n=C2=B7=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0UI Engineering (Conve=\r\nrsion fromPSD to Word Press, Joomla, Drupal, Concrete 5, Modx, Typo3)\r\n\r\n=C2=B7=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0Responsive Design (HT=\r\nML5 &CSS3)\r\n\r\n=C2=B7=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0Ecommerce Development=\r\n- (Magento,Woo-commerce, CS cart, OS commerce, Shopify, Zen cart, Prestasho=\r\np)\r\n\r\n=C2=B7=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0Framework [Cake PHP, =\r\ncodeigniter, Zend Framework]\r\n\r\n=C2=B7=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0Search Engine Optimiz=\r\nation(SEO)/Social Media Optimization (SMO)/Pay per click (PPC)\r\n\r\n=C2=B7=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0=C2=A0Logo Design/Graphic D=\r\nesign\r\n\r\n=C2=A0\r\nWhat=E2=80=99s more, you can hire our webveterans who are well-trained and =\r\nhave in-depth expertise across varied areasincluding HTML 5, CSS, PHP, My S=\r\nQL, CMS, Adobe Photoshop, Payment GatewayIntegration and other key business=\r\n areas.\r\n=C2=A0\r\nWe would like to help you withyour business needs and give you a website th=\r\nat works on the web. If you=E2=80=99reinterested, would it be okay if we se=\r\nnd you a few ideas along with ourportfolio and client testimonials for your=\r\n perusal?\r\n=C2=A0\r\nWe look forward to hearing fromyou!\r\n=C2=A0\r\nThanks & Regards\r\n=C2=A0\r\n\r\nRohit\r\n\r\n\r\nOnline Marketing Consultant\r\n\r\n\r\n------=_Part_756954_466960068.1557916974980\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n\r\n<div style=3D\"color:;font: 10pt Helvetica Neue;\">\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal\"><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;font-fami=\r\nly:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot=\r\n;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;col=\r\nor:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;mso-far=\r\neast-language:EN-IN\">Hello,<o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-bottom:0in;margin-bottom:.0001pt;l=\r\nine-height:normal\"><span lang=3D\"EN-IN\" style=3D\"font-size:11.5pt;mso-ascii=\r\n-font-family:Calibri;mso-fareast-font-family:&quot;Times New Roman&quot;;ms=\r\no-hansi-font-family:Calibri;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-languag=\r\ne:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;font-family:&quot;Ver=\r\ndana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New R=\r\noman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;m=\r\nso-themecolor:text2;mso-themeshade:191;background:white;mso-fareast-languag=\r\ne:EN-IN\">I hope you are having a great day!!</span><span lang=3D\"EN-IN\" sty=\r\nle=3D\"font-size:11.5pt;mso-ascii-font-family:Calibri;mso-fareast-font-famil=\r\ny:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;mso-bidi-font-f=\r\namily:&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;mso-th=\r\nemeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;font-family:&quot;Ver=\r\ndana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New R=\r\noman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;m=\r\nso-themecolor:text2;mso-themeshade:191;background:white;mso-fareast-languag=\r\ne:EN-IN\">We are a 10 Year old ISO certified company that\r\nspecializes in Web design, Development and Mobile Application Development\r\nCompany. Having successfully delivered 1000+ projects, we offer a wide rang=\r\ne of\r\nInternet- Related outsourcing services to our clients all around the globe =\r\nat\r\ncompetitive prices.</span><span lang=3D\"EN-IN\" style=3D\"font-size:11.5pt;ms=\r\no-ascii-font-family:Calibri;mso-fareast-font-family:&quot;Times New Roman&q=\r\nuot;;mso-hansi-font-family:Calibri;mso-bidi-font-family:&quot;Times New Rom=\r\nan&quot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-=\r\nlanguage:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;font-family:&quot;Ver=\r\ndana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:&quot;Times New R=\r\noman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;m=\r\nso-themecolor:text2;mso-themeshade:191;background:white;mso-fareast-languag=\r\ne:EN-IN\">Here take a look what we can help you with:</span><span lang=3D\"EN=\r\n-IN\" style=3D\"font-size:11.5pt;mso-ascii-font-family:Calibri;mso-fareast-fo=\r\nnt-family:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;mso-bid=\r\ni-font-family:&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text=\r\n2;mso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n<!--[if !supportLineBreakNewLine]--><br>\r\n\r\n<!--[endif]--></span><span lang=3D\"EN-IN\" style=3D\"font-size:12.0pt;font-fa=\r\nmily:&quot;Times New Roman&quot;,&quot;serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;mso-themesha=\r\nde:191;mso-fareast-language:EN-IN\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-top:0in;margin-right:0in;margin-bo=\r\nttom:2.25pt;margin-left:12.0pt;text-indent:-.25in;line-height:16.0pt;mso-li=\r\nst:l0 level1 lfo1;tab-stops:list .5in;background:white\"><!--[if !supportLis=\r\nts]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;mso-bidi-font-size:11.=\r\n5pt;font-family:Symbol;mso-fareast-font-family:Symbol;mso-bidi-font-family:=\r\nSymbol;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-la=\r\nnguage:EN-IN\">=C2=B7<span style=3D\"font-variant-numeric: normal; font-varia=\r\nnt-east-asian: normal; font-stretch: normal; font-size: 7pt; line-height: n=\r\normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&=\r\nnbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;=\r\nfont-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-fam=\r\nily:&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&=\r\nquot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-lan=\r\nguage:EN-IN\">UI Engineering (Conversion from\r\nPSD to Word Press, Joomla, Drupal, Concrete 5, Modx, Typo3)</span><span lan=\r\ng=3D\"EN-IN\" style=3D\"font-size:11.5pt;mso-ascii-font-family:Calibri;mso-far=\r\neast-font-family:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;=\r\nmso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;mso-themecol=\r\nor:text2;mso-themeshade:191;mso-fareast-language:EN-IN\"><o:p></o:p></span><=\r\n/div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-top:0in;margin-right:0in;margin-bo=\r\nttom:2.25pt;margin-left:12.0pt;text-indent:-.25in;line-height:16.0pt;mso-li=\r\nst:l0 level1 lfo1;tab-stops:list .5in;background:white\"><!--[if !supportLis=\r\nts]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;mso-bidi-font-size:11.=\r\n5pt;font-family:Symbol;mso-fareast-font-family:Symbol;mso-bidi-font-family:=\r\nSymbol;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-la=\r\nnguage:EN-IN\">=C2=B7<span style=3D\"font-variant-numeric: normal; font-varia=\r\nnt-east-asian: normal; font-stretch: normal; font-size: 7pt; line-height: n=\r\normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&=\r\nnbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;=\r\nfont-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-fam=\r\nily:&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&=\r\nquot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-lan=\r\nguage:EN-IN\">Responsive Design (HTML5 &amp;\r\nCSS3)</span><span lang=3D\"EN-IN\" style=3D\"font-size:11.5pt;mso-ascii-font-f=\r\namily:Calibri;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-hansi=\r\n-font-family:Calibri;mso-bidi-font-family:&quot;Times New Roman&quot;;color=\r\n:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-language:EN-IN=\r\n\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-top:0in;margin-right:0in;margin-bo=\r\nttom:2.25pt;margin-left:12.0pt;text-indent:-.25in;line-height:16.0pt;mso-li=\r\nst:l0 level1 lfo1;tab-stops:list .5in;background:white\"><!--[if !supportLis=\r\nts]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;mso-bidi-font-size:11.=\r\n5pt;font-family:Symbol;mso-fareast-font-family:Symbol;mso-bidi-font-family:=\r\nSymbol;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-la=\r\nnguage:EN-IN\">=C2=B7<span style=3D\"font-variant-numeric: normal; font-varia=\r\nnt-east-asian: normal; font-stretch: normal; font-size: 7pt; line-height: n=\r\normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&=\r\nnbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;=\r\nfont-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-fam=\r\nily:&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&=\r\nquot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-lan=\r\nguage:EN-IN\">Ecommerce Development- (Magento,\r\nWoo-commerce, CS cart, OS commerce, Shopify, Zen cart, Prestashop)</span><s=\r\npan lang=3D\"EN-IN\" style=3D\"font-size:11.5pt;mso-ascii-font-family:Calibri;=\r\nmso-fareast-font-family:&quot;Times New Roman&quot;;mso-hansi-font-family:C=\r\nalibri;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;mso-t=\r\nhemecolor:text2;mso-themeshade:191;mso-fareast-language:EN-IN\"><o:p></o:p><=\r\n/span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-top:0in;margin-right:0in;margin-bo=\r\nttom:2.25pt;margin-left:12.0pt;text-indent:-.25in;line-height:16.0pt;mso-li=\r\nst:l0 level1 lfo1;tab-stops:list .5in;background:white\"><!--[if !supportLis=\r\nts]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;mso-bidi-font-size:11.=\r\n5pt;font-family:Symbol;mso-fareast-font-family:Symbol;mso-bidi-font-family:=\r\nSymbol;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-la=\r\nnguage:EN-IN\">=C2=B7<span style=3D\"font-variant-numeric: normal; font-varia=\r\nnt-east-asian: normal; font-stretch: normal; font-size: 7pt; line-height: n=\r\normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&=\r\nnbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;=\r\nfont-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-fam=\r\nily:&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&=\r\nquot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-lan=\r\nguage:EN-IN\">Framework [Cake PHP, code\r\nigniter, Zend Framework]</span><span lang=3D\"EN-IN\" style=3D\"font-size:11.5=\r\npt;mso-ascii-font-family:Calibri;mso-fareast-font-family:&quot;Times New Ro=\r\nman&quot;;mso-hansi-font-family:Calibri;mso-bidi-font-family:&quot;Times Ne=\r\nw Roman&quot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-far=\r\neast-language:EN-IN\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-top:0in;margin-right:0in;margin-bo=\r\nttom:2.25pt;margin-left:12.0pt;text-indent:-.25in;line-height:16.0pt;mso-li=\r\nst:l0 level1 lfo1;tab-stops:list .5in;background:white\"><!--[if !supportLis=\r\nts]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;mso-bidi-font-size:11.=\r\n5pt;font-family:Symbol;mso-fareast-font-family:Symbol;mso-bidi-font-family:=\r\nSymbol;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-la=\r\nnguage:EN-IN\">=C2=B7<span style=3D\"font-variant-numeric: normal; font-varia=\r\nnt-east-asian: normal; font-stretch: normal; font-size: 7pt; line-height: n=\r\normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&=\r\nnbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;=\r\nfont-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-fam=\r\nily:&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&=\r\nquot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-lan=\r\nguage:EN-IN\">Search Engine Optimization\r\n(SEO)/Social Media Optimization (SMO)/Pay per click (PPC)</span><span lang=\r\n=3D\"EN-IN\" style=3D\"font-size:11.5pt;mso-ascii-font-family:Calibri;mso-fare=\r\nast-font-family:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;m=\r\nso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;mso-themecolo=\r\nr:text2;mso-themeshade:191;mso-fareast-language:EN-IN\"><o:p></o:p></span></=\r\ndiv>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\" style=3D\"margin-top:0in;margin-right:0in;margin-bo=\r\nttom:2.25pt;margin-left:12.0pt;text-indent:-.25in;line-height:16.0pt;mso-li=\r\nst:l0 level1 lfo1;tab-stops:list .5in;background:white\"><!--[if !supportLis=\r\nts]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;mso-bidi-font-size:11.=\r\n5pt;font-family:Symbol;mso-fareast-font-family:Symbol;mso-bidi-font-family:=\r\nSymbol;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-la=\r\nnguage:EN-IN\">=C2=B7<span style=3D\"font-variant-numeric: normal; font-varia=\r\nnt-east-asian: normal; font-stretch: normal; font-size: 7pt; line-height: n=\r\normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&=\r\nnbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;=\r\nfont-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-fam=\r\nily:&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&=\r\nquot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareast-lan=\r\nguage:EN-IN\">Logo Design/Graphic Design</span><span lang=3D\"EN-IN\" style=3D=\r\n\"font-size:11.5pt;mso-ascii-font-family:Calibri;mso-fareast-font-family:&qu=\r\not;Times New Roman&quot;;mso-hansi-font-family:Calibri;mso-bidi-font-family=\r\n:&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;mso-themesh=\r\nade:191;mso-fareast-language:EN-IN\"><o:p></o:p></span></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\"><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;lin=\r\ne-height:115%;font-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fa=\r\nreast-font-family:&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Ti=\r\nmes New Roman&quot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;b=\r\nackground:white;mso-fareast-language:EN-IN\">&nbsp;</span><span lang=3D\"EN-I=\r\nN\" style=3D\"font-size:11.5pt;line-height:115%;mso-ascii-font-family:Calibri=\r\n;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-hansi-font-family:=\r\nCalibri;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;mso-=\r\nthemecolor:text2;mso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">What=E2=80=99s more, you can hire our web\r\nveterans who are well-trained and have in-depth expertise across varied are=\r\nas\r\nincluding HTML 5, CSS, PHP, My SQL, CMS, Adobe Photoshop, Payment Gateway\r\nIntegration and other key business areas.</span><span lang=3D\"EN-IN\" style=\r\n=3D\"font-size:11.5pt;line-height:115%;mso-ascii-font-family:Calibri;mso-far=\r\neast-font-family:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;=\r\nmso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;mso-themecol=\r\nor:text2;mso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">&nbsp;</span><span lang=3D\"EN-IN\" style=3D\"font-s=\r\nize:11.5pt;line-height:115%;mso-ascii-font-family:Calibri;mso-fareast-font-=\r\nfamily:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;mso-bidi-f=\r\nont-family:&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;m=\r\nso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">We would like to help you with\r\nyour business needs and give you a website that works on the web. If you=E2=\r\n=80=99re\r\ninterested, would it be okay if we send you a few ideas along with our\r\nportfolio and client testimonials for your perusal?</span><span lang=3D\"EN-=\r\nIN\" style=3D\"font-size:11.5pt;line-height:115%;mso-ascii-font-family:Calibr=\r\ni;mso-fareast-font-family:&quot;Times New Roman&quot;;mso-hansi-font-family=\r\n:Calibri;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;mso=\r\n-themecolor:text2;mso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">&nbsp;</span><span lang=3D\"EN-IN\" style=3D\"font-s=\r\nize:11.5pt;line-height:115%;mso-ascii-font-family:Calibri;mso-fareast-font-=\r\nfamily:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;mso-bidi-f=\r\nont-family:&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;m=\r\nso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">We look forward to hearing from\r\nyou!</span><span lang=3D\"EN-IN\" style=3D\"font-size:11.5pt;line-height:115%;=\r\nmso-ascii-font-family:Calibri;mso-fareast-font-family:&quot;Times New Roman=\r\n&quot;;mso-hansi-font-family:Calibri;mso-bidi-font-family:&quot;Times New R=\r\noman&quot;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;mso-fareas=\r\nt-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">&nbsp;</span><span lang=3D\"EN-IN\" style=3D\"font-s=\r\nize:11.5pt;line-height:115%;mso-ascii-font-family:Calibri;mso-fareast-font-=\r\nfamily:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;mso-bidi-f=\r\nont-family:&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;m=\r\nso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">Thanks &amp; Regards</span><span lang=3D\"EN-IN\" s=\r\ntyle=3D\"font-size:11.5pt;line-height:115%;mso-ascii-font-family:Calibri;mso=\r\n-fareast-font-family:&quot;Times New Roman&quot;;mso-hansi-font-family:Cali=\r\nbri;mso-bidi-font-family:&quot;Times New Roman&quot;;color:#17365D;mso-them=\r\necolor:text2;mso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">&nbsp;</span><span lang=3D\"EN-IN\" style=3D\"font-s=\r\nize:11.5pt;line-height:115%;mso-ascii-font-family:Calibri;mso-fareast-font-=\r\nfamily:&quot;Times New Roman&quot;;mso-hansi-font-family:Calibri;mso-bidi-f=\r\nont-family:&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;m=\r\nso-themeshade:191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.5pt;line-height:115%;font=\r\n-family:&quot;Segoe UI&quot;,&quot;sans-serif&quot;;mso-fareast-font-family=\r\n:&quot;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;mso-themesh=\r\nade:191;background:#F3F3F3;mso-fareast-language:EN-IN\">Rohit<o:p></o:p></sp=\r\nan></div>\r\n\r\n\r\n\r\n<div class=3D\"MsoNormal\"><span lang=3D\"EN-IN\" style=3D\"font-size:11.5pt;lin=\r\ne-height:115%;mso-ascii-font-family:Calibri;mso-fareast-font-family:&quot;T=\r\nimes New Roman&quot;;mso-hansi-font-family:Calibri;mso-bidi-font-family:&qu=\r\not;Times New Roman&quot;;color:#17365D;mso-themecolor:text2;mso-themeshade:=\r\n191;mso-fareast-language:EN-IN\"><br>\r\n\r\n</span><span lang=3D\"EN-IN\" style=3D\"font-size:10.0pt;line-height:115%;font=\r\n-family:&quot;Verdana&quot;,&quot;sans-serif&quot;;mso-fareast-font-family:=\r\n&quot;Times New Roman&quot;;mso-bidi-font-family:&quot;Times New Roman&quot=\r\n;;color:#17365D;mso-themecolor:text2;mso-themeshade:191;background:white;ms=\r\no-fareast-language:EN-IN\">Online Marketing Consultant</span><span lang=3D\"E=\r\nN-IN\" style=3D\"color:#17365D;mso-themecolor:text2;mso-themeshade:191\"><o:p>=\r\n</o:p></span></div>\r\n</div>\r\n\r\n------=_Part_756954_466960068.1557916974980--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('17', 'Ajay Kumar <ajay@croxtechnologies.biz> - ajay@croxtechnologies.biz', '10016', '1', NULL, 'Digital Marketing/ PHP, Magento, Drupal, E-Commerce .etc apusseo.com', '<p><font color=\"#0000a0\" face=\"Calibri\">Hi Company Director</font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\">I apologize for my cold outreach and I hope You\'re doing well.</font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\">I work for a leading Website Design / Apps Development Company based out in India at a Minimum price by experts, where you won\'t compromise the quality too.</font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\"><strong>Our Creative Services Cover the Following Areas:-</strong></font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\"><strong> <font color=\"#008080\">Website Development</font> (Custom Website Development, PHP Development, Ajax Programming) etc.<br /> <font color=\"#008080\">Website Designing</font> (HTML Designing, Corporate Website Design, PSD to XHTML/HTML) etc.<br /> <font color=\"#008080\">Open Source Customization/ CMS</font> (Joomla, Drupal, Wordpress) etc.<br /> <font color=\"#008080\">Ecommerce Website Development</font> (Magento, OS Commerce, Zen Cart integration) etc.<br /> <font color=\"#008080\">Web Programming Services</font> (PHP MySQL Development, PHP Frameworks, JavaScript Frameworks) etc..<br /> <font color=\"#008080\">Digital Marketing Services</font> (SEO, SMO, PPC and Guest Blogging) etc.</strong></font></p><br />\n<p><font color=\"#008080\" face=\"Calibri\"><strong>Why Choose Us:-</strong></font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\"><strong> All of our design are 100% custom made. No template used.<br /> Unlimited revisions until you are 100% satisfied.<br /> Pre-launch testing in all major web browsers including IE6, IE7, Firefox, Safari etc.<br /> Testing on both Mac and Windows.<br /> We have over 7 years of experience.<br /> With over 60+ experts strength, we have a pool of talent.<br /> Our rates are very competitive.<br /> 24 Hours Support from Monday to Friday.<br /> Phone, email, instant message, Live chat, any way you want to talk, we\'re here for you.</strong></font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\">Do let me know if you are willing to discuss a possible redesigning/redevelopment of your website or designing new website. I can send you more details on the packages/action/Portfolio/past work details.</font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\"><strong>I look forward to your reply.</strong></font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\"><strong>Kinds Regards,</strong></font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\"><strong>Ajay Kumar</strong></font></p><br />\n<p><font color=\"#0000a0\" face=\"Calibri\"><strong>Crox Technologies Group Inc.</strong></font></p><br />\n<p><font color=\"#0000a0\" size=\"2\" face=\"Calibri\"><em><strong>Recipients ID:</strong> Email info@apusseo.com Website apusseo.com</em><br /><strong>=================================================================</strong><br /><strong>Disclaimer:</strong> If you are not the intended recipient, please contact the sender by reply e-mail and destroy all copies of the original message. To stop receiving further mail please reply with <font color=\"#800000\">\"Remove\"</font> in the subject line. We are sorry for the inconvenience.</font></p>', 'closed', '0', '0', '1', '0', NULL, '1558565705', '1', '1', '0', 'Return-Path: <ajay@croxtechnologies.biz>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id BkEVMfHS5Vx28wwAMoQ/pw\r\n	(envelope-from <ajay@croxtechnologies.biz>)\r\n	for <info@apusseo.com>; Thu, 23 May 2019 01:53:37 +0300\r\nReturn-path: <ajay@croxtechnologies.biz>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Thu, 23 May 2019 01:53:37 +0300\r\nReceived: from [103.127.72.171] (port=51312 helo=localhost.localdomain.com)\r\n	by cp.euwebhoster.com with esmtp (Exim 4.91)\r\n	(envelope-from <ajay@croxtechnologies.biz>)\r\n	id 1hTa76-003YnU-MM\r\n	for info@apusseo.com; Thu, 23 May 2019 01:53:37 +0300\r\nX-Sender: \"Ajay Kumar\"\r\n <ajay@croxtechnologies.biz>\r\nX-Receiver: info@apusseo.com\r\nMIME-Version: 1.0\r\nFrom: \"Ajay Kumar\"\r\n <ajay@croxtechnologies.biz>\r\nTo: info@apusseo.com\r\nReply-To: \"Ajay Kumar\"\r\n <ajayweb2019@gmail.com>\r\nDate: 22 May 2019 15:29:49 -0700\r\nSubject: Digital Marketing/ PHP, Magento, Drupal, E-Commerce .etc apusseo.com\r\nContent-Type: text/html; charset=Windows-1252\r\nContent-Transfer-Encoding: quoted-printable\r\nPriority: normal\r\nImportance: High\r\n\r\n <BODY scroll=3Dauto><P><FONT color=3D#0000a0 face=3DCalibri>Hi Co=\r\nmpany Director</FONT></P>=0D=0A<P><FONT color=3D#0000a0 face=3DCa=\r\nlibri>I apologize for my cold outreach and I hope You\'re doing we=\r\nll.</FONT></P>=0D=0A<P><FONT color=3D#0000a0 face=3DCalibri>I wor=\r\nk for a leading Website Design / Apps Development Company based o=\r\nut in India at a Minimum price by experts, where you won\'t compro=\r\nmise the quality too.</FONT></P>=0D=0A<P><FONT color=3D#0000a0 fa=\r\nce=3DCalibri><STRONG>Our Creative Services Cover the Following Ar=\r\neas:-</STRONG></FONT></P>=0D=0A<P><FONT color=3D#0000a0 face=3DCa=\r\nlibri><STRONG>=95 <FONT color=3Dteal>Website Development</FONT> (=\r\nCustom Website Development, PHP Development, Ajax Programming) et=\r\nc.<BR>=95 <FONT color=3Dteal>Website Designing</FONT> (HTML Desig=\r\nning, Corporate Website Design, PSD to XHTML/HTML) etc.<BR>=95 <F=\r\nONT color=3Dteal>Open Source Customization/ CMS</FONT> (Joomla, D=\r\nrupal, Wordpress) etc.<BR>=95 <FONT color=3Dteal>Ecommerce Websit=\r\ne Development</FONT> (Magento, OS Commerce, Zen Cart integration)=\r\n etc.<BR>=95 <FONT color=3Dteal>Web Programming Services</FONT> (=\r\nPHP MySQL Development, PHP Frameworks, JavaScript Frameworks) etc=\r\n..<BR>=95 <FONT color=3Dteal>Digital Marketing Services</FONT> (SE=\r\nO, SMO, PPC and Guest Blogging) etc.</STRONG></FONT></P>=0D=0A<P>=\r\n<FONT color=3Dteal face=3DCalibri><STRONG>Why Choose Us:-</STRONG=\r\n></FONT></P>=0D=0A<P><FONT color=3D#0000a0 face=3DCalibri><STRONG=\r\n>=95 All of our design are 100% custom made. No template used.<BR=\r\n>=95 Unlimited revisions until you are 100% satisfied.<BR>=95 Pre=\r\n-launch testing in all major web browsers including IE6, IE7, Fir=\r\nefox, Safari etc.<BR>=95 Testing on both Mac and Windows.<BR>=95 =\r\nWe have over 7 years of experience.<BR>=95 With over 60+ experts =\r\nstrength, we have a pool of talent.<BR>=95 Our rates are very com=\r\npetitive.<BR>=95 24 Hours Support from Monday to Friday.<BR>=95 P=\r\nhone, email, instant message, Live chat, any way you want to talk=\r\n, we\'re here for you.</STRONG></FONT></P>=0D=0A<P><FONT color=3D#=\r\n0000a0 face=3DCalibri>Do let me know if you are willing to discus=\r\ns a possible redesigning/redevelopment of your website or designi=\r\nng new website. I can send you more details on the packages/actio=\r\nn/Portfolio/past work details.</FONT></P>=0D=0A<P><FONT color=3D#=\r\n0000a0 face=3DCalibri><STRONG>I look forward to your reply.</STRO=\r\nNG></FONT></P>=0D=0A<P><FONT color=3D#0000a0 face=3DCalibri><STRO=\r\nNG>Kinds Regards,</STRONG></FONT></P>=0D=0A<P><FONT color=3D#0000=\r\na0 face=3DCalibri><STRONG>Ajay Kumar</STRONG></FONT></P>=0D=0A<P>=\r\n<FONT color=3D#0000a0 face=3DCalibri><STRONG>Crox Technologies Gr=\r\noup Inc.</STRONG></FONT></P>=0D=0A<P><FONT color=3D#0000a0 size=3D=\r\n2 face=3DCalibri><EM><STRONG>Recipients ID:</STRONG> Email info@a=\r\npusseo.com Website apusseo.com</EM><BR><STRONG>=3D=3D=3D=3D=3D=3D=\r\n=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=\r\n=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=\r\n=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D=3D</STRONG><BR><STRONG=\r\n>Disclaimer:</STRONG> If you are not the intended recipient, plea=\r\nse contact the sender by reply e-mail and destroy all copies of t=\r\nhe original message. To stop receiving further mail please reply =\r\nwith <FONT color=3Dmaroon>\"Remove\"</FONT> in the subject line. We=\r\n are sorry for the inconvenience.</FONT></P></BODY>=0D=0A\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('18', 'Renaud Clarke <renaud@geekunique.co.uk> - renaud@geekunique.co.uk', '10017', '1', NULL, 'Off shore', '<div dir=\"ltr\"><div>Hello,</div><div><br /></div><div>We are looking to move our SEO work offshore. We love Latvia / Riga and would like to know more about if you could take all our clients on board?</div><div><br /></div><div>The factors:</div><div><ol><li>Skills and process</li><li>price (we want to make more money offshore!!<br /></li></ol></div><div><br /></div><div>Let\'s chat.<br /></div><div><div><br />-- <br /><div dir=\"ltr\" class=\"gmail_signature\"><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><div dir=\"ltr\"><table style=\"font-family:Arial;font-size:13px;color:rgb(139,149,151);\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody><tr><td><table style=\"font-family:Arial;\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody><tr><td><font face=\"Arial\" color=\"#666666\"><span style=\"font-size:20px;\"><b>Renaud Clarke</b></span></font><br /></td></tr><tr><td>Consultant</td></tr></tbody></table></td><td valign=\"top\"><img src=\"http://atelier-hosting.com/emailsig/spacer.png\" width=\"20\" height=\"8\" alt=\"spacer.png\" /></td><td><table style=\"font-family:Arial;\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody><tr><td><a href=\"https://twitter.com/renaudclarke\"><img src=\"http://atelier-hosting.com/emailsig/twitter.gif\" alt=\"\" /></a> <a href=\"https://www.linkedin.com/in/renaudclarke\"><img src=\"http://atelier-hosting.com/emailsig/linkedin.gif\" alt=\"\" /></a></td></tr></tbody></table></td></tr></tbody></table><br /><a href=\"http://www.geekunique.co.uk\"><img src=\"https://docs.google.com/a/geekunique.co.uk/uc?id=0Bw8CBspoxBwgTXZueG43ZGxOUXc&amp;export=download\" alt=\"http://www.geekunique.co.uk\" /></a><a href=\"https://www.foxnitro.com\"><img src=\"https://docs.google.com/uc?export=download&amp;id=1bpLMykLoPZ0h8RFdndGIv4pVHySdM7dY&amp;revid=0Bw8CBspoxBwgUThSQ3ZMUnlFVDZYZXVQS1l1L1VnMk1EWWNZPQ\" alt=\"https://www.foxnitro.com\" /></a><br /><br style=\"color:rgb(139,149,151);font-family:Arial;font-size:13px;\" /><font style=\"font-family:Arial;font-size:13px;\" color=\"#0b5394\">l:</font><span style=\"color:rgb(139,149,151);font-family:Arial;font-size:13px;\"> 0203 375 6927 </span><font style=\"font-family:Arial;font-size:13px;\" color=\"#c4c4c4\">|</font><span style=\"color:rgb(139,149,151);font-family:Arial;font-size:13px;\"> </span><font style=\"font-family:Arial;font-size:13px;\" color=\"#0b5394\"><span><font style=\"font-family:Arial;font-size:13px;\" color=\"#0b5394\">t:</font><span style=\"color:rgb(139,149,151);font-family:Arial;font-size:13px;\"> 0780 1234477 </span><font style=\"font-family:Arial;font-size:13px;\" color=\"#c4c4c4\">|</font><span style=\"color:rgb(139,149,151);font-family:Arial;font-size:13px;\"> </span></span>e</font><font style=\"font-family:Arial;font-size:13px;\" color=\"#b2005e\">:</font><span style=\"color:rgb(139,149,151);font-family:Arial;font-size:13px;\"> <a href=\"mailto:renaud@geekunique.co.uk\">renaud@geekunique.co.uk</a> </span><font style=\"font-family:Arial;font-size:13px;\" color=\"#c4c4c4\">|</font><span style=\"color:rgb(139,149,151);font-family:Arial;font-size:13px;\"> </span><font style=\"font-family:Arial;font-size:13px;\" color=\"#0b5394\">w:</font><span style=\"color:rgb(139,149,151);font-family:Arial;font-size:13px;\"> <a href=\"http://www.geekunique.co.uk\">www.geekunique.co.uk</a> </span><br /></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div></div>\n', 'new', '0', '0', '1', '0', NULL, '1560423303', '1', '1', '0', 'Return-Path: <renaud@geekunique.co.uk>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id g8lLIQYrAl23CwMAMoQ/pw\r\n	(envelope-from <renaud@geekunique.co.uk>)\r\n	for <info@apusseo.com>; Thu, 13 Jun 2019 13:52:54 +0300\r\nReturn-path: <renaud@geekunique.co.uk>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Thu, 13 Jun 2019 13:52:54 +0300\r\nReceived: from mail-wr1-f52.google.com ([209.85.221.52]:45538)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.92)\r\n	(envelope-from <renaud@geekunique.co.uk>)\r\n	id 1hbNLi-000pvL-Et\r\n	for info@apusseo.com; Thu, 13 Jun 2019 13:52:54 +0300\r\nReceived: by mail-wr1-f52.google.com with SMTP id f9so20208182wre.12\r\n        for <info@apusseo.com>; Thu, 13 Jun 2019 03:52:54 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=geekunique-co-uk.20150623.gappssmtp.com; s=20150623;\r\n        h=mime-version:from:date:message-id:subject:to;\r\n        bh=7DvmKOqAEBWH4BRQ9RYMyM5i1wL9Yp5HTFCawyAoTjc=;\r\n        b=jJBSEHmUZGR93idcCeaEIm2QNc2/z6HK6/oxGnR1nWhHyxVNDexLPt+Uzkt6Jx261u\r\n         D6waUG0RoZ1L++e20l6MtQlgP8q0fizbUfZlR3y5YO8NF0jNzg0D2lM+XweNq1Nt4cZJ\r\n         1kTDE7gyLYX41spWu4xBK2EPKUPznO8x8e9GrHnT44aH7N2N+VYuSfImNhmxjrAkArIv\r\n         YNpDksOnun3rwr9GzXY210/cZyg7XeXEaL4U3Jf+4B8KCmM0nLy2olc2gaXkh6SZDaLn\r\n         oZSF/W8PpT+l+wm7AfefFQoym9drizDD8ZmdgpjhkyYtmGD3b8H9Y2opW6Ae6IEfc5Rc\r\n         VdeQ==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:mime-version:from:date:message-id:subject:to;\r\n        bh=7DvmKOqAEBWH4BRQ9RYMyM5i1wL9Yp5HTFCawyAoTjc=;\r\n        b=QYxAaOaJKwZ3lQGXWyqXdQjD03rxvbnMhNZh1cIZm6i/oGO5essMDpDOuiDqzPq31p\r\n         Ae1KvaXZJ4XOvWTwP1ZDKU8fozw8hxT1oFhw1kJy9jaZX0u3c8qhqDOxBHk5nGm3OMXE\r\n         d1g78jxzVRr9KsWeX/EBvNGFauOQclNgh5F83R1uq5Dv7zZ5H+d2WKHWJcsfVXgsWLH+\r\n         1iyqpGvQ+9dumfkn/1kgcdWNGCjyf5MHpIvqT5fPuM6uOXkEfp1ZjlUpL0AqW20WrX1p\r\n         VDX/Ip+96L7iDrmHyQ+aZkv5dVS0MI7Lpe5aVcVhrx1m+hb+dmOG3KcjLg6CWICXXf8S\r\n         uiSA==\r\nX-Gm-Message-State: APjAAAXrjNhyagswOxRSViHBJqGQziBu7FtV8LsPHbjL5VWS1EIYp1mF\r\n	wXtrA+KlePhb2T1zCz2QMXwRZcEzyi4GoWLjeXOvow1yGHc=\r\nX-Google-Smtp-Source: APXvYqxHbC4g2yBwjnblGNGhDv3LzS6NWR+jiRQ+fe8x525zLqH81lrMjms21TeL3KtVnkWBLq3C/bTw0MjkGwi/uNI=\r\nX-Received: by 2002:adf:edcd:: with SMTP id v13mr7432626wro.210.1560423173157;\r\n Thu, 13 Jun 2019 03:52:53 -0700 (PDT)\r\nMIME-Version: 1.0\r\nFrom: Renaud Clarke <renaud@geekunique.co.uk>\r\nDate: Thu, 13 Jun 2019 11:52:40 +0100\r\nMessage-ID: <CADop5y03gu+kfNfHh91zOFX7cUyVLjQQyY6MS2gUuYcovQco=g@mail.gmail.com>\r\nSubject: Off shore\r\nTo: info@apusseo.com\r\nContent-Type: multipart/alternative; boundary=\"000000000000ef883f058b325483\"\r\n\r\n --000000000000ef883f058b325483\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\n\r\nHello,\r\n\r\nWe are looking to move our SEO work offshore. We love Latvia / Riga and\r\nwould like to know more about if you could take all our clients on board?\r\n\r\nThe factors:\r\n\r\n   1. Skills and process\r\n   2. price (we want to make more money offshore!!\r\n\r\n\r\nLet\'s chat.\r\n\r\n-- \r\n*Renaud Clarke*\r\nConsultant\r\n<https://twitter.com/renaudclarke>\r\n<https://www.linkedin.com/in/renaudclarke>\r\n[image: http://www.geekunique.co.uk] <http://www.geekunique.co.uk>[image:\r\nhttps://www.foxnitro.com] <https://www.foxnitro.com>\r\n\r\nl: 0203 375 6927 | t: 0780 1234477 | e: renaud@geekunique.co.uk | w:\r\nwww.geekunique.co.uk\r\n\r\n--000000000000ef883f058b325483\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<div dir=3D\"ltr\"><div>Hello,</div><div><br></div><div>We are looking to mov=\r\ne our SEO work offshore. We love Latvia / Riga and would like to know more =\r\nabout if you could take all our clients on board?</div><div><br></div><div>=\r\nThe factors:</div><div><ol><li>Skills and process</li><li>price (we want to=\r\n make more money offshore!!<br></li></ol></div><div><br></div><div>Let&#39;=\r\ns chat.<br></div><div><div><br>-- <br><div dir=3D\"ltr\" class=3D\"gmail_signa=\r\nture\" data-smartmail=3D\"gmail_signature\"><div dir=3D\"ltr\"><div><div dir=3D\"=\r\nltr\"><div><div dir=3D\"ltr\"><div><div dir=3D\"ltr\"><div><div dir=3D\"ltr\"><div=\r\n><div dir=3D\"ltr\"><div><div dir=3D\"ltr\"><div><div dir=3D\"ltr\"><div><div dir=\r\n=3D\"ltr\"><div><div dir=3D\"ltr\"><div dir=3D\"ltr\"><table style=3D\"font-family=\r\n:Arial;font-size:13px;color:rgb(139,149,151)\" cellspacing=3D\"0\" cellpadding=\r\n=3D\"0\" border=3D\"0\"><tbody><tr><td><table style=3D\"font-family:Arial\" cells=\r\npacing=3D\"0\" cellpadding=3D\"0\" border=3D\"0\"><tbody><tr><td><font face=3D\"Ar=\r\nial\" color=3D\"#666666\"><span style=3D\"font-size:20px\"><b>Renaud Clarke</b><=\r\n/span></font><br></td></tr><tr><td>Consultant</td></tr></tbody></table></td=\r\n><td valign=3D\"top\"><img src=3D\"http://atelier-hosting.com/emailsig/spacer.=\r\npng\" width=3D\"20px\" height=3D\"8px\"></td><td><table style=3D\"font-family:Ari=\r\nal\" cellspacing=3D\"0\" cellpadding=3D\"0\" border=3D\"0\"><tbody><tr><td align=\r\n=3D\"top\"><a href=3D\"https://twitter.com/renaudclarke\" target=3D\"_blank\"><im=\r\ng src=3D\"http://atelier-hosting.com/emailsig/twitter.gif\" alt=3D\"\"></a>=C2=\r\n=A0<a href=3D\"https://www.linkedin.com/in/renaudclarke\" target=3D\"_blank\"><=\r\nimg src=3D\"http://atelier-hosting.com/emailsig/linkedin.gif\" alt=3D\"\"></a><=\r\n/td></tr></tbody></table></td></tr></tbody></table><br><a href=3D\"http://ww=\r\nw.geekunique.co.uk\" target=3D\"_blank\"><img src=3D\"https://docs.google.com/a=\r\n/geekunique.co.uk/uc?id=3D0Bw8CBspoxBwgTXZueG43ZGxOUXc&amp;export=3Ddownloa=\r\nd\" alt=3D\"http://www.geekunique.co.uk\"></a><a href=3D\"https://www.foxnitro.=\r\ncom\" target=3D\"_blank\"><img src=3D\"https://docs.google.com/uc?export=3Ddown=\r\nload&amp;id=3D1bpLMykLoPZ0h8RFdndGIv4pVHySdM7dY&amp;revid=3D0Bw8CBspoxBwgUT=\r\nhSQ3ZMUnlFVDZYZXVQS1l1L1VnMk1EWWNZPQ\" alt=3D\"https://www.foxnitro.com\"></a>=\r\n<br><br style=3D\"color:rgb(139,149,151);font-family:Arial;font-size:13px\"><=\r\nfont style=3D\"font-family:Arial;font-size:13px\" color=3D\"#0b5394\">l:</font>=\r\n<span style=3D\"color:rgb(139,149,151);font-family:Arial;font-size:13px\"> 02=\r\n03 375 6927 </span><font style=3D\"font-family:Arial;font-size:13px\" color=\r\n=3D\"#c4c4c4\">|</font><span style=3D\"color:rgb(139,149,151);font-family:Aria=\r\nl;font-size:13px\">=C2=A0</span><font style=3D\"font-family:Arial;font-size:1=\r\n3px\" color=3D\"#0b5394\"><span><font style=3D\"font-family:Arial;font-size:13p=\r\nx\" color=3D\"#0b5394\">t:</font><span style=3D\"color:rgb(139,149,151);font-fa=\r\nmily:Arial;font-size:13px\">=C2=A00780 1234477=C2=A0</span><font style=3D\"fo=\r\nnt-family:Arial;font-size:13px\" color=3D\"#c4c4c4\">|</font><span style=3D\"co=\r\nlor:rgb(139,149,151);font-family:Arial;font-size:13px\"> </span></span>e</fo=\r\nnt><font style=3D\"font-family:Arial;font-size:13px\" color=3D\"#b2005e\">:</fo=\r\nnt><span style=3D\"color:rgb(139,149,151);font-family:Arial;font-size:13px\">=\r\n=C2=A0<a href=3D\"mailto:renaud@geekunique.co.uk\" target=3D\"_blank\">renaud@g=\r\neekunique.co.uk</a>=C2=A0</span><font style=3D\"font-family:Arial;font-size:=\r\n13px\" color=3D\"#c4c4c4\">|</font><span style=3D\"color:rgb(139,149,151);font-=\r\nfamily:Arial;font-size:13px\">=C2=A0</span><font style=3D\"font-family:Arial;=\r\nfont-size:13px\" color=3D\"#0b5394\">w:</font><span style=3D\"color:rgb(139,149=\r\n,151);font-family:Arial;font-size:13px\">=C2=A0<a href=3D\"http://www.geekuni=\r\nque.co.uk\" target=3D\"_blank\">www.geekunique.co.uk</a>=C2=A0</span><br></div=\r\n></div></div></div></div></div></div></div></div></div></div></div></div></=\r\ndiv></div></div></div></div></div></div></div></div></div></div>\r\n\r\n--000000000000ef883f058b325483--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('19', 'Aaron Reed <aaronreed1972@gmail.com> - aaronreed1972@gmail.com', '10018', '1', NULL, 'Outsource your SEO: 15 Days Trial on any 3 Projects!', '<div dir=\"ltr\"><p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><a><span style=\"font-family:Verdana, sans-serif;\">Greetings,</span></a></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><span style=\"font-family:Verdana, sans-serif;color:#000000;\"> </span><span style=\"font-family:Verdana, sans-serif;\"></span></p>\n\n<p class=\"gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\">Do you\nthink organic traffic is sufficient to keep your business afloat?  If not,\nthen our meticulously crafted PPC campaigns may interest you.</span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\">We are a premier outsourcing company\nserving many reputed PPC and Online Advertising agencies based in the US,\nCanada, UK and Australia.  Get high-quality leads through paid search\ncampaigns that surpass &amp; strengthen your SEO strategies.</span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><b><span style=\"font-family:Verdana, sans-serif;\">Our Proud Deliverables</span></b><span style=\"font-family:Verdana, sans-serif;\"> - <b>150+ PPC Adwords\nProfessionals | 3 years of Experience| Partnered with 20+digital agencies</b></span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><b><span style=\"font-family:Verdana, sans-serif;color:#000000;\"> </span></b></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><b><span style=\"font-family:Verdana, sans-serif;\">What We Offer:</span></b></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><b><span style=\"font-family:Verdana, sans-serif;\"> </span></b></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><b><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">1.     15-day\nfree trial on 3 projects</span></b><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">2.     Free\nWebsite Audit Report to map the weak spots.</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">3.    \nCompetitors analysis to pursue keyword mapping and draft marketing campaigns</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">4.     We\nemploy Tiered link building involving\nwebsites with PA, DA &gt; 15. No low quality junk spam.</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">5.     We build\nat least 2-3 backlinks per project every single day. No Compromise here!</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">6.     We use\nBasecamp to manage projects to provide real-time performance updates.</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><b><span style=\"font-family:Verdana, sans-serif;\">Our All Services</span></b><span style=\"font-family:Verdana, sans-serif;\">: SEO | PPC | SMO | SMM | Website and\nMobile App Design &amp; Development.</span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><b><span style=\"font-family:Verdana, sans-serif;\">Interested</span></b><span style=\"font-family:Verdana, sans-serif;\"> and want to give it a shot? <b>Let’s\nhop on a quick Skype/Phone call</b>. I am sure you will love us (100% sure).</span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\">Interested?? Email me back with <b>Skype\nId OR Whatsapp</b> Number, I\'d love to chat.</span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><span style=\"font-family:Verdana, sans-serif;color:#000000;\"> </span><span style=\"font-family:Verdana, sans-serif;\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><span style=\"font-family:Verdana, sans-serif;\">Best Regards,</span><span style=\"font-family:Verdana, sans-serif;\"><br />\n</span><b><span style=\"font-family:Verdana, sans-serif;color:#000000;\">Aaron\nReed</span></b><span style=\"font-family:Verdana, sans-serif;\"><br />\nMarketing Executive</span><span style=\"font-size:10pt;font-family:Verdana, sans-serif;\"></span></p></div>\n<img src=\"https://aaronreed1972-dot-yamm-track.appspot.com/FireBase?ukey=1Ddu2-iSMUH42cQsydZMHjUVRnw5oBBTpA2GokLdc7vA-0&amp;key=YAMMID-11288814\" width=\"1\" height=\"1\" alt=\"beacon\" />\n', 'new', '0', '0', '1', '0', NULL, '1560511502', '1', '1', '0', 'Return-Path: <aaronreed1972@gmail.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id SRaKFz+DA13AaAwAMoQ/pw\r\n	(envelope-from <aaronreed1972@gmail.com>)\r\n	for <info@apusseo.com>; Fri, 14 Jun 2019 14:21:35 +0300\r\nReturn-path: <aaronreed1972@gmail.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Fri, 14 Jun 2019 14:21:35 +0300\r\nReceived: from mail-wm1-f67.google.com ([209.85.128.67]:53778)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.92)\r\n	(envelope-from <aaronreed1972@gmail.com>)\r\n	id 1hbkH1-003PYY-9A\r\n	for info@apusseo.com; Fri, 14 Jun 2019 14:21:35 +0300\r\nReceived: by mail-wm1-f67.google.com with SMTP id x15so1953876wmj.3\r\n        for <info@apusseo.com>; Fri, 14 Jun 2019 04:21:30 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=20161025;\r\n        h=mime-version:sender:from:date:message-id:subject:to;\r\n        bh=AIqvu+e8NspX1i0WcYi+qtIYPKbhfISucZBg4W07Nl0=;\r\n        b=ISJNHz44XlVArng/L7Q8NutvEUB90MZw6BE+ne7aWQRLX+N7rRXdquR9/q5kgjGZX5\r\n         EKTJw0ek+VT2cg3IL/vXQ/ExA3ZUg2Eid+ImDeUoKGrLzaG/FcrC8fN3KEccNifasV7J\r\n         fo9vKTQm+6QkVm3k+zjImSKELMoY0RR6xZw9WoYjhzszNNk0Qo000egDVheJ29NmdHgG\r\n         xs6hB/IC/6oXybLn18TfHBR/EvSzok4xhqrU4dNSSYKKEvhsu8k1GW194So+FG61F1+C\r\n         JrTjwApAOSnPSRrtNc04RzS/1dJInMRhQieI47ruyO6A2FhEv/hAaVGPuE/1pCBrOL6T\r\n         Y0AA==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:mime-version:sender:from:date:message-id:subject\r\n         :to;\r\n        bh=AIqvu+e8NspX1i0WcYi+qtIYPKbhfISucZBg4W07Nl0=;\r\n        b=ugTI9jM+GKF3Jz199+Pxp+Tc4y8etW96k99ns20UyioXWFpmL6zesTF2InoND+cewo\r\n         xKc73M9wJqe5vO0X8MvaRqmREMN6HZw3AgpJbuj5ISYuMNT+QXgS9EJ3qLNTRA5HCb4L\r\n         Y4UQczxIEW8TIUsMQT9i545K2+8RXwQE2ycqqJnWYUnt1NEoSw+KdeIsA0uq1NeL7Pt3\r\n         juDAsNvRg/DlJcGh6Q4BDixZCWlf6PESYDnvbkV36vJyM23JSPMg8LraICjH5KupIwQT\r\n         41+d31WnQJ422HdWSJVwCIuAWYyPe0Nf1Z5ampG9dcJpcazSD1YQ3g41kfHbhzWLjdwU\r\n         qXfQ==\r\nX-Gm-Message-State: APjAAAUI8cQdxrw3pD3R13BYDIl9nVRXuEP3zOB/xGdb/mIXKBWRJqXI\r\n	fojbB/SupF0bAtE9ituO9Q2ig8HpNx+utSo2rabWQoM=\r\nX-Google-Smtp-Source: APXvYqxx9R3z+v9dJtsrpmsLQ+HphwXFIlqlADR1ReGxcAFO05gmK7IRDXbZQxXU1vZa3hMJ1GCLgYoe9H7Q6lgbn94=\r\nX-Received: by 2002:a05:600c:2189:: with SMTP id e9mr7145254wme.56.1560511289898;\r\n Fri, 14 Jun 2019 04:21:29 -0700 (PDT)\r\nReceived: from 52669349336 named unknown by gmailapi.google.com with HTTPREST;\r\n Fri, 14 Jun 2019 04:21:29 -0700\r\nMIME-Version: 1.0\r\nSender: Aaron Reed <aaronreed1972@gmail.com>\r\nFrom: Aaron Reed <aaronreed1972@gmail.com>\r\nDate: Fri, 14 Jun 2019 04:21:29 -0700\r\nX-Google-Sender-Auth: Inw2v7Ft0HYIQlsHiUZd9UVuzC4\r\nMessage-ID: <CADQhacRw5zSZdVK2Q=mWBf82MOS3bd5GzOdsC-L_yJgMz2yZnw@mail.gmail.com>\r\nSubject: Outsource your SEO: 15 Days Trial on any 3 Projects!\r\nTo: Info <info@apusseo.com>\r\nContent-Type: multipart/alternative; boundary=\"0000000000001a3a38058b46d948\"\r\n\r\n --0000000000001a3a38058b46d948\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nGreetings,\r\n\r\n\r\n\r\nDo you think organic traffic is sufficient to keep your business afloat?\r\nIf not, then our meticulously crafted PPC campaigns may interest you.\r\n\r\n\r\n\r\nWe are a premier outsourcing company serving many reputed PPC and Online\r\nAdvertising agencies based in the US, Canada, UK and Australia.  Get\r\nhigh-quality leads through paid search campaigns that surpass & strengthen\r\nyour SEO strategies.\r\n\r\n\r\n\r\n*Our Proud Deliverables* - *150+ PPC Adwords Professionals | 3 years of\r\nExperience| Partnered with 20+digital agencies*\r\n\r\n\r\n\r\n*What We Offer:*\r\n\r\n\r\n\r\n*1.     15-day free trial on 3 projects*\r\n\r\n2.     Free Website Audit Report to map the weak spots.\r\n\r\n3.     Competitors analysis to pursue keyword mapping and draft marketing\r\ncampaigns\r\n\r\n4.     We employ Tiered link building involving websites with PA, DA > 15.\r\nNo low quality junk spam.\r\n\r\n5.     We build at least 2-3 backlinks per project every single day. No\r\nCompromise here!\r\n\r\n6.     We use Basecamp to manage projects to provide real-time performance\r\nupdates.\r\n\r\n\r\n\r\n*Our All Services*: SEO | PPC | SMO | SMM | Website and Mobile App Design &\r\nDevelopment.\r\n\r\n\r\n\r\n*Interested* and want to give it a shot? *Let=E2=80=99s hop on a quick Skyp=\r\ne/Phone\r\ncall*. I am sure you will love us (100% sure).\r\n\r\n\r\n\r\nInterested?? Email me back with *Skype Id OR Whatsapp* Number, I\'d love to\r\nchat.\r\n\r\n\r\n\r\nBest Regards,\r\n*Aaron Reed*\r\nMarketing Executive\r\n[image: beacon]\r\n\r\n--0000000000001a3a38058b46d948\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<div dir=3D\"ltr\"><p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;li=\r\nne-height:14.1pt;background-image:initial;background-position:initial;backg=\r\nround-size:initial;background-repeat:initial;background-origin:initial;back=\r\nground-clip:initial;font-family:Calibri,sans-serif\"><a name=3D\"_GoBack\" sty=\r\nle=3D\"\"><span style=3D\"font-family:Verdana,sans-serif\">Greetings,</span></a=\r\n></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><span style=3D\"font-family:Verdana,sans-=\r\nserif;color:black\">=C2=A0</span><span style=3D\"font-family:Verdana,sans-ser=\r\nif\"></span></p>\r\n\r\n<p class=3D\"gmail-m-4692000340142064654gmail-normal\" style=3D\"margin:0cm 0c=\r\nm 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;=\r\nbackground-position:initial;background-size:initial;background-repeat:initi=\r\nal;background-origin:initial;background-clip:initial;font-family:&quot;Time=\r\ns New Roman&quot;,serif\"><span style=3D\"font-family:Verdana,sans-serif\">Do =\r\nyou\r\nthink organic traffic is sufficient to keep your business afloat?=C2=A0 If =\r\nnot,\r\nthen our meticulously crafted PPC campaigns may interest you.</span><span s=\r\ntyle=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m-4692000340142064654gmail-normal\" style=3D\"margin:0cm 0c=\r\nm 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;=\r\nbackground-position:initial;background-size:initial;background-repeat:initi=\r\nal;background-origin:initial;background-clip:initial;font-family:&quot;Time=\r\ns New Roman&quot;,serif\"><span style=3D\"font-family:Verdana,sans-serif\">=C2=\r\n=A0</span><span style=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m-4692000340142064654gmail-normal\" style=3D\"margin:0cm 0c=\r\nm 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;=\r\nbackground-position:initial;background-size:initial;background-repeat:initi=\r\nal;background-origin:initial;background-clip:initial;font-family:&quot;Time=\r\ns New Roman&quot;,serif\"><span style=3D\"font-family:Verdana,sans-serif\">We =\r\nare a premier outsourcing company\r\nserving many reputed PPC and Online Advertising agencies based in the US,\r\nCanada, UK and Australia.=C2=A0 Get high-quality leads through paid search\r\ncampaigns that surpass &amp; strengthen your SEO strategies.</span><span st=\r\nyle=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m-4692000340142064654gmail-normal\" style=3D\"margin:0cm 0c=\r\nm 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;=\r\nbackground-position:initial;background-size:initial;background-repeat:initi=\r\nal;background-origin:initial;background-clip:initial;font-family:&quot;Time=\r\ns New Roman&quot;,serif\"><span style=3D\"font-family:Verdana,sans-serif\">=C2=\r\n=A0</span><span style=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m-4692000340142064654gmail-normal\" style=3D\"margin:0cm 0c=\r\nm 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;=\r\nbackground-position:initial;background-size:initial;background-repeat:initi=\r\nal;background-origin:initial;background-clip:initial;font-family:&quot;Time=\r\ns New Roman&quot;,serif\"><b><span style=3D\"font-family:Verdana,sans-serif\">=\r\nOur Proud Deliverables</span></b><span style=3D\"font-family:Verdana,sans-se=\r\nrif\">=C2=A0-=C2=A0<b>150+ PPC Adwords\r\nProfessionals | 3 years of Experience| Partnered with 20+digital agencies</=\r\nb></span><span style=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><b><span style=3D\"font-family:Verdana,sa=\r\nns-serif;color:black\">=C2=A0</span></b></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><b><span style=3D\"font-family:Verdana,sa=\r\nns-serif;background-image:initial;background-position:initial;background-si=\r\nze:initial;background-repeat:initial;background-origin:initial;background-c=\r\nlip:initial\">What We Offer:</span></b></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><b><span style=3D\"font-family:Verdana,sa=\r\nns-serif\">=C2=A0</span></b></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:130%;background-image:initial;back=\r\nground-position:initial;background-size:initial;background-repeat:initial;b=\r\nackground-origin:initial;background-clip:initial;font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\"><b><span style=3D\"line-height:130%;font-family:Verdana=\r\n,sans-serif\">1.=C2=A0=C2=A0=C2=A0=C2=A0 15-day\r\nfree trial on 3 projects</span></b><span style=3D\"line-height:130%;font-fam=\r\nily:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:130%;background-image:initial;back=\r\nground-position:initial;background-size:initial;background-repeat:initial;b=\r\nackground-origin:initial;background-clip:initial;font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\"><span style=3D\"line-height:130%;font-family:Verdana,sa=\r\nns-serif\">2.=C2=A0=C2=A0=C2=A0=C2=A0 Free\r\nWebsite Audit Report to map the weak spots.</span><span style=3D\"line-heigh=\r\nt:130%;font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:130%;background-image:initial;back=\r\nground-position:initial;background-size:initial;background-repeat:initial;b=\r\nackground-origin:initial;background-clip:initial;font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\"><span style=3D\"line-height:130%;font-family:Verdana,sa=\r\nns-serif\">3.=C2=A0=C2=A0=C2=A0=C2=A0\r\nCompetitors analysis to pursue keyword mapping and draft marketing campaign=\r\ns</span><span style=3D\"line-height:130%;font-family:Arial,sans-serif\"></spa=\r\nn></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:130%;background-image:initial;back=\r\nground-position:initial;background-size:initial;background-repeat:initial;b=\r\nackground-origin:initial;background-clip:initial;font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\"><span style=3D\"line-height:130%;font-family:Verdana,sa=\r\nns-serif\">4.=C2=A0=C2=A0=C2=A0=C2=A0 We\r\nemploy=C2=A0Tiered link building=C2=A0involving\r\nwebsites with PA, DA &gt; 15. No low quality junk spam.</span><span style=\r\n=3D\"line-height:130%;font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:130%;background-image:initial;back=\r\nground-position:initial;background-size:initial;background-repeat:initial;b=\r\nackground-origin:initial;background-clip:initial;font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\"><span style=3D\"line-height:130%;font-family:Verdana,sa=\r\nns-serif\">5.=C2=A0=C2=A0=C2=A0=C2=A0 We build\r\nat least 2-3 backlinks per project every single day. No Compromise here!</s=\r\npan><span style=3D\"line-height:130%;font-family:Arial,sans-serif\"></span></=\r\np>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:130%;background-image:initial;back=\r\nground-position:initial;background-size:initial;background-repeat:initial;b=\r\nackground-origin:initial;background-clip:initial;font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\"><span style=3D\"line-height:130%;font-family:Verdana,sa=\r\nns-serif\">6.=C2=A0=C2=A0=C2=A0=C2=A0 We use\r\nBasecamp to manage projects to provide real-time performance updates.</span=\r\n><span style=3D\"line-height:130%;font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><span style=3D\"font-family:Verdana,sans-=\r\nserif\">=C2=A0</span></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;b=\r\nackground-position:initial;background-size:initial;background-repeat:initia=\r\nl;background-origin:initial;background-clip:initial;font-family:&quot;Times=\r\n New Roman&quot;,serif\"><b><span style=3D\"font-family:Verdana,sans-serif\">O=\r\nur All Services</span></b><span style=3D\"font-family:Verdana,sans-serif\">: =\r\nSEO | PPC | SMO | SMM | Website and\r\nMobile App Design &amp; Development.</span></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;b=\r\nackground-position:initial;background-size:initial;background-repeat:initia=\r\nl;background-origin:initial;background-clip:initial;font-family:&quot;Times=\r\n New Roman&quot;,serif\"><span style=3D\"font-family:Verdana,sans-serif\">=C2=\r\n=A0</span></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;b=\r\nackground-position:initial;background-size:initial;background-repeat:initia=\r\nl;background-origin:initial;background-clip:initial;font-family:&quot;Times=\r\n New Roman&quot;,serif\"><b><span style=3D\"font-family:Verdana,sans-serif;ba=\r\nckground-image:initial;background-position:initial;background-size:initial;=\r\nbackground-repeat:initial;background-origin:initial;background-clip:initial=\r\n\">Interested</span></b><span style=3D\"font-family:Verdana,sans-serif;backgr=\r\nound-image:initial;background-position:initial;background-size:initial;back=\r\nground-repeat:initial;background-origin:initial;background-clip:initial\">=\r\n=C2=A0and want to give it a shot?=C2=A0<b>Let=E2=80=99s\r\nhop on a quick Skype/Phone call</b>. I am sure you will love us (100% sure)=\r\n.</span><span style=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;b=\r\nackground-position:initial;background-size:initial;background-repeat:initia=\r\nl;background-origin:initial;background-clip:initial;font-family:&quot;Times=\r\n New Roman&quot;,serif\"><span style=3D\"font-family:Verdana,sans-serif\">=C2=\r\n=A0</span><span style=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m6187785815084956404gmail-normal\" style=3D\"margin:0cm 0cm=\r\n 0.0001pt;text-align:justify;line-height:12.65pt;background-image:initial;b=\r\nackground-position:initial;background-size:initial;background-repeat:initia=\r\nl;background-origin:initial;background-clip:initial;font-family:&quot;Times=\r\n New Roman&quot;,serif\"><span style=3D\"font-family:Verdana,sans-serif\">Inte=\r\nrested?? Email me back with=C2=A0<b>Skype\r\nId OR Whatsapp</b>=C2=A0Number, I&#39;d love to chat.</span><span style=3D\"=\r\nfont-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><span style=3D\"font-family:Verdana,sans-=\r\nserif;color:black\">=C2=A0</span><span style=3D\"font-family:Verdana,sans-ser=\r\nif\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><span style=3D\"font-family:Verdana,sans-=\r\nserif\">Best Regards,</span><span style=3D\"font-family:Verdana,sans-serif\"><=\r\nbr>\r\n</span><b style=3D\"\"><span style=3D\"font-family:Verdana,sans-serif;color:bl=\r\nack;background-image:initial;background-position:initial;background-size:in=\r\nitial;background-repeat:initial;background-origin:initial;background-clip:i=\r\nnitial\">Aaron\r\nReed</span></b><span style=3D\"font-family:Verdana,sans-serif\"><br>\r\nMarketing Executive</span><span style=3D\"font-size:10pt;font-family:Verdana=\r\n,sans-serif;font-size:10pt\"></span></p></div>\r\n<img src=3D\"https://aaronreed1972-dot-yamm-track.appspot.com/FireBase?ukey=\r\n=3D1Ddu2-iSMUH42cQsydZMHjUVRnw5oBBTpA2GokLdc7vA-0&amp;key=3DYAMMID-11288814=\r\n\" width=3D\"1\" height=3D\"1\" alt=3D\"beacon\" style=3D\"display:none; display:no=\r\nne!important;\">\r\n\r\n--0000000000001a3a38058b46d948--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('20', 'Aaron Reed <aaronreed1972@gmail.com> - aaronreed1972@gmail.com', '10019', '1', NULL, 'Re: Outsource your SEO: 15 Days Trial on any 3 Projects!', '<div dir=\"ltr\"><p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><span lang=\"en-us\" style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\" xml:lang=\"en-us\">Hi,</span><span style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><span lang=\"en-us\" style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\" xml:lang=\"en-us\"> </span><span style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><span style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\">I just want to confirm whether you received my last\nemail or not. Let me know <b>if you are\ninterested in our services</b> </span><span lang=\"en-us\" style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\" xml:lang=\"en-us\">so that we can move ahead.</span><b><span style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\">I can send you our past\nwork details,company information and an affordable quotation</span></b><span style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\"> <b>with the best offer.</b></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><span style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\"> </span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><span lang=\"en-us\" style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\" xml:lang=\"en-us\">Let’s hop on a quick\nSkype call. <b>I am sure you will love us\n(100% sure</b>).Please reply to this email with you Skype or Phone number.</span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><span lang=\"en-us\" style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\" xml:lang=\"en-us\"> </span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><b><span style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\">Awaiting\nyour positive reply.</span></b></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><span lang=\"en-us\" style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\" xml:lang=\"en-us\">Best Regards,</span><span style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><b><span lang=\"en-us\" style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\" xml:lang=\"en-us\">Aaron\nReed</span></b></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:normal;font-size:11pt;font-family:Calibri, sans-serif;\"><span lang=\"en-us\" style=\"font-size:10pt;font-family:Verdana, sans-serif;color:rgb(23,54,93);\" xml:lang=\"en-us\">Business Development\nExecutive</span></p></div><br /><div class=\"gmail_quote\"><div dir=\"ltr\" class=\"gmail_attr\">On Fri, Jun 14, 2019 at 4:51 PM Aaron Reed &lt;<a href=\"mailto:aaronreed1972@gmail.com\">aaronreed1972@gmail.com</a>&gt; wrote:<br /></div><blockquote class=\"gmail_quote\" style=\"margin:0px 0px 0px .8ex;border-left:1px solid rgb(204,204,204);padding-left:1ex;\"><div dir=\"ltr\"><p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><a><span style=\"font-family:Verdana, sans-serif;\">Greetings,</span></a></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><span style=\"font-family:Verdana, sans-serif;color:#000000;\"> </span><span style=\"font-family:Verdana, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\">Do you\nthink organic traffic is sufficient to keep your business afloat?  If not,\nthen our meticulously crafted PPC campaigns may interest you.</span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\">We are a premier outsourcing company\nserving many reputed PPC and Online Advertising agencies based in the US,\nCanada, UK and Australia.  Get high-quality leads through paid search\ncampaigns that surpass &amp; strengthen your SEO strategies.</span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><b><span style=\"font-family:Verdana, sans-serif;\">Our Proud Deliverables</span></b><span style=\"font-family:Verdana, sans-serif;\"> - <b>150+ PPC Adwords\nProfessionals | 3 years of Experience| Partnered with 20+digital agencies</b></span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><b><span style=\"font-family:Verdana, sans-serif;color:#000000;\"> </span></b></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><b><span style=\"font-family:Verdana, sans-serif;\">What We Offer:</span></b></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><b><span style=\"font-family:Verdana, sans-serif;\"> </span></b></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><b><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">1.     15-day\nfree trial on 3 projects</span></b><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">2.     Free\nWebsite Audit Report to map the weak spots.</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">3.    \nCompetitors analysis to pursue keyword mapping and draft marketing campaigns</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">4.     We\nemploy Tiered link building involving\nwebsites with PA, DA &gt; 15. No low quality junk spam.</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">5.     We build\nat least 2-3 backlinks per project every single day. No Compromise here!</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:130%;font-family:\'Times New Roman\', serif;\"><span style=\"line-height:130%;font-family:Verdana, sans-serif;\">6.     We use\nBasecamp to manage projects to provide real-time performance updates.</span><span style=\"line-height:130%;font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><b><span style=\"font-family:Verdana, sans-serif;\">Our All Services</span></b><span style=\"font-family:Verdana, sans-serif;\">: SEO | PPC | SMO | SMM | Website and\nMobile App Design &amp; Development.</span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><b><span style=\"font-family:Verdana, sans-serif;\">Interested</span></b><span style=\"font-family:Verdana, sans-serif;\"> and want to give it a shot? <b>Let’s\nhop on a quick Skype/Phone call</b>. I am sure you will love us (100% sure).</span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\"> </span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-normal\" style=\"margin:0cm 0cm .0001pt;text-align:justify;line-height:12.65pt;font-family:\'Times New Roman\', serif;\"><span style=\"font-family:Verdana, sans-serif;\">Interested?? Email me back with <b>Skype\nId OR Whatsapp</b> Number, I\'d love to chat.</span><span style=\"font-family:Arial, sans-serif;\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><span style=\"font-family:Verdana, sans-serif;color:#000000;\"> </span><span style=\"font-family:Verdana, sans-serif;\"></span></p>\n\n<p class=\"MsoNormal\" style=\"margin:0cm 0cm .0001pt;line-height:14.1pt;font-family:Calibri, sans-serif;\"><span style=\"font-family:Verdana, sans-serif;\">Best Regards,</span><span style=\"font-family:Verdana, sans-serif;\"><br />\n</span><b><span style=\"font-family:Verdana, sans-serif;color:#000000;\">Aaron\nReed</span></b><span style=\"font-family:Verdana, sans-serif;\"><br />\nMarketing Executive</span><span style=\"font-family:Verdana, sans-serif;font-size:10pt;\"></span></p></div>\n<img src=\"https://aaronreed1972-dot-yamm-track.appspot.com/FireBase?ukey=1Ddu2-iSMUH42cQsydZMHjUVRnw5oBBTpA2GokLdc7vA-0&amp;key=YAMMID-11288814\" width=\"1\" height=\"1\" alt=\"beacon\" /></blockquote></div>\n', 'new', '0', '0', '1', '0', NULL, '1560852004', '1', '1', '0', 'Return-Path: <aaronreed1972@gmail.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id CyCaI9u1CF2eag8AMoQ/pw\r\n	(envelope-from <aaronreed1972@gmail.com>)\r\n	for <info@apusseo.com>; Tue, 18 Jun 2019 12:58:51 +0300\r\nReturn-path: <aaronreed1972@gmail.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Tue, 18 Jun 2019 12:58:51 +0300\r\nReceived: from mail-wr1-f68.google.com ([209.85.221.68]:36623)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.92)\r\n	(envelope-from <aaronreed1972@gmail.com>)\r\n	id 1hdAt9-004Epb-Ef\r\n	for info@apusseo.com; Tue, 18 Jun 2019 12:58:51 +0300\r\nReceived: by mail-wr1-f68.google.com with SMTP id n4so5152915wrs.3\r\n        for <info@apusseo.com>; Tue, 18 Jun 2019 02:58:51 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=20161025;\r\n        h=mime-version:references:in-reply-to:from:date:message-id:subject:to;\r\n        bh=q/NJT4v9Y+HVqVrDqu1jhUQoRtqv601dPi7iE6YMYzo=;\r\n        b=sCxAib/GLrdlK5NBClEANh8yitHyLf1GKapOKrHyf9wFbzGtr4VW8ff8PF4AWM4z1f\r\n         a6c/y9jJKIBRNw+TFy1fgx2Nndxe9ZhyFIZJ0K3+9HJnkX/bLI6hcyQqhbIOFZm82Ihm\r\n         SrAMQkRAv/WtrdCq3koeZTyFuhMdnuHbSAbiRp4z6jY++ivSw960wkwLDowYEYZXRPXn\r\n         8hGl9Bj5zrIVlOltLRxk51ImeDDvJzCtQ42UmplXSGR5Ea9Z69EFry/INX9zwztm37Dc\r\n         jcyJIO0SryABLqdw0fR9BfplFyE+CzgamEDT3UQKQR2v2eqWUeuBhU/Lh41YlZcSQKdP\r\n         9PKQ==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:mime-version:references:in-reply-to:from:date\r\n         :message-id:subject:to;\r\n        bh=q/NJT4v9Y+HVqVrDqu1jhUQoRtqv601dPi7iE6YMYzo=;\r\n        b=hlyYgAsyFWx1VEeIquQIzYBkFkqiN4KQcRZwWrSNZvNzFEZmsZqaAry+2crFLTdvmM\r\n         U91yrKayij5ZU+nls+igmLAb5qJNKu204HJ1+0UzPK2bKcEa5rquljgbkr1b/GWE3aXw\r\n         uG06ET4XNYSnVs5SyDS6HR7Ac9q2VwIqqsbGHyfJjI6iPy+yR6sSnicizLTwyz4joW2q\r\n         +wb5SrxTMlsSExnpn7MpyYLcgXfe9JsjRt+pCLAEiYTwBYa3zQvNx0Cb4X10okVzkDCW\r\n         TDAaGDUZGP/NjoG9pIB3o1T/0XUYOCAHjMP4Uq5JkLXv7SETH+K+QiVbPfclXlIzsToV\r\n         Sy0w==\r\nX-Gm-Message-State: APjAAAUDNrCR1gzXzeibuxMRDctfF/sh8S1zNggb9E/V1+AHA7zJh9Ft\r\n	jCzcNdHyAitiR5odDnox7H3Z0J7Qw3s4d1kvJms7nNM=\r\nX-Google-Smtp-Source: APXvYqzctHdy/j/10cw4Fih8h7KPyP93zP8GszCws8qYSaFe4Sou+frIdl7CmT7gjWdB8kPJdBawJDS8TaiYANo87EU=\r\nX-Received: by 2002:adf:f683:: with SMTP id v3mr21761915wrp.258.1560851930882;\r\n Tue, 18 Jun 2019 02:58:50 -0700 (PDT)\r\nMIME-Version: 1.0\r\nReferences: <CADQhacRw5zSZdVK2Q=mWBf82MOS3bd5GzOdsC-L_yJgMz2yZnw@mail.gmail.com>\r\nIn-Reply-To: <CADQhacRw5zSZdVK2Q=mWBf82MOS3bd5GzOdsC-L_yJgMz2yZnw@mail.gmail.com>\r\nFrom: Aaron Reed <aaronreed1972@gmail.com>\r\nDate: Tue, 18 Jun 2019 15:28:39 +0530\r\nMessage-ID: <CADQhacRqzMWof84CYz33SQdSFDyfvDY2o2dj_a6g-ha8Rh5hgQ@mail.gmail.com>\r\nSubject: Re: Outsource your SEO: 15 Days Trial on any 3 Projects!\r\nTo: Info <info@apusseo.com>\r\nContent-Type: multipart/alternative; boundary=\"000000000000e326b8058b962809\"\r\n\r\n --000000000000e326b8058b962809\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHi,\r\n\r\n\r\n\r\nI just want to confirm whether you received my last email or not. Let me\r\nknow *if you are interested in our services* so that we can move ahead.*I\r\ncan send you our past work details,company information and an affordable\r\nquotation* *with the best offer.*\r\n\r\n\r\n\r\nLet=E2=80=99s hop on a quick Skype call. *I am sure you will love us (100%\r\nsure*).Please\r\nreply to this email with you Skype or Phone number.\r\n\r\n\r\n\r\n*Awaiting your positive reply.*\r\n\r\nBest Regards,\r\n\r\n*Aaron Reed*\r\n\r\nBusiness Development Executive\r\n\r\nOn Fri, Jun 14, 2019 at 4:51 PM Aaron Reed <aaronreed1972@gmail.com> wrote:\r\n\r\n> Greetings,\r\n>\r\n>\r\n>\r\n> Do you think organic traffic is sufficient to keep your business afloat?\r\n> If not, then our meticulously crafted PPC campaigns may interest you.\r\n>\r\n>\r\n>\r\n> We are a premier outsourcing company serving many reputed PPC and Online\r\n> Advertising agencies based in the US, Canada, UK and Australia.  Get\r\n> high-quality leads through paid search campaigns that surpass & strengthe=\r\nn\r\n> your SEO strategies.\r\n>\r\n>\r\n>\r\n> *Our Proud Deliverables* - *150+ PPC Adwords Professionals | 3 years of\r\n> Experience| Partnered with 20+digital agencies*\r\n>\r\n>\r\n>\r\n> *What We Offer:*\r\n>\r\n>\r\n>\r\n> *1.     15-day free trial on 3 projects*\r\n>\r\n> 2.     Free Website Audit Report to map the weak spots.\r\n>\r\n> 3.     Competitors analysis to pursue keyword mapping and draft marketing\r\n> campaigns\r\n>\r\n> 4.     We employ Tiered link building involving websites with PA, DA > 15=\r\n.\r\n> No low quality junk spam.\r\n>\r\n> 5.     We build at least 2-3 backlinks per project every single day. No\r\n> Compromise here!\r\n>\r\n> 6.     We use Basecamp to manage projects to provide real-time performanc=\r\ne\r\n> updates.\r\n>\r\n>\r\n>\r\n> *Our All Services*: SEO | PPC | SMO | SMM | Website and Mobile App Design\r\n> & Development.\r\n>\r\n>\r\n>\r\n> *Interested* and want to give it a shot? *Let=E2=80=99s hop on a quick\r\n> Skype/Phone call*. I am sure you will love us (100% sure).\r\n>\r\n>\r\n>\r\n> Interested?? Email me back with *Skype Id OR Whatsapp* Number, I\'d love\r\n> to chat.\r\n>\r\n>\r\n>\r\n> Best Regards,\r\n> *Aaron Reed*\r\n> Marketing Executive\r\n> [image: beacon]\r\n\r\n--000000000000e326b8058b962809\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<div dir=3D\"ltr\"><p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;li=\r\nne-height:normal;font-size:11pt;font-family:Calibri,sans-serif\"><span lang=\r\n=3D\"EN-US\" style=3D\"font-size:10pt;font-family:Verdana,sans-serif;color:rgb=\r\n(23,54,93)\">Hi,</span><span style=3D\"font-size:10pt;font-family:Verdana,san=\r\ns-serif;color:rgb(23,54,93)\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><span lang=3D\"EN-US\" style=\r\n=3D\"font-size:10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">=C2=\r\n=A0</span><span style=3D\"font-size:10pt;font-family:Verdana,sans-serif;colo=\r\nr:rgb(23,54,93)\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><span style=3D\"font-size:10p=\r\nt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">I just want to confir=\r\nm whether you received my last\r\nemail or not. Let me know <b>if you are\r\ninterested in our services</b>=C2=A0</span><span lang=3D\"EN-US\" style=3D\"fo=\r\nnt-size:10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">so that we=\r\n can move ahead.</span><b><span style=3D\"font-size:10pt;font-family:Verdana=\r\n,sans-serif;color:rgb(23,54,93)\">I can send you our past\r\nwork details,company information and an affordable quotation</span></b><spa=\r\nn style=3D\"font-size:10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93=\r\n)\"> <b>with the best offer.</b></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><span style=3D\"font-size:10p=\r\nt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">=C2=A0</span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><span lang=3D\"EN-US\" style=\r\n=3D\"font-size:10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">Let=\r\n=E2=80=99s hop on a quick\r\nSkype call. <b>I am sure you will love us\r\n(100% sure</b>).Please reply to this email with you Skype or Phone number.<=\r\n/span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><span lang=3D\"EN-US\" style=\r\n=3D\"font-size:10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">=C2=\r\n=A0</span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><b><span style=3D\"font-size:=\r\n10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">Awaiting\r\nyour positive reply.</span></b></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><span lang=3D\"EN-US\" style=\r\n=3D\"font-size:10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">Best=\r\n Regards,</span><span style=3D\"font-size:10pt;font-family:Verdana,sans-seri=\r\nf;color:rgb(23,54,93)\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><b><span lang=3D\"EN-US\" styl=\r\ne=3D\"font-size:10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93);back=\r\nground-image:initial;background-position:initial;background-size:initial;ba=\r\nckground-repeat:initial;background-origin:initial;background-clip:initial\">=\r\nAaron\r\nReed</span></b></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:normal;=\r\nfont-size:11pt;font-family:Calibri,sans-serif\"><span lang=3D\"EN-US\" style=\r\n=3D\"font-size:10pt;font-family:Verdana,sans-serif;color:rgb(23,54,93)\">Busi=\r\nness Development\r\nExecutive</span></p></div><br><div class=3D\"gmail_quote\"><div dir=3D\"ltr\" c=\r\nlass=3D\"gmail_attr\">On Fri, Jun 14, 2019 at 4:51 PM Aaron Reed &lt;<a href=\r\n=3D\"mailto:aaronreed1972@gmail.com\">aaronreed1972@gmail.com</a>&gt; wrote:<=\r\nbr></div><blockquote class=3D\"gmail_quote\" style=3D\"margin:0px 0px 0px 0.8e=\r\nx;border-left:1px solid rgb(204,204,204);padding-left:1ex\"><div dir=3D\"ltr\"=\r\n><p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt=\r\n;background-image:initial;background-position:initial;background-size:initi=\r\nal;background-repeat:initial;background-origin:initial;background-clip:init=\r\nial;font-family:Calibri,sans-serif\"><a name=3D\"m_-6065500086584561423__GoBa=\r\nck\"><span style=3D\"font-family:Verdana,sans-serif\">Greetings,</span></a></p=\r\n>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><span style=3D\"font-family:Verdana,sans-=\r\nserif;color:black\">=C2=A0</span><span style=3D\"font-family:Verdana,sans-ser=\r\nif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-no=\r\nrmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65=\r\npt;background-image:initial;background-position:initial;background-size:ini=\r\ntial;background-repeat:initial;background-origin:initial;background-clip:in=\r\nitial;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"font-fa=\r\nmily:Verdana,sans-serif\">Do you\r\nthink organic traffic is sufficient to keep your business afloat?=C2=A0 If =\r\nnot,\r\nthen our meticulously crafted PPC campaigns may interest you.</span><span s=\r\ntyle=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-no=\r\nrmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65=\r\npt;background-image:initial;background-position:initial;background-size:ini=\r\ntial;background-repeat:initial;background-origin:initial;background-clip:in=\r\nitial;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"font-fa=\r\nmily:Verdana,sans-serif\">=C2=A0</span><span style=3D\"font-family:Arial,sans=\r\n-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-no=\r\nrmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65=\r\npt;background-image:initial;background-position:initial;background-size:ini=\r\ntial;background-repeat:initial;background-origin:initial;background-clip:in=\r\nitial;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"font-fa=\r\nmily:Verdana,sans-serif\">We are a premier outsourcing company\r\nserving many reputed PPC and Online Advertising agencies based in the US,\r\nCanada, UK and Australia.=C2=A0 Get high-quality leads through paid search\r\ncampaigns that surpass &amp; strengthen your SEO strategies.</span><span st=\r\nyle=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-no=\r\nrmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65=\r\npt;background-image:initial;background-position:initial;background-size:ini=\r\ntial;background-repeat:initial;background-origin:initial;background-clip:in=\r\nitial;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"font-fa=\r\nmily:Verdana,sans-serif\">=C2=A0</span><span style=3D\"font-family:Arial,sans=\r\n-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m-4692000340142064654gmail-no=\r\nrmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65=\r\npt;background-image:initial;background-position:initial;background-size:ini=\r\ntial;background-repeat:initial;background-origin:initial;background-clip:in=\r\nitial;font-family:&quot;Times New Roman&quot;,serif\"><b><span style=3D\"font=\r\n-family:Verdana,sans-serif\">Our Proud Deliverables</span></b><span style=3D=\r\n\"font-family:Verdana,sans-serif\">=C2=A0-=C2=A0<b>150+ PPC Adwords\r\nProfessionals | 3 years of Experience| Partnered with 20+digital agencies</=\r\nb></span><span style=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><b><span style=3D\"font-family:Verdana,sa=\r\nns-serif;color:black\">=C2=A0</span></b></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><b><span style=3D\"font-family:Verdana,sa=\r\nns-serif;background-image:initial;background-position:initial;background-si=\r\nze:initial;background-repeat:initial;background-origin:initial;background-c=\r\nlip:initial\">What We Offer:</span></b></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><b><span style=3D\"font-family:Verdana,sa=\r\nns-serif\">=C2=A0</span></b></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:130%;b=\r\nackground-image:initial;background-position:initial;background-size:initial=\r\n;background-repeat:initial;background-origin:initial;background-clip:initia=\r\nl;font-family:&quot;Times New Roman&quot;,serif\"><b><span style=3D\"line-hei=\r\nght:130%;font-family:Verdana,sans-serif\">1.=C2=A0=C2=A0=C2=A0=C2=A0 15-day\r\nfree trial on 3 projects</span></b><span style=3D\"line-height:130%;font-fam=\r\nily:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:130%;b=\r\nackground-image:initial;background-position:initial;background-size:initial=\r\n;background-repeat:initial;background-origin:initial;background-clip:initia=\r\nl;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"line-height=\r\n:130%;font-family:Verdana,sans-serif\">2.=C2=A0=C2=A0=C2=A0=C2=A0 Free\r\nWebsite Audit Report to map the weak spots.</span><span style=3D\"line-heigh=\r\nt:130%;font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:130%;b=\r\nackground-image:initial;background-position:initial;background-size:initial=\r\n;background-repeat:initial;background-origin:initial;background-clip:initia=\r\nl;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"line-height=\r\n:130%;font-family:Verdana,sans-serif\">3.=C2=A0=C2=A0=C2=A0=C2=A0\r\nCompetitors analysis to pursue keyword mapping and draft marketing campaign=\r\ns</span><span style=3D\"line-height:130%;font-family:Arial,sans-serif\"></spa=\r\nn></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:130%;b=\r\nackground-image:initial;background-position:initial;background-size:initial=\r\n;background-repeat:initial;background-origin:initial;background-clip:initia=\r\nl;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"line-height=\r\n:130%;font-family:Verdana,sans-serif\">4.=C2=A0=C2=A0=C2=A0=C2=A0 We\r\nemploy=C2=A0Tiered link building=C2=A0involving\r\nwebsites with PA, DA &gt; 15. No low quality junk spam.</span><span style=\r\n=3D\"line-height:130%;font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:130%;b=\r\nackground-image:initial;background-position:initial;background-size:initial=\r\n;background-repeat:initial;background-origin:initial;background-clip:initia=\r\nl;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"line-height=\r\n:130%;font-family:Verdana,sans-serif\">5.=C2=A0=C2=A0=C2=A0=C2=A0 We build\r\nat least 2-3 backlinks per project every single day. No Compromise here!</s=\r\npan><span style=3D\"line-height:130%;font-family:Arial,sans-serif\"></span></=\r\np>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:130%;b=\r\nackground-image:initial;background-position:initial;background-size:initial=\r\n;background-repeat:initial;background-origin:initial;background-clip:initia=\r\nl;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"line-height=\r\n:130%;font-family:Verdana,sans-serif\">6.=C2=A0=C2=A0=C2=A0=C2=A0 We use\r\nBasecamp to manage projects to provide real-time performance updates.</span=\r\n><span style=3D\"line-height:130%;font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><span style=3D\"font-family:Verdana,sans-=\r\nserif\">=C2=A0</span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65p=\r\nt;background-image:initial;background-position:initial;background-size:init=\r\nial;background-repeat:initial;background-origin:initial;background-clip:ini=\r\ntial;font-family:&quot;Times New Roman&quot;,serif\"><b><span style=3D\"font-=\r\nfamily:Verdana,sans-serif\">Our All Services</span></b><span style=3D\"font-f=\r\namily:Verdana,sans-serif\">: SEO | PPC | SMO | SMM | Website and\r\nMobile App Design &amp; Development.</span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65p=\r\nt;background-image:initial;background-position:initial;background-size:init=\r\nial;background-repeat:initial;background-origin:initial;background-clip:ini=\r\ntial;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"font-fam=\r\nily:Verdana,sans-serif\">=C2=A0</span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65p=\r\nt;background-image:initial;background-position:initial;background-size:init=\r\nial;background-repeat:initial;background-origin:initial;background-clip:ini=\r\ntial;font-family:&quot;Times New Roman&quot;,serif\"><b><span style=3D\"font-=\r\nfamily:Verdana,sans-serif;background-image:initial;background-position:init=\r\nial;background-size:initial;background-repeat:initial;background-origin:ini=\r\ntial;background-clip:initial\">Interested</span></b><span style=3D\"font-fami=\r\nly:Verdana,sans-serif;background-image:initial;background-position:initial;=\r\nbackground-size:initial;background-repeat:initial;background-origin:initial=\r\n;background-clip:initial\">=C2=A0and want to give it a shot?=C2=A0<b>Let=E2=\r\n=80=99s\r\nhop on a quick Skype/Phone call</b>. I am sure you will love us (100% sure)=\r\n.</span><span style=3D\"font-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65p=\r\nt;background-image:initial;background-position:initial;background-size:init=\r\nial;background-repeat:initial;background-origin:initial;background-clip:ini=\r\ntial;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"font-fam=\r\nily:Verdana,sans-serif\">=C2=A0</span><span style=3D\"font-family:Arial,sans-=\r\nserif\"></span></p>\r\n\r\n<p class=3D\"gmail-m_-6065500086584561423gmail-m6187785815084956404gmail-nor=\r\nmal\" style=3D\"margin:0cm 0cm 0.0001pt;text-align:justify;line-height:12.65p=\r\nt;background-image:initial;background-position:initial;background-size:init=\r\nial;background-repeat:initial;background-origin:initial;background-clip:ini=\r\ntial;font-family:&quot;Times New Roman&quot;,serif\"><span style=3D\"font-fam=\r\nily:Verdana,sans-serif\">Interested?? Email me back with=C2=A0<b>Skype\r\nId OR Whatsapp</b>=C2=A0Number, I&#39;d love to chat.</span><span style=3D\"=\r\nfont-family:Arial,sans-serif\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><span style=3D\"font-family:Verdana,sans-=\r\nserif;color:black\">=C2=A0</span><span style=3D\"font-family:Verdana,sans-ser=\r\nif\"></span></p>\r\n\r\n<p class=3D\"MsoNormal\" style=3D\"margin:0cm 0cm 0.0001pt;line-height:14.1pt;=\r\nbackground-image:initial;background-position:initial;background-size:initia=\r\nl;background-repeat:initial;background-origin:initial;background-clip:initi=\r\nal;font-family:Calibri,sans-serif\"><span style=3D\"font-family:Verdana,sans-=\r\nserif\">Best Regards,</span><span style=3D\"font-family:Verdana,sans-serif\"><=\r\nbr>\r\n</span><b><span style=3D\"font-family:Verdana,sans-serif;color:black;backgro=\r\nund-image:initial;background-position:initial;background-size:initial;backg=\r\nround-repeat:initial;background-origin:initial;background-clip:initial\">Aar=\r\non\r\nReed</span></b><span style=3D\"font-family:Verdana,sans-serif\"><br>\r\nMarketing Executive</span><span style=3D\"font-family:Verdana,sans-serif;fon=\r\nt-size:10pt\"></span></p></div>\r\n<img src=3D\"https://aaronreed1972-dot-yamm-track.appspot.com/FireBase?ukey=\r\n=3D1Ddu2-iSMUH42cQsydZMHjUVRnw5oBBTpA2GokLdc7vA-0&amp;key=3DYAMMID-11288814=\r\n\" width=3D\"1\" height=3D\"1\" alt=3D\"beacon\" style=3D\"display: none;\"></blockq=\r\nuote></div>\r\n\r\n--000000000000e326b8058b962809--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('21', 'Fastbase <investor@analyticsaccounts.com> - investor@analyticsaccounts.com', '10020', '1', NULL, 'New! 12 Month Web Leads Report', '\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"background-color:#fafafa;\" width=\"100%\">\n	<tbody>\n		<tr>\n			<td class=\"h0\" height=\"20\" style=\"font-size:1px;line-height:20px;\"> </td>\n		</tr>\n		<tr>\n			<td align=\"center\">\n			<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"main-table\" width=\"100%\">\n				<tbody>\n					<tr>\n						<td align=\"center\" class=\"layouts-here\">\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"full-width\" style=\"width:560px;\" width=\"560\">\n							<tbody>\n								<tr>\n									<td align=\"center\" class=\"color-bg\" style=\"background-color:#4285f4;border-width:0px 0px 0px;border-style:solid solid none;border-color:#e0e0e0 #e0e0e0;\">\n									<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"container\" style=\"width:480px;\" width=\"480\">\n										<tbody>\n											<tr>\n												<td class=\"spacer\" height=\"5\" style=\"font-size:1px;line-height:5px;\"> </td>\n											</tr>\n										</tbody>\n									</table>\n									</td>\n								</tr>\n							</tbody>\n						</table>\n\n						\n\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"full-width\" style=\"width:560px;\" width=\"560\">\n							<tbody>\n								<tr>\n									<td align=\"center\" style=\"background-color:#ffffff;border:1px solid #e0e0e0;border-top:0 none;border-bottom:1px solid #e0e0e0;\">\n									<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"container\" style=\"width:480px;\" width=\"480\">\n										<tbody>\n											<tr>\n												<td class=\"spacer\" height=\"20\" style=\"font-size:1px;line-height:20px;\"> </td>\n											</tr>\n											<tr>\n												<td class=\"spacer active\" height=\"24\"> </td>\n											</tr>\n											<tr>\n												<td class=\"text\" style=\"color:#525252;font-family:Arial, sans-serif;font-size:15px;line-height:20px;text-align:left;\"><span style=\"font-family:Arial, sans-serif;font-size:22px;line-height:1.2;font-weight:400;\">Web Leads Report 2.0 Extension<br />\n												for Google Analytics</span><br />\n												<br />\n												You can now get a complete list of all your website visitors within the last 12 months using the new <strong>Web Leads 2.0</strong> Extension.<br />\n												<br />\n												The Web Leads report contains all company names, addresses, phone numbers, websites, contact person, email addresses, and important metrics that track your website’s most popular pages.<br />\n												<br />\n												Sign in with Google Analytics for free.</td>\n											</tr>\n											<tr>\n												<td class=\"spacer\" height=\"40\" style=\"font-size:1px;line-height:34px;\"> </td>\n											</tr>\n											<tr>\n												<td align=\"center\">\n												<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"btn-9\">\n													<tbody>\n														<tr>\n															<td><a href=\"http://email.analyticsaccounts.biz/campaigns/cl5782a6a824e/track-url/rt6742z9vc762/b5656a5960746e05085e46e43533faed6e0f005d\" style=\"font-family:Arial, sans-serif;font-size:14px;font-weight:400;line-height:1.08;padding:13px 20px;text-align:center;background-color:#4285f4;color:#ffffff;text-decoration:none;\">SIGN IN WITH <span style=\"font-weight:bold;\">GOOGLE ANALYTICS</span></a></td>\n														</tr>\n													</tbody>\n												</table>\n												</td>\n											</tr>\n											<tr>\n												<td class=\"spacer\" height=\"40\" style=\"font-size:1px;line-height:10px;\"> </td>\n											</tr>\n											<tr>\n												<td class=\"spacer\" height=\"12\" style=\"font-size:1px;line-height:10px;\"> </td>\n											</tr>\n											<tr>\n												<td class=\"text\" style=\"color:#494848;font-family:\'Open Sans\', Arial, sans-serif;font-size:14px;line-height:20px;text-align:left;\"><span class=\"text\" style=\"color:#494848;font-family:\'Open Sans\', Arial, sans-serif;font-size:14px;line-height:20px;text-align:left;\">Sincerely,<br />\n												Fastbase / Extension to Google Analytics</span><br />\n												 </td>\n											</tr>\n										</tbody>\n									</table>\n									</td>\n								</tr>\n							</tbody>\n						</table>\n\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"full-width\" style=\"width:560px;\" width=\"560\">\n							<tbody>\n								<tr>\n									<td>\n									<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"container\" style=\"width:480px;\" width=\"480\">\n										<tbody>\n											<tr>\n												<td class=\"spacer\" height=\"15\" style=\"font-size:1px;line-height:15px;\"> </td>\n											</tr>\n											<tr>\n												<td class=\"text\" style=\"color:#494848;font-family:Arial, sans-serif;font-size:10px;line-height:16px;text-align:center;\">Copyright © 2019 Fastbase Inc. 315 Montgomery Street, San Francisco, CA 94104, USA<br />\n												<br />\n												This email was sent to info@apusseo.com on 2019-06-21. If you do not wish to receive such emails in the future, please unsubscribe here:<br />\n												<a href=\"http://email.analyticsaccounts.biz/campaigns/cl5782a6a824e/track-url/rt6742z9vc762/5a9ff1aad4c0185bccf645958a77b3014c3da936\" style=\"text-decoration:underline;color:#6B6B6B;\">http://email.analyticsaccounts.biz/lists/qx0273askv853/unsubscribe/rt6742z9vc762/cl5782a6a824e/unsubscribe-direct</a><br />\n												You can also change your preferences at your profile\'s page here: <a href=\"http://email.analyticsaccounts.biz/campaigns/cl5782a6a824e/track-url/rt6742z9vc762/78c5de7d253193444d8596af5f8784c6adb8b87f\" style=\"text-decoration:underline;color:#6B6B6B;\">http://email.analyticsaccounts.biz/lists/qx0273askv853/update-profile/rt6742z9vc762</a></td>\n											</tr>\n											<tr>\n												<td align=\"center\"> </td>\n											</tr>\n											<tr>\n												<td class=\"spacer\" height=\"17\" style=\"font-size:1px;line-height:17px;\"> </td>\n											</tr>\n										</tbody>\n									</table>\n									</td>\n								</tr>\n							</tbody>\n						</table>\n						</td>\n					</tr>\n					<tr>\n						<td>\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"footer\" width=\"100%\">\n							<tbody>\n								<tr>\n									<td align=\"center\">\n									<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"container\" style=\"width:560px;\" width=\"560\">\n										<tbody>\n											<tr>\n												<td class=\"spacer\" height=\"20\" style=\"font-size:1px;line-height:20px;\"> </td>\n											</tr>\n											<tr>\n												<td> </td>\n											</tr>\n											<tr>\n												<td class=\"spacer\" height=\"20\" style=\"font-size:1px;line-height:20px;\"> </td>\n											</tr>\n										</tbody>\n									</table>\n									</td>\n								</tr>\n							</tbody>\n						</table>\n						</td>\n					</tr>\n				</tbody>\n			</table>\n			</td>\n		</tr>\n	</tbody>\n</table>\n<img width=\"1\" height=\"1\" src=\"http://email.analyticsaccounts.biz/campaigns/cl5782a6a824e/track-opening/rt6742z9vc762\" alt=\"\" />\n', 'new', '0', '0', '1', '0', NULL, '1561084802', '1', '1', '0', 'Return-Path: <bounce-info=apusseo.com@smtp.analyticsaccounts.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id zrJsCqpCDF0TrAcAMoQ/pw\r\n	(envelope-from <bounce-info=apusseo.com@smtp.analyticsaccounts.com>)\r\n	for <info@apusseo.com>; Fri, 21 Jun 2019 05:36:26 +0300\r\nReturn-path: <bounce-info=apusseo.com@smtp.analyticsaccounts.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Fri, 21 Jun 2019 05:36:26 +0300\r\nReceived: from gateway25.hack-pr.team ([51.255.10.25]:44561)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-GCM-SHA384:256)\r\n	(Exim 4.92)\r\n	(envelope-from <bounce-info=apusseo.com@smtp.analyticsaccounts.com>)\r\n	id 1he9Pe-0026na-0M\r\n	for info@apusseo.com; Fri, 21 Jun 2019 05:36:26 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256;\r\n bh=R5wAhWI4QhXSy3pUe94In90IrWBQinWd/tjvYgaK06o=; d=analyticsaccounts.com;\r\n h=Message-ID: Date: Subject: From: To: MIME-Version: Content-Type:\r\n Feedback-ID; i=@analyticsaccounts.com; s=mail; c=relaxed/relaxed;\r\n t=1561084540;\r\n b=zdxblfcLZnZihIkLosMKVD16JD/uS0bXfEdCVo0cIWvxCsMaos1+NXi0HcBECOTOihU+TU4n3\r\n 3JYZKw1UZiTgB+Sz+k78GxN3QkcdTl8XXqoRN59UY81iI6ZCMbmqXyr4MndYMh4DiXhoMwOfE\r\n pbdkiCPHbU2MENClqmk4PvBuY=\r\nMessage-ID: <bf05a376188c1e8e242eb28410104c16@smtp.analyticsaccounts.com>\r\nDate: Fri, 21 Jun 2019 02:35:39 +0000\r\nSubject: New! 12 Month Web Leads Report\r\nFrom: Fastbase <investor@analyticsaccounts.com>\r\nTo: \"info@apusseo.com\" <info@apusseo.com>\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative;\r\n boundary=\"_=_swift_v4_1561084539_98cdf212d6046e08199a61d8d10dbdcd_=_\"\r\nX-Subscriber-Uid: rt6742z9vc762\r\nX-Report-Abuse: Please report abuse for this campaign here:\r\n http://email.analyticsaccounts.biz/campaigns/cl5782a6a824e/report-abuse/qx0273askv853/rt6742z9vc762\r\nX-Mailer: SwiftMailer - 5.4.x\r\nX-EBS: http://email.analyticsaccounts.biz/lists/block-address\r\nX-Campaign-Uid: cl5782a6a824e\r\nFeedback-ID: cl5782a6a824e:rt6742z9vc762:qx0273askv853:hw486ha30gfa3\r\n\r\n \r\n--_=_swift_v4_1561084539_98cdf212d6046e08199a61d8d10dbdcd_=_\r\nContent-Type: text/plain; charset=utf-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nWeb Leads Report 2.0 Extension for Google Analytics\r\n\r\nYou can now get a =\r\ncomplete list of all your website visitors within the last 12 months using =\r\nthe new Web Leads 2.0 Extension.\r\nThe Web Leads report contains all compan=\r\ny names, addresses, phone numbers, websites, contact person, email addresse=\r\ns, and important metrics that track your website=E2=80=99s most popular pag=\r\nes.\r\n\r\nSign in with Google Analytics for free: http://email.analyticsacco=\r\nunts.biz/campaigns/cl5782a6a824e/track-url/rt6742z9vc762/b1fbc4ba4c41e09b14=\r\ndd4061b4ab31a58e4513d5\r\n\r\nSincerely,\r\nFastbase / Extension to Google Ana=\r\nlytics\r\n\r\n--------------\r\nThis email was sent to info@apusseo.com on 201=\r\n9-06-21. If you do not wish to receive such emails in the future, please un=\r\nsubscribe here:\r\nhttp://email.analyticsaccounts.biz/lists/qx0273askv853/un=\r\nsubscribe/rt6742z9vc762/cl5782a6a824e/unsubscribe-direct\r\n\r\n-------------=\r\n-\r\nYou can also change your preferences at your profile\'s page here: http:=\r\n//email.analyticsaccounts.biz/lists/qx0273askv853/update-profile/rt6742z9vc=\r\n762\r\n\r\n--_=_swift_v4_1561084539_98cdf212d6046e08199a61d8d10dbdcd_=_\r\nContent-Type: text/html; charset=utf-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<!DOCTYPE html>\r\n<html>\r\n<head><meta http-equiv=3D\"Content-Type\" content=3D\"text/html; charset=3Dutf=\r\n-8\"><meta name=3D\"viewport\" content=3D\"width=3Ddevice-width, maximum-scale=\r\n=3D1\">\r\n=09<title>Web Leads for Analytics</title>\r\n=09<link href=3D\"https://fonts.googleapis.com/css?family=3DOpen+Sans:400,40=\r\n0italic,700&subset=3Dlatin,cyrillic\" rel=3D\"stylesheet\" type=3D\"text/css\" /=\r\n>\r\n=09<link href=3D\"https://fonts.googleapis.com/css?family=3DPoppins:400,700\"=\r\n rel=3D\"stylesheet\" type=3D\"text/css\" />\r\n=09<link href=3D\"https://fonts.googleapis.com/css?family=3DPrompt:700,400\" =\r\nrel=3D\"stylesheet\" type=3D\"text/css\" />\r\n=09<link href=3D\"https://fonts.googleapis.com/css?family=3DOleo+Script+Swas=\r\nh+Caps\" rel=3D\"stylesheet\" type=3D\"text/css\" />\r\n=09<link href=3D\"https://fonts.googleapis.com/css?family=3DPalanquin+Dark:4=\r\n00,700\" rel=3D\"stylesheet\" type=3D\"text/css\" />\r\n=09<style media=3D\"all\" type=3D\"text/css\">*\r\n    {\r\n        -webkit-text-size-adjust:none;\r\n        -ms-text-size-adjust:none\r\n    }\r\n    html\r\n    {\r\n        width:100%\r\n    }\r\n    body\r\n    {\r\n        width:100%;\r\n        background-color:#fafafa;\r\n        height:100%;\r\n        margin:0;\r\n        padding:0;\r\n        -webkit-font-smoothing:antialiased\r\n    }\r\n    p\r\n    {\r\n        margin:0\r\n    }\r\n    a\r\n    {\r\n        color:inherit\r\n    }\r\n    a[x-apple-data-detectors]\r\n    {\r\n        color:inherit!important;\r\n        text-decoration:inherit!important\r\n    }\r\n    .full-image img\r\n    {\r\n        width:100%!important\r\n    }\r\n=09</style>\r\n=09<style type=3D\"text/css\">@media only screen and (max-width: 768px) {\r\n        .main-table\r\n        {\r\n            width:100%!important;\r\n            clear:both;\r\n            min-width:0!important\r\n        }      =20\r\n        .image img\r\n        {\r\n            width:100%!important;\r\n            height:auto!important\r\n        }\r\n    }\r\n    @media only screen and (max-width: 640px) {\r\n        .container\r\n        {\r\n            width:320px!important;\r\n            min-width:0!important\r\n        }      =20\r\n        .m-cell\r\n        {\r\n            display:block!important;\r\n            float:left!important;\r\n            width:100%!important;\r\n            max-width:none!important;\r\n            min-width:0!important\r\n        }      =20\r\n        .stripes\r\n        {\r\n            border:0 none!important\r\n        }      =20\r\n        .stripes-top\r\n        {\r\n            border-bottom:0 none!important\r\n        }      =20\r\n        .m-w100,.full-width\r\n        {\r\n            width:100%!important;\r\n            max-width:none!important\r\n        }      =20\r\n        .col-sm\r\n        {\r\n            width:180px!important\r\n        }      =20\r\n        .inner\r\n        {\r\n            width:280px!important\r\n        }      =20\r\n        .tbl-sm\r\n        {\r\n            width:220px!important\r\n        }      =20\r\n        .img-bg\r\n        {\r\n            background-size:cover\r\n        }      =20\r\n        .nav\r\n        {\r\n            width:100%!important;\r\n            clear:both;\r\n            text-align:center\r\n        }      =20\r\n        .nav .text\r\n        {\r\n            width:31%\r\n        }      =20\r\n        .mw-auto\r\n        {\r\n            width:auto!important\r\n        }      =20\r\n        .mb-auto\r\n        {\r\n            height:auto!important\r\n        }      =20\r\n        .h1\r\n        {\r\n            font-size:34px!important\r\n        }      =20\r\n        .h1-2,.h1-4\r\n        {\r\n            font-size:40px!important\r\n        }      =20\r\n        .h2\r\n        {\r\n            font-size:28px!important\r\n        }      =20\r\n        .h4\r\n        {\r\n            font-size:16px!important\r\n        }      =20\r\n        .h80\r\n        {\r\n            height:75px!important;\r\n            line-height:75px!important\r\n        }      =20\r\n        .h50\r\n        {\r\n            height:50px!important;\r\n            line-height:50px!important\r\n        }      =20\r\n        .h40\r\n        {\r\n            height:40px!important;\r\n            line-height:40px!important\r\n        }      =20\r\n        .h0\r\n        {\r\n            display:none!important\r\n        }      =20\r\n        .m-sp\r\n        {\r\n            background:none!important;\r\n            height:15px!important\r\n        }      =20\r\n        .btn td,.btn-1 td,.btn-2 td,.btn-3 td,.btn-4 td,.btn-5 td,.btn-7 td=\r\n,.btn-8 td,.btn-9 td,.btn-10 td\r\n        {\r\n            padding:0!important\r\n        }      =20\r\n        .btn td a,.btn-2 td a\r\n        {\r\n            display:block;\r\n            padding:14px 22px\r\n        }      =20\r\n        .btn-1 td a\r\n        {\r\n            display:block;\r\n            padding:13px 20px\r\n        }      =20\r\n        .btn-3 td a,.btn-5 td a\r\n        {\r\n            display:block;\r\n            padding:14px 30px\r\n        }      =20\r\n        .btn-4 td a\r\n        {\r\n            display:block;\r\n            padding:13px 30px\r\n        }      =20\r\n        .btn-7 td a,.btn-8 td a\r\n        {\r\n            display:block;\r\n            padding:9px 20px\r\n        }      =20\r\n        .btn-9 td a\r\n        {\r\n            display:block;\r\n            padding:13px 35px\r\n        }      =20\r\n        .btn-10 td a\r\n        {\r\n            display:block;\r\n            padding:11px 33px\r\n        }      =20\r\n        .image img,.timer img\r\n        {\r\n            width:100%!important;\r\n            height:auto!important\r\n        }      =20\r\n        .m-left\r\n        {\r\n            text-align:left!important\r\n        }      =20\r\n        .footer .text,.m-center\r\n        {\r\n            text-align:center!important\r\n        }\r\n    }\r\n    @media only screen and (max-width: 380px) {\r\n        .container\r\n        {\r\n            width:280px!important\r\n        }      =20\r\n        .inner\r\n        {\r\n            width:240px!important\r\n        }\r\n    }\r\n    @media only screen and (max-width: 350px) {\r\n        .container\r\n        {\r\n            width:240px!important\r\n        }      =20\r\n        .inner\r\n        {\r\n            width:200px!important\r\n        }\r\n    }\r\n=09</style>\r\n=09<!--[if gte mso 9]>   <style type=3D\"text/css\">     body, table, tr, td,=\r\n h1, h2, h3, h4, h5, h6, ul, li, ol, dl, dd, dt {       font-family: Helvet=\r\nica, Arial, sans-serif !important;     }     .h4 { line-height: 120% !impor=\r\ntant; }     .h5 { line-height: 130% !important; }     .h1-4 { line-height: =\r\n90% !important; }     .price-2, .plus { line-height: 80% !important; }     =\r\n.btn-7 td { line-height: 108% !important; }   </style>   <![endif]--><!--[i=\r\nf gte mso 9]><xml>   <o:OfficeDocumentSettings>     <o:AllowPNG/>     <o:Pi=\r\nxelsPerInch>96</o:PixelsPerInch>   </o:OfficeDocumentSettings> </xml><![end=\r\nif]-->\r\n</head>\r\n<body style=3D\"-webkit-text-size-adjust: none; margin: 0; padding: 0; font-=\r\nfamily: Arial,sans-serif; background-color: #fafafa; color: #494848;\">\r\n<table align=3D\"center\" border=3D\"0\" cellpadding=3D\"0\" cellspacing=3D\"0\" st=\r\nyle=3D\"background-color: #fafafa;\" width=3D\"100%\"><!-- Spacer -->\r\n=09<tbody>\r\n=09=09<tr>\r\n=09=09=09<td class=3D\"h0\" height=3D\"20\" style=3D\"font-size: 1px; line-heigh=\r\nt: 20px;\">=C2=A0</td>\r\n=09=09</tr>\r\n=09=09<tr>\r\n=09=09=09<td align=3D\"center\"><!--[if (gte mso 9)|(IE)]>     <table width=\r\n=3D\"800\" align=3D\"center\" cellpadding=3D\"0\" cellspacing=3D\"0\" border=3D\"0\" =\r\nstyle=3D\"width: 800px;\">       <tr>         <td align=3D\"center\" valign=3D\"=\r\ntop\">     <![endif]-->\r\n=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=3D\"0\" cellspacing=\r\n=3D\"0\" class=3D\"main-table\" style=3D\"max-width: 800px; min-width: 700px;\" w=\r\nidth=3D\"100%\">\r\n=09=09=09=09<tbody>\r\n=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09<td align=3D\"center\" class=3D\"layouts-here\">\r\n=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=3D\"0\" ce=\r\nllspacing=3D\"0\" class=3D\"full-width\" style=3D\"width: 560px;\" width=3D\"560\">\r\n=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09<td align=3D\"center\" class=3D\"color-bg\" style=3D=\r\n\"background-color: #4285f4; border-width: 0px 0px 0px; border-style: solid =\r\nsolid none; border-color: #e0e0e0 #e0e0e0 -moz-use-text-color; -moz-border-=\r\ntop-colors: none; -moz-border-right-colors: none; -moz-border-bottom-colors=\r\n: none; -moz-border-left-colors: none; border-image: none; border-radius: 0=\r\npx 0px 0px 0px;\">\r\n=09=09=09=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=\r\n=3D\"0\" cellspacing=3D\"0\" class=3D\"container\" style=3D\"width: 480px;\" width=\r\n=3D\"480\">\r\n=09=09=09=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"5\" style=\r\n=3D\"font-size: 1px; line-height: 5px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09=09=09=09</table>\r\n=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09</table>\r\n\r\n=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=3D\"0\" ce=\r\nllspacing=3D\"0\" class=3D\"full-width\" style=3D\"width: 560px;\" width=3D\"560\">\r\n=09=09=09=09=09=09</table>\r\n\r\n=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=3D\"0\" ce=\r\nllspacing=3D\"0\" class=3D\"full-width\" style=3D\"width: 560px;\" width=3D\"560\">\r\n=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09<td align=3D\"center\" style=3D\"background-color: =\r\n#ffffff; border: 1px solid #e0e0e0; border-top: 0 none; border-bottom: 1px =\r\nsolid #e0e0e0;\">\r\n=09=09=09=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=\r\n=3D\"0\" cellspacing=3D\"0\" class=3D\"container\" style=3D\"width: 480px;\" width=\r\n=3D\"480\">\r\n=09=09=09=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"20\" styl=\r\ne=3D\"font-size: 1px; line-height: 20px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer active\" height=3D\"2=\r\n4\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"text\" style=3D\"color: #525=\r\n252; font-family: Arial,sans-serif; font-size: 15px; line-height: 20px; tex=\r\nt-align: left;\"><span style=3D\"font-family: Arial,sans-serif; font-size: 22=\r\npx; line-height: 1.2; font-weight: 400;\">Web Leads Report 2.0 Extension<br =\r\n/>\r\n=09=09=09=09=09=09=09=09=09=09=09=09for Google Analytics</span><br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09You can now get a complete list of all =\r\nyour website visitors within the last 12 months using the new <strong>Web L=\r\neads 2.0</strong> Extension.<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09The Web Leads report contains all compa=\r\nny names, addresses, phone numbers, websites, contact person, email address=\r\nes, and important metrics that track your website=E2=80=99s most popular pa=\r\nges.<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09Sign in with Google Analytics for free.=\r\n</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"40\" styl=\r\ne=3D\"font-size: 1px; line-height: 34px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td align=3D\"center\">\r\n=09=09=09=09=09=09=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" ce=\r\nllpadding=3D\"0\" cellspacing=3D\"0\" class=3D\"btn-9\" style=3D\"min-width: 160px=\r\n;\">\r\n=09=09=09=09=09=09=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09=09=09=09<td><a href=3D\"http://email.an=\r\nalyticsaccounts.biz/campaigns/cl5782a6a824e/track-url/rt6742z9vc762/b5656a5=\r\n960746e05085e46e43533faed6e0f005d\" style=3D\"border-radius: 2px; font-family=\r\n: Arial,sans-serif; font-size: 14px; font-weight: 400; line-height: 1.08; p=\r\nadding: 13px 20px; text-align: center; background-color: #4285f4; color: #f=\r\nfffff; text-decoration: none;\">SIGN IN WITH <span style=3D\"font-weight:bold=\r\n;\">GOOGLE ANALYTICS</span></a></td>\r\n=09=09=09=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09=09=09=09=09=09=09</table>\r\n=09=09=09=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"40\" styl=\r\ne=3D\"font-size: 1px; line-height: 10px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"12\" styl=\r\ne=3D\"font-size: 1px; line-height: 10px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"text\" style=3D\"color: #494=\r\n848; font-family: \'Open Sans\',Arial,sans-serif; font-size: 14px; line-heigh=\r\nt: 20px; text-align: left;\"><span class=3D\"text\" style=3D\"color: #494848; f=\r\nont-family: \'Open Sans\',Arial,sans-serif; font-size: 14px; line-height: 20p=\r\nx; text-align: left;\">Sincerely,<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09Fastbase / Extension to Google Analytic=\r\ns</span><br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09=09=09=09</table>\r\n=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09</table>\r\n\r\n=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=3D\"0\" ce=\r\nllspacing=3D\"0\" class=3D\"full-width\" style=3D\"width: 560px;\" width=3D\"560\">\r\n=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09<td>\r\n=09=09=09=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=\r\n=3D\"0\" cellspacing=3D\"0\" class=3D\"container\" style=3D\"width: 480px;\" width=\r\n=3D\"480\">\r\n=09=09=09=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"15\" styl=\r\ne=3D\"font-size: 1px; line-height: 15px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"text\" style=3D\"color: #494=\r\n848; font-family: Arial,sans-serif; font-size: 10px; line-height: 16px; tex=\r\nt-align: center;\">Copyright =C2=A9 2019 Fastbase Inc. 315 Montgomery Street=\r\n, San Francisco, CA 94104,=C2=A0USA<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09This email was sent to info@apusseo.com=\r\n on 2019-06-21. If you do not wish to receive such emails in the future, pl=\r\nease unsubscribe here:<br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09<a data-unsubtag=3D\"_DIRECT_UNSUBSCRIBE=\r\n_URL_\" href=3D\"http://email.analyticsaccounts.biz/campaigns/cl5782a6a824e/t=\r\nrack-url/rt6742z9vc762/5a9ff1aad4c0185bccf645958a77b3014c3da936\" style=3D\"t=\r\next-decoration:underline; color:#6B6B6B;\">http://email.analyticsaccounts.bi=\r\nz/lists/qx0273askv853/unsubscribe/rt6742z9vc762/cl5782a6a824e/unsubscribe-d=\r\nirect</a><br />\r\n=09=09=09=09=09=09=09=09=09=09=09=09You can also change your preferences at=\r\n your profile\'s page here: <a href=3D\"http://email.analyticsaccounts.biz/ca=\r\nmpaigns/cl5782a6a824e/track-url/rt6742z9vc762/78c5de7d253193444d8596af5f878=\r\n4c6adb8b87f\" style=3D\"text-decoration:underline; color:#6B6B6B;\" target=3D\"=\r\n_blank\">http://email.analyticsaccounts.biz/lists/qx0273askv853/update-profi=\r\nle/rt6742z9vc762</a></td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td align=3D\"center\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"17\" styl=\r\ne=3D\"font-size: 1px; line-height: 17px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09=09=09=09</table>\r\n=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09</table>\r\n=09=09=09=09=09=09</td>\r\n=09=09=09=09=09</tr>\r\n=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09<td>\r\n=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=3D\"0\" ce=\r\nllspacing=3D\"0\" class=3D\"footer\" width=3D\"100%\">\r\n=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09<td align=3D\"center\">\r\n=09=09=09=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" cellpadding=\r\n=3D\"0\" cellspacing=3D\"0\" class=3D\"container\" style=3D\"width: 560px;\" width=\r\n=3D\"560\">\r\n=09=09=09=09=09=09=09=09=09=09<tbody>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"20\" styl=\r\ne=3D\"font-size: 1px; line-height: 20px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td>=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09=09<tr>\r\n=09=09=09=09=09=09=09=09=09=09=09=09<td class=3D\"spacer\" height=3D\"20\" styl=\r\ne=3D\"font-size: 1px; line-height: 20px;\">=C2=A0</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09=09=09=09</table>\r\n=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09</tr>\r\n=09=09=09=09=09=09=09</tbody>\r\n=09=09=09=09=09=09</table>\r\n=09=09=09=09=09=09<!-- End Footer --></td>\r\n=09=09=09=09=09</tr>\r\n=09=09=09=09</tbody>\r\n=09=09=09</table>\r\n=09=09=09<!--[if (gte mso 9)|(IE)]>     </td>     </tr>     </table>     <!=\r\n[endif]--></td>\r\n=09=09</tr>\r\n=09</tbody>\r\n</table>\r\n<img width=3D\"1\" height=3D\"1\" src=3D\"http://email.analyticsaccounts.biz/cam=\r\npaigns/cl5782a6a824e/track-opening/rt6742z9vc762\" alt=3D\"\" />\r\n</body>\r\n</html>\r\n\r\n--_=_swift_v4_1561084539_98cdf212d6046e08199a61d8d10dbdcd_=_--\r\n\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('22', 'Ethel Gilbertdata <Ethel.gilbertdata@outlook.com> - Ethel.gilbertdata@outlook.com', '10021', '1', NULL, 'Marketing Agency Professionals E-Mails List', '\n<div class=\"WordSection1\">\n<p class=\"MsoNormal\"><a></a><a></a><a></a><a><span><span><span><span style=\"font-family:\'Times New Roman\', serif;\">Hi,</span></span></span></span></a></p><p><a></a></p><a></a>\n<p class=\"MsoNormal\"><span><span><span><span><span style=\"font-family:\'Times New Roman\', serif;\"></span></span></span></span></span></p><p> </p>\n<p class=\"MsoNoSpacing\"><span><span><span><span><span style=\"font-family:\'Times New Roman\', serif;\">I am contacting you to\n check if you </span></span></span></span></span><span><span><span><span class=\"size\"><span style=\"font-family:\'Times New Roman\', serif;\">would you be interested\n in <b>Marketing Agency Professionals E-Mails Lists?</b> </span></span></span></span></span><span><span><span><span style=\"font-family:\'Times New Roman\', serif;\">Which\n includes complete contact details and verified email addresses for your marketing and business activities across\n<b>USA, UK, Canada, Australia and etc</b></span></span></span></span><span><span><b><span style=\"font-family:\'Times New Roman\', serif;\">.</span></b></span></span><span><span><span style=\"font-family:\'Times New Roman\', serif;\"></span></span></span></p><p></p>\n<p class=\"MsoNormal\"><span><span><span style=\"font-family:\'Times New Roman\', serif;\"></span></span></span></p><p></p>\n<p class=\"MsoNormal\"><span><span><a><span style=\"font-family:\'Times New Roman\', serif;\">Would be interested in acquiring mentioned below contacts:</span></a></span></span></p><p><a></a></p><a></a>\n<p class=\"MsoNormal\" style=\"margin-left:.25in;\"><span><span><span><span style=\"font-family:\'Times New Roman\', serif;\"></span></span></span></span></p><p> </p>\n<p class=\"MsoListParagraphCxSpFirst\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Marketing managers</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Communications managers</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Public relations specialists</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Brand manager/Owners</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Product marketing managers</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Market research analysts</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Digital marketing specialists</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Content marketing specialists</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">SEO specialists</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Social media marketers</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Marketing automation specialists</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Media owners</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Advertising and marketing agencies</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Event Marketers</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Channel Marketing</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">B2B Providers</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoListParagraphCxSpLast\" style=\"text-indent:-.25in;\">\n<span><span><span><span style=\"font-family:Symbol;\"><span>·<span style=\"font:7pt \'Times New Roman\';\">        \n</span></span></span><b><span style=\"font-family:\'Times New Roman\', serif;\">Decision Makers @ Startups and More.</span></b></span></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoNormal\" style=\"margin-left:.25in;\"><span><span><span><b><span style=\"font-family:\'Times New Roman\', serif;\"></span></b></span></span></span></p><p><b> </b></p><b></b>\n<span></span><span></span>\n<p class=\"MsoNoSpacing\"><span><a><span style=\"font-family:\'Times New Roman\', serif;\">Please let me know which target criteria you would like to acquire, so I can give you more information about counts, pricing\n and few samples for the same.</span></a></span></p><p><a></a></p><a></a>\n<p class=\"MsoNoSpacing\"><span><span><span style=\"font-family:\'Times New Roman\', serif;\"></span></span></span></p><p> </p>\n<p class=\"MsoNoSpacing\"><span><span><span style=\"font-family:\'Times New Roman\', serif;\">Target Industry:  ___________?? (Any Industry)        \n</span></span></span></p><p></p>\n<p class=\"MsoNoSpacing\"><span><span><span style=\"font-family:\'Times New Roman\', serif;\">Target Geography:  ___________?? (Example: USA, UK, Canada, Australia, etc.…)\n</span></span></span></p><p></p>\n<p class=\"MsoNoSpacing\"><span><span><span style=\"font-family:\'Times New Roman\', serif;\">Target Job Title:  ________________?? (Example: CEO, VP, Managers, Directors, etc.…)</span></span></span></p><p></p>\n<p class=\"MsoNoSpacing\"><span><span><b><span style=\"font-family:\'Times New Roman\', serif;\"></span></b></span></span></p><p><b> </b></p><b></b>\n<p class=\"MsoNoSpacing\"><span><span><span style=\"font-family:\'Times New Roman\', serif;\">Let me know your interest, so that we could discuss further.</span></span></span></p><p></p>\n<p class=\"MsoNoSpacing\"><span><span><span style=\"font-family:\'Times New Roman\', serif;\"></span></span></span></p><p> </p>\n<p class=\"MsoNoSpacing\"><span><span><span style=\"font-family:\'Times New Roman\', serif;\">Best Regards,</span></span></span></p><p></p>\n<p class=\"MsoNoSpacing\"><span><span><b><span style=\"font-family:\'Times New Roman\', serif;\">Ethel Warren</span></b></span></span></p><p><b></b></p><b></b>\n<p class=\"MsoNoSpacing\"><span><span><b><span style=\"font-family:\'Times New Roman\', serif;\">Demand Gen</span></b></span></span></p><p><b></b></p><b></b>\n<span></span><span></span>\n<p class=\"MsoNormal\"><span style=\"font-family:\'Times New Roman\', serif;\"></span></p><p> </p>\n<p class=\"MsoNormal\"></p><p> </p>\n</div>\n', 'new', '0', '0', '1', '0', NULL, '1562190905', '1', '1', '0', 'Return-Path: <Ethel.gilbertdata@outlook.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id nWjeCLMjHV3IBwsAMoQ/pw\r\n	(envelope-from <Ethel.gilbertdata@outlook.com>)\r\n	for <info@apusseo.com>; Thu, 04 Jul 2019 00:52:51 +0300\r\nReturn-path: <Ethel.gilbertdata@outlook.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Thu, 04 Jul 2019 00:52:51 +0300\r\nReceived: from mail-oln040092254104.outbound.protection.outlook.com ([40.92.254.104]:46544 helo=APC01-PU1-obe.outbound.protection.outlook.com)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-SHA384:256)\r\n	(Exim 4.92)\r\n	(envelope-from <Ethel.gilbertdata@outlook.com>)\r\n	id 1hinBK-00323B-GK\r\n	for info@apusseo.com; Thu, 04 Jul 2019 00:52:51 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=outlook.com;\r\n s=selector1;\r\n h=From:Date:Subject:Message-ID:Content-Type:MIME-Version:X-MS-Exchange-SenderADCheck;\r\n bh=xPxt6iccITVMfKXSJ6QFk+vpdWAufM5VFsdKcmmfGJ4=;\r\n b=AVZEHkesyTmZ9DFn+sAHSIEL3GPJB/fQcgaOejuOMOCTwLmwxvqAxg3iKjbPVRyjS/b2JxHAupWP3D2bGldJWaRT18oNrXNDRZF/PpQtl8U2o3U6SqhcpNHesH7rPq9TDpJptZA/2yYv3Z4Slq3HzinO1k6fG5UkyKTpY+nr1sUVUhEa4lPHO675Gz/hRHlHY8YUBEc35kqH/xWxOs8oxSGGHNFTyxP+/74JW/7uJ9RFBBmKtbXj7SbHirfmiopoS+zOV/ZmePnBpn9rMxVeEOoXJz7xHIiJcxSDJSz57ukvfC1XfKaMTz6dHo965EeEIygzlQnTEbDkKrw/bcdkYQ==\r\nReceived: from SG2APC01FT064.eop-APC01.prod.protection.outlook.com\r\n (10.152.250.53) by SG2APC01HT247.eop-APC01.prod.protection.outlook.com\r\n (10.152.251.118) with Microsoft SMTP Server (version=TLS1_2,\r\n cipher=TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384) id 15.20.2032.15; Wed, 3 Jul\r\n 2019 21:51:35 +0000\r\nReceived: from SG2PR03MB4486.apcprd03.prod.outlook.com (10.152.250.55) by\r\n SG2APC01FT064.mail.protection.outlook.com (10.152.251.229) with Microsoft\r\n SMTP Server (version=TLS1_2, cipher=TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384) id\r\n 15.20.2032.15 via Frontend Transport; Wed, 3 Jul 2019 21:51:35 +0000\r\nReceived: from SG2PR03MB4486.apcprd03.prod.outlook.com\r\n ([fe80::6846:ebef:4016:b598]) by SG2PR03MB4486.apcprd03.prod.outlook.com\r\n ([fe80::6846:ebef:4016:b598%7]) with mapi id 15.20.2052.010; Wed, 3 Jul 2019\r\n 21:51:35 +0000\r\nFrom: Ethel Gilbertdata <Ethel.gilbertdata@outlook.com>\r\nSubject: Marketing Agency Professionals E-Mails List\r\nThread-Topic: Marketing Agency Professionals E-Mails List\r\nThread-Index: AdUx6XBi8VJZIsDnS6mwYstCbtfMcA==\r\nImportance: high\r\nX-Priority: 1\r\nDisposition-Notification-To: Ethel Gilbertdata <Ethel.gilbertdata@outlook.com>\r\nReturn-Receipt-To: <Ethel.gilbertdata@outlook.com>\r\nDate: Wed, 3 Jul 2019 21:51:34 +0000\r\nMessage-ID: <SG2PR03MB448668D7338AF5503733266EF1FB0@SG2PR03MB4486.apcprd03.prod.outlook.com>\r\nAccept-Language: en-US\r\nContent-Language: en-US\r\nX-MS-Has-Attach:\r\nX-MS-TNEF-Correlator:\r\nx-incomingtopheadermarker: OriginalChecksum:F1CF65CE4E20ABF3EBE874917A45E23820CA879149B473AB18B34C6D951E14A6;UpperCasedChecksum:328C10984B73DFA57A3DE820576B19D4E1D11A226A6C30548AFFD9EAAEDB7218;SizeAsReceived:25568;Count:43\r\nx-tmn: [963jLM1xQYyAOWUfRWBvbARRR+S7pnom]\r\nx-ms-publictraffictype: Email\r\nx-incomingheadercount: 43\r\nx-eopattributedmessage: 0\r\nx-ms-exchange-slblob-mailprops: 0TRxAplA31Far+R2VrkcO42M/MaacgRVRlBOI/wIRrbj4u+rtfZ7uoTF/uztGBDPgwzMbqx1EPuMBxwkjzPu1hpI6XnK3dvLNEg9yXJFn5A+tm0Tm8FoOxtjM7PIzb+hJSF+XvoinJvbVLDlgfK8rHonYcHjS0kHDZZ9iE4mhm+t1kU8drysgXOG3VlZK3SiG7WTMT+KL99xtESnx946ansjCfih6vN0IFwkEwJ1rptiq70m8T+XdzKENw8wmiryu+zuw3HeA0l6GqY3JZYDriYntMGm6L89bBsZ6z0nZ0ltCcEe/whMD/umhWVCVeF+gEUy9D9iMbMQF0rSlQeE0CS6nYzC+OPo6PoLnp0mA/8fK606rWM/XzQ+5/vXFNfzK0TYBt68RB8ERYshnEyRwWpDXrr6ajbP1/weJsFBMXGSzCLu0JSDCXwpjgCcRuJ5lDFY39C0cIDKX+m7xPudz1hh33M9iYcoQvpk93pQFc0bhO2oKpHthC0Uf6zNf+EWhUL/Ph86RSTW5Rwt2sAdi4ms6nZcZxN2zvk3cyVRSkr3NZb3yoW+C6OvzNxlOkHZoG4mmL6hlciaWJAYLhHeAD3ecCfBYgoB9KbKu8KXvKSn9lCQwmowsmCrn6exeQ9own980XQ9VArt62nDiL+fwA==\r\nx-microsoft-antispam: BCL:0;PCL:0;RULEID:(2390118)(5050001)(7020095)(20181119110)(201702061078)(5061506573)(5061507331)(1603103135)(2017031320274)(201702181274)(2017031322404)(2017031323274)(2017031324274)(1601125500)(1603101475)(1701031045);SRVR:SG2APC01HT247;\r\nx-ms-traffictypediagnostic: SG2APC01HT247:\r\nx-microsoft-antispam-message-info: c3FIjgmcJgfMM5ZZGmwM0yp0F//BXEPqbFoWRUA/E6ZMCUEd7g3UcLyE7mmxfW4q1IlG7LVEEBHnGYnMOvOgnOgvsplACQP4TizsqlLLVU2jxFTL4Abwm9H9kRKjOswOAC61tLO6kz+ZjniKCqTW5aDj9rt8LAUW4LVvlC6oh8JSkANchw1D688X4HZOjTO0\r\nContent-Type: multipart/alternative;\r\n	boundary=\"_000_SG2PR03MB448668D7338AF5503733266EF1FB0SG2PR03MB4486apcp_\"\r\nMIME-Version: 1.0\r\nX-OriginatorOrg: outlook.com\r\nX-MS-Exchange-CrossTenant-RMS-PersistedConsumerOrg: 00000000-0000-0000-0000-000000000000\r\nX-MS-Exchange-CrossTenant-Network-Message-Id: 23c82b1a-025a-4de6-fbc3-08d700009e3a\r\nX-MS-Exchange-CrossTenant-rms-persistedconsumerorg: 00000000-0000-0000-0000-000000000000\r\nX-MS-Exchange-CrossTenant-originalarrivaltime: 03 Jul 2019 21:51:34.8571\r\n (UTC)\r\nX-MS-Exchange-CrossTenant-fromentityheader: Internet\r\nX-MS-Exchange-CrossTenant-id: 84df9e7f-e9f6-40af-b435-aaaaaaaaaaaa\r\nX-MS-Exchange-Transport-CrossTenantHeadersStamped: SG2APC01HT247\r\n\r\n --_000_SG2PR03MB448668D7338AF5503733266EF1FB0SG2PR03MB4486apcp_\r\nContent-Type: text/plain; charset=\"us-ascii\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nHi,\r\n\r\n\r\nI am contacting you to check if you would you be interested in Marketing Ag=\r\nency Professionals E-Mails Lists? Which includes complete contact details a=\r\nnd verified email addresses for your marketing and business activities acro=\r\nss USA, UK, Canada, Australia and etc.\r\nWould be interested in acquiring mentioned below contacts:\r\n\r\n\r\n*         Marketing managers\r\n\r\n*         Communications managers\r\n\r\n*         Public relations specialists\r\n\r\n*         Brand manager/Owners\r\n\r\n*         Product marketing managers\r\n\r\n*         Market research analysts\r\n\r\n*         Digital marketing specialists\r\n\r\n*         Content marketing specialists\r\n\r\n*         SEO specialists\r\n\r\n*         Social media marketers\r\n\r\n*         Marketing automation specialists\r\n\r\n*         Media owners\r\n\r\n*         Advertising and marketing agencies\r\n\r\n*         Event Marketers\r\n\r\n*         Channel Marketing\r\n\r\n*         B2B Providers\r\n\r\n*         Decision Makers @ Startups and More.\r\n\r\n\r\nPlease let me know which target criteria you would like to acquire, so I ca=\r\nn give you more information about counts, pricing and few samples for the s=\r\name.\r\n\r\n\r\n\r\nTarget Industry:  ___________?? (Any Industry)\r\n\r\nTarget Geography:  ___________?? (Example: USA, UK, Canada, Australia, etc.=\r\n...)\r\n\r\nTarget Job Title:  ________________?? (Example: CEO, VP, Managers, Director=\r\ns, etc....)\r\n\r\n\r\n\r\nLet me know your interest, so that we could discuss further.\r\n\r\n\r\n\r\nBest Regards,\r\n\r\nEthel Warren\r\n\r\nDemand Gen\r\n\r\n\r\n\r\n--_000_SG2PR03MB448668D7338AF5503733266EF1FB0SG2PR03MB4486apcp_\r\nContent-Type: text/html; charset=\"us-ascii\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<html xmlns:v=3D\"urn:schemas-microsoft-com:vml\" xmlns:o=3D\"urn:schemas-micr=\r\nosoft-com:office:office\" xmlns:w=3D\"urn:schemas-microsoft-com:office:word\" =\r\nxmlns:m=3D\"http://schemas.microsoft.com/office/2004/12/omml\" xmlns=3D\"http:=\r\n//www.w3.org/TR/REC-html40\">\r\n<head>\r\n<meta http-equiv=3D\"Content-Type\" content=3D\"text/html; charset=3Dus-ascii\"=\r\n>\r\n<meta name=3D\"Generator\" content=3D\"Microsoft Word 15 (filtered medium)\">\r\n<style><!--\r\n/* Font Definitions */\r\n@font-face\r\n	{font-family:Wingdings;\r\n	panose-1:5 0 0 0 0 0 0 0 0 0;}\r\n@font-face\r\n	{font-family:\"Cambria Math\";\r\n	panose-1:2 4 5 3 5 4 6 3 2 4;}\r\n@font-face\r\n	{font-family:Calibri;\r\n	panose-1:2 15 5 2 2 2 4 3 2 4;}\r\n/* Style Definitions */\r\np.MsoNormal, li.MsoNormal, div.MsoNormal\r\n	{margin:0in;\r\n	margin-bottom:.0001pt;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\na:link, span.MsoHyperlink\r\n	{mso-style-priority:99;\r\n	color:#0563C1;\r\n	text-decoration:underline;}\r\na:visited, span.MsoHyperlinkFollowed\r\n	{mso-style-priority:99;\r\n	color:#954F72;\r\n	text-decoration:underline;}\r\np.MsoNoSpacing, li.MsoNoSpacing, div.MsoNoSpacing\r\n	{mso-style-priority:1;\r\n	margin:0in;\r\n	margin-bottom:.0001pt;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\np.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph\r\n	{mso-style-priority:34;\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:.5in;\r\n	margin-bottom:.0001pt;\r\n	mso-add-space:auto;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\np.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParag=\r\nraphCxSpFirst\r\n	{mso-style-priority:34;\r\n	mso-style-type:export-only;\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:.5in;\r\n	margin-bottom:.0001pt;\r\n	mso-add-space:auto;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\np.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListPar=\r\nagraphCxSpMiddle\r\n	{mso-style-priority:34;\r\n	mso-style-type:export-only;\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:.5in;\r\n	margin-bottom:.0001pt;\r\n	mso-add-space:auto;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\np.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagra=\r\nphCxSpLast\r\n	{mso-style-priority:34;\r\n	mso-style-type:export-only;\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:.5in;\r\n	margin-bottom:.0001pt;\r\n	mso-add-space:auto;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",sans-serif;}\r\nspan.EmailStyle17\r\n	{mso-style-type:personal-compose;\r\n	font-family:\"Calibri\",sans-serif;\r\n	color:windowtext;}\r\nspan.size\r\n	{mso-style-name:size;}\r\n.MsoChpDefault\r\n	{mso-style-type:export-only;\r\n	font-family:\"Calibri\",sans-serif;}\r\n@page WordSection1\r\n	{size:8.5in 11.0in;\r\n	margin:1.0in 1.0in 1.0in 1.0in;}\r\ndiv.WordSection1\r\n	{page:WordSection1;}\r\n/* List Definitions */\r\n@list l0\r\n	{mso-list-id:1785733738;\r\n	mso-list-type:hybrid;\r\n	mso-list-template-ids:-444445666 67698689 67698691 67698693 67698689 67698=\r\n691 67698693 67698689 67698691 67698693;}\r\n@list l0:level1\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0B7;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:Symbol;}\r\n@list l0:level2\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:o;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:\"Courier New\";}\r\n@list l0:level3\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0A7;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:Wingdings;}\r\n@list l0:level4\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0B7;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:Symbol;}\r\n@list l0:level5\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:o;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:\"Courier New\";}\r\n@list l0:level6\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0A7;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:Wingdings;}\r\n@list l0:level7\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0B7;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:Symbol;}\r\n@list l0:level8\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:o;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:\"Courier New\";}\r\n@list l0:level9\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0A7;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:Wingdings;}\r\nol\r\n	{margin-bottom:0in;}\r\nul\r\n	{margin-bottom:0in;}\r\n--></style><!--[if gte mso 9]><xml>\r\n<o:shapedefaults v:ext=3D\"edit\" spidmax=3D\"1026\" />\r\n</xml><![endif]--><!--[if gte mso 9]><xml>\r\n<o:shapelayout v:ext=3D\"edit\">\r\n<o:idmap v:ext=3D\"edit\" data=3D\"1\" />\r\n</o:shapelayout></xml><![endif]-->\r\n</head>\r\n<body lang=3D\"EN-US\" link=3D\"#0563C1\" vlink=3D\"#954F72\">\r\n<div class=3D\"WordSection1\">\r\n<p class=3D\"MsoNormal\" style=3D\"text-autospace:none\"><a name=3D\"_Hlk3454270=\r\n\"></a><a name=3D\"_Hlk506298519\"></a><a name=3D\"_Hlk3461388\"></a><a name=3D\"=\r\n_Hlk506450654\"><span style=3D\"mso-bookmark:_Hlk3461388\"><span style=3D\"mso-=\r\nbookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span styl=\r\ne=3D\"font-family:&quot;Times New Roman&quot;,serif\">Hi,<o:p></o:p></span></=\r\nspan></span></span></a></p>\r\n<p class=3D\"MsoNormal\" style=3D\"text-autospace:none\"><span style=3D\"mso-boo=\r\nkmark:_Hlk506450654\"><span style=3D\"mso-bookmark:_Hlk3461388\"><span style=\r\n=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk3454270\"><s=\r\npan style=3D\"font-family:&quot;Times New Roman&quot;,serif\"><o:p>&nbsp;</o:=\r\np></span></span></span></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk506450654\"><span =\r\nstyle=3D\"mso-bookmark:_Hlk3461388\"><span style=3D\"mso-bookmark:_Hlk50629851=\r\n9\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span style=3D\"font-family:&quo=\r\nt;Times New Roman&quot;,serif\">I am contacting you to\r\n check if you </span></span></span></span></span><span style=3D\"mso-bookmar=\r\nk:_Hlk3461388\"><span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"ms=\r\no-bookmark:_Hlk3454270\"><span class=3D\"size\"><span style=3D\"font-family:&qu=\r\not;Times New Roman&quot;,serif\">would you be interested\r\n in <b>Marketing Agency Professionals E-Mails Lists?</b> </span></span></sp=\r\nan></span></span><span style=3D\"mso-bookmark:_Hlk3461388\"><span style=3D\"ms=\r\no-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"font-family:&quot;Times New Roman&quot;,serif\">Which\r\n includes complete contact details and verified email addresses for your ma=\r\nrketing and business activities across\r\n<b>USA, UK, Canada, Australia and etc</b></span></span></span></span><span =\r\nstyle=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk345427=\r\n0\"><b><span style=3D\"font-family:&quot;Times New Roman&quot;,serif\">.</span=\r\n></b></span></span><span style=3D\"mso-bookmark:_Hlk506298519\"><span style=\r\n=3D\"mso-bookmark:_Hlk3454270\"><span style=3D\"font-family:&quot;Times New Ro=\r\nman&quot;,serif\"><o:p></o:p></span></span></span></p>\r\n<p class=3D\"MsoNormal\" style=3D\"text-autospace:none\"><span style=3D\"mso-boo=\r\nkmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span style=\r\n=3D\"font-family:&quot;Times New Roman&quot;,serif\"><o:p></o:p></span></span=\r\n></span></p>\r\n<p class=3D\"MsoNormal\" style=3D\"text-autospace:none\"><span style=3D\"mso-boo=\r\nkmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk3454270\"><a name=3D\"_H=\r\nlk506450659\"><span style=3D\"font-family:&quot;Times New Roman&quot;,serif\">=\r\nWould be interested in acquiring mentioned below contacts:<o:p></o:p></span=\r\n></a></span></span></p>\r\n<p class=3D\"MsoNormal\" style=3D\"margin-left:.25in;text-autospace:none\"><spa=\r\nn style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk3454=\r\n270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><span style=3D\"font-family:=\r\n&quot;Times New Roman&quot;,serif\"><o:p>&nbsp;</o:p></span></span></span></=\r\nspan></p>\r\n<p class=3D\"MsoListParagraphCxSpFirst\" style=3D\"text-indent:-.25in;mso-list=\r\n:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Marketing managers<o:p></o:p></span></b></span></span>=\r\n</span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Communications managers<o:p></o:p></span></b></span></=\r\nspan></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Public relations specialists<o:p></o:p></span></b></sp=\r\nan></span></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Brand manager/Owners<o:p></o:p></span></b></span></spa=\r\nn></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Product marketing managers<o:p></o:p></span></b></span=\r\n></span></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Market research analysts<o:p></o:p></span></b></span><=\r\n/span></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Digital marketing specialists<o:p></o:p></span></b></s=\r\npan></span></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Content marketing specialists<o:p></o:p></span></b></s=\r\npan></span></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">SEO specialists<o:p></o:p></span></b></span></span></s=\r\npan></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Social media marketers<o:p></o:p></span></b></span></s=\r\npan></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Marketing automation specialists<o:p></o:p></span></b>=\r\n</span></span></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Media owners<o:p></o:p></span></b></span></span></span=\r\n></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Advertising and marketing agencies<o:p></o:p></span></=\r\nb></span></span></span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Event Marketers<o:p></o:p></span></b></span></span></s=\r\npan></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Channel Marketing<o:p></o:p></span></b></span></span><=\r\n/span></p>\r\n<p class=3D\"MsoListParagraphCxSpMiddle\" style=3D\"text-indent:-.25in;mso-lis=\r\nt:l0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">B2B Providers<o:p></o:p></span></b></span></span></spa=\r\nn></p>\r\n<p class=3D\"MsoListParagraphCxSpLast\" style=3D\"text-indent:-.25in;mso-list:=\r\nl0 level1 lfo1;text-autospace:none\">\r\n<span style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk=\r\n3454270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><![if !supportLists]><s=\r\npan style=3D\"font-family:Symbol\"><span style=3D\"mso-list:Ignore\">&middot;<s=\r\npan style=3D\"font:7.0pt &quot;Times New Roman&quot;\">&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span></span><![endif]><b><span style=3D\"font-family:&quot;Times Ne=\r\nw Roman&quot;,serif\">Decision Makers @ Startups and More.<o:p></o:p></span>=\r\n</b></span></span></span></p>\r\n<p class=3D\"MsoNormal\" style=3D\"margin-left:.25in;text-autospace:none\"><spa=\r\nn style=3D\"mso-bookmark:_Hlk506298519\"><span style=3D\"mso-bookmark:_Hlk3454=\r\n270\"><span style=3D\"mso-bookmark:_Hlk506450659\"><b><span style=3D\"font-fami=\r\nly:&quot;Times New Roman&quot;,serif\"><o:p>&nbsp;</o:p></span></b></span></=\r\nspan></span></p>\r\n<span style=3D\"mso-bookmark:_Hlk506450659\"></span><span style=3D\"mso-bookma=\r\nrk:_Hlk506298519\"></span>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><a name=\r\n=3D\"_Hlk3461423\"><span style=3D\"font-family:&quot;Times New Roman&quot;,ser=\r\nif\">Please let me know which target criteria you would like to acquire, so =\r\nI can give you more information about counts, pricing\r\n and few samples for the same.<o:p></o:p></span></a></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><span style=3D\"font-family:&quot;Times New=\r\n Roman&quot;,serif\"><o:p>&nbsp;</o:p></span></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><span style=3D\"font-family:&quot;Times New=\r\n Roman&quot;,serif\">Target Industry:&nbsp; ___________?? (Any Industry)&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n<o:p></o:p></span></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><span style=3D\"font-family:&quot;Times New=\r\n Roman&quot;,serif\">Target Geography:&nbsp; ___________?? (Example: USA, UK=\r\n, Canada, Australia, etc.&#8230;)\r\n<o:p></o:p></span></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><span style=3D\"font-family:&quot;Times New=\r\n Roman&quot;,serif\">Target Job Title:&nbsp; ________________?? (Example: CE=\r\nO, VP, Managers, Directors, etc.&#8230;)<o:p></o:p></span></span></span></p=\r\n>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><b><span style=3D\"font-family:&quot;Times =\r\nNew Roman&quot;,serif\"><o:p>&nbsp;</o:p></span></b></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><span style=3D\"font-family:&quot;Times New=\r\n Roman&quot;,serif\">Let me know your interest, so that we could discuss fur=\r\nther.<o:p></o:p></span></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><span style=3D\"font-family:&quot;Times New=\r\n Roman&quot;,serif\"><o:p>&nbsp;</o:p></span></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><span style=3D\"font-family:&quot;Times New=\r\n Roman&quot;,serif\">Best Regards,<o:p></o:p></span></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><b><span style=3D\"font-family:&quot;Times =\r\nNew Roman&quot;,serif\">Ethel Warren<o:p></o:p></span></b></span></span></p>\r\n<p class=3D\"MsoNoSpacing\"><span style=3D\"mso-bookmark:_Hlk3454270\"><span st=\r\nyle=3D\"mso-bookmark:_Hlk3461423\"><b><span style=3D\"font-family:&quot;Times =\r\nNew Roman&quot;,serif\">Demand Gen<o:p></o:p></span></b></span></span></p>\r\n<span style=3D\"mso-bookmark:_Hlk3461423\"></span><span style=3D\"mso-bookmark=\r\n:_Hlk3454270\"></span>\r\n<p class=3D\"MsoNormal\"><span style=3D\"font-family:&quot;Times New Roman&quo=\r\nt;,serif\"><o:p>&nbsp;</o:p></span></p>\r\n<p class=3D\"MsoNormal\"><o:p>&nbsp;</o:p></p>\r\n</div>\r\n</body>\r\n</html>\r\n\r\n--_000_SG2PR03MB448668D7338AF5503733266EF1FB0SG2PR03MB4486apcp_--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('23', 'London Stock Journals <news@londonstockjournals.com> - news@londonstockjournals.com', '10022', '1', NULL, 'Last chance to reserve shares with discount in Fastbase Pre-IPO', '\n<table align=\"left\" bgcolor=\"#fafafa\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"mainbody\" style=\"padding:0;margin:0px;background-color:#fafafa;font-family:Arial, sans-serif;width:100%;\"><tbody><tr><td valign=\"top\"></td>\n		</tr><tr><td align=\"center\" class=\"main-colm\" valign=\"top\">\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"mainbody\" style=\"width:640px;margin:0px;padding:0px;\"><tbody><tr><td align=\"center\" valign=\"top\">\n						<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border:#e0dede 1px solid;width:100%;\"><tbody><tr><td class=\"mb_pad1\" style=\"padding:30px 40px;background-color:#497ae0;color:#fff;letter-spacing:.5px;\">\n									<h1>Last chance to reserve shares with discount in Fastbase Pre-IPO</h1>\n									</td>\n								</tr><tr><td align=\"left\" class=\"mb_pad1\" style=\"padding:30px 40px;background-color:#fff;font-size:16px;\">\n									<p></p>\n\n									<p></p>\n\n									<p><strong>Invitation to buy shares in Fastbase Inc.</strong></p>\n\n									<p>Since your company is using Google Analytics, you have the opportunity to purchase up to 25,000 shares at US$ 3.45 per share including discount on a first come first serve basis.</p>\n\n									<p>Fastbase is pleased to announce its plan to allow shares of its common stock to soon be eligible for quotation and trading on the OTC Markets platform based in New York. The company believes that this is an important step towards the goal of achieving a listing on the NASDAQ or the NYSE.</p>\n\n									<p>Fastbase is targeting admission to the OTC stock market in July, 2019, as the fastest-growing SaaS web analytics and lead generation tool built upon Google Analytics.    </p>\n\n									<p>The closing date for reserving shares is <strong>July 12, 2019.</strong></p>\n\n									<p><br />\n									To reserve your shares now, use the <a href=\"http://clicks.nasdaqanalytics.com/email/S-592@6806@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@\">share reservation form.</a></p>\n\n									<p></p>\n\n									<table border=\"0\" class=\"row-tb_100 ed-section\" width=\"600\"><tbody><tr><td align=\"center\" style=\"padding:5px;font-size:18px;color:rgb(51,51,51);font-family:Lato, Tahoma, sans-serif;\">\n												<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse:separate;background-color:rgb(71,140,248);width:295px;padding-top:10px;padding-bottom:10px;border-style:none;border-color:rgb(128,128,128);border-width:0px;\" width=\"295\"><tbody><tr><td align=\"center\" style=\"font-size:16px;color:rgb(51,51,51);font-family:Lato, Tahoma, sans-serif;\" valign=\"middle\"><a href=\"https://privateplacement.fastbase.co.uk/reservation\"><span style=\"color:#FFFFFF;\"><strong><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">Share reservation</span></strong></span></a></td>\n														</tr></tbody></table></td>\n											</tr><tr><td style=\"padding-top:5px;font-size:16px;color:rgb(51,51,51);font-family:Lato, Tahoma, sans-serif;\">\n												<p></p>\n\n												<p><strong><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">Fastbase In Press</span></strong></p>\n\n												<p><span style=\"font-size:12px;\"><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">BusinessInsider Jun. 18, 2019, 12:31 PM</span></span></p>\n\n												<p><a href=\"http://clicks.nasdaqanalytics.com/email/S-592@6807@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@\"><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">Google Analytics Extension 3.0 to Boost Lead Generation Coming Soon Powered by Fastbase Inc.</span></a></p>\n\n												<p></p>\n\n												<p><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">Try the new Fastbase, <a href=\"http://clicks.nasdaqanalytics.com/email/S-592@6808@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@\">Sign in with Google Analytics</a></span></p>\n\n												<p></p>\n\n												<p><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">Rasmus Refer, CEO   </span></p>\n\n												<p><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">Fastbase Inc.   </span></p>\n\n												<p><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">140 Broadway</span></p>\n\n												<p><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">10005 New York, United States  </span></p>\n\n												<p><br /><span style=\"font-size:12px;\"><span style=\"font-family:arial, \'helvetica neue\', helvetica, sans-serif;\">This offering is only open to non-US investors and certain US investors that qualify as accredited investors under Regulation D, Rule 501, and this offering is being made on a good-faith reliance on Regulation D Rule 506(c) and exemptions for offering securities to non-US investors.</span></span></p>\n												</td>\n											</tr></tbody></table><p></p>\n\n									<p></p>\n									</td>\n								</tr></tbody></table></td>\n					</tr><tr><td>\n						<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border:#e0dede 0px solid;width:100%;margin:0 auto;\"><tbody><tr><td style=\"text-align:center;padding:30px 0px;\"><br /><font color=\"#525252\" style=\"font-size:12px;font-weight:600;font-family:Arial, sans-serif;padding:0px;margin:0px;text-align:center;\">© 2019 Fastbase Inc.</font></td>\n								</tr><tr><td style=\"text-align:center;padding:0;\">\n									<p><font color=\"#525252\" style=\"font-size:12px;font-weight:600;font-family:Arial, sans-serif;padding:0px;margin:0px;text-align:center;\">You have received this invitation from Fastbase Inc. </font></p>\n\n									<p><a href=\"http://clicks.nasdaqanalytics.com/profile/S-592@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@1\"><font color=\"#525252\" style=\"font-size:12px;font-weight:600;font-family:Arial, sans-serif;padding:0px;margin:0px;text-align:center;\">Click here to unsubscribe</font></a></p>\n									</td>\n								</tr></tbody></table></td>\n					</tr></tbody></table></td>\n		</tr></tbody></table><a href=\"http://clicks.nasdaqanalytics.com/profile/S-592@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@16\" class=\"system_detection_link\" style=\"font-size:1px;line-height:1px;\"></a><img src=\"http://clicks.nasdaqanalytics.com/email/S-592@@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@1yu9A.jpg\" alt=\"open\" height=\"1\" width=\"1\" />', 'new', '0', '0', '1', '0', NULL, '1562222702', '1', '1', '0', 'Return-Path: <news@londonstockjournals.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id 0N8uHE6fHV0UIA4AMoQ/pw\r\n	(envelope-from <news@londonstockjournals.com>)\r\n	for <info@apusseo.com>; Thu, 04 Jul 2019 09:40:14 +0300\r\nReturn-path: <news@londonstockjournals.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Thu, 04 Jul 2019 09:40:14 +0300\r\nReceived: from emx073.instillerhq.com ([185.105.64.73]:60929)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-GCM-SHA384:256)\r\n	(Exim 4.92)\r\n	(envelope-from <news@londonstockjournals.com>)\r\n	id 1hivPi-003tGH-BW\r\n	for info@apusseo.com; Thu, 04 Jul 2019 09:40:14 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; s=dkim1024; d=londonstockjournals.com;\r\n h=Date:To:From:Reply-To:Subject:List-Unsubscribe:MIME-Version:Content-Type:\r\n Message-ID; i=news@londonstockjournals.com;\r\n bh=rr8UPGMvIEDHmXvHKTfULXC6u9ShiMsvsudFbf5jrBo=;\r\n b=Ks/Oz416ryz7cXa7mF+fegJOHAFErSE4yL/pUP2WZ1YAfuF1wQbbMo1VhjaJJhI90B1PY39zilhb\r\n   SYP51MMTUIdL4KShy9InFthXOGTMKgmI0nV7pUzs3rGmjFr59LK3PUlleYacMStQJJXCFHfb/9qb\r\n   7Dme4jCsYdUnSJzAxNM=\r\nReceived: by emx073.instillerhq.com id h3mfks2gp282 for <info@apusseo.com>; Thu, 4 Jul 2019 07:40:13 +0100 (envelope-from <news@londonstockjournals.com>)\r\nDate: Thu, 4 Jul 2019 07:40:13 +0100\r\nTo: \"info@apusseo.com\" <info@apusseo.com>\r\nFrom: London Stock Journals <news@londonstockjournals.com>\r\nReply-To: London Stock Journals <hc@fastbase.com>\r\nSubject: Last chance to reserve shares with discount in Fastbase Pre-IPO\r\nx-track-version: 4\r\nx-track-source: instiller_ritzau\r\nx-track-spooler-id: 592\r\nx-track-spooler-split-id: 592\r\nx-track-spooler-segment-id: 2129\r\nx-job: instiller_ritzau_SMTP_EC_592-copy_3_last_chance_to_reserve_shares_with_discount\r\nx-virtual-mta: ritzau-dedicated-fastbase\r\nx-render: ldex-mail-001.instillerhq.com\r\nFeedback-ID: 592-copy_3_last_chance_to_reserve_shares_with_discount:fastbase:CAMPAIGN:ritzau\r\nx-track-contact-id: 15185925\r\nList-Unsubscribe: <mailto:list-unsubscribe-1ogfl1o-efe05.ig@londonstockjournals.com>,<http://clicks.nasdaqanalytics.com/profile/S-592@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@9>\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative;\r\n	boundary=\"b1_8f12a58a7ed5ca9a5db330c369a1c878\"\r\nMessage-ID: <0.0.3.8C7.1D532335563B370.0@emx073.instillerhq.com>\r\n\r\n \r\n--b1_8f12a58a7ed5ca9a5db330c369a1c878\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nLast chance to reserve shares with discount in Fastbase Pre-IPO\r\n\r\n\r\n\r\n\r\n\r\nInvitation to buy shares in Fastbase Inc.\r\n\r\nSince your company is using Google Analytics, you have the opportunity to p=\r\nurchase up to 25,000 shares at US$ 3.45 per share including discount on a f=\r\nirst come first serve basis.\r\n\r\nFastbase is pleased to announce its plan to allow shares of its common stoc=\r\nk to soon be eligible for quotation and trading on the OTC Markets platform=\r\n based in New York. The company believes that this is an important step tow=\r\nards the goal of achieving a listing on the NASDAQ or the NYSE.\r\n\r\nFastbase is targeting admission to the OTC stock market in July, 2019, as t=\r\nhe fastest-growing SaaS web analytics and lead generation tool built upon G=\r\noogle Analytics.   =20\r\n\r\nThe closing date for reserving shares is July 10, 2019.\r\n\r\n\r\nTo reserve your shares now, use the share reservation form.\r\n\r\n\r\n\r\nShare reservation\r\n\r\n\r\nFastbase In Press\r\n\r\nBusinessInsider Jun. 18, 2019, 12:31 PM\r\n\r\nGoogle Analytics Extension 3.0 to Boost Lead Generation Coming Soon Powered=\r\n by Fastbase Inc.\r\n\r\n\r\n\r\nTry the new Fastbase, Sign in with Google Analytics\r\n\r\n\r\n\r\nRasmus Refer, CEO  =20\r\n\r\nFastbase Inc.  =20\r\n\r\n140 Broadway\r\n\r\n10005 New York, United States =20\r\n\r\n\r\nThis offering is only open to non-US investors and certain US investors tha=\r\nt qualify as accredited investors under Regulation D, Rule 501, and this of=\r\nfering is being made on a good-faith reliance on Regulation D Rule 506(c) a=\r\nnd exemptions for offering securities to non-US investors.\r\n\r\n\r\n\r\n\r\n\r\n\r\nhttp://clicks.nasdaqanalytics.com/profile/S-592@IzjgkFt8k4EeHKJOBE_sFRcA6EY=\r\n-6TsC6xBCLQS-jQI.@1\r\n\r\n--b1_8f12a58a7ed5ca9a5db330c369a1c878\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<!DOCTYPE html>=0A<html><head><meta charset=3D\"UTF-8\"><meta name=3D\"x-apple=\r\n-disable-message-reformatting\"><meta http-equiv=3D\"content-type\" content=3D=\r\n\"text/html; charset=3DUTF-8\"><meta name=3D\"viewport\" content=3D\"width=3Ddev=\r\nice-width, initial-scale=3D1, maximum-scale=3D1, user-scalable=3Dno\"><title=\r\n>Invitation til Fastbase Pre-IPO</title><style type=3D\"text/css\">@media onl=\r\ny screen and (max-device-width: 767px) {\r\n.mainbody {\r\nwidth:100% !important;\r\n}\r\n.indent_txt{\r\n}\r\n}\r\n@media only screen and (max-device-width:640px) {\r\nindent_txt\r\n{\r\n\r\n}\r\n.mainbody {\r\nwidth:100% !important;\r\n}\r\n.mb_pad1 {\r\npadding-left: 20px !important;\r\npadding-right: 20px !important;\r\n}\r\n.mb-title1 {\r\nfont-size:18px !important;\r\n}\r\n}\r\n=09</style></head><body bgcolor=3D\"#fafafa\" style=3D\"width:100%; margin:0; =\r\npadding:0\">\r\n<table align=3D\"left\" bgcolor=3D\"#fafafa\" border=3D\"0\" cellpadding=3D\"0\" ce=\r\nllspacing=3D\"0\" class=3D\"mainbody\" style=3D\"padding:0; margin:0px; backgrou=\r\nnd-color:#fafafa;  font-family:Arial,sans-serif; width:100%\"><tbody><tr sty=\r\nle=3D\"\"><td valign=3D\"top\"></td>\r\n=09=09</tr><tr><td align=3D\"center\" class=3D\"main-colm\" valign=3D\"top\">\r\n=09=09=09<table border=3D\"0\" cellpadding=3D\"0\" cellspacing=3D\"0\" class=3D\"m=\r\nainbody\" style=3D\"width:640px; max-width:100%;  margin:0px; padding:0px\"><t=\r\nbody><tr><td align=3D\"center\" valign=3D\"top\">\r\n=09=09=09=09=09=09<table border=3D\"0\" cellpadding=3D\"0\" cellspacing=3D\"0\" s=\r\ntyle=3D\"border:#e0dede 1px solid; width:100%\"><tbody><tr><td class=3D\"mb_pa=\r\nd1\" style=3D\"padding:30px 40px; background-color:#497ae0; color:#fff; lette=\r\nr-spacing:0.5px\">\r\n=09=09=09=09=09=09=09=09=09<h1>Last chance to reserve shares with discount =\r\nin Fastbase Pre-IPO</h1>\r\n=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09</tr><tr><td align=3D\"left\" class=3D\"mb_pad1\" style=\r\n=3D\"padding:30px 40px; background-color:#fff; font-size:16px;\">\r\n=09=09=09=09=09=09=09=09=09<p></p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p></p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p><strong>Invitation to buy shares in Fastbase =\r\nInc.</strong></p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p>Since your company is&nbsp;using Google Analy=\r\ntics, you have the opportunity to purchase up to 25,000 shares at US$ 3.45 =\r\nper share including discount&nbsp;on a first come first serve basis.</p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p>Fastbase is pleased to announce its plan to a=\r\nllow shares of its common stock to soon be eligible for quotation and tradi=\r\nng on the OTC Markets platform based in New York. The company believes that=\r\n this is an important step towards the goal of achieving a listing on the N=\r\nASDAQ or the NYSE.</p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p>Fastbase is targeting admission to the OTC st=\r\nock market&nbsp;in July, 2019, as the fastest-growing SaaS web analytics an=\r\nd lead generation tool built upon Google Analytics.&nbsp; &nbsp;&nbsp;</p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p>The closing date for reserving shares is <str=\r\nong>July&nbsp;12, 2019.</strong></p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p><br>\r\n=09=09=09=09=09=09=09=09=09To reserve your shares now, use the&nbsp;<a href=\r\n=3D\"http://clicks.nasdaqanalytics.com/email/S-592@6806@IzjgkFt8k4EeHKJOBE_s=\r\nFRcA6EY-6TsC6xBCLQS-jQI.@\" style=3D\"\" target=3D\"_blank\">share reservation f=\r\norm.</a></p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p></p>\r\n\r\n=09=09=09=09=09=09=09=09=09<table border=3D\"0\" class=3D\"row-tb_100 ed-secti=\r\non\" width=3D\"600\"><tbody><tr><td align=3D\"center\" style=3D\"padding: 5px; fo=\r\nnt-size: 18px; color: rgb(51, 51, 51); font-family: Lato, Tahoma, sans-seri=\r\nf;\">\r\n=09=09=09=09=09=09=09=09=09=09=09=09<table align=3D\"center\" border=3D\"0\" ce=\r\nllpadding=3D\"0\" cellspacing=3D\"0\" cm-node=3D\"1\" style=3D\"border-collapse: s=\r\neparate; border-radius: 5px; background-color: rgb(71, 140, 248); width: 29=\r\n5px; padding-top: 10px; padding-bottom: 10px; border-style: none; border-co=\r\nlor: rgb(128, 128, 128); border-width: 0px; box-shadow: none;\" width=3D\"295=\r\npx\"><tbody><tr><td align=3D\"center\" style=3D\"font-size: 16px; color: rgb(51=\r\n, 51, 51); font-family: Lato, Tahoma, sans-serif;\" valign=3D\"middle\"><a hre=\r\nf=3D\"https://privateplacement.fastbase.co.uk/reservation\" style=3D\"\" target=\r\n=3D\"_blank\" tracking-mode=3D\"off\"><span style=3D\"color:#FFFFFF;\"><strong><s=\r\npan style=3D\"font-family:arial,helvetica neue,helvetica,sans-serif;\">Share =\r\nreservation</span></strong></span></a></td>\r\n=09=09=09=09=09=09=09=09=09=09=09=09=09=09</tr></tbody></table></td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr><tr><td style=3D\"padding-top: 5px; fo=\r\nnt-size: 16px; color: rgb(51, 51, 51); font-family: Lato, Tahoma, sans-seri=\r\nf;\">\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><strong><span style=3D\"font-family:a=\r\nrial,helvetica neue,helvetica,sans-serif;\">Fastbase In Press</span></strong=\r\n></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><span style=3D\"font-size:12px;\"><spa=\r\nn style=3D\"font-family:arial,helvetica neue,helvetica,sans-serif;\">Business=\r\nInsider&nbsp;Jun. 18, 2019, 12:31 PM</span></span></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><a href=3D\"http://clicks.nasdaqanaly=\r\ntics.com/email/S-592@6807@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@\" st=\r\nyle=3D\"\" target=3D\"_blank\"><span style=3D\"font-family:arial,helvetica neue,=\r\nhelvetica,sans-serif;\">Google Analytics Extension 3.0 to Boost Lead Generat=\r\nion Coming Soon Powered by Fastbase Inc.</span></a></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><span style=3D\"font-family:arial,hel=\r\nvetica neue,helvetica,sans-serif;\">Try the new Fastbase,&nbsp;<a href=3D\"ht=\r\ntp://clicks.nasdaqanalytics.com/email/S-592@6808@IzjgkFt8k4EeHKJOBE_sFRcA6E=\r\nY-6TsC6xBCLQS-jQI.@\" style=3D\"\" target=3D\"_blank\">Sign in with Google Analy=\r\ntics</a></span></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><span style=3D\"font-family:arial,hel=\r\nvetica neue,helvetica,sans-serif;\">Rasmus Refer, CEO&nbsp;&nbsp;&nbsp;</spa=\r\nn></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><span style=3D\"font-family:arial,hel=\r\nvetica neue,helvetica,sans-serif;\">Fastbase Inc. &nbsp;&nbsp;</span></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><span style=3D\"font-family:arial,hel=\r\nvetica neue,helvetica,sans-serif;\">140 Broadway</span></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><span style=3D\"font-family:arial,hel=\r\nvetica neue,helvetica,sans-serif;\">10005 New York, United States&nbsp;&nbsp=\r\n;</span></p>\r\n\r\n=09=09=09=09=09=09=09=09=09=09=09=09<p><br><span style=3D\"font-size:12px;\">=\r\n<span style=3D\"font-family:arial,helvetica neue,helvetica,sans-serif;\">This=\r\n offering is only open to non-US investors and certain US investors that qu=\r\nalify as accredited investors under Regulation D, Rule 501, and this offeri=\r\nng is being made on a good-faith reliance on Regulation D Rule 506(c) and e=\r\nxemptions for offering securities to non-US investors.</span></span></p>\r\n=09=09=09=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09=09=09=09</tr></tbody></table><p></p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p></p>\r\n=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09</tr></tbody></table></td>\r\n=09=09=09=09=09</tr><tr><td>\r\n=09=09=09=09=09=09<table border=3D\"0\" cellpadding=3D\"0\" cellspacing=3D\"0\" s=\r\ntyle=3D\"border:#e0dede 0px solid;width:100%; margin:0 auto;  max-width:100%=\r\n;\"><tbody><tr><td style=3D\"text-align:center; padding:30px 0px; \"><br><font=\r\n color=3D\"#525252\" style=3D\"font-size:12px; font-weight:600; font-family:Ar=\r\nial,sans-serif; padding:0px; margin:0px; text-align:center;\">&copy; 2019 Fa=\r\nstbase Inc.</font></td>\r\n=09=09=09=09=09=09=09=09</tr><tr><td style=3D\"text-align:center; padding:0\"=\r\n>\r\n=09=09=09=09=09=09=09=09=09<p><font color=3D\"#525252\" style=3D\"font-size:12=\r\npx; font-weight:600; font-family:Arial,sans-serif; padding:0px; margin:0px;=\r\n text-align:center;\">You have received this invitation from Fastbase&nbsp;I=\r\nnc.&nbsp;</font></p>\r\n\r\n=09=09=09=09=09=09=09=09=09<p><a href=3D\"http://clicks.nasdaqanalytics.com/=\r\nprofile/S-592@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@1\" style=3D\"\" ta=\r\nrget=3D\"_blank\"><font color=3D\"#525252\" style=3D\"font-size:12px; font-weigh=\r\nt:600; font-family:Arial,sans-serif; padding:0px; margin:0px; text-align:ce=\r\nnter;\">Click here to unsubscribe</font></a></p>\r\n=09=09=09=09=09=09=09=09=09</td>\r\n=09=09=09=09=09=09=09=09</tr></tbody></table></td>\r\n=09=09=09=09=09</tr></tbody></table></td>\r\n=09=09</tr></tbody></table><a href=3D\"http://clicks.nasdaqanalytics.com/pro=\r\nfile/S-592@IzjgkFt8k4EeHKJOBE_sFRcA6EY-6TsC6xBCLQS-jQI.@16\" class=3D\"system=\r\n_detection_link\" style=3D\"mso-hide:all;display:none;max-height:0px;max-widt=\r\nh:0px;overflow:hidden;opacity:0;font-size:1px;line-height:1px;\"></a><img sr=\r\nc=3D\"http://clicks.nasdaqanalytics.com/email/S-592@@IzjgkFt8k4EeHKJOBE_sFRc=\r\nA6EY-6TsC6xBCLQS-jQI.@1yu9A.jpg\" alt=3D\"open\" height=3D\"1\" width=3D\"1\" /></=\r\nbody></html>\r\n\r\n\r\n--b1_8f12a58a7ed5ca9a5db330c369a1c878--\r\n\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('24', 'Fowler Jones <fowlerwebmanager@yandex.com> - fowlerwebmanager@yandex.com', '10023', '1', NULL, 'Re: Smart business website at just $399', '<div><div style=\"line-height:normal;margin-bottom:.0001pt;\"><span style=\"background-color:#FFFFFF;color:#222222;\">Hi,</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><br /><span style=\"color:#222222;\">I am curious to know, whether you have received my last email or not. Please let me know, the possibilities to put our heads/minds together on your Projects.</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><span style=\"color:#222222;\">I’m looking forward to working together.</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><span style=\"color:#222222;\">Thanks,</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><span style=\"color:#222222;\">Fowler  </span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><strong><span style=\"color:#222222;\">Marketing Executive </span></strong></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><span style=\"color:#222222;\">----------------------------------------------------------------</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><span style=\"color:#222222;\">Hi,<br /><br />Greetings of the day!</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><strong><span style=\"color:#222222;\">Are you looking for reliable, result-oriented digital marketing solutions for your business or clients?</span></strong></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><span style=\"color:#222222;\">We are a Digital Marketing Agency staffed only by senior professionals. Delivering digital solutions and technological services from ideation to execution with eminence and innovation.</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><br /><span style=\"color:#222222;\">We help startups and organizations to successfully develop and promote websites that your users will love to use.</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><strong><span style=\"background-color:#FFFF00;color:#222222;\">Choosing us over others will give you:</span></strong></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><ul><li style=\"background-color:#FFFFFF;color:#222222;line-height:normal;margin-bottom:.0001pt;\">Delivering first-class customer care</li><li style=\"background-color:#FFFFFF;color:#222222;line-height:normal;margin-bottom:.0001pt;\">Staying on-time and in-budget</li><li style=\"background-color:#FFFFFF;color:#222222;line-height:normal;margin-bottom:.0001pt;\">Quality Focused in terms of code and security measures</li><li style=\"background-color:#FFFFFF;color:#222222;line-height:normal;margin-bottom:.0001pt;\">Straight talking solutions</li><li style=\"background-color:#FFFFFF;color:#222222;line-height:normal;margin-bottom:.0001pt;\">An Expert team of professionals</li><li style=\"background-color:#FFFFFF;color:#222222;line-height:normal;margin-bottom:.0001pt;\">Offering exceptional support </li><li style=\"background-color:#FFFFFF;color:#222222;line-height:normal;margin-bottom:.0001pt;\">Great value for money</li><li style=\"background-color:#FFFFFF;color:#222222;line-height:normal;margin-bottom:.0001pt;\">No hidden extras</li></ul><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><strong><span style=\"color:#222222;\">We specialise in:</span></strong></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;margin-left:.25in;margin-right:0in;margin-top:0in;\"><strong><span style=\"color:#222222;\">Responsive Website: </span></strong><em><span style=\"color:#222222;\">$399 USD (upto 7 pages in wordpress platform)</span></em></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;margin-left:.25in;margin-right:0in;margin-top:0in;\"><strong><span style=\"color:#222222;\">E-commerce Website: </span></strong><em><span style=\"color:#222222;\">$1099 USD (Wordpress + woo commerce)</span></em></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;margin-left:.25in;margin-right:0in;margin-top:0in;\"><strong><span style=\"color:#222222;\">Social media management: </span></strong><em><span style=\"color:#222222;\">$299 USD (3 platform) / month</span></em></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;margin-left:.25in;margin-right:0in;margin-top:0in;\"><strong><span style=\"color:#222222;\">Search engine optimisation: </span></strong><em><span style=\"color:#222222;\">$299 USD per month (5 keywords plan) / month</span></em></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;margin-left:.25in;margin-right:0in;margin-top:0in;\"><strong><span style=\"color:#222222;\">SEO Copywriting: </span></strong><em><span style=\"color:#222222;\">Starts with $19 USD (upto 500 Words)</span></em></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><em><strong><span style=\"color:#222222;\">Other open-source technologies that we use (based on the project)</span></strong><span style=\"color:#222222;\"> - Laravel, CodeIgniter, Cake PHP, Angular Js, Node Js, Magento, WooCommerce, Shopify, etc.</span></em></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><em><strong><span style=\"color:#222222;\">Our solutions are as unique as you are. So, tell us your goals and we’ll show you what we can do.</span></strong></em></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><em><strong><span style=\"color:#222222;\">You won\'t be disappointed. 98%+ of our clients stick with us.</span></strong></em></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><span style=\"color:#222222;\">Kind regards,</span></div><div style=\"background-color:#FFFFFF;line-height:normal;margin-bottom:.0001pt;\"><br /><span style=\"color:#222222;\">Fowler<br /><strong>Marketing Executive</strong></span></div></div>', 'new', '0', '0', '1', '0', NULL, '1562577003', '1', '1', '0', 'Return-Path: <fowlerwebmanager@yandex.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id +EPbAQ4II12jUQMAMoQ/pw\r\n	(envelope-from <fowlerwebmanager@yandex.com>)\r\n	for <info@apusseo.com>; Mon, 08 Jul 2019 12:08:30 +0300\r\nReturn-path: <fowlerwebmanager@yandex.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Mon, 08 Jul 2019 12:08:30 +0300\r\nReceived: from forward104p.mail.yandex.net ([77.88.28.107]:47154)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-GCM-SHA384:256)\r\n	(Exim 4.92)\r\n	(envelope-from <fowlerwebmanager@yandex.com>)\r\n	id 1hkPdN-000udw-UE\r\n	for info@apusseo.com; Mon, 08 Jul 2019 12:08:30 +0300\r\nReceived: from mxback7j.mail.yandex.net (mxback7j.mail.yandex.net [IPv6:2a02:6b8:0:1619::110])\r\n	by forward104p.mail.yandex.net (Yandex) with ESMTP id 176124B013E7;\r\n	Mon,  8 Jul 2019 12:08:22 +0300 (MSK)\r\nReceived: from localhost (localhost [::1])\r\n	by mxback7j.mail.yandex.net (nwsmtp/Yandex) with ESMTP id OtIxXikmi3-8H4uiKcr;\r\n	Mon, 08 Jul 2019 12:08:21 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=yandex.com; s=mail; t=1562576901;\r\n	bh=2T870F/eD+gwTKP3FhYvEJZaFke4VMpkgongvcAWO3g=;\r\n	h=Date:Message-Id:Subject:To:From;\r\n	b=Pb6HMNCvXvNlbgnSmjCgXPS7k688LzcXx5hj8vnxZ3g2zy/s7JvDGdL3al4yzJYDH\r\n	 JiliaS73Km4IwSUCrBbuQ9EAL/dkHJZDlLQierelQXb0cuRlt0FOhoFrto/KrnGd3A\r\n	 o3Kj00NV+qYxaelDK7/ciBVfX0+zDZfcFOEugq4U=\r\nAuthentication-Results: mxback7j.mail.yandex.net; dkim=pass header.i=@yandex.com\r\nReceived: by sas1-adb97d30497b.qloud-c.yandex.net with HTTP;\r\n	Mon, 08 Jul 2019 12:08:17 +0300\r\nFrom: Fowler Jones <fowlerwebmanager@yandex.com>\r\nEnvelope-From: fowlerwebmanager@yandex.ua\r\nTo: fowlerwebmanager <fowlerwebmanager@yandex.com>\r\nSubject: Re: Smart business website at just $399\r\nMIME-Version: 1.0\r\nX-Mailer: Yamail [ http://yandex.ru ] 5.0\r\nDate: Mon, 08 Jul 2019 14:38:17 +0530\r\nMessage-Id: <23250051562576897@sas1-adb97d30497b.qloud-c.yandex.net>\r\nContent-Transfer-Encoding: base64\r\nContent-Type: text/html; charset=utf-8\r\n\r\n PGRpdj48ZGl2IHN0eWxlPSJsaW5lLWhlaWdodDpub3JtYWw7bWFyZ2luLWJvdHRvbTowLjAwMDFw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\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('25', 'Quality Beauty Store Shop <web@qualitybeautystore.com> - web@qualitybeautystore.com', '10024', '1', NULL, 'Account Activation', '<p>Your account has been activated successfully.</p>\n\n', 'new', '0', '0', '1', '0', NULL, '1562591702', '1', '1', '0', 'Return-Path: <web@qualitybeautystore.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id +M+eKv5AI11/7gQAMoQ/pw\r\n	(envelope-from <web@qualitybeautystore.com>)\r\n	for <info@apusseo.com>; Mon, 08 Jul 2019 16:11:26 +0300\r\nReturn-path: <web@qualitybeautystore.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Mon, 08 Jul 2019 16:11:26 +0300\r\nReceived: from mail-wr1-f66.google.com ([209.85.221.66]:39430)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.92)\r\n	(envelope-from <web@qualitybeautystore.com>)\r\n	id 1hkTQU-001MHb-KV\r\n	for info@apusseo.com; Mon, 08 Jul 2019 16:11:26 +0300\r\nReceived: by mail-wr1-f66.google.com with SMTP id x4so17039850wrt.6\r\n        for <info@apusseo.com>; Mon, 08 Jul 2019 06:11:26 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=qualitybeautystore-com.20150623.gappssmtp.com; s=20150623;\r\n        h=from:to:message-id:subject:date:content-transfer-encoding\r\n         :content-disposition:mime-version;\r\n        bh=V+j7jHuSZ1FBz37e7l8g0at+P1ioJlt84764Srj6ktk=;\r\n        b=yrEGGifPwaOPVh9Xtf9s689PDikJ+otQ6JG5pUOyrfUfHAOeL1e6H0DkND1eZ/y+qx\r\n         mXz3MyEe0dkSKFO0emK3gHWxtUMZAwdOkLNRJofj2PXMMy0ijgosuirR4IiPFusgtjoe\r\n         h/bvrSWF9IbnU52Acs25h5HIoTBDQS8mu1rhptUiOy+EHU/ypQZW8Eh6n1KMVIBJyeki\r\n         AicNAfVPiDewbqjPioXP1o3lw6HMFFv2+JEvN9QsZj8Jq5a4GQVE5eYxjCsUQ02AtIk1\r\n         U1G1RA39xbTdrfwHPOpOlt96FoK2oPHhGgEhVaSXxmNK2dY8AiPMJJhNPxlKahguaImP\r\n         4oDw==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:from:to:message-id:subject:date\r\n         :content-transfer-encoding:content-disposition:mime-version;\r\n        bh=V+j7jHuSZ1FBz37e7l8g0at+P1ioJlt84764Srj6ktk=;\r\n        b=G3VxuOdvP9sblxCVuMD7gFwOYB4fEAz07ZFsj10dz5k7Bq7XuB+RAS7HhxrPpjPQRk\r\n         cn9HNdKt769N/4ZO6ba2YOSHvwAB5gjXcf0jpFCOyjh6whnkOfGB3OCh+iVBko+A1Tcv\r\n         8vr8W3IcuZlbilp6PTmXMnG9Lb9UGwO+PdsiSLQS8VTPfn8nuNMGCtcm7pHy86TocJiT\r\n         4653MksChC77MKUQlpQuubNPqizFYmRlb4dXtESRrZ7JmC+YHST72LukeQnsmPPhn5Bx\r\n         NSXYyxhIFuyZNmbGmkV4jOPXIS/T3Rtx8G6HXkTCOjm//bYBydxqbyJPB3lnVnq4Uic3\r\n         mcKw==\r\nX-Gm-Message-State: APjAAAWTb+8e6CN80ZgdKQpr0haOCaXXv9Y2cf6zFN70+hfWSWq9tVkx\r\n	fzUDn3O0kFQ0/ZBgob4mF8VkwEbR/tA=\r\nX-Google-Smtp-Source: APXvYqyyHfJI2ln1xy/g3sg0LzMBHOIZ++0GmCc9x+k3Icq0px41Bf828hgKf3h3AvphOQJX1VcOGQ==\r\nX-Received: by 2002:adf:c613:: with SMTP id n19mr19014527wrg.109.1562591485917;\r\n        Mon, 08 Jul 2019 06:11:25 -0700 (PDT)\r\nReceived: from qualitybeautystore.com ([46.101.36.19])\r\n        by smtp.gmail.com with ESMTPSA id s63sm17202677wme.17.2019.07.08.06.11.24\r\n        for <info@apusseo.com>\r\n        (version=TLS1_2 cipher=ECDHE-RSA-AES128-GCM-SHA256 bits=128/128);\r\n        Mon, 08 Jul 2019 06:11:25 -0700 (PDT)\r\nX-Mailer: Postman SMTP 2.0.2 for WordPress (https://wordpress.org/plugins/post-smtp/)\r\nContent-Type: text/html; charset=UTF-8\r\nFrom: Quality Beauty Store Shop <web@qualitybeautystore.com>\r\nTo: info@apusseo.com\r\nMessage-Id: <dabeeccace0907b1aca3c9aceffac064@qualitybeautystore.com>\r\nSubject: Account Activation\r\nDate: Mon, 08 Jul 2019 13:11:24 +0000\r\nContent-Transfer-Encoding: quoted-printable\r\nContent-Disposition: inline\r\nMIME-Version: 1.0\r\n\r\n <p>Your account has been activated successfully.</p>=0A\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('26', 'Quality Beauty Store Shop <web@qualitybeautystore.com> - web@qualitybeautystore.com', '10025', '1', NULL, 'LP registration Registration', '<p>Hello,<br />Thank you for registering with us.</p>\n\n', 'new', '0', '0', '1', '0', NULL, '1562591702', '1', '1', '0', 'Return-Path: <web@qualitybeautystore.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id +HtYOP9AI11/7gQAMoQ/pw\r\n	(envelope-from <web@qualitybeautystore.com>)\r\n	for <info@apusseo.com>; Mon, 08 Jul 2019 16:11:27 +0300\r\nReturn-path: <web@qualitybeautystore.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Mon, 08 Jul 2019 16:11:27 +0300\r\nReceived: from mail-wr1-f67.google.com ([209.85.221.67]:46512)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.92)\r\n	(envelope-from <web@qualitybeautystore.com>)\r\n	id 1hkTQV-001MHl-S0\r\n	for info@apusseo.com; Mon, 08 Jul 2019 16:11:27 +0300\r\nReceived: by mail-wr1-f67.google.com with SMTP id z1so12411618wru.13\r\n        for <info@apusseo.com>; Mon, 08 Jul 2019 06:11:28 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=qualitybeautystore-com.20150623.gappssmtp.com; s=20150623;\r\n        h=from:to:message-id:subject:date:content-transfer-encoding\r\n         :content-disposition:mime-version;\r\n        bh=cC+dawiIcb5vY2tT4BmFcYKyhNc2xCbfIs3nht9aN7Y=;\r\n        b=nu1p+2tr/WOzUEeziI/F4ry70F9lAbePAxaybkiWiey90SPtvOY34q+NkNaxQs6f8K\r\n         0N+PT/FSq/79O19e7xO6bl7oLcBc0iqb/h6k9pAEd4fdArQkGJ20FdkIsudWrgNo4xlG\r\n         oOZw+cMfxzljyGglJsYSm8xno2CkpZgPubmL+cI3Z213TJt+b/ogpsAhCthmVikOSX+L\r\n         tvLjkiIVFNNSoFYGvHi0pKxmM8nJCmsc4FgKIY6BjhnoCNOjSQfaRrfS6CMNvoKpgR1t\r\n         lvjsuQZMQ/Yq6my/pbdkBWQ7xBTPAOq+AaFw4Ygvp2BjUOfzUhZPkm/GZo0kN/kYC8ad\r\n         i5KQ==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:from:to:message-id:subject:date\r\n         :content-transfer-encoding:content-disposition:mime-version;\r\n        bh=cC+dawiIcb5vY2tT4BmFcYKyhNc2xCbfIs3nht9aN7Y=;\r\n        b=NRI7ZbfbE8dd+vQ7/WFrCwlOIWOqDbiDpucj4ASs8FLjt+2aXdo7RB2rQJHBedjkAX\r\n         NMElmCosWYuXjzUarpCpFVkD+tSYDzd6tWatsPh7SzGH+Cg16G6vRcw73lWIms58EzPO\r\n         uOdYi4D33kmqdYFgY/a4Wye9CfuszxxSYmvCLOLMkz1HQCuBpkEeF3b6UQTySUT5Bo4M\r\n         kmfWtCdRtiVRfx6Jsy4l8rxE7x3lrgjgPjs5HcXKF2nnQeKhQ691n4aPsWoptdTmTuHh\r\n         Rd6jEXYaJS0bJWVDU6kTMEpQpTs23bccLnhNC5DqdqpQgMtzGNfnNzb1OgkMBjejPzAb\r\n         PcoA==\r\nX-Gm-Message-State: APjAAAVtnp+IazJabYkvHm3xAFleE57IM3buLR57VaiBoPI7Tpk+eJ9k\r\n	QzE/szMPvbskN2rzD9gF9IpElcy4Vd0=\r\nX-Google-Smtp-Source: APXvYqwryBwFWFhV8+B3lHrBk7+mDVH9LZtAndGl4RAFro0z/e3xQyKbPTdEOLwU8PwL75RWY8lzGg==\r\nX-Received: by 2002:a5d:6583:: with SMTP id q3mr20476930wru.184.1562591487802;\r\n        Mon, 08 Jul 2019 06:11:27 -0700 (PDT)\r\nReceived: from qualitybeautystore.com ([46.101.36.19])\r\n        by smtp.gmail.com with ESMTPSA id e7sm16076003wmd.0.2019.07.08.06.11.27\r\n        for <info@apusseo.com>\r\n        (version=TLS1_2 cipher=ECDHE-RSA-AES128-GCM-SHA256 bits=128/128);\r\n        Mon, 08 Jul 2019 06:11:27 -0700 (PDT)\r\nX-Mailer: Postman SMTP 2.0.2 for WordPress (https://wordpress.org/plugins/post-smtp/)\r\nContent-Type: text/html; charset=UTF-8\r\nFrom: Quality Beauty Store Shop <web@qualitybeautystore.com>\r\nTo: info@apusseo.com\r\nMessage-Id: <4bee0528aa21113db5f81f7a1a99c9bd@qualitybeautystore.com>\r\nSubject: LP registration Registration\r\nDate: Mon, 08 Jul 2019 13:11:27 +0000\r\nContent-Transfer-Encoding: quoted-printable\r\nContent-Disposition: inline\r\nMIME-Version: 1.0\r\n\r\n <p>Hello,<br />Thank you for registering with us.</p>=0A\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('27', 'Aditya <che@affiwebtech.com> - che@affiwebtech.com', '10026', '1', NULL, 'Lead Generation | E-mail Marketing', '\n\n<div class=\"Section1\">\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Hi,</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">My name is Aditya we have sized 15+ employees and have extensive\nexpertise in Email Marketing. We helps to reduce employees cost and increase\nthe revenues by highest sales. We are Generating  potential leads/clients for\nMobile Apps, SEO and Website design &amp; Development services.</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">We can be of assistance in following services-</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Lead Generation-</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> (Website designing &amp;\nDevelopment, Mobile Apps, SEO, PPC and E learning)</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Email Marketing</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> (We use our custom email\nmarketing campaigns to increase your sales.)</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Data Mining</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> (Create a good data base)</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Dedicated Email Marketer</span></b><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> (Manage the all email\nmarketing activities)</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">I’ll happy to share a example of leads.</span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">If you are interested, please share your requirements along with\nyour Skype ID so we could assist you with our best approach.</span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p> </p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Looking forward to hear you.</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\"> </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Thanks &amp; Warm Regards,  </span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Aditya</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">--------------------------------------------------------------------------------</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\" style=\"margin-bottom:.0001pt;line-height:normal;background:#FFFFFF;\"><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#0F243E;\">Handset/Whatsapp: + 91 987-171-2192</span><span style=\"font-size:12pt;font-family:Arial, \'sans-serif\';color:#222222;\"></span></p><p></p>\n\n<p class=\"MsoNormal\"></p><p> </p>\n\n</div>\n\n', 'new', '0', '0', '1', '0', NULL, '1562607302', '1', '1', '0', 'Return-Path: <che@affiwebtech.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id bPyKMd99I13+jgYAMoQ/pw\r\n	(envelope-from <che@affiwebtech.com>)\r\n	for <info@apusseo.com>; Mon, 08 Jul 2019 20:31:11 +0300\r\nReturn-path: <che@affiwebtech.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Mon, 08 Jul 2019 20:31:11 +0300\r\nReceived: from mail-pl1-f193.google.com ([209.85.214.193]:43145)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.92)\r\n	(envelope-from <che@affiwebtech.com>)\r\n	id 1hkXTr-001nnw-EH\r\n	for info@apusseo.com; Mon, 08 Jul 2019 20:31:11 +0300\r\nReceived: by mail-pl1-f193.google.com with SMTP id cl9so8598816plb.10\r\n        for <info@apusseo.com>; Mon, 08 Jul 2019 10:31:11 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=affiwebtech-com.20150623.gappssmtp.com; s=20150623;\r\n        h=from:to:subject:date:message-id:mime-version:thread-index\r\n         :content-language;\r\n        bh=oghqrpOKssra3KIaEPovzffb268jHxsSks7VGlHUP5U=;\r\n        b=Qde1A8c+rEhKNQr+RZJffMdFNCN3Qsu2UPynv+Dhx9BccYIrA5olfs5eWP3RGfrTVt\r\n         uOD1O4Ll4OZSgd3Gf/Mizq/NJV5DHNYLImnOtlPHMmTsSm29SCSxTeqF3FYFf8/dQu+V\r\n         g9P7KXXcR1mq3X5aXLb3vVMIWQzSCrhv4WfOkknxVf1woh4B839so4UOctawxUsSj/Eo\r\n         dh+T9X6FmdVfc1dAEzIGD70spqN9bXI7O+3uuSODaS56Yxut0Jr31P6iWvjzPXbJwetN\r\n         WmZKFWQ8oShwYz12kwoVhe40xj+7l4/TGj6O+BzYaOnV5Qg1nEtR8uVFudlMoOnbzfff\r\n         D8jw==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:from:to:subject:date:message-id:mime-version\r\n         :thread-index:content-language;\r\n        bh=oghqrpOKssra3KIaEPovzffb268jHxsSks7VGlHUP5U=;\r\n        b=UHUJBlpn9mKk68zLWKPKsN370exPa2ZQrlnOdMCzkAGtFoKmJpwRnM3X4/o7Z2cW80\r\n         5hKAnHg176AU+m6d+2BUfvZjT8fdXELAIYVm9TCoD6/hEXMzFBmA6G9WSe8sx5lR2CUM\r\n         wsq12qlvxL9C1DD4OX2mJVgp9mHs7nt9N33pZahvKraY/5f4VFdjhpNWdMSLuuY/J5Wt\r\n         QjkrSwuLl9wGQPyFCn1/noMWM3ih916LrdLaEbxUU0C6pwrjIu12WEV1TWkDBp3qeKfS\r\n         l7PFck7aMSIRd5TdIbNLIsj/ZL7Jk5z0wCmqVVtBbQ354sKxIXrXmBLHz/NrTfUHk+8P\r\n         lcRQ==\r\nX-Gm-Message-State: APjAAAV0TZnXRqqAa4z3DsQiKgx+F0H0jk/TtvoI0BIZnnjwPg3VWsk6\r\n	CfLknc+hg8UKdDW0UJJ7oHf39d6hCe8=\r\nX-Google-Smtp-Source: APXvYqyRqXwzEQ637g7HP3iZtPWK9SRVc/nrfVtkNEHfqUSb5FfRFKsYYEb+YOCEC4mcp6JTI0RplA==\r\nX-Received: by 2002:a17:902:145:: with SMTP id 63mr27349115plb.55.1562607068802;\r\n        Mon, 08 Jul 2019 10:31:08 -0700 (PDT)\r\nReceived: from Krishna ([43.252.30.240])\r\n        by smtp.gmail.com with ESMTPSA id a25sm17588153pfn.1.2019.07.08.10.31.07\r\n        for <info@apusseo.com>\r\n        (version=TLS1_2 cipher=ECDHE-RSA-AES128-GCM-SHA256 bits=128/128);\r\n        Mon, 08 Jul 2019 10:31:08 -0700 (PDT)\r\nFrom: \"Aditya\" <che@affiwebtech.com>\r\nTo: <info@apusseo.com>\r\nSubject: Lead Generation | E-mail Marketing\r\nDate: Mon, 8 Jul 2019 23:00:14 +0530\r\nMessage-ID: <007d01d535b2$efa311b0$cee93510$@com>\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative;\r\n	boundary=\"----=_NextPart_000_007E_01D535E1.095B4DB0\"\r\nX-Mailer: Microsoft Office Outlook 12.0\r\nThread-Index: AdU1sso/LUPW78DpQAqXyprPpDdEMw==\r\nContent-Language: en-us\r\n\r\n This is a multipart message in MIME format.\r\n\r\n------=_NextPart_000_007E_01D535E1.095B4DB0\r\nContent-Type: text/plain;\r\n	charset=\"us-ascii\"\r\nContent-Transfer-Encoding: 7bit\r\n\r\nHi,\r\n\r\n \r\n\r\nMy name is Aditya we have sized 15+ employees and have extensive expertise\r\nin Email Marketing. We helps to reduce employees cost and increase the\r\nrevenues by highest sales. We are Generating  potential leads/clients for\r\nMobile Apps, SEO and Website design & Development services.\r\n\r\n \r\n\r\nWe can be of assistance in following services-\r\n\r\n \r\n\r\nLead Generation- (Website designing & Development, Mobile Apps, SEO, PPC and\r\nE learning)\r\n\r\n \r\n\r\nEmail Marketing (We use our custom email marketing campaigns to increase\r\nyour sales.)\r\n\r\n \r\n\r\nData Mining (Create a good data base)\r\n\r\n \r\n\r\nDedicated Email Marketer (Manage the all email marketing activities)\r\n\r\n \r\n\r\nI\'ll happy to share a example of leads.\r\n\r\n \r\n\r\nIf you are interested, please share your requirements along with your Skype\r\nID so we could assist you with our best approach.\r\n\r\n \r\n\r\nLooking forward to hear you.\r\n\r\n \r\n\r\nThanks & Warm Regards,  \r\n\r\nAditya\r\n\r\n----------------------------------------------------------------------------\r\n----\r\n\r\nHandset/Whatsapp: + 91 987-171-2192\r\n\r\n \r\n\r\n\r\n------=_NextPart_000_007E_01D535E1.095B4DB0\r\nContent-Type: text/html;\r\n	charset=\"us-ascii\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<html xmlns:v=3D\"urn:schemas-microsoft-com:vml\" =\r\nxmlns:o=3D\"urn:schemas-microsoft-com:office:office\" =\r\nxmlns:w=3D\"urn:schemas-microsoft-com:office:word\" =\r\nxmlns:m=3D\"http://schemas.microsoft.com/office/2004/12/omml\" =\r\nxmlns=3D\"http://www.w3.org/TR/REC-html40\">\r\n\r\n<head>\r\n<META HTTP-EQUIV=3D\"Content-Type\" CONTENT=3D\"text/html; =\r\ncharset=3Dus-ascii\">\r\n<meta name=3DGenerator content=3D\"Microsoft Word 12 (filtered medium)\">\r\n<style>\r\n<!--\r\n /* Font Definitions */\r\n @font-face\r\n	{font-family:\"Cambria Math\";\r\n	panose-1:2 4 5 3 5 4 6 3 2 4;}\r\n@font-face\r\n	{font-family:Calibri;\r\n	panose-1:2 15 5 2 2 2 4 3 2 4;}\r\n /* Style Definitions */\r\n p.MsoNormal, li.MsoNormal, div.MsoNormal\r\n	{margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:10.0pt;\r\n	margin-left:0in;\r\n	line-height:115%;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",\"sans-serif\";}\r\na:link, span.MsoHyperlink\r\n	{mso-style-priority:99;\r\n	color:blue;\r\n	text-decoration:underline;}\r\na:visited, span.MsoHyperlinkFollowed\r\n	{mso-style-priority:99;\r\n	color:purple;\r\n	text-decoration:underline;}\r\n.MsoChpDefault\r\n	{mso-style-type:export-only;}\r\n.MsoPapDefault\r\n	{mso-style-type:export-only;\r\n	margin-bottom:10.0pt;\r\n	line-height:115%;}\r\n@page Section1\r\n	{size:8.5in 11.0in;\r\n	margin:1.0in .75in .5in 1.0in;}\r\ndiv.Section1\r\n	{page:Section1;}\r\n-->\r\n</style>\r\n<!--[if gte mso 9]><xml>\r\n <o:shapedefaults v:ext=3D\"edit\" spidmax=3D\"1026\" />\r\n</xml><![endif]--><!--[if gte mso 9]><xml>\r\n <o:shapelayout v:ext=3D\"edit\">\r\n  <o:idmap v:ext=3D\"edit\" data=3D\"1\" />\r\n </o:shapelayout></xml><![endif]-->\r\n</head>\r\n\r\n<body lang=3DEN-US link=3Dblue vlink=3Dpurple>\r\n\r\n<div class=3DSection1>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Hi,</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>My name is Aditya we have sized 15+ employees and have =\r\nextensive\r\nexpertise in Email Marketing. We helps to reduce employees cost and =\r\nincrease\r\nthe revenues by highest sales. We are Generating &nbsp;potential =\r\nleads/clients for\r\nMobile Apps, SEO and Website design &amp; Development =\r\nservices.</span><span\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";color:#222222\'=\r\n><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><b><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>We can be of assistance in following =\r\nservices-</span></b><span\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";color:#222222\'=\r\n><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><b><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Lead Generation-</span></b><span =\r\nstyle=3D\'font-size:12.0pt;\r\nfont-family:\"Arial\",\"sans-serif\";color:#0F243E\'>&nbsp;(Website designing =\r\n&amp;\r\nDevelopment, Mobile Apps, SEO, PPC and E learning)</span><span\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";color:#222222\'=\r\n><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><b><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Email Marketing</span></b><span =\r\nstyle=3D\'font-size:12.0pt;\r\nfont-family:\"Arial\",\"sans-serif\";color:#0F243E\'>&nbsp;(We use our custom =\r\nemail\r\nmarketing campaigns to increase your sales.)</span><span =\r\nstyle=3D\'font-size:12.0pt;\r\nfont-family:\"Arial\",\"sans-serif\";color:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><b><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Data Mining</span></b><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\r\n\"Arial\",\"sans-serif\";color:#0F243E\'>&nbsp;(Create a good data =\r\nbase)</span><span\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";color:#222222\'=\r\n><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><b><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Dedicated Email Marketer</span></b><span =\r\nstyle=3D\'font-size:12.0pt;\r\nfont-family:\"Arial\",\"sans-serif\";color:#0F243E\'>&nbsp;(Manage the all =\r\nemail\r\nmarketing activities)</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>I&#8217;ll happy to share a example of =\r\nleads.<o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;<o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>If you are interested, please share your requirements =\r\nalong with\r\nyour Skype ID so we could assist you with our best =\r\napproach.<o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p>&nbsp;</o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Looking forward to hear you.</span><span =\r\nstyle=3D\'font-size:12.0pt;\r\nfont-family:\"Arial\",\"sans-serif\";color:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>&nbsp;</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Thanks &amp; Warm Regards,&nbsp; </span><span =\r\nstyle=3D\'font-size:12.0pt;\r\nfont-family:\"Arial\",\"sans-serif\";color:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Aditya</span><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#222222\'><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>----------------------------------------------------------=\r\n----------------------</span><span\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";color:#222222\'=\r\n><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal =\r\nstyle=3D\'margin-bottom:0in;margin-bottom:.0001pt;line-height:\r\nnormal;background:white\'><span =\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";\r\ncolor:#0F243E\'>Handset/Whatsapp: + 91 987-171-2192</span><span\r\nstyle=3D\'font-size:12.0pt;font-family:\"Arial\",\"sans-serif\";color:#222222\'=\r\n><o:p></o:p></span></p>\r\n\r\n<p class=3DMsoNormal><o:p>&nbsp;</o:p></p>\r\n\r\n</div>\r\n\r\n</body>\r\n\r\n</html>\r\n\r\n------=_NextPart_000_007E_01D535E1.095B4DB0--\r\n\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('28', 'Minerva Cabasso <minervaonlinemarketing@gmail.com> - minervaonlinemarketing@gmail.com', '10027', '1', NULL, 'Link Building And Content Writing Service Provider.', '<div dir=\"ltr\">Hi,<br /><br />I\'m a Blogger outreach supplier. I have in my collection 6000+ good quality sites.<br /><br />For example:<br /><a href=\"https://renovate.home.blog/\">https://renovate.home.blog/</a>	DA 64 <br /><a href=\"https://myinterior.design.blog/\">https://myinterior.design.blog/</a>	DA 38 <br /><a href=\"https://pinkbluelovescute.com/\">https://pinkbluelovescute.com/</a>	DA 38 <br /><a href=\"http://foroes.net/\">http://foroes.net/</a>	DA 54		<br /><a href=\"https://southfloridareporter.com/\">https://southfloridareporter.com/</a>	DA 53		<br /><a href=\"http://www.itsgettinghotinhere.org/\">http://www.itsgettinghotinhere.org/</a>	DA 52<br /><br />The above sites are just a few examples. I have many more sites with high page authority and domain authority.<br /><br />Waiting for your response.<br clear=\"all\" /><div><br /></div>-- <br /><div dir=\"ltr\" class=\"gmail_signature\"><div dir=\"ltr\"><div><div dir=\"ltr\"><div><div dir=\"ltr\"><b>Kind Regards!</b><div><font color=\"#000000\" face=\"Roboto, RobotoDraft, Arial, sans-serif\"><span style=\"white-space:nowrap;\"><b>Minerva</b></span></font></div><div><b style=\"color:rgb(38,50,56);font-family:Roboto, sans-serif;font-size:13px;\">Professional Blogger and Outreach supplier</b><font color=\"#000000\" face=\"Roboto, RobotoDraft, Arial, sans-serif\"><span style=\"white-space:nowrap;\"><b><br /></b></span></font></div><div><span style=\"color:rgb(0,0,0);font-family:Roboto, RobotoDraft, Arial, sans-serif;font-size:13px;font-weight:700;white-space:nowrap;\">Web : </span><font color=\"#000000\" face=\"Roboto, RobotoDraft, Arial, sans-serif\"><span style=\"white-space:nowrap;\"><b><a href=\"https://qualitylinkbuilders.com/\">https://qualitylinkbuilders.com/</a></b></span></font></div></div></div></div></div></div></div><br /><div class=\"mt-signature\">\n        <table border=\"0\" cellpadding=\"8\" cellspacing=\"0\">\n            <tbody><tr>\n                <td>\n                    <a href=\"https://mailtrack.io?utm_source=gmail&amp;utm_medium=signature&amp;utm_campaign=signaturevirality5&amp;\" style=\"text-decoration:none;\">\n                        <img src=\"https://s3.amazonaws.com/mailtrack-signature/sender_notified.gif\" alt=\"Mailtrack\" width=\"32\" height=\"32\" />\n                    </a>\n                </td>\n                <td>\n                    <span style=\"color:#777;\">Sender notified by</span> <br />\n                    <a href=\"https://mailtrack.io?utm_source=gmail&amp;utm_medium=signature&amp;utm_campaign=signaturevirality5&amp;\" class=\"mt-install\" style=\"color:#4374f7;\">Mailtrack</a>\n                    <span style=\"font-size:0;\">07/16/19, 11:37:20 AM</span>\n                </td>\n                <td>\n                    \n                </td>\n            </tr>\n        </tbody></table>\n    </div><img width=\"0\" height=\"0\" class=\"mailtrack-img\" alt=\"\" src=\"https://mailtrack.io/trace/mail/3ddcffccc6c9a9aaecc1d6055bd63d3fcddb22f6.png?u=3434353\" /></div>\n', 'new', '0', '0', '1', '0', NULL, '1563257403', '1', '1', '0', 'Return-Path: <minervaonlinemarketing@gmail.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id XXfOHqlpLV2RkwoAMoQ/pw\r\n	(envelope-from <minervaonlinemarketing@gmail.com>)\r\n	for <info@apusseo.com>; Tue, 16 Jul 2019 09:07:37 +0300\r\nReturn-path: <minervaonlinemarketing@gmail.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Tue, 16 Jul 2019 09:07:37 +0300\r\nReceived: from mail-pf1-f193.google.com ([209.85.210.193]:35926)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.92)\r\n	(envelope-from <minervaonlinemarketing@gmail.com>)\r\n	id 1hnGcj-002uJW-8e\r\n	for info@apusseo.com; Tue, 16 Jul 2019 09:07:37 +0300\r\nReceived: by mail-pf1-f193.google.com with SMTP id r7so8564731pfl.3\r\n        for <info@apusseo.com>; Mon, 15 Jul 2019 23:07:37 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=20161025;\r\n        h=mime-version:from:date:message-id:subject:to;\r\n        bh=EszC4ccIWB/MUIR/tZJDjXxdQJml9/7P48yuLUaOEeI=;\r\n        b=XFGFYAa4irFiBy/5OtPVAqxNhBpVDg+EjyU2XG83UEqKUqde3/1vdw5VkKKYfbffPj\r\n         AlTHv9Vdhy0DVUsU82+ACvvGk6pqnxoJtW+q3TBBLApM6jZTFqkdgNLDa/XZPk/wdNrE\r\n         h3ru014ENhn9N0L7YnH9k/4uAxKL2GhP+xUw1XBDrfW2aSoRLCCZenMyey3/zOtXgn2X\r\n         z0E5i0C5xRlSbOaevt/GrBRMcUnGtJvfi/m10UopHtT1akf6AmsSRITDfzM0wFrwuUMW\r\n         Sc/NPBp+KgwUKjjA23xK3+aGxnO2X625wOydGDG+KdpYyMLp5vKR0YzAAwSiAAtdbcfu\r\n         ViIw==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:mime-version:from:date:message-id:subject:to;\r\n        bh=EszC4ccIWB/MUIR/tZJDjXxdQJml9/7P48yuLUaOEeI=;\r\n        b=NeoOoRePAzDTeVpHXrgMg1gy54ulpKQ/LXP0Sh+vuLku4QuhDOoG5C24ty6x979Rij\r\n         LIHYs5BVYllIHLCXEHxraQr3TQeY+1epYiIfK09KRK+U2ECKeh5r3x0V0/QyydgQ7U1Q\r\n         SJ8PTMeKTAFREmNR4gkY77bVFZrXl1M5pI5PKfW9l00Mif5/l8DH90a4u4DszIx95kWL\r\n         0vRvbv4nGXmVXOM+Ulct2f4Dcb5E8p8xXRg0j/CqscPyhUBKBGVVvEzHPS4u4ssjRTk5\r\n         WDEpIT7wqaulGbVyjegGt6YAm00xGl29tz1z7uIUzFTqYwTZUJt/9eysxqMx5NfgpPm9\r\n         FAmw==\r\nX-Gm-Message-State: APjAAAVdU1fJPfnknUktHdXGqezU17yvkoKsIcMLrACzo1JrULKOZKz+\r\n	8WVjTOTJ58kAc2dLRgQCCgFEDUwlPf792GP9mrBwses=\r\nX-Google-Smtp-Source: APXvYqwvQB32PNxR2Wupgzlqpt+8GOQ3KO9HjVp84+0EexITdvCfTdYThwqM1msFPNGei81LtPI9WBgOnr+DnxqWwXw=\r\nX-Received: by 2002:a63:784c:: with SMTP id t73mr32311944pgc.268.1563257254266;\r\n Mon, 15 Jul 2019 23:07:34 -0700 (PDT)\r\nMIME-Version: 1.0\r\nFrom: Minerva Cabasso <minervaonlinemarketing@gmail.com>\r\nDate: Tue, 16 Jul 2019 11:37:22 +0530\r\nMessage-ID: <CAB=Qkze6+CR3dgyh3pdbHNixvhk=TCS94Nd_asBFcv2to5_g5Q@mail.gmail.com>\r\nSubject: Link Building And Content Writing Service Provider.\r\nTo: info@apusseo.com\r\nContent-Type: multipart/alternative; boundary=\"000000000000554aa9058dc6311f\"\r\n\r\n --000000000000554aa9058dc6311f\r\nContent-Type: text/plain; charset=\"UTF-8\"\r\n\r\nHi,\r\n\r\nI\'m a Blogger outreach supplier. I have in my collection 6000+ good quality\r\nsites.\r\n\r\nFor example:\r\nhttps://renovate.home.blog/ DA 64\r\nhttps://myinterior.design.blog/ DA 38\r\nhttps://pinkbluelovescute.com/ DA 38\r\nhttp://foroes.net/ DA 54\r\nhttps://southfloridareporter.com/ DA 53\r\nhttp://www.itsgettinghotinhere.org/ DA 52\r\n\r\nThe above sites are just a few examples. I have many more sites with high\r\npage authority and domain authority.\r\n\r\nWaiting for your response.\r\n\r\n-- \r\n*Kind Regards!*\r\n*Minerva*\r\n*Professional Blogger and Outreach supplier*\r\nWeb : *https://qualitylinkbuilders.com/ <https://qualitylinkbuilders.com/>*\r\n\r\n[image: Mailtrack]\r\n<https://mailtrack.io?utm_source=gmail&utm_medium=signature&utm_campaign=signaturevirality5&>\r\nSender\r\nnotified by\r\nMailtrack\r\n<https://mailtrack.io?utm_source=gmail&utm_medium=signature&utm_campaign=signaturevirality5&>\r\n07/16/19,\r\n11:37:20 AM\r\n\r\n--000000000000554aa9058dc6311f\r\nContent-Type: text/html; charset=\"UTF-8\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<div dir=3D\"ltr\">Hi,<br><br>I&#39;m a Blogger outreach supplier. I have in =\r\nmy collection 6000+ good quality sites.<br><br>For example:<br><a href=3D\"h=\r\nttps://renovate.home.blog/\">https://renovate.home.blog/</a>	DA 64 <br><a hr=\r\nef=3D\"https://myinterior.design.blog/\">https://myinterior.design.blog/</a>	=\r\nDA 38 <br><a href=3D\"https://pinkbluelovescute.com/\">https://pinkbluelovesc=\r\nute.com/</a>	DA 38 <br><a href=3D\"http://foroes.net/\">http://foroes.net/</a=\r\n>	DA 54		<br><a href=3D\"https://southfloridareporter.com/\">https://southflo=\r\nridareporter.com/</a>	DA 53		<br><a href=3D\"http://www.itsgettinghotinhere.=\r\norg/\">http://www.itsgettinghotinhere.org/</a>	DA 52<br><br>The above sites =\r\nare just a few examples. I have many more sites with high page authority an=\r\nd domain authority.<br><br>Waiting for your response.<br clear=3D\"all\"><div=\r\n><br></div>-- <br><div dir=3D\"ltr\" class=3D\"gmail_signature\" data-smartmail=\r\n=3D\"gmail_signature\"><div dir=3D\"ltr\"><div><div dir=3D\"ltr\"><div><div dir=\r\n=3D\"ltr\"><b>Kind Regards!</b><div><font color=3D\"#000000\" face=3D\"Roboto, R=\r\nobotoDraft, Arial, sans-serif\"><span style=3D\"white-space:nowrap\"><b>Minerv=\r\na</b></span></font></div><div><b style=3D\"outline:none;color:rgb(38,50,56);=\r\nfont-family:Roboto,sans-serif;font-size:13px\">Professional Blogger and Outr=\r\neach supplier</b><font color=3D\"#000000\" face=3D\"Roboto, RobotoDraft, Arial=\r\n, sans-serif\"><span style=3D\"white-space:nowrap\"><b><br></b></span></font><=\r\n/div><div><span style=3D\"color:rgb(0,0,0);font-family:Roboto,RobotoDraft,Ar=\r\nial,sans-serif;font-size:13px;font-weight:700;white-space:nowrap\">Web :=C2=\r\n=A0</span><font color=3D\"#000000\" face=3D\"Roboto, RobotoDraft, Arial, sans-=\r\nserif\"><span style=3D\"white-space:nowrap\"><b><a href=3D\"https://qualitylink=\r\nbuilders.com/\" target=3D\"_blank\">https://qualitylinkbuilders.com/</a></b></=\r\nspan></font></div></div></div></div></div></div></div><br><div class=3D\"mt-=\r\nsignature\">\r\n        <table border=3D\"0\" cellpadding=3D\"8\" cellspacing=3D\"0\" style=3D\"us=\r\ner-select: none;\">\r\n            <tbody><tr>\r\n                <td>\r\n                    <a href=3D\"https://mailtrack.io?utm_source=3Dgmail&amp;=\r\nutm_medium=3Dsignature&amp;utm_campaign=3Dsignaturevirality5&amp;\" class=3D=\r\n\"\" style=3D\"text-decoration:none\">\r\n                        <img src=3D\"https://s3.amazonaws.com/mailtrack-sign=\r\nature/sender_notified.gif\" alt=3D\"Mailtrack\" class=3D\"\" width=3D\"32\" height=\r\n=3D\"32\">\r\n                    </a>\r\n                </td>\r\n                <td>\r\n                    <span style=3D\"color:#777\">Sender notified by</span> <b=\r\nr>\r\n                    <a href=3D\"https://mailtrack.io?utm_source=3Dgmail&amp;=\r\nutm_medium=3Dsignature&amp;utm_campaign=3Dsignaturevirality5&amp;\" class=3D=\r\n\"mt-install\" style=3D\"color:#4374f7\">Mailtrack</a>\r\n                    <span style=3D\"color:transparent;font-size:0\">07/16/19,=\r\n 11:37:20 AM</span>\r\n                </td>\r\n                <td>\r\n                   =20\r\n                </td>\r\n            </tr>\r\n        </tbody></table>\r\n    </div><img width=3D\"0\" height=3D\"0\" class=3D\"mailtrack-img\" alt=3D\"\" st=\r\nyle=3D\"display:flex\" src=3D\"https://mailtrack.io/trace/mail/3ddcffccc6c9a9a=\r\naecc1d6055bd63d3fcddb22f6.png?u=3D3434353\"></div>\r\n\r\n--000000000000554aa9058dc6311f--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('29', 'LLC Massive Dynamicks <info@massivedynamicks.com> - import@massivedynamicks.com', '10028', '1', NULL, 'RFQ # 216779', '\n<p>Good day to you.<br /><br />This is Mrs. Faye from LLC Massive Dynamicks. One of your customers recommended your company to my director Mr. Yuki. We would like to put the potential items in our range, would you please get back to us promptly with your company profile and and catalog.</p>\n<p>We would place an order immediate upon receipt of your reply mail now.</p>\n<p>Awaiting your reply.</p>\n<p>Best regards</p>\n<p>Technical Purchase Manager</p>\n<p>Mob: +1 (937) 9360029</p>\n<p>LLC Massive Dynamicks</p>\n<p>12 America Ave, Lakewood, NJ 08701, USA</p>', 'new', '0', '0', '1', '0', NULL, '1563343803', '1', '1', '0', 'Return-Path: <info@massivedynamicks.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id C7x9LPC6Ll1rYwIAMoQ/pw\r\n	(envelope-from <info@massivedynamicks.com>)\r\n	for <info@apusseo.com>; Wed, 17 Jul 2019 09:06:40 +0300\r\nReturn-path: <info@massivedynamicks.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Wed, 17 Jul 2019 09:06:40 +0300\r\nReceived: from ns1.mporaprim.pw ([134.209.145.98]:58042)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-GCM-SHA384:256)\r\n	(Exim 4.92)\r\n	(envelope-from <info@massivedynamicks.com>)\r\n	id 1hnd5M-000eiO-H6\r\n	for info@apusseo.com; Wed, 17 Jul 2019 09:06:40 +0300\r\nReceived: from [41.83.218.90] (unknown [41.83.218.90])\r\n	by ns1.mporaprim.pw (Postfix) with ESMTPA id 515ACC8425\r\n	for <info@apusseo.com>; Wed, 17 Jul 2019 05:49:31 +0000 (UTC)\r\nReply-To: import@massivedynamicks.com\r\nFrom: LLC Massive Dynamicks<info@massivedynamicks.com>\r\nTo: info@apusseo.com\r\nSubject: RFQ # 216779\r\nDate: 17 Jul 2019 05:49:34 +0000\r\nMessage-ID: <20190717054934.367EC1D803158A08@massivedynamicks.com>\r\nMIME-Version: 1.0\r\nContent-Type: text/html\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n <!DOCTYPE HTML>\r\n\r\n<HTML><HEAD><TITLE></TITLE>\r\n<META content=3DIE=3Dedge http-equiv=3DX-UA-Compatible>\r\n<META name=3DGENERATOR content=3D\"MSHTML 8.00.7601.17514\"></HEAD>\r\n<BODY style=3D\"MARGIN: 0.4em\">\r\n<P>Good day to you.<BR><BR>This is Mrs. Faye from LLC Massive Dynamicks. On=\r\ne of your customers recommended your company to my director Mr. Yuki. We wo=\r\nuld like to put the potential items in our range, would you please get back=\r\n to us promptly with your company profile and and catalog.</P>\r\n<P>We would place an order immediate upon receipt of your reply mail now.</=\r\nP>\r\n<P>Awaiting your reply.</P>\r\n<P>Best regards</P>\r\n<P>Technical Purchase Manager</P>\r\n<P>Mob: +1 (937) 9360029</P>\r\n<P>LLC Massive Dynamicks</P>\r\n<P>12 America Ave, Lakewood, NJ 08701, USA</P></BODY></HTML>\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('30', 'Jasleen K <jasleen@lapronics.online> - jasleen@lapronics.online', '10029', '1', NULL, 'Apus.co [Apus]', '<p><span style=\"font-weight:400;\">Hi There, </span></p><p><span style=\"font-weight:400;\">We recently bought the domain name </span><strong>\"</strong><strong>Apus.co</strong><strong>\"</strong><span style=\"font-weight:400;\"> for development for one of our client but the plans have changed now. </span></p><p><span style=\"font-weight:400;\">Looks like you are in the same business and listed in Google search and maps for the same keywords.</span></p><p><span style=\"font-weight:400;\">Would you like to acquire the domain name?</span></p><div class=\"io-ox-signature\"><p><br /></p><p>Sincerely, </p><p>Jasleen<br /></p><p>Digital Marketer, Client Outreach, USA<br />WZ-90, West New Delhi | India 110063</p><p>------------------------------------------------------------------------------</p><p><strong><em>If you don\'t want to receive these emails then Please type Remove or Unsubscribe</em></strong></p></div>', 'new', '0', '0', '1', '0', NULL, '1565034004', '1', '1', '0', 'Return-Path: <jasleen@lapronics.online>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id 1bOvBDCFSF112AUAMoQ/pw\r\n	(envelope-from <jasleen@lapronics.online>)\r\n	for <info@apusseo.com>; Mon, 05 Aug 2019 22:36:16 +0300\r\nReturn-path: <jasleen@lapronics.online>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Mon, 05 Aug 2019 22:36:16 +0300\r\nReceived: from us2-ob3-1.mailhostbox.com ([208.91.199.217]:36368)\r\n	by cp.euwebhoster.com with esmtps (TLSv1:DHE-RSA-AES256-SHA:256)\r\n	(Exim 4.92)\r\n	(envelope-from <jasleen@lapronics.online>)\r\n	id 1huimF-001bel-Ot\r\n	for info@apusseo.com; Mon, 05 Aug 2019 22:36:16 +0300\r\nReceived: from 172.16.214.62 (unknown [172.16.214.62])\r\n	(using TLSv1 with cipher AES256-SHA (256/256 bits))\r\n	(No client certificate requested)\r\n	(Authenticated sender: jasleen@lapronics.online)\r\n	by us2.outbound.mailhostbox.com (Postfix) with ESMTPSA id CC104D588B\r\n	for <info@apusseo.com>; Mon,  5 Aug 2019 19:36:13 +0000 (GMT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=lapronics.online;\r\n	s=20181031; t=1565033773;\r\n	bh=lLJHH8N8gJWqcEPcSF8GoMqfSulbuEtHX+heRLMSDjI=;\r\n	h=Date:From:Reply-To:To:Subject;\r\n	b=HUsbJY84OteOxvg9+xPmmCsngz9BxWq0OYEWC2Nan2SoF1D+7Q5JuvZBdN+77Mk1x\r\n	 lt9Jxtbmz5ML7/ZgDVFcxC+bsXlNkfU9q9Wulc89yrfiWA6jzLZlwYkPbbw64ohsKR\r\n	 eheIiFAPFdj2fpuvvm16+i0+cxuyvt3yCivTrnxc=\r\nDate: Tue, 6 Aug 2019 01:06:13 +0530 (IST)\r\nFrom: Jasleen K <jasleen@lapronics.online>\r\nReply-To: Jasleen K <jasleen@lapronics.online>\r\nTo: info@apusseo.com\r\nMessage-ID: <614842433.266.1565033773769@webmail.lapronics.online>\r\nSubject: Apus.co [Apus]\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_265_1048906527.1565033773759\"\r\nX-Priority: 3\r\nImportance: Medium\r\nX-Mailer: Open-Xchange Mailer v7.8.3-Rev22\r\nX-Originating-Client: open-xchange-appsuite\r\nX-CMAE-Score: 0\r\nX-CMAE-Analysis: v=2.2 cv=KeeiiUQD c=1 sm=1 tr=0\r\n	a=Ejo+fC9hko1e0+RChf/zrg==:117 a=MKtGQD3n3ToA:10 a=1oJP67jkp3AA:10\r\n	a=Y4L443X5LNQA:10 a=ZZnuYtJkoWoA:10 a=gWPzeh52L0f8FBCSqa8A:9\r\n	a=QEXdDO2ut3YA:10 a=n1E-kIZMCWf6cM6i:21 a=_W_S_7VecoQA:10\r\n\r\n ------=_Part_265_1048906527.1565033773759\r\nMIME-Version: 1.0\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\nHi There, \r\n\r\nWe recently bought the domain name \"Apus.co\" for development for one of our client but the plans have changed now. \r\n\r\nLooks like you are in the same business and listed in Google search and maps for the same keywords.\r\n\r\nWould you like to acquire the domain name?\r\n\r\n\r\nSincerely, \r\n\r\nJasleen\r\n\r\nDigital Marketer, Client Outreach, USA\r\nWZ-90, West New Delhi | India 110063\r\n\r\n------------------------------------------------------------------------------\r\n\r\nIf you don\'t want to receive these emails then Please type Remove or Unsubscribe\r\n------=_Part_265_1048906527.1565033773759\r\nMIME-Version: 1.0\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\n<!DOCTYPE html>\r\n<html><head>\r\n    <meta charset=\"UTF-8\">\r\n</head><body><p><span style=\"font-weight: 400;\">Hi There,&#160;</span></p><p><span style=\"font-weight: 400;\">We recently bought the domain name </span><strong>&#34;</strong><strong>Apus.co</strong><strong>&#34;</strong><span style=\"font-weight: 400;\"> for development for one of our client but the plans have changed now.&#160;</span></p><p><span style=\"font-weight: 400;\">Looks like you are in the same business and listed in Google search and maps for the same keywords.</span></p><p><span style=\"font-weight: 400;\">Would you like to acquire the domain name?</span></p><div class=\"io-ox-signature\"><p><br></p><p>Sincerely,&#160;</p><p>Jasleen<br></p><p>Digital Marketer, Client Outreach, USA<br>WZ-90, West New Delhi | India 110063</p><p>------------------------------------------------------------------------------</p><p><strong><em>If you don&#39;t want to receive these emails then Please type Remove or Unsubscribe</em></strong></p></div></body></html>\r\n \r\n------=_Part_265_1048906527.1565033773759--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('31', 'Jasleen K <jasleen@lapronics.online> - jasleen@lapronics.online', '10030', '1', NULL, 'Re: Apus.co [Apus]', 'Did you receive my last email, Just Confirming?<br />\n<br /><blockquote>\n\n    \nOn August 6, 2019 at 1:06 AM Jasleen K &lt;jasleen@lapronics.online&gt; wrote:<br /><br /><p><span style=\"font-weight:400;\">Hi There, </span></p><p><span style=\"font-weight:400;\">We recently bought the domain name </span><strong>\"</strong><strong>Apus.co</strong><strong>\"</strong><span style=\"font-weight:400;\"> for development for one of our client but the plans have changed now. </span></p><p><span style=\"font-weight:400;\">Looks like you are in the same business and listed in Google search and maps for the same keywords.</span></p><p><span style=\"font-weight:400;\">Would you like to acquire the domain name?</span></p><div class=\"io-ox-signature\"><p><br /></p><p>Sincerely, </p><p>Jasleen<br /></p><p>Digital Marketer, Client Outreach, USA<br />WZ-90, West New Delhi | India 110063</p><p>------------------------------------------------------------------------------</p><p><strong><em>If you don\'t want to receive these emails then Please type Remove or Unsubscribe</em></strong></p></div></blockquote>\n<br /> \n ', 'new', '0', '0', '1', '0', NULL, '1565431204', '1', '1', '0', 'Return-Path: <jasleen@lapronics.online>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id iCtDCUeVTl2A5A0AMoQ/pw\r\n	(envelope-from <jasleen@lapronics.online>)\r\n	for <info@apusseo.com>; Sat, 10 Aug 2019 12:58:31 +0300\r\nReturn-path: <jasleen@lapronics.online>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Sat, 10 Aug 2019 12:58:31 +0300\r\nReceived: from us2-ob3-1.mailhostbox.com ([208.91.199.217]:52993)\r\n	by cp.euwebhoster.com with esmtps (TLSv1:DHE-RSA-AES256-SHA:256)\r\n	(Exim 4.92)\r\n	(envelope-from <jasleen@lapronics.online>)\r\n	id 1hwO8s-003otO-TI\r\n	for info@apusseo.com; Sat, 10 Aug 2019 12:58:31 +0300\r\nReceived: from 172.16.214.50 (unknown [172.16.214.50])\r\n	(using TLSv1 with cipher AES256-SHA (256/256 bits))\r\n	(No client certificate requested)\r\n	(Authenticated sender: jasleen@lapronics.online)\r\n	by us2.outbound.mailhostbox.com (Postfix) with ESMTPSA id 856CDD1413\r\n	for <info@apusseo.com>; Sat, 10 Aug 2019 09:58:28 +0000 (GMT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=lapronics.online;\r\n	s=20181031; t=1565431108;\r\n	bh=c5VdeHamgaTvnMiCiRD2QwY8x1eYRzRH3yzWKJRmI6c=;\r\n	h=Date:From:Reply-To:To:In-Reply-To:References:Subject;\r\n	b=XbPsDse0033fZ1KfzF2n3bCyeF1LOaQyCytR96Ftlzq4tPRwGpNXLwrWTqJFU5imn\r\n	 +ec5tpPBiuUGx/teIeePcftx4CJKhexB+Ux3gnfjbMHpqPMZQzNweJCAZHrcaBbAB9\r\n	 izM5QWCE7PlCNhhfimVGdhQ9XfRjOdhOISG08YUA=\r\nDate: Sat, 10 Aug 2019 15:28:28 +0530 (IST)\r\nFrom: Jasleen K <jasleen@lapronics.online>\r\nReply-To: Jasleen K <jasleen@lapronics.online>\r\nTo: info@apusseo.com\r\nMessage-ID: <570878359.129039.1565431108481@webmail.lapronics.online>\r\nIn-Reply-To: <614842433.266.1565033773769@webmail.lapronics.online>\r\nReferences: <614842433.266.1565033773769@webmail.lapronics.online>\r\nSubject: Re: Apus.co [Apus]\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n	boundary=\"----=_Part_129038_1779933266.1565431108474\"\r\nX-Priority: 3\r\nImportance: Medium\r\nX-Mailer: Open-Xchange Mailer v7.8.3-Rev22\r\nX-Originating-Client: open-xchange-appsuite\r\nX-CMAE-Score: 0\r\nX-CMAE-Analysis: v=2.2 cv=KeeiiUQD c=1 sm=1 tr=0\r\n	a=wucOMCQccDYl2pmMnmOueA==:117 a=jpOVt7BSZ2e4Z31A5e1TngXxSK0=:19\r\n	a=MKtGQD3n3ToA:10 a=1oJP67jkp3AA:10 a=Y4L443X5LNQA:10 a=ZZnuYtJkoWoA:10\r\n	a=gWPzeh52L0f8FBCSqa8A:9 a=QEXdDO2ut3YA:10 a=wPOM5HPxnbqfKKom:21\r\n	a=_W_S_7VecoQA:10\r\n\r\n ------=_Part_129038_1779933266.1565431108474\r\nMIME-Version: 1.0\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\nDid you receive my last email, Just Confirming?\r\n\r\n\r\n> On August 6, 2019 at 1:06 AM Jasleen K <jasleen@lapronics.online> wrote:\r\n> \r\n> \r\n>     Hi There, \r\n> \r\n>     We recently bought the domain name \"Apus.co\" for development for one of our client but the plans have changed now. \r\n> \r\n>     Looks like you are in the same business and listed in Google search and maps for the same keywords.\r\n> \r\n>     Would you like to acquire the domain name?\r\n> \r\n> \r\n>     Sincerely, \r\n> \r\n>     Jasleen\r\n> \r\n>     Digital Marketer, Client Outreach, USA\r\n>     WZ-90, West New Delhi | India 110063\r\n> \r\n>     ------------------------------------------------------------------------------\r\n> \r\n>     If you don\'t want to receive these emails then Please type Remove or Unsubscribe\r\n> \r\n \r\n\r\n------=_Part_129038_1779933266.1565431108474\r\nMIME-Version: 1.0\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<!DOCTYPE html>\r\n<html><head>\r\n    <meta charset=3D\"UTF-8\">\r\n</head><body>Did you receive my last email, Just Confirming?<br>\r\n<br><blockquote type=3D\"cite\">\r\n\r\n   =20\r\nOn August 6, 2019 at 1:06 AM Jasleen K &#60;jasleen@lapronics.online&#62; w=\r\nrote:<br><br><p><span style=3D\"font-weight: 400;\">Hi There,&#160;</span></p=\r\n><p><span style=3D\"font-weight: 400;\">We recently bought the domain name </=\r\nspan><strong>&#34;</strong><strong>Apus.co</strong><strong>&#34;</strong><s=\r\npan style=3D\"font-weight: 400;\"> for development for one of our client but =\r\nthe plans have changed now.&#160;</span></p><p><span style=3D\"font-weight: =\r\n400;\">Looks like you are in the same business and listed in Google search a=\r\nnd maps for the same keywords.</span></p><p><span style=3D\"font-weight: 400=\r\n;\">Would you like to acquire the domain name?</span></p><div class=3D\"io-ox=\r\n-signature\"><p><br></p><p>Sincerely,&#160;</p><p>Jasleen<br></p><p>Digital =\r\nMarketer, Client Outreach, USA<br>WZ-90, West New Delhi | India 110063</p><=\r\np>-------------------------------------------------------------------------=\r\n-----</p><p><strong><em>If you don&#39;t want to receive these emails then =\r\nPlease type Remove or Unsubscribe</em></strong></p></div></blockquote>\r\n<br>&#160;\r\n </body></html>\r\n=20\r\n------=_Part_129038_1779933266.1565431108474--\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('32', 'Madhu Mala <madhuseomanager@yandex.com> - madhuseomanager@yandex.com', '10031', '1', NULL, 'Get Up to 7 pages of website at $399', '<div><div style=\"line-height:normal;margin-bottom:.0001pt;\">Hi,</div><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"line-height:normal;margin-bottom:.0001pt;\">Greetings of the day!</div><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"line-height:normal;margin-bottom:.0001pt;\">Are you looking for a way to generate more business through your website? With a professionally designed online presence, you can take your online business to a new level.</div><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"line-height:normal;margin-bottom:.0001pt;\">While your website has a lot going for it – such as the mobile-friendly design – there are steps you can take to improve its appearance and conversion potential.</div><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"line-height:normal;margin-bottom:.0001pt;\">My one and only goal is simple: to redesign your website as a means for helping you generate more revenue.</div><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"line-height:normal;margin-bottom:.0001pt;\"><strong>Please see the features and functionalities you’re going to avail in this starter <span style=\"background:#FFFF00;\">package at just $399</span></strong></div><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"line-height:normal;margin-bottom:.0001pt;\"><strong><span style=\"background:#FFFF00;\">Our WordPress website package includes:</span></strong></div><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><ul><li style=\"margin-bottom:.0001pt;\"><strong>Up to 7 pages of website</strong></li><li style=\"margin-bottom:.0001pt;\"><strong>A complete custom designed and developed- No theme or premade design used!!</strong></li><li style=\"margin-bottom:.0001pt;\"><strong>WordPress CMS based development</strong></li><li style=\"margin-bottom:.0001pt;\"><strong>Responsive Mobile Version</strong></li><li style=\"margin-bottom:.0001pt;\"><strong>Search engine friendly design</strong></li><li style=\"margin-bottom:.0001pt;\"><strong>Complete assistance in uploading the website to your server</strong></li><li style=\"margin-bottom:.0001pt;\"><strong>Google Analytics and Search Console set-up and integration</strong></li></ul><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"line-height:normal;margin-bottom:.0001pt;\">If you understand the importance of a well-designed website and if you want to have more online success in the future, take the time to respond to this email.</div><div style=\"line-height:normal;margin-bottom:.0001pt;\"> </div><div style=\"line-height:normal;margin-bottom:.0001pt;\">I look forward to your positive response.</div><div style=\"line-height:normal;margin-bottom:.0001pt;\">--</div><div style=\"line-height:normal;margin-bottom:.0001pt;\">Kind regards,</div><div style=\"line-height:normal;margin-bottom:.0001pt;\">Madhu</div><div style=\"line-height:normal;margin-bottom:.0001pt;\">Business Development Executive</div></div>', 'new', '0', '0', '1', '0', NULL, '1565686204', '1', '1', '0', 'Return-Path: <madhuseomanager@yandex.com>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id HYSCNat5Ul3qEAcAMoQ/pw\r\n	(envelope-from <madhuseomanager@yandex.com>)\r\n	for <info@apusseo.com>; Tue, 13 Aug 2019 11:49:47 +0300\r\nReturn-path: <madhuseomanager@yandex.com>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Tue, 13 Aug 2019 11:49:48 +0300\r\nReceived: from forward400j.mail.yandex.net ([5.45.198.245]:34799)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES256-GCM-SHA384:256)\r\n	(Exim 4.92)\r\n	(envelope-from <madhuseomanager@yandex.com>)\r\n	id 1hxSV1-001wSx-On\r\n	for info@apusseo.com; Tue, 13 Aug 2019 11:49:47 +0300\r\nReceived: from mxback8q.mail.yandex.net (mxback8q.mail.yandex.net [IPv6:2a02:6b8:c0e:42:0:640:b38f:32ec])\r\n	by forward400j.mail.yandex.net (Yandex) with ESMTP id 05A686E1545;\r\n	Tue, 13 Aug 2019 11:49:47 +0300 (MSK)\r\nReceived: from localhost (localhost [::1])\r\n	by mxback8q.mail.yandex.net (nwsmtp/Yandex) with ESMTP id I938h5lQCG-ngJGAAl4;\r\n	Tue, 13 Aug 2019 11:49:46 +0300\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=yandex.com; s=mail; t=1565686186;\r\n	bh=dr9+nFiVmbeGnIB50zozgA0zQ8Pd6qva1CMSBYNMocI=;\r\n	h=Message-Id:Date:Subject:To:From;\r\n	b=tDL296s4WjiBcI57VAQr2lDgcveJPZ3Qh6V/KOHk03lcQolp2A+40lltsrz7d0zDO\r\n	 KugmY4TwQHEZFB3K90e74zT13Q8C/f7l0zLq+Tt/G1/28w6o4stGE9JWTl7eURO6GT\r\n	 v8O2K77iFrOo7sVFnfMiJrM/kCZdmRd7UzClCL+w=\r\nAuthentication-Results: mxback8q.mail.yandex.net; dkim=pass header.i=@yandex.com\r\nReceived: by vla1-d6957fa77501.qloud-c.yandex.net with HTTP;\r\n	Tue, 13 Aug 2019 11:49:42 +0300\r\nFrom: Madhu Mala <madhuseomanager@yandex.com>\r\nTo: madhuseomanager <madhuseomanager@yandex.com>\r\nSubject: Get Up to 7 pages of website at $399\r\nMIME-Version: 1.0\r\nX-Mailer: Yamail [ http://yandex.ru ] 5.0\r\nDate: Tue, 13 Aug 2019 14:19:42 +0530\r\nMessage-Id: <1072471565686182@vla1-d6957fa77501.qloud-c.yandex.net>\r\nContent-Transfer-Encoding: base64\r\nContent-Type: text/html; charset=utf-8\r\n\r\n PGRpdj48ZGl2IHN0eWxlPSJsaW5lLWhlaWdodDpub3JtYWw7bWFyZ2luLWJvdHRvbTowLjAwMDFw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\r\nbG9wbWVudCBFeGVjdXRpdmU8L2Rpdj48L2Rpdj4=\r\n');
INSERT INTO tickets (`id`, `from`, `reference`, `type_id`, `lock`, `subject`, `text`, `status`, `client_id`, `company_id`, `user_id`, `escalation_time`, `priority`, `created`, `queue_id`, `updated`, `project_id`, `raw`) VALUES ('33', 'Jayden Li <jayden@crazycybertech.info> - jayden@crazycybertech.info', '10032', '1', NULL, '1st Page on Google Proposal', '<div class=\"WordSection1\"><p style=\"background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#002060;\" xml:lang=\"en-in\">Hi,  <br /><br />I found your web contact email info@apusseo.com. I would like to discuss a business opportunity with you</span><span style=\"color:#333399;\">.</span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#002060;\" xml:lang=\"en-in\">                                                                                                                               </span></p><p style=\"background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#002060;\" xml:lang=\"en-in\">Would you like to be listed at the top of every major search engine such as Google, Yahoo! &amp; Bing for multiple search phrases (keywords) relevant to your products / services?<br /><br />We are a team of professionals which includes 50 full time SEO experts (Google Certified). We are proud to inform you that our team handled 250+ SEO projects. </span></p><p style=\"background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#002060;\" xml:lang=\"en-in\">We will be glad to assist you with offering our services. </span></p><p style=\"background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#002060;\" xml:lang=\"en-in\">Contact us for the best quote for your website &amp; we\'ll place your website on 1st page Google ranking for targeted keywords. </span></p><p style=\"background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#002060;\" xml:lang=\"en-in\">I\'d be happy to send you our package, pricing and past work details, if you\'d like to assess our work. </span></p><p style=\"background:#FFFFFF;\"><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#002060;\" xml:lang=\"en-in\">Note-:-Please Share your contact details (Skype ID or Phone Number) and let us know your convenient time for the call/call so our seniors can contact you directly for further discussion.<br /><br /><br />Best Regards,</span><span style=\"color:#002060;\"><br /></span><span lang=\"en-in\" style=\"font-size:10pt;font-family:Verdana, \'sans-serif\';color:#002060;\" xml:lang=\"en-in\">Jayden Li  : SEO-Consultant</span></p><p class=\"MsoNormal\"></p><p> </p><p class=\"MsoNormal\"></p><p> </p></div>', 'new', '0', '0', '1', '0', NULL, '1565944803', '1', '1', '0', 'Return-Path: <jayden@crazycybertech.info>\r\nDelivered-To: info@apusseo.com\r\nReceived: from cp.euwebhoster.com\r\n	by cp.euwebhoster.com with LMTP\r\n	id iB9hLtRrVl23LA8AMoQ/pw\r\n	(envelope-from <jayden@crazycybertech.info>)\r\n	for <info@apusseo.com>; Fri, 16 Aug 2019 11:39:48 +0300\r\nReturn-path: <jayden@crazycybertech.info>\r\nEnvelope-to: info@apusseo.com\r\nDelivery-date: Fri, 16 Aug 2019 11:39:48 +0300\r\nReceived: from mail-pl1-f193.google.com ([209.85.214.193]:35053)\r\n	by cp.euwebhoster.com with esmtps (TLSv1.2:ECDHE-RSA-AES128-GCM-SHA256:128)\r\n	(Exim 4.92)\r\n	(envelope-from <jayden@crazycybertech.info>)\r\n	id 1hyXm0-004AlV-FL\r\n	for info@apusseo.com; Fri, 16 Aug 2019 11:39:48 +0300\r\nReceived: by mail-pl1-f193.google.com with SMTP id gn20so2184547plb.2\r\n        for <info@apusseo.com>; Fri, 16 Aug 2019 01:39:43 -0700 (PDT)\r\nDKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=crazycybertech-info.20150623.gappssmtp.com; s=20150623;\r\n        h=from:to:subject:date:message-id:mime-version:thread-index\r\n         :content-language;\r\n        bh=maVGKKQ0mILe09BJ0h0rltNG6NrY9L2OjOpWJ3wjjdw=;\r\n        b=w4a+zTwh77TwJ/SIXDDH+1p/zujcKey8A7PkDy/3r9MntRSEFm8dnplzbe6GXiBJxk\r\n         qgNaoMzT4G3KEsiYpnmMAWSFR2BDf7jJ2733HTZ61iyDVcmlR+zhfhfoSJ+ycQhjedr7\r\n         +sSXf3Z4w3IXS9j+/6kKJZt8FgB91OfI4Z90JPdgqERgtzF/PK1YLn29mTiR63sGIVSs\r\n         JGA//8RHK+fdUukLtjlL49GdzRYROS0B+NJyonhDnkidYE7ihkcFq63OEQ8c+6iwTNpF\r\n         81+T002UFCdkwK0clFwm2vkG7eZ6gi9A/bOdkTWn5U2nIgl+NRgVBY9ksN8Yjmj0RBHd\r\n         lvCQ==\r\nX-Google-DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=1e100.net; s=20161025;\r\n        h=x-gm-message-state:from:to:subject:date:message-id:mime-version\r\n         :thread-index:content-language;\r\n        bh=maVGKKQ0mILe09BJ0h0rltNG6NrY9L2OjOpWJ3wjjdw=;\r\n        b=KQelJ+ztDD7M91HxyiAvbmVBoGlk/lfzZnzVmxZRMc1VwIKHg6+RSJ7JOZpgW5hymk\r\n         xHu1/73Fw++gvZNIf4s0+LMHgkI1SG/fZN01/5EpFiCBA2mYG/2FG7MdLR/KnQCEUjPr\r\n         LRmlSDgE7aHwK6zflnnk8j2WYjVEnBnqL+7bnfCcY7qbDo/jBKWlaC93j+pU5RU10PlQ\r\n         yFNN93jvnoCXVOzLyM8RbKXAXoEFkDyY3BimI4+ANLe46ooJSOOrOuuUGtiGSaEiN7nL\r\n         U9BXOH8ipb7Qkr0jbvtzooxtQbwISBEij5WSNMEmqVuT1xEEFeFS0UhhPKo50tomwhLn\r\n         Mrsg==\r\nX-Gm-Message-State: APjAAAXQk8JqbTRA6IzlSue7XfkUoBJDpbSCc/0ASglmaGvJNW3hYAbc\r\n	tsMZ+bL4/01Z/XSi8C5zzzYky6S97Ag=\r\nX-Google-Smtp-Source: APXvYqyu3muhi4hKgZOyT5woXEemsnGj/thKQVB0WLdWuyWBl4NtKha5IH+VHZbQveq7y07abr0s5Q==\r\nX-Received: by 2002:a17:902:6b88:: with SMTP id p8mr7912103plk.95.1565944780739;\r\n        Fri, 16 Aug 2019 01:39:40 -0700 (PDT)\r\nReceived: from pci31PC ([122.177.68.154])\r\n        by smtp.gmail.com with ESMTPSA id s125sm4983235pfc.133.2019.08.16.01.39.39\r\n        for <info@apusseo.com>\r\n        (version=TLS1 cipher=ECDHE-RSA-AES128-SHA bits=128/128);\r\n        Fri, 16 Aug 2019 01:39:40 -0700 (PDT)\r\nFrom: \"Jayden Li	\" <jayden@crazycybertech.info>\r\nTo: <info@apusseo.com>\r\nSubject: 1st Page on Google Proposal\r\nDate: Fri, 16 Aug 2019 13:53:28 +0530\r\nMessage-ID: <21d2c01d5540e$232e7460$698b5d20$@info>\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative;\r\n	boundary=\"----=_NextPart_000_21D2D_01D5543C.3CE6B060\"\r\nX-Mailer: Microsoft Office Outlook 12.0\r\nThread-Index: AdVSmJ86u7cgerXNRLK42BKn4/XB4w==\r\nContent-Language: en-us\r\n\r\n This is a multi-part message in MIME format.\r\n\r\n------=_NextPart_000_21D2D_01D5543C.3CE6B060\r\nContent-Type: text/plain;\r\n	charset=\"us-ascii\"\r\nContent-Transfer-Encoding: 7bit\r\n\r\nHi,  \r\n\r\nI found your web contact email info@apusseo.com. I would like to discuss a\r\nbusiness opportunity with you.\r\n\r\n\r\nWould you like to be listed at the top of every major search engine such as\r\nGoogle, Yahoo! & Bing for multiple search phrases (keywords) relevant to\r\nyour products / services?\r\n\r\nWe are a team of professionals which includes 50 full time SEO experts\r\n(Google Certified). We are proud to inform you that our team handled 250+\r\nSEO projects. \r\n\r\nWe will be glad to assist you with offering our services. \r\n\r\nContact us for the best quote for your website & we\'ll place your website on\r\n1st page Google ranking for targeted keywords. \r\n\r\nI\'d be happy to send you our package, pricing and past work details, if\r\nyou\'d like to assess our work. \r\n\r\nNote-:-Please Share your contact details (Skype ID or Phone Number) and let\r\nus know your convenient time for the call/call so our seniors can contact\r\nyou directly for further discussion.\r\n\r\n\r\nBest Regards,\r\nJayden Li  : SEO-Consultant\r\n\r\n \r\n\r\n \r\n\r\n\r\n------=_NextPart_000_21D2D_01D5543C.3CE6B060\r\nContent-Type: text/html;\r\n	charset=\"us-ascii\"\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n<html xmlns:v=3D\"urn:schemas-microsoft-com:vml\" =\r\nxmlns:o=3D\"urn:schemas-microsoft-com:office:office\" =\r\nxmlns:w=3D\"urn:schemas-microsoft-com:office:word\" =\r\nxmlns:m=3D\"http://schemas.microsoft.com/office/2004/12/omml\" =\r\nxmlns=3D\"http://www.w3.org/TR/REC-html40\"><head><META =\r\nHTTP-EQUIV=3D\"Content-Type\" CONTENT=3D\"text/html; =\r\ncharset=3Dus-ascii\"><meta name=3DGenerator content=3D\"Microsoft Word 12 =\r\n(filtered medium)\"><style><!--\r\n/* Font Definitions */\r\n@font-face\r\n	{font-family:Wingdings;\r\n	panose-1:5 0 0 0 0 0 0 0 0 0;}\r\n@font-face\r\n	{font-family:Mangal;\r\n	panose-1:2 4 5 3 5 2 3 3 2 2;}\r\n@font-face\r\n	{font-family:\"Cambria Math\";\r\n	panose-1:2 4 5 3 5 4 6 3 2 4;}\r\n@font-face\r\n	{font-family:Calibri;\r\n	panose-1:2 15 5 2 2 2 4 3 2 4;}\r\n@font-face\r\n	{font-family:Verdana;\r\n	panose-1:2 11 6 4 3 5 4 4 2 4;}\r\n/* Style Definitions */\r\np.MsoNormal, li.MsoNormal, div.MsoNormal\r\n	{margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:10.0pt;\r\n	margin-left:0in;\r\n	line-height:115%;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",\"sans-serif\";}\r\na:link, span.MsoHyperlink\r\n	{mso-style-priority:99;\r\n	color:#0563C1;\r\n	text-decoration:underline;}\r\na:visited, span.MsoHyperlinkFollowed\r\n	{mso-style-priority:99;\r\n	color:purple;\r\n	text-decoration:underline;}\r\np\r\n	{mso-style-priority:99;\r\n	mso-margin-top-alt:auto;\r\n	margin-right:0in;\r\n	mso-margin-bottom-alt:auto;\r\n	margin-left:0in;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\",\"serif\";}\r\np.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph\r\n	{mso-style-priority:34;\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:10.0pt;\r\n	margin-left:.5in;\r\n	line-height:115%;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",\"sans-serif\";}\r\np.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, =\r\ndiv.MsoListParagraphCxSpFirst\r\n	{mso-style-priority:34;\r\n	mso-style-type:export-only;\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:.5in;\r\n	margin-bottom:.0001pt;\r\n	line-height:115%;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",\"sans-serif\";}\r\np.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, =\r\ndiv.MsoListParagraphCxSpMiddle\r\n	{mso-style-priority:34;\r\n	mso-style-type:export-only;\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:.5in;\r\n	margin-bottom:.0001pt;\r\n	line-height:115%;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",\"sans-serif\";}\r\np.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, =\r\ndiv.MsoListParagraphCxSpLast\r\n	{mso-style-priority:34;\r\n	mso-style-type:export-only;\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:10.0pt;\r\n	margin-left:.5in;\r\n	line-height:115%;\r\n	font-size:11.0pt;\r\n	font-family:\"Calibri\",\"sans-serif\";}\r\np.yiv2490515894msonormal, li.yiv2490515894msonormal, =\r\ndiv.yiv2490515894msonormal\r\n	{mso-style-name:yiv2490515894msonormal;\r\n	mso-margin-top-alt:auto;\r\n	margin-right:0in;\r\n	mso-margin-bottom-alt:auto;\r\n	margin-left:0in;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\",\"serif\";}\r\nspan.apple-converted-space\r\n	{mso-style-name:apple-converted-space;}\r\n.MsoChpDefault\r\n	{mso-style-type:export-only;}\r\n.MsoPapDefault\r\n	{mso-style-type:export-only;\r\n	margin-bottom:10.0pt;\r\n	line-height:115%;}\r\n@page WordSection1\r\n	{size:8.5in 11.0in;\r\n	margin:1.0in 1.0in 1.0in 1.0in;}\r\ndiv.WordSection1\r\n	{page:WordSection1;}\r\n/* List Definitions */\r\n@list l0\r\n	{mso-list-id:1111781044;\r\n	mso-list-template-ids:-1205847804;}\r\n@list l0:level1\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0B7;\r\n	mso-level-tab-stop:.5in;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	mso-ansi-font-size:10.0pt;\r\n	font-family:Symbol;}\r\n@list l1\r\n	{mso-list-id:1660619046;\r\n	mso-list-type:hybrid;\r\n	mso-list-template-ids:852238522 67698693 67698691 67698693 67698689 =\r\n67698691 67698693 67698689 67698691 67698693;}\r\n@list l1:level1\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0A7;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:Wingdings;}\r\n@list l2\r\n	{mso-list-id:1742867705;\r\n	mso-list-type:hybrid;\r\n	mso-list-template-ids:1814611338 -452397432 67698713 67698715 67698703 =\r\n67698713 67698715 67698703 67698713 67698715;}\r\n@list l2:level1\r\n	{mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	color:black;}\r\n@list l3\r\n	{mso-list-id:1985817933;\r\n	mso-list-type:hybrid;\r\n	mso-list-template-ids:612024854 67698703 67698713 67698715 67698703 =\r\n67698713 67698715 67698703 67698713 67698715;}\r\n@list l3:level1\r\n	{mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;}\r\n@list l4\r\n	{mso-list-id:1993213685;\r\n	mso-list-type:hybrid;\r\n	mso-list-template-ids:283018166 67698689 67698691 67698693 67698689 =\r\n67698691 67698693 67698689 67698691 67698693;}\r\n@list l4:level1\r\n	{mso-level-number-format:bullet;\r\n	mso-level-text:\\F0B7;\r\n	mso-level-tab-stop:none;\r\n	mso-level-number-position:left;\r\n	text-indent:-.25in;\r\n	font-family:Symbol;}\r\nol\r\n	{margin-bottom:0in;}\r\nul\r\n	{margin-bottom:0in;}\r\n--></style><!--[if gte mso 9]><xml>\r\n<o:shapedefaults v:ext=3D\"edit\" spidmax=3D\"1026\" />\r\n</xml><![endif]--><!--[if gte mso 9]><xml>\r\n<o:shapelayout v:ext=3D\"edit\">\r\n<o:idmap v:ext=3D\"edit\" data=3D\"1\" />\r\n</o:shapelayout></xml><![endif]--></head><body lang=3DEN-US =\r\nlink=3D\"#0563C1\" vlink=3Dpurple><div class=3DWordSection1><p =\r\nstyle=3D\'background:white\'><span lang=3DEN-IN =\r\nstyle=3D\'font-size:10.0pt;font-family:\"Verdana\",\"sans-serif\";color:#00206=\r\n0\'>Hi,&nbsp;&nbsp;<br><br>I found your web contact =\r\nemail&nbsp;info@apusseo.com. I would like to discuss a business =\r\nopportunity with you</span><span style=3D\'color:#333399\'>.</span><span =\r\nlang=3DEN-IN =\r\nstyle=3D\'font-size:10.0pt;font-family:\"Verdana\",\"sans-serif\";color:#00206=\r\n0\'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp=\r\n;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&=\r\nnbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&n=\r\nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nb=\r\nsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbs=\r\np;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp=\r\n;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&=\r\nnbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></p><p =\r\nstyle=3D\'background:white\'><span lang=3DEN-IN =\r\nstyle=3D\'font-size:10.0pt;font-family:\"Verdana\",\"sans-serif\";color:#00206=\r\n0\'>Would you like to be listed at the top of every major search engine =\r\nsuch as Google, Yahoo! &amp; Bing for multiple search phrases (keywords) =\r\nrelevant to&nbsp;your products / services?<br><br>We are a team of =\r\nprofessionals which includes 50 full time SEO experts (Google =\r\nCertified). We are proud to inform you that our team handled 250+ SEO =\r\nprojects.&nbsp;</span></p><p style=3D\'background:white\'><span =\r\nlang=3DEN-IN =\r\nstyle=3D\'font-size:10.0pt;font-family:\"Verdana\",\"sans-serif\";color:#00206=\r\n0\'>We will be glad to assist you with offering our =\r\nservices.&nbsp;</span></p><p style=3D\'background:white\'><span =\r\nlang=3DEN-IN =\r\nstyle=3D\'font-size:10.0pt;font-family:\"Verdana\",\"sans-serif\";color:#00206=\r\n0\'>Contact us for the best quote for your website &amp; we\'ll place your =\r\nwebsite on 1st page Google ranking for targeted =\r\nkeywords.&nbsp;</span></p><p style=3D\'background:white\'><span =\r\nlang=3DEN-IN =\r\nstyle=3D\'font-size:10.0pt;font-family:\"Verdana\",\"sans-serif\";color:#00206=\r\n0\'>I\'d be happy to send you our package, pricing and past work details, =\r\nif you\'d like to assess our work.&nbsp;</span></p><p =\r\nstyle=3D\'background:white\'><span lang=3DEN-IN =\r\nstyle=3D\'font-size:10.0pt;font-family:\"Verdana\",\"sans-serif\";color:#00206=\r\n0\'>Note-:-Please Share your contact details (Skype ID or Phone Number) =\r\nand let us know your convenient time for the call/call so our seniors =\r\ncan contact you directly for further discussion.<br><br><br>Best =\r\nRegards,</span><span style=3D\'color:#002060\'><br></span><span =\r\nlang=3DEN-IN =\r\nstyle=3D\'font-size:10.0pt;font-family:\"Verdana\",\"sans-serif\";color:#00206=\r\n0\'>Jayden Li&nbsp; : SEO-Consultant</span></p><p =\r\nclass=3DMsoNormal><o:p>&nbsp;</o:p></p><p =\r\nclass=3DMsoNormal><o:p>&nbsp;</o:p></p></div></body></html>\r\n------=_NextPart_000_21D2D_01D5543C.3CE6B060--\r\n\r\n');


#
# TABLE STRUCTURE FOR: types
#

DROP TABLE IF EXISTS types;

CREATE TABLE `types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `inactive` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO types (`id`, `name`, `description`, `inactive`) VALUES ('1', 'Service Request', 'Service Requests', '0');


#
# TABLE STRUCTURE FOR: users
#

DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(45) DEFAULT NULL,
  `firstname` varchar(120) DEFAULT NULL,
  `lastname` varchar(120) DEFAULT NULL,
  `hashed_password` varchar(128) DEFAULT NULL,
  `email` varchar(60) DEFAULT NULL,
  `status` enum('active','inactive','deleted') DEFAULT NULL,
  `admin` enum('0','1') DEFAULT '0',
  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `userpic` varchar(250) DEFAULT 'no-pic.png',
  `title` varchar(150) DEFAULT NULL,
  `access` varchar(150) NOT NULL DEFAULT '1,2',
  `last_active` varchar(50) DEFAULT NULL,
  `last_login` varchar(50) DEFAULT NULL,
  `queue` bigint(20) DEFAULT '0',
  `token` varchar(255) DEFAULT NULL,
  `language` varchar(255) DEFAULT NULL,
  `signature` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO users (`id`, `username`, `firstname`, `lastname`, `hashed_password`, `email`, `status`, `admin`, `created`, `userpic`, `title`, `access`, `last_active`, `last_login`, `queue`, `token`, `language`, `signature`) VALUES ('1', 'tabac', 'Sergey', 'Baranov', '22564f5e407449527b2d7b3a413b3f397c2d626226284756672d65506148595224c32b252dabe97a36164314c671091f0f55135890299897f0100b2541e2cfcf', 'sergey@unicom.lv', 'active', '1', '2019-01-11 14:16:34', 'no-pic.png', 'Apus CEO', '1,2,3,4,5,6,7,8,9,10,11,12,13,20,33,105,108', '1566487548', '1566485423', '0', '511ea4fd4e9d2926a2c245676b2d6556', NULL, 'Sergey Baranov');
INSERT INTO users (`id`, `username`, `firstname`, `lastname`, `hashed_password`, `email`, `status`, `admin`, `created`, `userpic`, `title`, `access`, `last_active`, `last_login`, `queue`, `token`, `language`, `signature`) VALUES ('2', 'rubiconr8a', 'Aleksey', 'Narnicky', '2541694f40703c306a294e517731616a2d367b6a67576e45322c3d6833515d4350f062a825259042610947e0801da44df83dd53614be93849fa68d033df00ecc', 'rubiconr8a@gmail.com', 'active', '0', '2019-01-14 15:53:21', 'no-pic.png', 'Developer', '3,12,8,6,7,20,105,10,11', NULL, NULL, '1', NULL, NULL, '');
INSERT INTO users (`id`, `username`, `firstname`, `lastname`, `hashed_password`, `email`, `status`, `admin`, `created`, `userpic`, `title`, `access`, `last_active`, `last_login`, `queue`, `token`, `language`, `signature`) VALUES ('3', 'sergeyapus', 'Sergey', 'Jacenko', '265f4c412d685a214d36776a25657b437a4a79702467653b5967454c22767c31fc0ef57f7586490077bbf7c3c3e640833c7dfd42ebae0786a8a92ab74704c3a1', 'apus.work@gmail.com', 'active', '0', '2019-08-22 18:24:51', 'no-pic.png', 'Sergey', '2,3,4,108,20,105,10', NULL, NULL, '1', NULL, NULL, '');


