<?php
$metattitle = 'Server Rooms - KSK Holding SIA';
require_once (__DIR__ . '/../sections/head.php');
require_once (__DIR__ . '/../sections/header.php');
?>

<div class="sectionimg grid-container icon-toplp">
	<img width="320" src="data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20viewBox='0%200%20340%200'%3E%3C/svg%3E" data-lazy-src="/images/bg-icons/1.svg" class="kartinkadizain">
</div>

<div class="sectionimg grid-container icon-toplp">
  <img width="320" src="data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20viewBox='0%200%20340%200'%3E%3C/svg%3E" class="kartinkadizain">
</div>

<section class="what-we-do imgsection teleblockpadding-top-0">
  <div class="grid-container teleblockcontent">
    <h1 class="section_heading">Data Centers</h1>
    <div class="teleblocktext">
      <p>
        Reliable Server Room Construction Services for Your Business
      </p>
    </div>
    <div class="roomblockline"></div>
    <div class="grid-x">
      <div class="cell colmd6 roomcontent">
        <p>
         At KSK, we understand the important role server rooms play in keeping businesses safe and efficient. Thanks to our experience in building specialist server rooms, we offer robust solutions that meet the unique needs of a variety of industries. In this block we look at the key features of our server room services and how they can benefit your business.
        </p>
      </div>
      <div class="cell colmd5 roomimg">
        <img src="/images/images/server-rooms-1.png" />
      </div>
    </div>
    <h2 class="descr-content-room">Enhanced<br> Security</h2>
    <div class="teleblockline"></div>
    <div class="grid-x">
      <div class="cell colmd4 teleblocktileser">
        <div class="expnumeber">
          1
        </div>
        <h5 class="teleblocksubtitler">Robust Access Control</h5>
        <p>Our advanced access control systems secure your server room.</p>
      </div>
      <div class="cell colmd4 teleblocktileser">
        <div class="expnumeber">
          2
        </div>
        <h5 class="teleblocksubtitle">Surveillance Solutions</h5>
        <p>Regular video surveillance of your server room</p>
      </div>
      <div class="cell colmd4 teleblocktileser">
        <div class="expnumeber">
          3
        </div>
        <h5 class="teleblocksubtitle">Intrusion Detection</h5>
        <p>Advanced intrusion detection systems and rapid decision-making.</p>
      </div>
    </div>
  </div>
</section>

<section class="our-works imgsection" id="whatweoffer">
	<div class="ourwork-bsicon">
		<img width="420" src="data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20viewBox='0%200%20420%200'%3E%3C/svg%3E" data-lazy-src="/images/bg-icons/4.svg">
	</div>
  
  <div class="grid-container teleblockcontentsecond">
    <h3 class="section_heading">Expert<br>Project Management</h3>
    <div class="teleblocktextsecondbl">
      <p>
        We pride ourselves on our experienced team and efficient project management
      </p>
    </div>
    <div class="teleblockfeatures cell grid-x">
      <div class="medium-auto small-6">
        <div class="teleblockfeature secondblockpag">
          <div class="offertitle">
            Skilled<br> Professionals
          </div>
          <p>Our dedicated professionals have extensive experience in constructing server rooms for a diverse range of businesses. With their expertise and attention to detail, you can expect high-quality workmanship and adherence to industry best practices.
          </p>
        </div>
      </div>
      <div class="medium-auto small-6">
        <div class="teleblockfeature secondblockpag">
          <div class="offertitle">
            Timeline<br> Management
          </div>
          <p>
            We understand the importance of timely project completion. Our team works diligently to ensure minimal disruption to your operations during the construction phase, adhering to agreed-upon timelines and milestones.
          </p>
        </div>
      </div>
      <div class="medium-auto small-12">
        <div class="teleblockfeature secondblockpag">
          <div class="offertitle">
            Comprehensive<br> Support
          </div>
          <p>
            We provide full support from planning to execution, ensuring a successful server room construction project. With meticulous attention to detail and expert guidance, we exceed expectations, delivering a secure and high-performance server room that meets industry standards.
          </p>
        </div>
      </div>
    </div>
</section>

<section class="what-we-do imgsection thirdblockpag teleblockpadding-top-0">
  <div class="grid-container teleblockcontent">
    <h3 class="section_heading">Reliability<br />at its Core</h3>
    <div class="teleblocktextthirdbl">
      <p>
        We prioritize the reliability and uninterrupted operation of your server room infrastructure
      </p>
    </div>
    <div class="teleblockline"></div>
    <div class="grid-x">
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          01
        </div>
        <h5 class="teleblocksubtitle">Backup Power Solutions</h5>
        <p>We install uninterruptible power supply (UPS) systems and standby generators to provide a reliable source of power
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          02
        </div>
        <h5 class="teleblocksubtitle">Optimal Cooling Infrastructure</h5>
        <p>Installation of cooling systems, including precision air-conditioning units, to regulate the environment in the server room.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          03
        </div>
        <h5 class="teleblocksubtitle">Fire Suppression Mechanisms</h5>
        <p>Install modern fire detection systems and deploy extinguishing mechanisms such as gas or water suppression systems.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          04
        </div>
        <h5 class="teleblocksubtitle">Customized Solutions for Varied Businesses</h5>
        <p>
          Our server room services are tailored to your specific needs.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          05
        </div>
        <h5 class="teleblocksubtitle">Tailored Designs</h5>
        <p>
          We take into account your current and future needs, ensuring that your server room can adapt to the growth of your business.
        </p>
      </div>
      <div class="cell colmd6 teleblocktile">
        <div class="expnumeber">
          06
        </div>
        <h5 class="teleblocksubtitle">Scalable Infrastructure</h5>
        <p>
          If you need to add extra server racks or accommodate future equipment, our solutions can easily be adapted to your requirements.
        </p>
      </div>
    </div>
  </div>
</section>


<section class="imgsection" id="portfollio">
	<div class="grid-container teleblockcontent">
		<div class="teleblockline linewhite"></div>
		<div class="grid-x mbig">
			<div class="cell colmd6">
				<h3 class="section_heading">KSK Server
				<br />
			Rooms Portfolio</h3>
			</div>
			</div>
	</div>
</section>

<section class="portfolioblock">
		<swiper-container init="false" speed="500" loop="true"  pagination="true">
			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture1.webp" /> 
			</swiper-slide>
			
			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture2.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture3.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture4.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture5.webp" />

			</swiper-slide>
			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture6.webp" />
			</swiper-slide>

			<swiper-slide class="portgall image_item1">
				<img src="/images/Picture7.webp" />
			</swiper-slide>
			
			<swiper-slide class="portgall image_item4">
				<img src="/images/Picture8.webp" />
			</swiper-slide>
		
	</swiper-container>
	<div class="photos-itemimg__content">
		<div class="grid-container">

			<div class="grid-x mbig align-center">

				<!-- <div class="cell colmd1"></div>
				<div class="cell colmd12 text-center">
					<h2>Rapidly growing market </h2>
				</div>
				<div class="cell colmd12 text-center">
					<p>
						At least 8 companies targeting to open live casino business on the 40 billion market in 2021.
						<br />
						We do difference.
					</p>
				</div> -->

				<div class="cell colmd1"></div>

				<div class="cell colmd12 text-center">
					<a href="/contacts/" class="button contactsbtn">Contacts</a>
				</div>
			</div>
		</div>
	</div>
</section>

<div id="overlay"></div>
<div id="additionalinfo" class="additionalinfo">
        <div class="controls">
            <h3>Information</h3>
            <div class="btnclose" onclick="off()">✖</div>
        </div>
        <table id="producttext" class="producttext">
		</table>
    </div>
<script>
	const swiperEl = document.querySelector('swiper-container');

	  // swiper parameters
	  const swiperParams = {
	    slidesPerView: 2,
	    breakpoints: {
	      640: {
	        slidesPerView: 3,
	      },
	      1024: {
	        slidesPerView: 5,
	      },
	    },
	    mousewheel: {
		    forceToAxis: true,
		  },
	    on: {
	      init() {
	        // ...
	      },
	    },
	  };
	  
	    // now we need to assign all parameters to Swiper element
  Object.assign(swiperEl, swiperParams);

  // and now initialize it
  swiperEl.initialize();
	  
    const buttons = document.getElementById("map-holder").getElementsByTagName("a");

    const buttonPressed = e => {
        history.pushState({}, '', ''); 
        console.log(e.target.getAttribute("data-text"));
        document.getElementById("overlay").style.display = "block";
	document.getElementById("additionalinfo").style.display = "block";
        document.getElementById("producttext").innerHTML = e.target.parentElement.getAttribute("data-text");
    }

    for (let button of buttons) {
        button.addEventListener("click", buttonPressed);
    }

    const overlay = document.getElementById("overlay");
	const additionalinfo = document.getElementById("additionalinfo");

    addEventListener("popstate", () => {
        off();
    });

    overlay.addEventListener('click', () => {
        off();
    })

    function on() {
        overlay.style.display = "block";
		additionalinfo.style.display = "block";
    }

    function off() {
        overlay.style.display = "none";
		additionalinfo.style.display = "none";
    }

</script>
<?php
require_once (__DIR__ . '/../sections/footer.php');
?>